/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.profile;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import oracle.ide.controls.CustomJSplitPane;
import oracle.ide.controls.SortedJTable;
import oracle.ide.controls.SortedTableModel;
import oracle.jdevimpl.runner.profile.EventProfModel;
import oracle.jdevimpl.runner.profile.ProfHistPanel;

public class EventProfPanel
extends JPanel {
    private JSplitPane _splitPane;
    private EventProfModel _histModel;
    private ProfHistPanel _php;
    private JTable _table;
    private int _nScrollGraph;
    private JScrollPane _spTable;

    private void $init$() {
        this._nScrollGraph = 0;
    }

    public EventProfPanel(EventProfModel histModel) {
        super(new BorderLayout());
        this.$init$();
        this.setBorder(BorderFactory.createEmptyBorder());
        this._histModel = histModel;
        this._php = new ProfHistPanel(this._histModel);
        this._php.setBorder(BorderFactory.createEmptyBorder());
        this._table = new SortedJTable((SortedTableModel)this._histModel, 3, true);
        this._spTable = new JScrollPane(this._table);
        this._spTable.setBorder(BorderFactory.createEmptyBorder());
        this._spTable.setBorder(BorderFactory.createEmptyBorder());
        this._spTable.setHorizontalScrollBarPolicy(32);
        this._splitPane = new CustomJSplitPane(1, (Component)this._spTable, (Component)this._php);
        this._splitPane.setDividerLocation(0.5);
        this._php.setVerticalScrollBar(this._spTable.getVerticalScrollBar());
        this._php.setRowHeight(this._table.getRowHeight());
        this._php.addSelectionListener(new 1());
        this._table.getSelectionModel().addListSelectionListener(new 2());
        this._histModel.addTableModelListener(new 3());
        this.add((Component)this._splitPane, "Center");
        Dimension d1 = this._table.getTableHeader().getPreferredSize();
        Dimension d2 = this._php.getColumnHeader().getPreferredSize();
        d2.height = d1.height - 1;
        this._php.getColumnHeader().setPreferredSize(d2);
    }

    public ProfHistPanel getHistoryPanel() {
        return this._php;
    }

    public JTable getTable() {
        return this._table;
    }

    public JScrollPane getScrollPane() {
        return this._spTable;
    }

    private void graphSelectionChange(PropertyChangeEvent e) {
        int[] nNewSel = (int[])e.getNewValue();
        ++this._nScrollGraph;
        this._table.clearSelection();
        int i = 0;
        while (i < nNewSel.length) {
            this._table.addRowSelectionInterval(nNewSel[i], nNewSel[i]);
            ++i;
        }
        --this._nScrollGraph;
    }

    private void tableSelectionChange(ListSelectionEvent e) {
        int[] nNewSel = this._table.getSelectedRows();
        this._php.setSelected(nNewSel);
        this.scrollGraphToVisible();
    }

    public void scrollGraphToVisible() {
        if (this._nScrollGraph == 0) {
            this._php.scrollGraphToVisible();
        }
    }

    static void mav$graphSelectionChange(EventProfPanel eventProfPanel, PropertyChangeEvent propertyChangeEvent) {
        eventProfPanel.graphSelectionChange(propertyChangeEvent);
    }

    static void mav$tableSelectionChange(EventProfPanel eventProfPanel, ListSelectionEvent listSelectionEvent) {
        eventProfPanel.tableSelectionChange(listSelectionEvent);
    }

    static ProfHistPanel ra$_php(EventProfPanel eventProfPanel) {
        return eventProfPanel._php;
    }

    final class 1
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent e) {
            EventProfPanel.mav$graphSelectionChange(EventProfPanel.this, e);
        }
    }

    final class 2
    implements ListSelectionListener {
        public void valueChanged(ListSelectionEvent e) {
            if (e.getValueIsAdjusting()) {
                return;
            }
            EventProfPanel.mav$tableSelectionChange(EventProfPanel.this, e);
        }
    }

    final class 3
    implements TableModelListener {
        public void tableChanged(TableModelEvent e) {
            EventProfPanel.ra$_php(EventProfPanel.this).updateDatas();
            EventProfPanel.ra$_php(EventProfPanel.this).repaint();
        }
    }
}

