/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.profile;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashSet;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import oracle.ide.Context;
import oracle.ide.IdeConstants;
import oracle.ide.controller.Controller;
import oracle.ide.controls.CustomJSplitPane;
import oracle.ide.help.HelpInfo;
import oracle.ide.help.HelpSystem;
import oracle.ide.icons.IdeIcons;
import oracle.ide.resource.IdeArb;
import oracle.ide.util.IntHashMap;
import oracle.ide.util.Pair;
import oracle.ide.view.View;
import oracle.jdeveloper.profiler.EventTester;
import oracle.jdeveloper.runner.Source;
import oracle.jdevimpl.runner.debug.DbgArb;
import oracle.jdevimpl.runner.profile.BaseSavable;
import oracle.jdevimpl.runner.profile.BasicEvent;
import oracle.jdevimpl.runner.profile.DefaultAllignRenderer;
import oracle.jdevimpl.runner.profile.EventProfModel;
import oracle.jdevimpl.runner.profile.EventProfPanel;
import oracle.jdevimpl.runner.profile.FileSavable;
import oracle.jdevimpl.runner.profile.FileSaver;
import oracle.jdevimpl.runner.profile.HTMLSavable;
import oracle.jdevimpl.runner.profile.HTMLSaver;
import oracle.jdevimpl.runner.profile.JProfiler;
import oracle.jdevimpl.runner.profile.LocationProvider;
import oracle.jdevimpl.runner.profile.ProfArb;
import oracle.jdevimpl.runner.profile.ProfWindow;
import oracle.jdevimpl.runner.profile.ProfileEvent;
import oracle.jdevimpl.runner.profile.ProfilerSettings;
import oracle.jdevimpl.runner.profile.ProfilingProcess;
import oracle.jdevimpl.runner.profile.RightAllignRenderer;
import oracle.jdevimpl.runner.profile.UpdatableSettings;
import oracle.jdevimpl.runner.run.RunArb;

public final class EventTable
extends ProfWindow
implements LocationProvider,
ActionListener,
UpdatableSettings,
HTMLSavable,
FileSavable {
    public static final int MAX_COLUMNS = 6;
    public static final int COL_EVENT = 0;
    public static final int COL_MESS = 1;
    public static final int COL_LOC = 2;
    public static final int COL_START = 3;
    public static final int COL_END = 4;
    public static final int COL_DUR = 5;
    private static final String PROFILES_EVENT_TABLE_ID = "Profiler.EventTable";
    private ProfilingProcess process;
    private String title;
    private boolean[] columnShowing;
    private TableColumn[] column;
    private JPanel mainPanel;
    private boolean isAutoSelect;
    private ProfileEvent[] eventArray;
    private ProfileEvent[] currentItems;
    private EventsArrayModel dataModel;
    private EventProfPanel epp;
    private JButton buttonRestart;
    private JButton buttonSnapshot;
    private JButton buttonTerminate;
    private JButton buttonRun;
    private JButton buttonPause;
    private JButton buttonClear;
    private JLabel samplesLabel;
    private JLabel codePosLabel;
    private JTextArea commentArea;
    private JButton testButton;
    private EventTester curTester;
    private String curDetail;
    private JPanel detailPanel;
    private JPanel sumPanel;
    private JLabel startLabel;
    private JLabel startValue;
    private JLabel endLabel;
    private JLabel endValue;
    private JLabel durLabel;
    private JLabel durValue;
    private JLabel countLabel;
    private JLabel countValue;
    private JLabel cumtimeLabel;
    private JLabel cumtimeValue;
    private JLabel avgLabel;
    private JLabel avgValue;
    private JLabel medianLabel;
    private JLabel medianValue;
    private JLabel uniqueLabel;
    private JLabel uniqueValue;
    private JLabel minLabel;
    private JLabel minValue;
    private JLabel maxLabel;
    private JLabel maxValue;
    private JLabel devLabel;
    private JLabel devValue;
    private static final HelpInfo HELP_TOPIC = new HelpInfo(ProfArb.getString(7));

    private void $init$() {
        this.columnShowing = new boolean[6];
        this.column = new TableColumn[6];
        this.isAutoSelect = false;
    }

    public EventTable(ProfilingProcess p) {
        this.$init$();
        this.process = p;
        this.eventArray = new ProfileEvent[0];
        this.initialize();
    }

    public void resetProcess(ProfilingProcess p) {
        this.process = p;
        this.buttonRestart.setEnabled(true);
        this.buttonSnapshot.setEnabled(true);
        this.buttonTerminate.setEnabled(true);
        this.buttonRun.setEnabled(false);
        this.buttonPause.setEnabled(true);
        this.buttonClear.setEnabled(false);
        this.setData(new ProfileEvent[0]);
    }

    public void saveToHTML(boolean full) {
        HTMLSaver hsv = new HTMLSaver(this.eventArray);
        hsv.SaveToFile(this.getContext());
    }

    public void saveToFile() {
        FileSaver fs = new FileSaver(this);
        fs.save(this.getContext());
    }

    public void saveToFile(DataOutputStream stream) throws IOException {
        stream.writeInt(1);
        this.process.saveMapsToFile(stream);
        IntHashMap usedEvents = new IntHashMap(10);
        int i = 0;
        while (i < this.eventArray.length) {
            BasicEvent ev = this.eventArray[i].getEvent();
            usedEvents.put(ev._id, (Object)ev);
            ++i;
        }
        stream.writeInt(usedEvents.size());
        for (BaseSavable o : usedEvents) {
            o.saveToFile(stream);
        }
        stream.writeInt(this.eventArray.length);
        int i2 = 0;
        while (i2 < this.eventArray.length) {
            this.eventArray[i2].saveToFile(stream);
            ++i2;
        }
    }

    public void setData(ProfileEvent[] events) {
        this.eventArray = events;
        this.dataModel.setDatas(events);
        if (events.length > 0) {
            this.selectByRow(0);
        }
    }

    public void notifyProcessEnd() {
        SwingUtilities.invokeLater(new EventRunner(0));
    }

    public Component getGUI() {
        return this.mainPanel;
    }

    public Controller getController() {
        return null;
    }

    public Context getContext(EventObject event) {
        Context context = this.process.getContext();
        context.setView((View)this);
        context.setEvent(event);
        return context;
    }

    public void initialize() {
        this.title = ProfArb.getString(189) + this.process.getRunTitle();
        JToolBar toolBar = this.createToolBar();
        JComponent tablePanel = this.createTablePanel();
        JPanel bottomPanel = this.createBottomPanel();
        CustomJSplitPane infoPanel = new CustomJSplitPane(0, true, (Component)tablePanel, (Component)bottomPanel);
        infoPanel.setBorder(BorderFactory.createEmptyBorder());
        infoPanel.setDividerLocation(0.8);
        infoPanel.setResizeWeight(1.0);
        this.mainPanel = new JPanel(new BorderLayout());
        this.mainPanel.setBorder(BorderFactory.createEmptyBorder());
        this.mainPanel.add((Component)toolBar, "North");
        this.mainPanel.add((Component)infoPanel, "Center");
        this.updateSettings();
    }

    public String getTabName() {
        return this.process.getTabName();
    }

    public Icon getTabIcon() {
        return this.process.getIcon();
    }

    public String getTitleName() {
        return this.title;
    }

    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        this.whenActionPerformed(source);
    }

    private void whenActionPerformed(Object source) {
        if (source == this.buttonRun) {
            this.process.performRunCommand();
            this.buttonRun.setEnabled(false);
            this.buttonClear.setEnabled(false);
            this.buttonPause.setEnabled(true);
            this.buttonSnapshot.setEnabled(true);
            this.buttonPause.requestFocus();
        } else if (source == this.buttonPause) {
            this.process.performPauseCommand();
            this.buttonRun.setEnabled(true);
            this.buttonRun.requestFocus();
            this.buttonClear.setEnabled(true);
            this.buttonSnapshot.setEnabled(false);
            this.buttonPause.setEnabled(false);
        } else if (source == this.buttonClear) {
            this.process.performClearSampleCommand();
        } else if (source == this.buttonSnapshot) {
            this.process.performSnapshotCommand();
        } else if (source == this.buttonRestart) {
            this.process.performRestartCommand();
        } else if (source == this.buttonTerminate) {
            this.process.performTerminateCommand();
        } else if (source == this.testButton) {
            this.doTestOnCurEvent();
        }
    }

    public void changeSettings() {
        this.process.showSettings();
    }

    public void updateSettings() {
        ProfilerSettings ps = ProfilerSettings.getInstance();
        JTable table = this.epp.getTable();
        boolean[] show = ps.getEventColumnVisible();
        boolean isChanged = false;
        int i = 0;
        while (i < 6) {
            if (this.columnShowing[i] != show[i]) {
                isChanged = true;
                this.columnShowing[i] = show[i];
                if (show[i]) {
                    table.addColumn(this.column[i]);
                } else {
                    table.removeColumn(this.column[i]);
                }
            }
            ++i;
        }
        if (isChanged) {
            this.dataModel.fireTableChanged(new TableModelEvent(this.dataModel, 0, this.eventArray.length - 1, -1));
        }
    }

    private JPanel createDetailPanel() {
        GridBagLayout gridbag = new GridBagLayout();
        JPanel panel = new JPanel(gridbag);
        panel.setBorder(BorderFactory.createEmptyBorder());
        int x = 0;
        int y = 0;
        JLabel textlabel = new JLabel(ProfArb.getString(123));
        panel.add((Component)textlabel, new GridBagConstraints(x++, y, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 5, 2, 5), 0, 0));
        this.codePosLabel = new JLabel("");
        panel.add((Component)this.codePosLabel, new GridBagConstraints(x++, y, 1, 1, 1.0, 0.0, 17, 0, new Insets(2, 5, 2, 5), 0, 0));
        this.testButton = new JButton(ProfArb.getString(11));
        this.testButton.addActionListener(this);
        this.testButton.setVisible(false);
        panel.add((Component)this.testButton, new GridBagConstraints(x++, y, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 5, 2, 5), 0, 0));
        Dimension d1 = textlabel.getPreferredSize();
        Dimension d2 = this.testButton.getPreferredSize();
        if (d1.height < d2.height) {
            d1.height = d2.height;
            textlabel.setPreferredSize(d1);
        }
        x = 0;
        ++y;
        this.commentArea = new JTextArea();
        this.commentArea.setBackground(this.codePosLabel.getBackground());
        this.commentArea.setLineWrap(true);
        this.commentArea.setEditable(false);
        JScrollPane sp = new JScrollPane(this.commentArea);
        sp.setBorder(new TitledBorder(ProfArb.getString(16)));
        panel.add((Component)sp, new GridBagConstraints(x++, y, 0, 1, 1.0, 1.0, 17, 1, new Insets(2, 5, 2, 5), 0, 0));
        HelpSystem.getHelpSystem().registerTopic((JComponent)panel, ProfArb.getString(7));
        return panel;
    }

    private JPanel createSumPanel() {
        GridBagLayout gridbag = new GridBagLayout();
        JPanel panel = new JPanel(gridbag);
        panel.setBorder(BorderFactory.createEmptyBorder());
        int x = 0;
        int y = 0;
        this.startLabel = new JLabel();
        this.startValue = new JLabel();
        this.endLabel = new JLabel();
        this.endValue = new JLabel();
        this.durLabel = new JLabel();
        this.durValue = new JLabel();
        this.countLabel = new JLabel();
        this.countValue = new JLabel();
        this.cumtimeLabel = new JLabel();
        this.cumtimeValue = new JLabel();
        this.avgLabel = new JLabel();
        this.avgValue = new JLabel();
        this.medianLabel = new JLabel();
        this.medianValue = new JLabel();
        this.uniqueLabel = new JLabel();
        this.uniqueValue = new JLabel();
        this.minLabel = new JLabel();
        this.minValue = new JLabel();
        this.maxLabel = new JLabel();
        this.maxValue = new JLabel();
        this.devLabel = new JLabel();
        this.devValue = new JLabel();
        this.startLabel.setText(ProfArb.getString(259));
        this.startValue.setText("999.9999");
        this.startValue.setMinimumSize(new Dimension(50, 16));
        this.endLabel.setText(ProfArb.getString(247));
        this.endValue.setText("999.9999");
        this.durLabel.setText(ProfArb.getString(18));
        this.durValue.setText("999.9999");
        this.countLabel.setText(ProfArb.getString(47));
        this.countValue.setText("999.9999");
        this.countValue.setMinimumSize(new Dimension(50, 16));
        this.cumtimeLabel.setText(ProfArb.getString(96));
        this.cumtimeValue.setText("999.9999");
        this.avgLabel.setText(ProfArb.getString(274));
        this.avgValue.setText("999.9999");
        this.medianLabel.setText(ProfArb.getString(115));
        this.medianValue.setText("999.9999");
        this.uniqueLabel.setText(ProfArb.getString(186));
        this.uniqueValue.setText("999.9999");
        this.minLabel.setText(ProfArb.getString(120));
        this.minValue.setText("999.9999");
        this.maxLabel.setText(ProfArb.getString(329));
        this.maxValue.setText("999.9999");
        this.devLabel.setText(ProfArb.getString(32));
        this.devValue.setText("999.9999");
        Font curfont = this.startLabel.getFont();
        Font boldfont = curfont.deriveFont(1);
        this.startLabel.setFont(boldfont);
        this.endLabel.setFont(boldfont);
        this.durLabel.setFont(boldfont);
        this.countLabel.setFont(boldfont);
        this.avgLabel.setFont(boldfont);
        this.cumtimeLabel.setFont(boldfont);
        this.minLabel.setFont(boldfont);
        this.maxLabel.setFont(boldfont);
        this.medianLabel.setFont(boldfont);
        this.devLabel.setFont(boldfont);
        this.uniqueLabel.setFont(boldfont);
        panel.add((Component)this.startLabel, new GridBagConstraints(x++, y, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 4, 0, 0), 0, 0));
        panel.add((Component)this.startValue, new GridBagConstraints(x++, y, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 4, 0, 20), 0, 0));
        panel.add((Component)this.endLabel, new GridBagConstraints(x++, y, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 4, 0, 0), 0, 0));
        panel.add((Component)this.endValue, new GridBagConstraints(x++, y, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 4, 0, 20), 0, 0));
        panel.add((Component)this.durLabel, new GridBagConstraints(x++, y, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 4, 0, 0), 0, 0));
        panel.add((Component)this.durValue, new GridBagConstraints(x++, y, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 4, 0, 20), 0, 0));
        panel.add((Component)new JLabel(), new GridBagConstraints(x++, y, 1, 1, 1.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        x = 0;
        panel.add((Component)this.countLabel, new GridBagConstraints(x++, ++y, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 4, 0, 0), 0, 0));
        panel.add((Component)this.countValue, new GridBagConstraints(x++, y, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 4, 0, 20), 0, 0));
        panel.add((Component)this.cumtimeLabel, new GridBagConstraints(x++, y, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 4, 0, 0), 0, 0));
        panel.add((Component)this.cumtimeValue, new GridBagConstraints(x++, y, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 4, 0, 20), 0, 0));
        panel.add((Component)this.avgLabel, new GridBagConstraints(x++, y, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 4, 0, 0), 0, 0));
        panel.add((Component)this.avgValue, new GridBagConstraints(x++, y, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 4, 0, 20), 0, 0));
        x = 0;
        panel.add((Component)this.minLabel, new GridBagConstraints(x++, ++y, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 4, 0, 0), 0, 0));
        panel.add((Component)this.minValue, new GridBagConstraints(x++, y, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 4, 0, 20), 0, 0));
        panel.add((Component)this.maxLabel, new GridBagConstraints(x++, y, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 4, 0, 0), 0, 0));
        panel.add((Component)this.maxValue, new GridBagConstraints(x++, y, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 4, 0, 20), 0, 0));
        panel.add((Component)this.medianLabel, new GridBagConstraints(x++, y, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 4, 0, 0), 0, 0));
        panel.add((Component)this.medianValue, new GridBagConstraints(x++, y, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 4, 0, 20), 0, 0));
        x = 0;
        panel.add((Component)this.devLabel, new GridBagConstraints(x++, ++y, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 4, 0, 0), 0, 0));
        panel.add((Component)this.devValue, new GridBagConstraints(x++, y, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 4, 0, 20), 0, 0));
        panel.add((Component)this.uniqueLabel, new GridBagConstraints(x++, y, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 4, 0, 0), 0, 0));
        panel.add((Component)this.uniqueValue, new GridBagConstraints(x++, y, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 4, 0, 20), 0, 0));
        x = 0;
        panel.add((Component)new JLabel(), new GridBagConstraints(x++, ++y, 1, 1, 0.0, 1.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        HelpSystem.getHelpSystem().registerTopic((JComponent)panel, ProfArb.getString(7));
        return panel;
    }

    private JPanel createBottomPanel() {
        GridBagLayout gridbag = new GridBagLayout();
        JPanel panel = new JPanel(gridbag);
        panel.setBorder(BorderFactory.createEmptyBorder());
        this.detailPanel = this.createDetailPanel();
        this.sumPanel = this.createSumPanel();
        this.sumPanel.setVisible(false);
        panel.add((Component)this.detailPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)this.sumPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        return panel;
    }

    public HelpInfo getHelpInfo() {
        return HELP_TOPIC;
    }

    public void findSource() {
        if (this.currentItems[0].isCodePosition()) {
            Context context = this.getContext();
            Source.showSourceFile(context.getWorkspace(), context.getProject(), this.currentItems[0].getPackage(), null, this.currentItems[0].getFileName(), this.currentItems[0].getLine(), true);
        }
    }

    public boolean canFindSource() {
        return this.currentItems[0].isCodePosition();
    }

    private void setAllSizes(JComponent c, Dimension d) {
        c.setMinimumSize(d);
        Border b = c.getBorder();
        c.setBorder(b);
        c.setMaximumSize(d);
        c.setPreferredSize(d);
    }

    private JToolBar createToolBar() {
        JToolBar tb = new JToolBar();
        tb.setFloatable(false);
        tb.setRollover(true);
        tb.setBorder(IdeConstants.TOOLBAR_EMPTY_BORDER);
        this.buttonRestart = new JButton(RunArb.getIcon(17));
        this.buttonRestart.setToolTipText(ProfArb.getString(68));
        this.registerActionMnemonic(tb, this.buttonRestart, ProfArb.getMnemonic(328));
        this.buttonRestart.addActionListener(this);
        tb.add(this.buttonRestart);
        this.buttonRestart.setEnabled(true);
        this.buttonRun = new JButton(DbgArb.getIcon(584));
        this.buttonRun.setToolTipText(ProfArb.getString(317));
        this.registerActionMnemonic(tb, this.buttonRun, ProfArb.getMnemonic(76));
        this.buttonRun.addActionListener(this);
        tb.add(this.buttonRun);
        this.buttonRun.setEnabled(false);
        this.buttonPause = new JButton(DbgArb.getIcon(684));
        this.buttonPause.setToolTipText(ProfArb.getString(142));
        this.registerActionMnemonic(tb, this.buttonPause, ProfArb.getMnemonic(117));
        this.buttonPause.addActionListener(this);
        tb.add(this.buttonPause);
        this.buttonPause.setEnabled(true);
        this.buttonSnapshot = new JButton(IdeArb.getIcon((int)79));
        this.buttonSnapshot.setToolTipText(ProfArb.getString(228));
        this.registerActionMnemonic(tb, this.buttonSnapshot, ProfArb.getMnemonic(264));
        this.buttonSnapshot.addActionListener(this);
        tb.add(this.buttonSnapshot);
        this.buttonSnapshot.setEnabled(true);
        this.buttonClear = new JButton(IdeIcons.getIcon((int)6));
        this.buttonClear.setToolTipText(ProfArb.getString(131));
        this.registerActionMnemonic(tb, this.buttonClear, ProfArb.getMnemonic(114));
        this.buttonClear.addActionListener(this);
        tb.add(this.buttonClear);
        this.buttonClear.setEnabled(false);
        this.buttonTerminate = new JButton(IdeArb.getIcon((int)343));
        this.buttonTerminate.setToolTipText(ProfArb.getString(219));
        this.registerActionMnemonic(tb, this.buttonTerminate, ProfArb.getMnemonic(148));
        this.buttonTerminate.addActionListener(this);
        tb.add(this.buttonTerminate);
        this.buttonTerminate.setEnabled(true);
        return tb;
    }

    void registerActionMnemonic(JToolBar tb, JButton button, char mnemonic) {
        InputMap im = tb.getInputMap(1);
        ActionMap am = tb.getActionMap();
        MyAction action = new MyAction(button);
        KeyStroke ks = KeyStroke.getKeyStroke((int)mnemonic, 2);
        im.put(ks, action);
        am.put(action, action);
    }

    private void setSumPanelContent() {
        if (this.currentItems != null) {
            int nevents;
            int revents = nevents = this.currentItems.length;
            int minStart = Integer.MAX_VALUE;
            int maxEnd = 0;
            int minDuration = Integer.MAX_VALUE;
            int maxDuration = 0;
            int cumDuration = 0;
            boolean isPending = false;
            int[] durations = new int[nevents];
            Object[] bounds = new Pair[nevents * 2];
            int idur = 0;
            int ibounds = 0;
            int i = 0;
            while (i < nevents) {
                ProfileEvent item = this.currentItems[i];
                int start = item.getStart();
                int end = item.getEnd();
                if (minStart > start) {
                    minStart = start;
                }
                if (end != -1) {
                    int duration = end - start;
                    durations[idur++] = duration;
                    bounds[ibounds++] = new Pair((Object)new Integer(start), (Object)Boolean.TRUE);
                    bounds[ibounds++] = new Pair((Object)new Integer(end), (Object)Boolean.FALSE);
                    if (maxEnd < end) {
                        maxEnd = end;
                    }
                    if (maxDuration < duration) {
                        maxDuration = duration;
                    }
                    if (minDuration > duration) {
                        minDuration = duration;
                    }
                    cumDuration += duration;
                } else {
                    --revents;
                    isPending = true;
                }
                ++i;
            }
            int mean = cumDuration / revents;
            if (idur > 0) {
                long cumsquare = 0L;
                int i2 = 0;
                while (i2 < idur) {
                    long dev = durations[i2] - mean;
                    cumsquare += dev * dev;
                    ++i2;
                }
                int stdev = (int)Math.round(Math.sqrt(cumsquare / (long)idur));
                this.devValue.setText(ProfileEvent.timeFormater(stdev));
            } else {
                this.devValue.setText(ProfArb.getString(95));
            }
            if (idur > 0) {
                Arrays.sort(durations, 0, idur);
                int median = idur % 1 == 0 ? (durations[idur /= 2] + durations[idur - 1]) / 2 : durations[idur / 2];
                this.medianValue.setText(ProfileEvent.timeFormater(median));
            } else {
                this.medianValue.setText(ProfArb.getString(95));
            }
            if (ibounds > 0) {
                Arrays.sort(bounds, 0, ibounds);
                int curstate = 0;
                int curcum = 0;
                int laststart = 0;
                int i3 = 0;
                while (i3 < ibounds) {
                    int t = (Integer)bounds[i3].getFirst();
                    boolean isStart = (Boolean)bounds[i3].getSecond();
                    if (isStart) {
                        if (curstate == 0) {
                            laststart = t;
                        }
                        ++curstate;
                    } else if (--curstate == 0) {
                        curcum += t - laststart;
                    }
                    ++i3;
                }
                this.uniqueValue.setText(ProfileEvent.timeFormater(curcum));
            } else {
                this.uniqueValue.setText(ProfArb.getString(95));
            }
            this.countValue.setText(Integer.toString(nevents));
            this.startValue.setText(ProfileEvent.timeFormater(minStart));
            if (isPending) {
                this.endValue.setText(ProfArb.getString(326));
                this.durValue.setText(ProfArb.getString(326));
            } else {
                this.endValue.setText(ProfileEvent.timeFormater(maxEnd));
                this.durValue.setText(ProfileEvent.timeFormater(maxEnd - minStart));
            }
            this.cumtimeValue.setText(ProfileEvent.timeFormater(cumDuration));
            if (revents != 0) {
                this.minValue.setText(ProfileEvent.timeFormater(minDuration));
                this.maxValue.setText(ProfileEvent.timeFormater(maxDuration));
                this.avgValue.setText(ProfileEvent.timeFormater(cumDuration / revents));
            } else {
                this.minValue.setText(ProfArb.getString(95));
                this.maxValue.setText(ProfArb.getString(95));
                this.avgValue.setText(ProfArb.getString(95));
            }
        }
    }

    private void setDetailPanelContent() {
        if (this.currentItems != null && this.currentItems.length > 0) {
            ProfileEvent currentItem = this.currentItems[0];
            this.codePosLabel.setText(currentItem.getPosS());
            this.commentArea.setText(currentItem.getCommentS());
            String hclass = currentItem.getHelperClassS();
            boolean classOK = false;
            if (hclass != null) {
                try {
                    Class<?> testerClass = Class.forName(hclass);
                    this.curTester = (EventTester)testerClass.newInstance();
                    this.curDetail = currentItem.getDetailS();
                    classOK = true;
                }
                catch (Exception e) {
                    System.err.println("Got " + e + " while getting EventTester");
                }
                if (!classOK) {
                    System.err.println("Missing or bad class in ActionTag");
                }
            }
            if (!classOK) {
                this.testButton.setVisible(false);
                this.curTester = null;
                this.curDetail = null;
            } else {
                this.testButton.setText(this.curTester.getButtonName());
                this.testButton.setVisible(true);
            }
        }
    }

    private void doTestOnCurEvent() {
        if (this.curTester != null) {
            ProfileEvent currentItem = this.currentItems[0];
            this.curTester.doTest(this.getContext(), currentItem.getId(), currentItem.getFileName(), currentItem.getLine(), currentItem.getStartF(), currentItem.getEndF(), this.commentArea.getText(), this.curDetail);
        }
    }

    private JComponent createTablePanel() {
        this.dataModel = new EventsArrayModel();
        this.epp = new EventProfPanel(this.dataModel);
        JTable table = this.epp.getTable();
        table.addMouseListener(new 1());
        RightAllignRenderer rightAllignRenderer = new RightAllignRenderer(this.process);
        DefaultAllignRenderer defaultAllignRenderer = new DefaultAllignRenderer(this.process);
        TableColumnModel tableColumnModel = table.getColumnModel();
        int i = 0;
        while (i < 6) {
            this.column[i] = tableColumnModel.getColumn(i);
            this.columnShowing[i] = true;
            ++i;
        }
        this.column[0].setCellRenderer(defaultAllignRenderer);
        this.column[0].setPreferredWidth(200);
        this.column[1].setCellRenderer(defaultAllignRenderer);
        this.column[1].setPreferredWidth(300);
        this.column[2].setCellRenderer(defaultAllignRenderer);
        this.column[2].setPreferredWidth(300);
        this.column[3].setCellRenderer(rightAllignRenderer);
        this.column[3].setPreferredWidth(100);
        this.column[4].setCellRenderer(rightAllignRenderer);
        this.column[4].setPreferredWidth(100);
        this.column[5].setCellRenderer(rightAllignRenderer);
        this.column[5].setPreferredWidth(100);
        Dimension spacing = new Dimension(0, 0);
        table.setIntercellSpacing(spacing);
        ListSelectionModel listSelectionModel = table.getSelectionModel();
        listSelectionModel.setSelectionMode(2);
        listSelectionModel.addListSelectionListener(new 2());
        return this.epp;
    }

    private void selectByRow(int row) {
        ListSelectionModel lsm = this.epp.getTable().getSelectionModel();
        lsm.clearSelection();
        lsm.addSelectionInterval(row, row);
        JViewport vp = this.epp.getScrollPane().getViewport();
        Rectangle r = this.epp.getTable().getCellRect(row, 0, true);
        Rectangle rv = vp.getViewRect();
        r.y -= rv.y;
        vp.scrollRectToVisible(r);
    }

    private void selectByObjects(ProfileEvent[] objects) {
        ListSelectionModel lsm = this.epp.getTable().getSelectionModel();
        lsm.clearSelection();
        HashSet<ProfileEvent> hs = new HashSet<ProfileEvent>();
        int i = 0;
        while (i < objects.length) {
            hs.add(objects[i]);
            ++i;
        }
        int minrow = this.eventArray.length;
        int maxrow = 0;
        int addpos = 0;
        i = 0;
        while (i < this.eventArray.length) {
            if (hs.contains(this.eventArray[i])) {
                if (minrow > i) {
                    minrow = i;
                }
                objects[addpos++] = this.eventArray[i];
                lsm.addSelectionInterval(i, i);
                maxrow = i;
            }
            ++i;
        }
        JViewport vp = this.epp.getScrollPane().getViewport();
        Rectangle r = this.epp.getTable().getCellRect(maxrow, 0, true);
        Rectangle rv = vp.getViewRect();
        r.y -= rv.y;
        vp.scrollRectToVisible(r);
        r = this.epp.getTable().getCellRect(minrow, 0, true);
        rv = vp.getViewRect();
        r.y -= rv.y;
        vp.scrollRectToVisible(r);
    }

    public void stateChange(int newState) {
        switch (newState) {
            case 3: {
                this.process.terminateProcess();
                this.eventArray = null;
                this.currentItems = null;
                break;
            }
        }
        super.stateChange(newState);
    }

    static void wa$isAutoSelect(EventTable eventTable, boolean bl) {
        eventTable.isAutoSelect = bl;
    }

    static ProfileEvent[] ra$currentItems(EventTable eventTable) {
        return eventTable.currentItems;
    }

    static void mav$selectByObjects(EventTable eventTable, ProfileEvent[] profileEventArray) {
        eventTable.selectByObjects(profileEventArray);
    }

    static ProfilingProcess ra$process(EventTable eventTable) {
        return eventTable.process;
    }

    static JButton ra$buttonRestart(EventTable eventTable) {
        return eventTable.buttonRestart;
    }

    static JButton ra$buttonSnapshot(EventTable eventTable) {
        return eventTable.buttonSnapshot;
    }

    static JButton ra$buttonTerminate(EventTable eventTable) {
        return eventTable.buttonTerminate;
    }

    static JButton ra$buttonRun(EventTable eventTable) {
        return eventTable.buttonRun;
    }

    static JButton ra$buttonPause(EventTable eventTable) {
        return eventTable.buttonPause;
    }

    static JButton ra$buttonClear(EventTable eventTable) {
        return eventTable.buttonClear;
    }

    static void mav$whenActionPerformed(EventTable eventTable, Object object) {
        eventTable.whenActionPerformed(object);
    }

    static boolean ra$isAutoSelect(EventTable eventTable) {
        return eventTable.isAutoSelect;
    }

    static EventProfPanel ra$epp(EventTable eventTable) {
        return eventTable.epp;
    }

    static void wa$currentItems(EventTable eventTable, ProfileEvent[] profileEventArray) {
        eventTable.currentItems = profileEventArray;
    }

    static ProfileEvent[] ra$eventArray(EventTable eventTable) {
        return eventTable.eventArray;
    }

    static JPanel ra$detailPanel(EventTable eventTable) {
        return eventTable.detailPanel;
    }

    static JPanel ra$sumPanel(EventTable eventTable) {
        return eventTable.sumPanel;
    }

    static void mav$setDetailPanelContent(EventTable eventTable) {
        eventTable.setDetailPanelContent();
    }

    static void mav$setSumPanelContent(EventTable eventTable) {
        eventTable.setSumPanelContent();
    }

    class EventsArrayModel
    extends AbstractTableModel
    implements EventProfModel {
        int _compareField;
        boolean _ascending;
        private ProfileEvent[] _eventArray;
        private EventComparator _scomp;

        private void $init$() {
            this._compareField = 0;
            this._scomp = new EventComparator();
        }

        public EventsArrayModel() {
            this.$init$();
        }

        public void setDatas(ProfileEvent[] eventArray) {
            this._eventArray = eventArray;
            Arrays.sort(this._eventArray, this._scomp);
            this.fireTableDataChanged();
        }

        public String getToolTipText(int col) {
            if (EventTable.ra$process(EventTable.this).isPopupActive()) {
                return null;
            }
            switch (col) {
                case 0: {
                    return ProfArb.getString(286);
                }
                case 1: {
                    return ProfArb.getString(195);
                }
                case 2: {
                    return ProfArb.getString(229);
                }
                case 3: {
                    return ProfArb.getString(102);
                }
                case 4: {
                    return ProfArb.getString(22);
                }
                case 5: {
                    return ProfArb.getString(277);
                }
            }
            return "Error";
        }

        public int getColumnCount() {
            return 6;
        }

        public String getColumnName(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return ProfArb.getString(313);
                }
                case 1: {
                    return ProfArb.getString(170);
                }
                case 2: {
                    return ProfArb.getString(231);
                }
                case 3: {
                    return ProfArb.getString(224);
                }
                case 4: {
                    return ProfArb.getString(284);
                }
                case 5: {
                    return ProfArb.getString(303);
                }
            }
            return "Error";
        }

        public int getRowCount() {
            if (this._eventArray != null) {
                return this._eventArray.length;
            }
            return 0;
        }

        public Object getValueAt(int row, int col) {
            if (this._eventArray == null || row >= this._eventArray.length) {
                return "";
            }
            switch (col) {
                case 0: {
                    return this._eventArray[row].getIdS();
                }
                case 1: {
                    return this._eventArray[row].getShortCommentS();
                }
                case 2: {
                    return this._eventArray[row].getPosS();
                }
                case 3: {
                    return this._eventArray[row].getStartS();
                }
                case 4: {
                    return this._eventArray[row].getEndS();
                }
                case 5: {
                    return this._eventArray[row].getDurationS();
                }
            }
            return "";
        }

        public int getEventStart(int nEvent) {
            if (this._eventArray == null || nEvent >= this._eventArray.length) {
                return 0;
            }
            return this._eventArray[nEvent].getStart();
        }

        public int getEventElapsed(int nEvent) {
            if (this._eventArray == null || nEvent >= this._eventArray.length) {
                return 0;
            }
            return this._eventArray[nEvent].getDuration();
        }

        public Color getEventColor(int nEvent) {
            if (this._eventArray == null || nEvent >= this._eventArray.length) {
                return Color.black;
            }
            return this._eventArray[nEvent].getColor();
        }

        public String getEventLabel(int nEvent) {
            return "";
        }

        public boolean sortByColumn(int col, boolean asc) {
            this._compareField = col;
            this._ascending = asc;
            EventTable.wa$isAutoSelect(EventTable.this, true);
            if (this._eventArray != null) {
                Arrays.sort(this._eventArray, this._scomp);
            }
            this.fireTableDataChanged();
            if (EventTable.ra$currentItems(EventTable.this) != null) {
                EventTable.mav$selectByObjects(EventTable.this, EventTable.ra$currentItems(EventTable.this));
            }
            EventTable.wa$isAutoSelect(EventTable.this, false);
            return false;
        }

        public boolean isColVisible(int col) {
            return true;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class EventComparator
        implements Comparator {
            public int compare(Object o1, Object o2) {
                int result;
                ProfileEvent m1 = (ProfileEvent)o1;
                ProfileEvent m2 = (ProfileEvent)o2;
                switch (EventsArrayModel.this._compareField) {
                    default: {
                        result = m1.getIdS().compareTo(m2.getIdS());
                        break;
                    }
                    case 1: {
                        result = m1.getShortCommentS().compareTo(m2.getShortCommentS());
                        break;
                    }
                    case 2: {
                        result = m1.getPosS().compareTo(m2.getPosS());
                        break;
                    }
                    case 3: {
                        result = m1.getStart() - m2.getStart();
                        break;
                    }
                    case 4: {
                        result = m1.getEnd() - m2.getEnd();
                        break;
                    }
                    case 5: {
                        result = m1.getDuration() - m2.getDuration();
                        break;
                    }
                }
                if (!EventsArrayModel.this._ascending) {
                    result = 0 - result;
                }
                return result;
            }

            EventComparator() {
            }
        }
    }

    class EventRunner
    implements Runnable {
        static final int PROC_END_ACTION = 0;
        int _type;

        EventRunner(int type) {
            this._type = type;
        }

        public void run() {
            switch (this._type) {
                case 0: {
                    EventTable.ra$buttonRestart(EventTable.this).setEnabled(true);
                    EventTable.ra$buttonSnapshot(EventTable.this).setEnabled(false);
                    EventTable.ra$buttonTerminate(EventTable.this).setEnabled(false);
                    EventTable.ra$buttonRun(EventTable.this).setEnabled(false);
                    EventTable.ra$buttonPause(EventTable.this).setEnabled(false);
                    EventTable.ra$buttonClear(EventTable.this).setEnabled(false);
                    break;
                }
            }
        }
    }

    class MyAction
    extends AbstractAction {
        JButton _src;

        MyAction(JButton src) {
            this._src = src;
        }

        public void actionPerformed(ActionEvent e) {
            EventTable.mav$whenActionPerformed(EventTable.this, this._src);
        }
    }

    final class 1
    extends MouseAdapter {
        public void mousePressed(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        public void mouseReleased(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        private void maybeShowPopup(MouseEvent e) {
            if (e.isPopupTrigger()) {
                Context context = EventTable.this.getContext(e);
                JProfiler.contextMenu.show(context);
            }
        }

        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() == 2) {
                EventTable.this.findSource();
            }
        }
    }

    final class 2
    implements ListSelectionListener {
        public void valueChanged(ListSelectionEvent e) {
            if (e.getValueIsAdjusting() || EventTable.ra$isAutoSelect(EventTable.this)) {
                return;
            }
            int[] selection = EventTable.ra$epp(EventTable.this).getTable().getSelectedRows();
            EventTable.wa$currentItems(EventTable.this, new ProfileEvent[selection.length]);
            int i = 0;
            while (i < selection.length) {
                EventTable.ra$currentItems((EventTable)EventTable.this)[i] = EventTable.ra$eventArray(EventTable.this)[selection[i]];
                ++i;
            }
            if (EventTable.ra$currentItems(EventTable.this).length <= 1) {
                EventTable.ra$detailPanel(EventTable.this).setVisible(true);
                EventTable.ra$sumPanel(EventTable.this).setVisible(false);
                EventTable.mav$setDetailPanelContent(EventTable.this);
            } else {
                EventTable.ra$detailPanel(EventTable.this).setVisible(false);
                EventTable.ra$sumPanel(EventTable.this).setVisible(true);
                EventTable.mav$setSumPanelContent(EventTable.this);
            }
        }
    }
}

