/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.profile;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import oracle.bali.ewt.chooser.color.ColorChoice;
import oracle.bali.ewt.model.ArrayTwoDModel;
import oracle.bali.ewt.model.TwoDModel;
import oracle.ide.controls.JNumericSpinBox;
import oracle.ide.help.HelpSystem;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.util.Namespace;
import oracle.ide.util.ResourceUtils;
import oracle.ide.util.TriStateBoolean;
import oracle.jdeveloper.runner.RunConfiguration;
import oracle.jdeveloper.runner.RunConfigurationEditorUtil;
import oracle.jdevimpl.runner.profile.BasicEvent;
import oracle.jdevimpl.runner.profile.EventsTreePanel;
import oracle.jdevimpl.runner.profile.ProfArb;
import oracle.jdevimpl.runner.profile.ProfileConfiguration;

public class EventsConfigurationPanel
extends DefaultTraversablePanel
implements DocumentListener,
ActionListener,
TreeSelectionListener,
PropertyChangeListener,
ChangeListener {
    private static final Color[][] DEFAULT_SWATCH_ARRAY = new Color[][]{{new Color(204, 255, 255), new Color(204, 204, 255), new Color(204, 204, 255), new Color(204, 204, 255), new Color(204, 204, 255), new Color(204, 204, 255), new Color(204, 204, 255), new Color(204, 204, 255), new Color(204, 204, 255), new Color(204, 204, 255), new Color(255, 204, 255), new Color(255, 204, 204), new Color(255, 204, 204), new Color(255, 204, 204), new Color(255, 204, 204), new Color(255, 204, 204), new Color(255, 204, 204), new Color(255, 204, 204), new Color(255, 204, 204), new Color(255, 204, 204), new Color(255, 255, 204), new Color(204, 255, 204), new Color(204, 255, 204), new Color(204, 255, 204), new Color(204, 255, 204), new Color(204, 255, 204), new Color(204, 255, 204), new Color(204, 255, 204), new Color(204, 255, 204), new Color(204, 255, 204), new Color(204, 255, 255)}, {new Color(153, 255, 255), new Color(153, 204, 255), new Color(153, 153, 255), new Color(153, 153, 255), new Color(153, 153, 255), new Color(153, 153, 255), new Color(153, 153, 255), new Color(153, 153, 255), new Color(153, 153, 255), new Color(204, 153, 255), new Color(255, 153, 255), new Color(255, 153, 204), new Color(255, 153, 153), new Color(255, 153, 153), new Color(255, 153, 153), new Color(255, 153, 153), new Color(255, 153, 153), new Color(255, 153, 153), new Color(255, 153, 153), new Color(255, 204, 153), new Color(255, 255, 153), new Color(204, 255, 153), new Color(153, 255, 153), new Color(153, 255, 153), new Color(153, 255, 153), new Color(153, 255, 153), new Color(153, 255, 153), new Color(153, 255, 153), new Color(153, 255, 153), new Color(153, 255, 204), new Color(153, 255, 255)}, {new Color(102, 255, 255), new Color(102, 204, 255), new Color(102, 153, 255), new Color(102, 102, 255), new Color(102, 102, 255), new Color(102, 102, 255), new Color(102, 102, 255), new Color(102, 102, 255), new Color(153, 102, 255), new Color(204, 102, 255), new Color(255, 102, 255), new Color(255, 102, 204), new Color(255, 102, 153), new Color(255, 102, 102), new Color(255, 102, 102), new Color(255, 102, 102), new Color(255, 102, 102), new Color(255, 102, 102), new Color(255, 153, 102), new Color(255, 204, 102), new Color(255, 255, 102), new Color(204, 255, 102), new Color(153, 255, 102), new Color(102, 255, 102), new Color(102, 255, 102), new Color(102, 255, 102), new Color(102, 255, 102), new Color(102, 255, 102), new Color(102, 255, 153), new Color(102, 255, 204), new Color(102, 255, 255)}, {new Color(51, 255, 255), new Color(51, 204, 255), new Color(51, 153, 255), new Color(51, 102, 255), new Color(51, 51, 255), new Color(51, 51, 255), new Color(51, 51, 255), new Color(102, 51, 255), new Color(153, 51, 255), new Color(204, 51, 255), new Color(255, 51, 255), new Color(255, 51, 204), new Color(255, 51, 153), new Color(255, 51, 102), new Color(255, 51, 51), new Color(255, 51, 51), new Color(255, 51, 51), new Color(255, 102, 51), new Color(255, 153, 51), new Color(255, 204, 51), new Color(255, 255, 51), new Color(204, 255, 51), new Color(153, 244, 51), new Color(102, 255, 51), new Color(51, 255, 51), new Color(51, 255, 51), new Color(51, 255, 51), new Color(51, 255, 102), new Color(51, 255, 153), new Color(51, 255, 204), new Color(51, 255, 255)}, {new Color(0, 255, 255), new Color(0, 204, 255), new Color(0, 153, 255), new Color(0, 102, 255), new Color(0, 51, 255), new Color(0, 0, 255), new Color(51, 0, 255), new Color(102, 0, 255), new Color(153, 0, 255), new Color(204, 0, 255), new Color(255, 0, 255), new Color(255, 0, 204), new Color(255, 0, 153), new Color(255, 0, 102), new Color(255, 0, 51), new Color(255, 0, 0), new Color(255, 51, 0), new Color(255, 102, 0), new Color(255, 153, 0), new Color(255, 204, 0), new Color(255, 255, 0), new Color(204, 255, 0), new Color(153, 255, 0), new Color(102, 255, 0), new Color(51, 255, 0), new Color(0, 255, 0), new Color(0, 255, 51), new Color(0, 255, 102), new Color(0, 255, 153), new Color(0, 255, 204), new Color(0, 255, 255)}, {new Color(0, 204, 204), new Color(0, 204, 204), new Color(0, 153, 204), new Color(0, 102, 204), new Color(0, 51, 204), new Color(0, 0, 204), new Color(51, 0, 204), new Color(102, 0, 204), new Color(153, 0, 204), new Color(204, 0, 204), new Color(204, 0, 204), new Color(204, 0, 204), new Color(204, 0, 153), new Color(204, 0, 102), new Color(204, 0, 51), new Color(204, 0, 0), new Color(204, 51, 0), new Color(204, 102, 0), new Color(204, 153, 0), new Color(204, 204, 0), new Color(204, 204, 0), new Color(204, 204, 0), new Color(153, 204, 0), new Color(102, 204, 0), new Color(51, 204, 0), new Color(0, 204, 0), new Color(0, 204, 51), new Color(0, 204, 102), new Color(0, 204, 153), new Color(0, 204, 204), new Color(0, 204, 204)}, {new Color(0, 153, 153), new Color(0, 153, 153), new Color(0, 153, 153), new Color(0, 102, 153), new Color(0, 51, 153), new Color(0, 0, 153), new Color(51, 0, 153), new Color(102, 0, 153), new Color(153, 0, 153), new Color(153, 0, 153), new Color(153, 0, 153), new Color(153, 0, 153), new Color(153, 0, 153), new Color(153, 0, 102), new Color(153, 0, 51), new Color(153, 0, 0), new Color(153, 51, 0), new Color(153, 102, 0), new Color(153, 153, 0), new Color(153, 153, 0), new Color(153, 153, 0), new Color(153, 153, 0), new Color(153, 153, 0), new Color(102, 153, 0), new Color(51, 153, 0), new Color(0, 153, 0), new Color(0, 153, 51), new Color(0, 153, 102), new Color(0, 153, 153), new Color(0, 153, 153), new Color(0, 153, 153)}, {new Color(0, 102, 102), new Color(0, 102, 102), new Color(0, 102, 102), new Color(0, 102, 102), new Color(0, 51, 102), new Color(0, 0, 102), new Color(51, 0, 102), new Color(102, 0, 102), new Color(102, 0, 102), new Color(102, 0, 102), new Color(102, 0, 102), new Color(102, 0, 102), new Color(102, 0, 102), new Color(102, 0, 102), new Color(102, 0, 51), new Color(102, 0, 0), new Color(102, 51, 0), new Color(102, 102, 0), new Color(102, 102, 0), new Color(102, 102, 0), new Color(102, 102, 0), new Color(102, 102, 0), new Color(102, 102, 0), new Color(102, 102, 0), new Color(51, 102, 0), new Color(0, 102, 0), new Color(0, 102, 51), new Color(0, 102, 102), new Color(0, 102, 102), new Color(0, 102, 102), new Color(0, 102, 102)}, {new Color(0, 51, 51), new Color(0, 51, 51), new Color(0, 51, 51), new Color(0, 51, 51), new Color(0, 51, 51), new Color(0, 0, 51), new Color(51, 0, 51), new Color(51, 0, 51), new Color(51, 0, 51), new Color(51, 0, 51), new Color(51, 0, 51), new Color(51, 0, 51), new Color(51, 0, 51), new Color(51, 0, 51), new Color(51, 0, 51), new Color(51, 0, 0), new Color(51, 51, 0), new Color(51, 51, 0), new Color(51, 51, 0), new Color(51, 51, 0), new Color(51, 51, 0), new Color(51, 51, 0), new Color(51, 51, 0), new Color(51, 51, 0), new Color(51, 51, 0), new Color(0, 51, 0), new Color(0, 51, 51), new Color(0, 51, 51), new Color(0, 51, 51), new Color(0, 51, 51), new Color(0, 51, 51)}};
    private static final TwoDModel DEFAULT_SWATCH_MODEL = new ArrayTwoDModel((Object[][])DEFAULT_SWATCH_ARRAY);
    private EventsTreePanel eventsTree;
    private JTextField eventDescriptionClasses;
    private BasicEvent curEvent;
    private BasicEvent padEvent;
    private JNumericSpinBox detailID;
    private JTextField detailName;
    private ColorChoice detailColor;
    private JButton addEventButton;
    private JButton addEventFamillyButton;
    private JButton cutEventButton;
    private JButton pasteEventButton;
    private JButton copyEventButton;
    private JComboBox DMSstate;
    private JNumericSpinBox DMSstartID;

    public EventsConfigurationPanel() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void onEntry(TraversableContext tc) {
        ProfileConfiguration profileConfiguration = EventsConfigurationPanel.getProfileConfiguration(tc);
        this.loadFrom(profileConfiguration);
    }

    public void onExit(TraversableContext tc) {
        ProfileConfiguration profileConfiguration = EventsConfigurationPanel.getProfileConfiguration(tc);
        this.commitTo(profileConfiguration);
    }

    private static ProfileConfiguration getProfileConfiguration(TraversableContext tc) {
        RunConfiguration runConfiguration = RunConfigurationEditorUtil.getRunConfiguration((Namespace)tc);
        return ProfileConfiguration.getInstance(runConfiguration);
    }

    private void loadFrom(ProfileConfiguration profileConfiguration) {
        this.eventsTree.setValue(profileConfiguration.getEvents());
        this.DMSstate.setSelectedIndex(profileConfiguration.getDMSstate());
        this.DMSstartID.setIntValue(profileConfiguration.getDMSstartID());
    }

    private void commitTo(ProfileConfiguration profileConfiguration) {
        profileConfiguration.setEvents(this.eventsTree.getValue());
        profileConfiguration.setDMSstate(this.DMSstate.getSelectedIndex());
        profileConfiguration.setDMSstartID(this.DMSstartID.getIntValue());
    }

    private void setAllSizes(JComponent c, Dimension d) {
        c.setMinimumSize(d);
        c.setMaximumSize(d);
        c.setPreferredSize(d);
    }

    private void jbInit() throws Exception {
        GridBagLayout gridbag = new GridBagLayout();
        this.setLayout(gridbag);
        HelpSystem.getHelpSystem().registerTopic((JComponent)((Object)this), ProfArb.getString(305));
        Insets margin = new Insets(1, 3, 1, 3);
        this.addEventButton = new JButton(ProfArb.getString(175));
        this.addEventButton.setMargin(margin);
        this.addEventButton.setToolTipText(ProfArb.getString(98));
        this.addEventButton.addActionListener(this);
        this.addEventButton.setMnemonic(ProfArb.getMnemonic(308));
        this.addEventFamillyButton = new JButton(ProfArb.getString(314));
        this.addEventFamillyButton.setMargin(margin);
        this.addEventFamillyButton.setToolTipText(ProfArb.getString(62));
        this.addEventFamillyButton.addActionListener(this);
        this.addEventFamillyButton.setMnemonic(ProfArb.getMnemonic(165));
        this.copyEventButton = new JButton(ProfArb.getString(143));
        this.copyEventButton.setMargin(margin);
        this.copyEventButton.setToolTipText(ProfArb.getString(44));
        this.copyEventButton.addActionListener(this);
        this.copyEventButton.setMnemonic(ProfArb.getMnemonic(23));
        this.cutEventButton = new JButton(ProfArb.getString(154));
        this.cutEventButton.setMargin(margin);
        this.cutEventButton.setToolTipText(ProfArb.getString(28));
        this.cutEventButton.addActionListener(this);
        this.cutEventButton.setMnemonic(ProfArb.getMnemonic(12));
        this.pasteEventButton = new JButton(ProfArb.getString(25));
        this.pasteEventButton.setMargin(margin);
        this.pasteEventButton.setToolTipText(ProfArb.getString(211));
        this.pasteEventButton.addActionListener(this);
        this.pasteEventButton.setEnabled(false);
        this.pasteEventButton.setMnemonic(ProfArb.getMnemonic(298));
        this.eventsTree = new EventsTreePanel();
        this.eventsTree.addTreeSelectionListener(this);
        String[] dmChoices = new String[]{ProfArb.getString(30), ProfArb.getString(157), ProfArb.getString(246)};
        this.DMSstate = new JComboBox<String>(dmChoices);
        this.DMSstartID = new JNumericSpinBox(0, 0x7FFFFFFE);
        int y = 0;
        JPanel events = new JPanel(new GridBagLayout());
        events.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(ProfArb.getString(215)), BorderFactory.createEmptyBorder(0, 8, 8, 8)));
        y = 0;
        Insets buttonInsets = new Insets(0, 5, 5, 0);
        JScrollPane js = new JScrollPane((Component)((Object)this.eventsTree));
        events.add((Component)js, new GridBagConstraints(0, y, 1, 5, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        events.add((Component)this.addEventButton, new GridBagConstraints(1, y++, 1, 1, 0.0, 0.0, 11, 0, buttonInsets, 0, 0));
        events.add((Component)this.addEventFamillyButton, new GridBagConstraints(1, y++, 1, 1, 0.0, 0.0, 11, 2, buttonInsets, 0, 0));
        events.add((Component)this.copyEventButton, new GridBagConstraints(1, y++, 1, 1, 0.0, 0.0, 11, 2, buttonInsets, 0, 0));
        events.add((Component)this.cutEventButton, new GridBagConstraints(1, y++, 1, 1, 0.0, 0.0, 11, 2, buttonInsets, 0, 0));
        events.add((Component)this.pasteEventButton, new GridBagConstraints(1, y++, 1, 1, 0.0, 1.0, 11, 2, buttonInsets, 0, 0));
        events.add((Component)this.makeEventDetailPanel(), new GridBagConstraints(0, y++, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 0, 0), 0, 0));
        JPanel general = new JPanel(new FlowLayout(0, 8, 0));
        JLabel lblDMSstate = new JLabel();
        general.add(lblDMSstate);
        general.add(this.DMSstate);
        ResourceUtils.resLabel((JLabel)lblDMSstate, (Component)this.DMSstate, (String)ProfArb.getString(193));
        JLabel lblDMSstartID = new JLabel();
        general.add(lblDMSstartID);
        general.add((Component)this.DMSstartID);
        ResourceUtils.resLabel((JLabel)lblDMSstartID, (Component)this.DMSstartID, (String)ProfArb.getString(172));
        y = 0;
        this.add(general, new GridBagConstraints(0, y++, 0, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add(events, new GridBagConstraints(0, y, 0, 1, 1.0, 1.0, 10, 1, new Insets(5, 0, 0, 0), 0, 0));
    }

    private JPanel makeEventDetailPanel() {
        JPanel panel = new JPanel();
        GridBagLayout gridbag = new GridBagLayout();
        panel.setLayout(gridbag);
        JLabel textLabel = new JLabel();
        this.detailID = new JNumericSpinBox(0, 0x7FFFFFFE);
        this.detailID.addChangeListener((ChangeListener)this);
        ResourceUtils.resLabel((JLabel)textLabel, (Component)this.detailID, (String)ProfArb.getString(240));
        this.detailColor = new ColorChoice((Icon)null, DEFAULT_SWATCH_MODEL, (Color)null);
        this.detailColor.setToolTipText(ProfArb.getString(160));
        this.detailColor.addPropertyChangeListener((PropertyChangeListener)this);
        this.detailColor.setMnemonic(ProfArb.getMnemonic(125));
        JLabel textLabel2 = new JLabel();
        this.detailName = new JTextField();
        this.detailName.getDocument().addDocumentListener(this);
        ResourceUtils.resLabel((JLabel)textLabel2, (Component)this.detailName, (String)ProfArb.getString(217));
        int x = 0;
        int y = 0;
        panel.add((Component)textLabel, new GridBagConstraints(x++, y, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)this.detailID, new GridBagConstraints(x++, y, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 8, 0, 0), 0, 0));
        panel.add((Component)this.detailColor, new GridBagConstraints(x++, y, 0, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        x = 0;
        panel.add((Component)textLabel2, new GridBagConstraints(x++, ++y, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        panel.add((Component)this.detailName, new GridBagConstraints(x++, y, 0, 1, 1.0, 0.0, 17, 2, new Insets(5, 8, 0, 0), 0, 0));
        return panel;
    }

    private void insertEventNode(BasicEvent newEvent) {
        Object parent;
        BasicEvent ev = (BasicEvent)this.eventsTree.getLastSelectedPathComponent();
        if (ev == null) {
            return;
        }
        if (ev.getColor() == null) {
            parent = ev;
            ev.insert((MutableTreeNode)((Object)newEvent), 0);
        } else {
            parent = (DefaultMutableTreeNode)ev.getParent();
            ((DefaultMutableTreeNode)parent).insert((MutableTreeNode)((Object)newEvent), ((DefaultMutableTreeNode)parent).getIndex((TreeNode)((Object)ev)) + 1);
        }
        this.eventsTree.checkSelected();
        ((DefaultTreeModel)this.eventsTree.getModel()).nodeStructureChanged((TreeNode)parent);
        TreePath tp = new TreePath(newEvent.getPath());
        this.eventsTree.scrollPathToVisible(tp);
        this.eventsTree.setSelectionPath(tp);
    }

    public void valueChanged(TreeSelectionEvent e) {
        BasicEvent ev = (BasicEvent)this.eventsTree.getLastSelectedPathComponent();
        if (ev == null) {
            return;
        }
        this.curEvent = null;
        if (ev.getId() != -1) {
            this.detailID.setEnabled(true);
            this.detailID.setIntValue(ev.getId());
            this.detailColor.setEnabled(true);
            Color closestColor = this.detailColor.getClosestColor(ev.getColor());
            this.detailColor.setSelectedColor(closestColor);
        } else {
            this.detailID.setEnabled(false);
            this.detailID.setIntValue(0);
            this.detailColor.setEnabled(false);
        }
        this.cutEventButton.setEnabled(ev.getParent() != null);
        this.detailName.setText(ev.getName());
        this.curEvent = ev;
    }

    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.copyEventButton) {
            if (this.curEvent != null) {
                this.padEvent = new BasicEvent(this.curEvent);
                this.pasteEventButton.setEnabled(true);
            }
        } else if (src == this.pasteEventButton) {
            if (this.curEvent != null && this.padEvent != null) {
                this.insertEventNode(new BasicEvent(this.padEvent));
            }
        } else if (src == this.cutEventButton) {
            DefaultMutableTreeNode parent;
            if (this.curEvent != null && (parent = (DefaultMutableTreeNode)this.curEvent.getParent()) != null) {
                int[] indexes = new int[1];
                Object[] removed = new Object[1];
                this.padEvent = this.curEvent;
                int index = parent.getIndex((TreeNode)((Object)this.curEvent));
                this.curEvent.removeFromParent();
                indexes[0] = index;
                removed[0] = this.curEvent;
                ((DefaultTreeModel)this.eventsTree.getModel()).nodesWereRemoved(parent, indexes, removed);
                if (index > 0) {
                    parent = (DefaultMutableTreeNode)parent.getChildAt(index - 1);
                }
                TreePath tp = new TreePath(parent.getPath());
                this.eventsTree.checkSelected();
                this.eventsTree.scrollPathToVisible(tp);
                this.eventsTree.setSelectionPath(tp);
                this.pasteEventButton.setEnabled(true);
            }
        } else if (src == this.addEventFamillyButton) {
            if (this.curEvent != null) {
                this.insertEventNode(new BasicEvent(ProfArb.getString(200), this.curEvent.getModel().getCheckBoxState() == TriStateBoolean.TRUE ? TriStateBoolean.TRUE : TriStateBoolean.FALSE));
            }
        } else if (src == this.addEventButton && this.curEvent != null) {
            this.insertEventNode(new BasicEvent(this.curEvent.getId() + 1, ProfArb.getString(59), this.curEvent.getColor() == null ? Color.blue : this.curEvent.getColor(), this.curEvent.getModel().getCheckBoxState() == TriStateBoolean.TRUE ? TriStateBoolean.TRUE : TriStateBoolean.FALSE));
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        Color newColor;
        Object source;
        String propertyName = event.getPropertyName();
        if (propertyName.equals("selectedColor") && (source = event.getSource()) == this.detailColor && this.curEvent != null && this.curEvent.getColor() != null && (newColor = this.detailColor.getSelectedColor()) != null) {
            this.curEvent.setColor(newColor);
            ((DefaultTreeModel)this.eventsTree.getModel()).nodeChanged((TreeNode)((Object)this.curEvent));
        }
    }

    private void checkEditFields() {
        if (this.curEvent != null) {
            this.curEvent.setName(this.detailName.getText());
            if (this.curEvent.getId() != -1) {
                this.curEvent.setId(this.detailID.getIntValue());
            }
            ((DefaultTreeModel)this.eventsTree.getModel()).nodeChanged((TreeNode)((Object)this.curEvent));
        }
    }

    public void changedUpdate(DocumentEvent e) {
    }

    public void insertUpdate(DocumentEvent e) {
        this.checkEditFields();
    }

    public void removeUpdate(DocumentEvent e) {
        this.checkEditFields();
    }

    public void stateChanged(ChangeEvent e) {
        this.checkEditFields();
    }

    public static void main_(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        TestFrame tf = new TestFrame();
        tf.addWindowListener(new 1());
        tf.show();
    }

    static class TestFrame
    extends JFrame {
        BorderLayout borderLayout1;

        private void $init$() {
            this.borderLayout1 = new BorderLayout();
        }

        public TestFrame() {
            this.$init$();
            try {
                this.jbInit();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        private void jbInit() throws Exception {
            this.getContentPane().setLayout(this.borderLayout1);
            this.setSize(new Dimension(400, 300));
            this.setTitle("Test");
            this.getContentPane().add((Component)((Object)new EventsConfigurationPanel()), "Center");
        }
    }

    static final class 1
    extends WindowAdapter {
        public void windowClosing(WindowEvent e) {
            System.exit(0);
        }
    }
}

