/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.profile;

import java.awt.Component;
import java.awt.Point;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import oracle.ide.controls.tree.CustomJTree;
import oracle.jdevimpl.runner.profile.BasicEvent;

public class EventsTreePanel
extends CustomJTree
implements DragGestureListener,
DragSourceListener,
DropTargetListener {
    private BasicEvent top = BasicEvent.parseFromString("G(All events;());");
    private DragSource dragSource;

    public EventsTreePanel() {
        this.top.checkSelected();
        DefaultTreeModel model = new DefaultTreeModel((TreeNode)((Object)this.top));
        this.setModel(model);
        this.setSelectionRow(0);
        this.setShowsRootHandles(true);
        this.dragSource = DragSource.getDefaultDragSource();
        this.dragSource.createDefaultDragGestureRecognizer((Component)((Object)this), 2, this);
        DropTarget dropTarget1 = new DropTarget((Component)((Object)this), 2, this);
    }

    public void dragGestureRecognized(DragGestureEvent e) {
        if (e.getDragAction() == 2) {
            Point pt = e.getDragOrigin();
            BasicEvent sel = (BasicEvent)this.getClosestPathForLocation(pt.x, pt.y).getLastPathComponent();
            if (sel != null && sel != this.top) {
                try {
                    e.startDrag(null, sel, this);
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
        }
    }

    public void dragEnter(DragSourceDragEvent e) {
    }

    public void dropActionChanged(DragSourceDragEvent e) {
    }

    public void dragDropEnd(DragSourceDropEvent e) {
    }

    public void dragExit(DragSourceEvent e) {
    }

    public void dragOver(DragSourceDragEvent e) {
    }

    public void dragEnter(DropTargetDragEvent e) {
        this.checkDrag(e);
    }

    public void dragOver(DropTargetDragEvent e) {
        this.checkDrag(e);
    }

    public void dragExit(DropTargetEvent e) {
    }

    public void drop(DropTargetDropEvent e) {
        if (e.isLocalTransfer() && e.isDataFlavorSupported(BasicEvent.eventFlavor) && (e.getSourceActions() & 2) != 0) {
            try {
                Point pt = e.getLocation();
                BasicEvent target = (BasicEvent)this.getClosestPathForLocation(pt.x, pt.y).getLastPathComponent();
                Transferable t = e.getTransferable();
                BasicEvent sel = (BasicEvent)t.getTransferData(BasicEvent.eventFlavor);
                if (sel != target && !sel.isNodeDescendant((DefaultMutableTreeNode)((Object)target))) {
                    Object parent_to;
                    e.acceptDrop(2);
                    DefaultMutableTreeNode parent_from = (DefaultMutableTreeNode)sel.getParent();
                    sel.removeFromParent();
                    if (target.getColor() == null) {
                        parent_to = target;
                        target.insert((MutableTreeNode)((Object)sel), 0);
                    } else {
                        parent_to = (DefaultMutableTreeNode)target.getParent();
                        ((DefaultMutableTreeNode)parent_to).insert((MutableTreeNode)((Object)sel), ((DefaultMutableTreeNode)parent_to).getIndex((TreeNode)((Object)target)) + 1);
                    }
                    this.checkSelected();
                    ((DefaultTreeModel)this.getModel()).nodeStructureChanged(parent_from);
                    ((DefaultTreeModel)this.getModel()).nodeStructureChanged((TreeNode)parent_to);
                    TreePath tp = new TreePath(sel.getPath());
                    this.scrollPathToVisible(tp);
                    this.setSelectionPath(tp);
                    e.getDropTargetContext().dropComplete(true);
                    return;
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        e.rejectDrop();
    }

    public void dropActionChanged(DropTargetDragEvent e) {
    }

    private void checkDrag(DropTargetDragEvent e) {
        if (e.isDataFlavorSupported(BasicEvent.eventFlavor) && (e.getSourceActions() & 2) != 0) {
            e.acceptDrag(2);
            return;
        }
        e.rejectDrag();
    }

    void checkSelected() {
        this.top.checkSelected();
    }

    void setValue(String advlist) {
        BasicEvent newTop;
        this.top = newTop = BasicEvent.parseFromString(advlist);
        this.checkSelected();
        DefaultTreeModel model = new DefaultTreeModel((TreeNode)((Object)this.top));
        this.setModel(model);
        this.setSelectionRow(0);
        this.repaint();
    }

    public String getValue() {
        String s = this.top.getStringValue();
        return s;
    }
}

