/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.profile;

import java.awt.Component;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.net.DefaultURLFilter;
import oracle.ide.net.URLChooser;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.jdevimpl.runner.profile.BaseSavable;
import oracle.jdevimpl.runner.profile.FileSavable;
import oracle.jdevimpl.runner.profile.ProfArb;
import oracle.jdevimpl.runner.profile.VMTypes;

public class FileSaver {
    private static URL lastSavedFile = null;
    private FileSavable _saved;

    public FileSaver(FileSavable saved) {
        this._saved = saved;
    }

    private static URL chooseFileName(Context context, boolean isSave) {
        try {
            URL url;
            DefaultURLFilter filt = new DefaultURLFilter(ProfArb.getString(40), ".opr");
            URLChooser chooser = DialogUtil.newURLChooser((Context)context);
            chooser.setURLFilter((URLFilter)filt);
            if (lastSavedFile != null) {
                chooser.setSelectedURL(lastSavedFile);
            }
            if (isSave) {
                if (chooser.showSaveDialog((Component)Ide.getMainWindow(), ProfArb.getString(77)) != 0) {
                    URL uRL = null;
                    return uRL;
                }
            } else if (chooser.showOpenDialog((Component)Ide.getMainWindow(), ProfArb.getString(15)) != 0) {
                URL uRL = null;
                return uRL;
            }
            if (!filt.accept(url = chooser.getSelectedURL())) {
                url = new URL(url.toString() + ".opr");
            }
            URL uRL = url;
            return uRL;
        }
        catch (IOException ioe) {
            System.out.println("Got exception " + ioe);
            return null;
        }
    }

    private static DataOutputStream getOutputFileStream(Context context) {
        try {
            URL url;
            lastSavedFile = url = FileSaver.chooseFileName(context, true);
            if (url != null) {
                DataOutputStream res;
                DataOutputStream dataOutputStream = res = new DataOutputStream(new BufferedOutputStream(URLFileSystem.openOutputStream((URL)url)));
                return dataOutputStream;
            }
        }
        catch (IOException ioe) {
            System.out.println("Got exception " + ioe);
        }
        return null;
    }

    public static URL chooseFileName(Context context) {
        return FileSaver.chooseFileName(context, false);
    }

    private static DataInputStream getInputFileStream(URL url) {
        try {
            lastSavedFile = url;
            if (url != null) {
                DataInputStream res;
                DataInputStream dataInputStream = res = new DataInputStream(new BufferedInputStream(URLFileSystem.openInputStream((URL)url)));
                return dataInputStream;
            }
        }
        catch (IOException ioe) {
            System.out.println("Got exception " + ioe);
        }
        return null;
    }

    public static DataInputStream selectResultStream(URL url) {
        DataInputStream res = FileSaver.getInputFileStream(url);
        if (res != null) {
            try {
                if (res.readInt() != -20266753) {
                    res.close();
                    System.out.println("Wrong magic number");
                    res = null;
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                res = null;
            }
        }
        return res;
    }

    public void save(Context context) {
        DataOutputStream stream = FileSaver.getOutputFileStream(context);
        if (stream != null) {
            try {
                stream.writeInt(-20266753);
                this._saved.saveToFile(stream);
                stream.close();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    public static void saveVMObjectToFile(VMTypes[] objects, DataOutputStream stream) throws IOException {
        stream.writeInt(objects.length);
        int i = 0;
        while (i < objects.length) {
            objects[i].saveToFile(stream);
            ++i;
        }
    }

    public static void saveVMObjectToFile(Collection col, DataOutputStream stream) throws IOException {
        int size = col.size();
        stream.writeInt(size);
        for (BaseSavable o : col) {
            o.saveToFile(stream);
        }
    }
}

