/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.profile;

import java.awt.Component;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.net.DefaultURLFilter;
import oracle.ide.net.URLChooser;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.ide.util.IdeUtil;
import oracle.jdevimpl.runner.profile.CallCountItem;
import oracle.jdevimpl.runner.profile.HeapDetailStat;
import oracle.jdevimpl.runner.profile.HeapStat;
import oracle.jdevimpl.runner.profile.MemoryDetailTable;
import oracle.jdevimpl.runner.profile.MemoryTable;
import oracle.jdevimpl.runner.profile.ProfArb;
import oracle.jdevimpl.runner.profile.ProfileEvent;
import oracle.jdevimpl.runner.profile.SampleTable;
import oracle.jdevimpl.runner.profile.SubCallCount;

public class HTMLSaver {
    private static URL lastSavedFile = null;
    static final String LINE_FEED = System.getProperty("line.separator");
    static final String HT_HEADER1 = "<!doctype html public \"-//w3c//dtd html 4.0 transitional//en\">" + LINE_FEED + "<html>" + LINE_FEED + "<head>" + LINE_FEED + "<meta http-equiv=\"Content-Type\" content=\"text/html; charset=";
    static final String HT_HEADER2 = "\">" + LINE_FEED + "<meta name=\"Author\" content=\"" + ProfArb.getString(136) + "\">" + LINE_FEED + "<title>";
    static final String HT_HEADER3 = "</title>" + LINE_FEED + "<STYLE>" + LINE_FEED + "A:link" + LINE_FEED + "{" + LINE_FEED + "    COLOR: blue;" + LINE_FEED + "    TEXT-DECORATION: none" + LINE_FEED + "}" + LINE_FEED + "A:visited" + LINE_FEED + "{" + LINE_FEED + "    COLOR: blue;" + LINE_FEED + "    TEXT-DECORATION: none" + LINE_FEED + "}" + LINE_FEED + "A:hover" + LINE_FEED + "{" + LINE_FEED + "    COLOR: blue;" + LINE_FEED + "    TEXT-DECORATION: underline" + LINE_FEED + "}" + LINE_FEED + "BODY" + LINE_FEED + "{" + LINE_FEED + "    BACKGROUND: white;" + LINE_FEED + "    COLOR: black" + LINE_FEED + "}" + LINE_FEED + "</STYLE>" + LINE_FEED + "</head>" + LINE_FEED + "<body>" + LINE_FEED;
    static final String HT_FOOTER = "</body>" + LINE_FEED + "</html>" + LINE_FEED;
    CallCountItem[] table;
    int nCalls;
    private MemoryTable memTable;
    private MemoryDetailTable[] memDetails;
    private int index;
    private HashMap detMap;
    private HashSet backLink;
    private HashMap mlMap;
    private int mlHash;
    private ProfileEvent[] events;

    public HTMLSaver(ProfileEvent[] eventArray) {
        this.events = eventArray;
    }

    public HTMLSaver(CallCountItem[] marray, int totalCalls) {
        this.table = marray;
        this.nCalls = totalCalls;
    }

    public HTMLSaver(MemoryTable mt, MemoryDetailTable[] dets, int ind) {
        this.memTable = mt;
        this.memDetails = dets;
        this.index = ind;
    }

    private static String HTML_Escape(String s) {
        StringBuffer sb = new StringBuffer(s.length() * 3 / 2);
        char[] chars = s.toCharArray();
        int i = 0;
        while (i < chars.length) {
            switch (chars[i]) {
                case '<': {
                    sb.append("&lt;");
                    break;
                }
                case '>': {
                    sb.append("&gt;");
                    break;
                }
                case '&': {
                    sb.append("&amp;");
                    break;
                }
                case '\"': {
                    sb.append("&quot;");
                    break;
                }
                default: {
                    sb.append(chars[i]);
                    break;
                }
            }
            ++i;
        }
        return new String(sb);
    }

    private static String HTML_Escape_ln(String s) {
        StringBuffer sb = new StringBuffer(s.length() * 3 / 2);
        char[] chars = s.toCharArray();
        int i = 0;
        while (i < chars.length) {
            switch (chars[i]) {
                case '<': {
                    sb.append("&lt;");
                    break;
                }
                case '>': {
                    sb.append("&gt;");
                    break;
                }
                case '&': {
                    sb.append("&amp;");
                    break;
                }
                case '\"': {
                    sb.append("&quot;");
                    break;
                }
                case '\n': {
                    sb.append("<br>");
                    break;
                }
                default: {
                    sb.append(chars[i]);
                    break;
                }
            }
            ++i;
        }
        return new String(sb);
    }

    private String URLLink(String link, String text) {
        return "<a href=\"#" + link + "\">" + HTMLSaver.HTML_Escape(text) + "</a>";
    }

    private String URLTag(String tag) {
        return "<a NAME=\"" + tag + "\"></a>";
    }

    private String TABLE_Cell(String Content2) {
        return "<td>" + Content2 + "</td>" + LINE_FEED;
    }

    private String TABLE_Cell(String attr, String Content2) {
        return "<td " + attr + ">" + Content2 + "</td>" + LINE_FEED;
    }

    private String TABLE_Row(String C1, String C2, String C3, String C4) {
        return "<tr>" + this.TABLE_Cell(C1) + this.TABLE_Cell(C2) + this.TABLE_Cell("align=\"right\"", C3) + this.TABLE_Cell("align=\"right\"", C4) + "</tr>" + LINE_FEED;
    }

    private String TABLE_RowSampleMain(String C1, String C2, String C3, String C4, String C5, String C6) {
        return "<tr>" + this.TABLE_Cell(C1) + this.TABLE_Cell(C2) + this.TABLE_Cell("align=\"right\"", C3) + this.TABLE_Cell("align=\"right\"", C4) + this.TABLE_Cell("align=\"right\"", C5) + this.TABLE_Cell("align=\"right\"", C6) + "</tr>" + LINE_FEED;
    }

    private String TABLE_Row(String C1, String C2, String C3, String C4, String C5, String C6) {
        return "<tr>" + this.TABLE_Cell(C1) + this.TABLE_Cell(C2) + this.TABLE_Cell(C3) + this.TABLE_Cell("align=\"right\"", C4) + this.TABLE_Cell("align=\"right\"", C5) + this.TABLE_Cell("align=\"right\"", C6) + "</tr>" + LINE_FEED;
    }

    private String TABLE_Row(String C1, String C2, String C3) {
        return "<tr>" + this.TABLE_Cell(C1) + this.TABLE_Cell(C2) + this.TABLE_Cell("align=\"right\"", C3) + "</tr>" + LINE_FEED;
    }

    private static PrintWriter getPrintWriter(Context context) {
        try {
            PrintWriter pw;
            DefaultURLFilter filt = new DefaultURLFilter(ProfArb.getString(61), ".htm");
            filt.addExtension(".html");
            URLChooser chooser = DialogUtil.newURLChooser((Context)context);
            chooser.setURLFilter((URLFilter)filt);
            if (lastSavedFile != null) {
                chooser.setSelectedURL(lastSavedFile);
            }
            if (chooser.showSaveDialog((Component)Ide.getMainWindow(), ProfArb.getString(273)) != 0) {
                PrintWriter printWriter = null;
                return printWriter;
            }
            URL url = chooser.getSelectedURL();
            if (!filt.accept(url)) {
                url = new URL(url.toString() + ".html");
            }
            lastSavedFile = url;
            PrintWriter printWriter = pw = new PrintWriter(new BufferedWriter(new OutputStreamWriter(URLFileSystem.openOutputStream((URL)url), IdeUtil.getIdeEncoding())));
            return printWriter;
        }
        catch (IOException ioe) {
            System.out.println("Got exception " + ioe);
            return null;
        }
    }

    private void printSampleIndex(PrintWriter pw, int ind) {
        pw.print("<p><b><font size=\"4\">");
        pw.print(ProfArb.getString(316) + " ");
        while (--ind >= 0) {
            pw.print(this.URLLink("smp" + ind, Integer.toString(this.memTable.getSampleNumber(ind))) + " ");
        }
        pw.print("</font></b></p>");
        pw.print(LINE_FEED);
    }

    private String getID(HeapStat hs) {
        return "t" + hs.getClassDesc() + "_";
    }

    private String getID(HeapDetailStat de, int tb) {
        String res = (String)this.mlMap.get(de.getName());
        if (res == null) {
            res = "p" + this.mlHash++ + "_";
            this.mlMap.put(de.getName(), res);
        }
        return res + tb + "_";
    }

    private void printOneSampleTable(PrintWriter pw, int ind, int maxindex) {
        pw.print("<p><b><font size=\"4\">");
        if (maxindex != -1) {
            pw.print(this.URLTag("smp" + ind));
        }
        pw.print(ProfArb.format(269, Integer.toString(this.memTable.getSampleNumber(ind)), Integer.toString(this.memTable.getTotalSampleNumber())) + " ");
        pw.print("</font></b></p>");
        pw.print(LINE_FEED);
        pw.print("<table border=\"1\">" + LINE_FEED);
        pw.print("  <tbody>" + LINE_FEED);
        pw.print("    <tr>" + LINE_FEED);
        if (maxindex != -1) {
            pw.print("      <td align=\"center\" bgcolor=\"#C0C0C0\" width=\"40\"></td>" + LINE_FEED);
        }
        pw.print("      <td align=\"center\" bgcolor=\"#C0C0C0\" width=\"400\">" + ProfArb.getString(35) + "</td>" + LINE_FEED);
        pw.print("      <td align=\"center\" bgcolor=\"#C0C0C0\" width=\"80\">" + ProfArb.getString(29) + "</td>" + LINE_FEED);
        pw.print("      <td align=\"center\" bgcolor=\"#C0C0C0\" width=\"80\">" + ProfArb.getString(233) + "</td>" + LINE_FEED);
        pw.print("      <td align=\"center\" bgcolor=\"#C0C0C0\" width=\"80\">" + ProfArb.getString(20) + "</td>" + LINE_FEED);
        pw.print("      <td align=\"center\" bgcolor=\"#C0C0C0\" width=\"80\">" + ProfArb.getString(10) + "</td>" + LINE_FEED);
        pw.print("      <td align=\"center\" bgcolor=\"#C0C0C0\" width=\"80\">" + ProfArb.getString(45) + "</td>" + LINE_FEED);
        pw.print("      <td align=\"center\" bgcolor=\"#C0C0C0\" width=\"80\">" + ProfArb.getString(265) + "</td>" + LINE_FEED);
        pw.print("      <td align=\"center\" bgcolor=\"#C0C0C0\" width=\"80\">" + ProfArb.getString(198) + "</td>" + LINE_FEED);
        pw.print("      <td align=\"center\" bgcolor=\"#C0C0C0\" width=\"80\">" + ProfArb.getString(272) + "</td>" + LINE_FEED);
        pw.print("    </tr>" + LINE_FEED);
        HeapDetailStat totals = this.memTable.getSampleTotals(ind);
        pw.print("    <tr>" + LINE_FEED);
        if (maxindex != -1) {
            pw.print("      <td align=\"center\" bgcolor=\"#C0C0C0\">");
            if (ind != maxindex) {
                pw.print(this.URLLink("smp" + (ind + 1), "<<") + " ");
            }
            if (ind != 0) {
                pw.print(this.URLLink("smp" + (ind - 1), ">>"));
            }
            pw.print("</td>" + LINE_FEED);
        }
        pw.print("      <td align=\"right\" bgcolor=\"#C0C0C0\">" + ProfArb.getString(0) + " " + "</td>" + LINE_FEED);
        pw.print("      <td align=\"right\" bgcolor=\"#C0C0C0\">" + totals.nb + "</td>" + LINE_FEED);
        pw.print("      <td align=\"right\" bgcolor=\"#C0C0C0\">" + totals.size + "</td>" + LINE_FEED);
        pw.print("      <td align=\"right\" bgcolor=\"#C0C0C0\">" + totals.nballoc + "</td>" + LINE_FEED);
        pw.print("      <td align=\"right\" bgcolor=\"#C0C0C0\">" + totals.sizealloc + "</td>" + LINE_FEED);
        pw.print("      <td align=\"right\" bgcolor=\"#C0C0C0\">" + totals.nbfreed + "</td>" + LINE_FEED);
        pw.print("      <td align=\"right\" bgcolor=\"#C0C0C0\">" + totals.sizefreed + "</td>" + LINE_FEED);
        pw.print("      <td align=\"right\" bgcolor=\"#C0C0C0\">" + totals.getNbDiff() + "</td>" + LINE_FEED);
        pw.print("      <td align=\"right\" bgcolor=\"#C0C0C0\">" + totals.getSizeDiff() + "</td>" + LINE_FEED);
        pw.print("    </tr>" + LINE_FEED);
        int csize = this.memTable.getTableSize(ind);
        HeapStat[] ctable = this.memTable.getSampleArray(ind);
        int i = 0;
        while (i < csize) {
            HeapStat cline = ctable[i];
            pw.print("    <tr>" + LINE_FEED);
            if (maxindex != -1) {
                String id = this.getID(cline);
                pw.print("      <td align=\"center\">");
                pw.print(this.URLTag(id + ind));
                if (this.backLink.contains(id)) {
                    pw.print(this.URLLink(id + (ind + 1), "<<") + " ");
                }
                this.backLink.add(id);
                if (ind > 0) {
                    pw.print(this.URLLink(id + (ind - 1), ">>"));
                }
                pw.print("</td>" + LINE_FEED);
            }
            pw.print("      <td align=\"left\">");
            MemoryDetailTable mdt = (MemoryDetailTable)this.detMap.get(cline.getClazz());
            if (mdt != null) {
                HeapDetailStat[] details = mdt.getSampleArray(ind);
                if (details != null) {
                    pw.print(this.URLTag("m" + ind + "_" + cline.getClassDesc()) + this.URLLink("d" + ind + "_" + cline.getClassDesc(), cline.getName()));
                } else {
                    pw.print(cline.getName());
                }
            } else {
                pw.print(cline.getName());
            }
            pw.print("</td>" + LINE_FEED);
            pw.print("      <td align=\"right\">" + cline.nb + "</td>" + LINE_FEED);
            pw.print("      <td align=\"right\">" + cline.size + "</td>" + LINE_FEED);
            pw.print("      <td align=\"right\">" + cline.nballoc + "</td>" + LINE_FEED);
            pw.print("      <td align=\"right\">" + cline.sizealloc + "</td>" + LINE_FEED);
            pw.print("      <td align=\"right\">" + cline.nbfreed + "</td>" + LINE_FEED);
            pw.print("      <td align=\"right\">" + cline.sizefreed + "</td>" + LINE_FEED);
            pw.print("      <td align=\"right\">" + cline.getNbDiff() + "</td>" + LINE_FEED);
            pw.print("      <td align=\"right\">" + cline.getSizeDiff() + "</td>" + LINE_FEED);
            pw.print("    </tr>" + LINE_FEED);
            ++i;
        }
        pw.print("  </tbody>" + LINE_FEED);
        pw.print("</table>" + LINE_FEED);
        i = 0;
        while (i < this.memDetails.length) {
            HeapDetailStat[] details = this.memDetails[i].getSampleArray(ind);
            if (details != null) {
                pw.print("<p><b><font size=\"4\">");
                pw.print(this.URLTag("d" + ind + "_" + this.memDetails[i].getClazz().classDescriptor));
                pw.print(ProfArb.format(230, Integer.toString(this.memTable.getSampleNumber(ind)), Integer.toString(this.memTable.getTotalSampleNumber())) + " ");
                pw.print(this.URLLink("m" + ind + "_" + this.memDetails[i].getClazz().classDescriptor, this.memDetails[i].getClazz().toString()));
                pw.print("</font></b></p>");
                pw.print(LINE_FEED);
                pw.print("<table border=\"1\">" + LINE_FEED);
                pw.print("  <tbody>" + LINE_FEED);
                pw.print("    <tr>" + LINE_FEED);
                pw.print("</td>" + LINE_FEED);
                if (maxindex != -1) {
                    pw.print("      <td align=\"center\" bgcolor=\"#C0C0C0\" width=\"40\">");
                    pw.print("</td>" + LINE_FEED);
                }
                pw.print("      <td align=\"center\" bgcolor=\"#C0C0C0\" width=\"400\">" + ProfArb.getString(177) + " " + "</td>" + LINE_FEED);
                pw.print("      <td align=\"center\" bgcolor=\"#C0C0C0\" width=\"80\">" + ProfArb.getString(29) + "</td>" + LINE_FEED);
                pw.print("      <td align=\"center\" bgcolor=\"#C0C0C0\" width=\"80\">" + ProfArb.getString(233) + "</td>" + LINE_FEED);
                pw.print("      <td align=\"center\" bgcolor=\"#C0C0C0\" width=\"80\">" + ProfArb.getString(20) + "</td>" + LINE_FEED);
                pw.print("      <td align=\"center\" bgcolor=\"#C0C0C0\" width=\"80\">" + ProfArb.getString(10) + "</td>" + LINE_FEED);
                pw.print("      <td align=\"center\" bgcolor=\"#C0C0C0\" width=\"80\">" + ProfArb.getString(45) + "</td>" + LINE_FEED);
                pw.print("      <td align=\"center\" bgcolor=\"#C0C0C0\" width=\"80\">" + ProfArb.getString(265) + "</td>" + LINE_FEED);
                pw.print("      <td align=\"center\" bgcolor=\"#C0C0C0\" width=\"80\">" + ProfArb.getString(198) + "</td>" + LINE_FEED);
                pw.print("      <td align=\"center\" bgcolor=\"#C0C0C0\" width=\"80\">" + ProfArb.getString(272) + "</td>" + LINE_FEED);
                pw.print("    </tr>" + LINE_FEED);
                csize = this.memDetails[i].getTableSize(ind);
                int j = 0;
                while (j < csize) {
                    HeapDetailStat cline = details[j];
                    pw.print("    <tr>" + LINE_FEED);
                    if (maxindex != -1) {
                        String id = this.getID(cline, i);
                        pw.print("      <td align=\"center\">");
                        pw.print(this.URLTag(id + ind));
                        if (this.backLink.contains(id)) {
                            pw.print(this.URLLink(id + (ind + 1), "<<") + " ");
                        }
                        this.backLink.add(id);
                        if (ind > 0) {
                            pw.print(this.URLLink(id + (ind - 1), ">>"));
                        }
                        pw.print("</td>" + LINE_FEED);
                    }
                    pw.print("      <td align=\"left\">");
                    pw.print(cline.getName());
                    pw.print("</td>" + LINE_FEED);
                    pw.print("      <td align=\"right\">" + cline.nb + "</td>" + LINE_FEED);
                    pw.print("      <td align=\"right\">" + cline.size + "</td>" + LINE_FEED);
                    pw.print("      <td align=\"right\">" + cline.nballoc + "</td>" + LINE_FEED);
                    pw.print("      <td align=\"right\">" + cline.sizealloc + "</td>" + LINE_FEED);
                    pw.print("      <td align=\"right\">" + cline.nbfreed + "</td>" + LINE_FEED);
                    pw.print("      <td align=\"right\">" + cline.sizefreed + "</td>" + LINE_FEED);
                    pw.print("      <td align=\"right\">" + cline.getNbDiff() + "</td>" + LINE_FEED);
                    pw.print("      <td align=\"right\">" + cline.getSizeDiff() + "</td>" + LINE_FEED);
                    pw.print("    </tr>" + LINE_FEED);
                    ++j;
                }
                pw.print("  </tbody>" + LINE_FEED);
                pw.print("</table>" + LINE_FEED);
            }
            ++i;
        }
    }

    private void saveMemSampleTable(PrintWriter pw) {
        pw.print(HT_HEADER1);
        pw.print(IdeUtil.getIdeIanaEncoding());
        pw.print(HT_HEADER2);
        pw.print(ProfArb.getString(145));
        pw.print(HT_HEADER3);
        int i = 0;
        this.detMap = new HashMap(this.memDetails.length);
        this.mlMap = new HashMap(200);
        this.backLink = new HashSet(200);
        i = 0;
        while (i < this.memDetails.length) {
            this.detMap.put(this.memDetails[i].getClazz(), this.memDetails[i]);
            ++i;
        }
        if (this.index == -1) {
            HeapStat[] ctable;
            int maxindex = 0;
            while ((ctable = this.memTable.getSampleArray(++maxindex)) != null) {
            }
            this.printSampleIndex(pw, maxindex);
            i = maxindex;
            do {
                this.printOneSampleTable(pw, --i, maxindex - 1);
            } while (i != 0);
        } else {
            this.printOneSampleTable(pw, this.index, -1);
        }
        pw.print(HT_FOOTER);
    }

    private void saveSampleTable(PrintWriter pw) {
        CallCountItem citem;
        pw.print(HT_HEADER1);
        pw.print(IdeUtil.getIdeIanaEncoding());
        pw.print(HT_HEADER2);
        pw.print(ProfArb.getString(145));
        pw.print(HT_HEADER3);
        pw.print("<table border=\"1\">" + LINE_FEED);
        pw.print("  <tbody>" + LINE_FEED);
        pw.print("    <tr>" + LINE_FEED);
        pw.print("      <td align=\"center\" bgcolor=\"#C0C0C0\" width=\"400\">" + ProfArb.getString(155) + "</td>" + LINE_FEED);
        pw.print("      <td align=\"center\" bgcolor=\"#C0C0C0\" width=\"400\">" + ProfArb.getString(4) + "</td>" + LINE_FEED);
        pw.print("      <td align=\"center\" bgcolor=\"#C0C0C0\" width=\"80\">" + ProfArb.getString(73) + "</td>" + LINE_FEED);
        pw.print("      <td align=\"center\" bgcolor=\"#C0C0C0\" width=\"80\">" + ProfArb.getString(190) + "</td>" + LINE_FEED);
        pw.print("      <td align=\"center\" bgcolor=\"#C0C0C0\" width=\"80\">" + ProfArb.getString(258) + "</td>" + LINE_FEED);
        pw.print("      <td align=\"center\" bgcolor=\"#C0C0C0\" width=\"80\">" + ProfArb.getString(174) + "</td>" + LINE_FEED);
        pw.print("    </tr>" + LINE_FEED);
        int i = 0;
        while (i < this.table.length) {
            citem = this.table[i];
            pw.print(this.TABLE_RowSampleMain(this.URLTag("lst" + citem.getRef()) + HTMLSaver.HTML_Escape(citem.getPseudoClass()), this.URLLink("det" + citem.getRef(), citem.getPseudoName() + citem.getNiceSignature()), SampleTable.pFormat((double)citem.getCallCount() / (double)this.nCalls), Integer.toString(citem.getCallCount()), SampleTable.pFormat((double)citem.getOnStackCount() / (double)this.nCalls), Integer.toString(citem.getOnStackCount())));
            ++i;
        }
        pw.print("  </tbody>" + LINE_FEED);
        pw.print("</table>" + LINE_FEED);
        pw.print("<HR>");
        pw.print(LINE_FEED);
        i = 0;
        while (i < this.table.length) {
            SubCallCount scc;
            citem = this.table[i];
            pw.print("<p><b><font size=\"4\">");
            pw.print(ProfArb.getString(150));
            pw.print("&nbsp;");
            pw.print(this.URLTag("det" + citem.getRef()));
            pw.print(HTMLSaver.HTML_Escape(citem.getPseudoClass()) + ".");
            pw.print(this.URLLink("lst" + citem.getRef(), citem.getPseudoName() + citem.getNiceSignature()));
            pw.print("</font></b></p>");
            pw.print(LINE_FEED);
            pw.print("<table border=\"0\">" + LINE_FEED);
            pw.print("  <tr>" + LINE_FEED);
            pw.print("    <td align=\"right\">" + LINE_FEED);
            pw.print("<p><font size=\"4\">");
            pw.print(ProfArb.getString(245));
            pw.print("&nbsp;");
            pw.print("</font></td>" + LINE_FEED);
            pw.print("    <td align=\"right\"><font color=\"#FF0000\" size=\"4\">");
            pw.print(SampleTable.pFormat((double)citem.getCallCount() / (double)this.nCalls));
            pw.print("</font></td>" + LINE_FEED);
            pw.print("  </tr>" + LINE_FEED);
            pw.print("  <tr>" + LINE_FEED);
            pw.print("    <td align=\"right\"><font size=\"4\">");
            pw.print(ProfArb.getString(178));
            pw.print("&nbsp;");
            pw.print("</font></td>" + LINE_FEED);
            pw.print("    <td align=\"right\"><font color=\"#FF0000\" size=\"4\">");
            pw.print(SampleTable.pFormat((double)citem.getOnStackCount() / (double)this.nCalls));
            pw.print("</font></td>" + LINE_FEED);
            pw.print("  </tr> " + LINE_FEED);
            pw.print("</table> " + LINE_FEED);
            citem.sortCalls();
            pw.print("<table border=\"0\">" + LINE_FEED);
            pw.print("  <tr>" + LINE_FEED);
            pw.print("    <td valign=\"top\" width=\"100\">");
            pw.print(ProfArb.getString(38));
            pw.print("</td>" + LINE_FEED);
            pw.print("    <td>" + LINE_FEED);
            pw.print("<table border=\"1\">" + LINE_FEED);
            pw.print("  <tbody>" + LINE_FEED);
            pw.print("    <tr>" + LINE_FEED);
            pw.print("      <td align=\"center\" bgcolor=\"#C0C0C0\" width=\"400\">");
            pw.print(ProfArb.getString(70));
            pw.print("</td>" + LINE_FEED);
            pw.print("      <td align=\"center\" bgcolor=\"#C0C0C0\" width=\"400\">");
            pw.print(ProfArb.getString(253));
            pw.print("</td>" + LINE_FEED);
            pw.print("      <td align=\"center\" bgcolor=\"#C0C0C0\" width=\"80\">");
            pw.print(ProfArb.getString(92));
            pw.print("</td>" + LINE_FEED);
            pw.print("      <td align=\"center\" bgcolor=\"#C0C0C0\" width=\"80\">" + ProfArb.getString(190) + "</td>" + LINE_FEED);
            pw.print("  </tr>" + LINE_FEED);
            ArrayList clist = citem.getCallerList();
            int max = clist.size();
            int j = 0;
            while (j < max) {
                scc = (SubCallCount)clist.get(j);
                CallCountItem cci = (CallCountItem)scc.ref;
                pw.print(this.TABLE_Row(HTMLSaver.HTML_Escape(cci.getPseudoClass()), this.URLLink("det" + cci.getRef(), cci.getPseudoName() + cci.getNiceSignature()), SampleTable.pFormat((double)scc.count / (double)citem.callerTotal), Integer.toString(scc.count)));
                ++j;
            }
            pw.print("</tbody>" + LINE_FEED);
            pw.print("</table>" + LINE_FEED);
            pw.print("    </td>" + LINE_FEED);
            pw.print("  </tr>" + LINE_FEED);
            pw.print("</table>" + LINE_FEED);
            pw.print("<p>");
            pw.print(LINE_FEED);
            pw.print(LINE_FEED);
            pw.print("<table border=\"0\">" + LINE_FEED);
            pw.print("  <tr>" + LINE_FEED);
            pw.print("    <td valign=\"top\" width=\"100\">");
            pw.print(ProfArb.getString(197));
            pw.print("</td>" + LINE_FEED);
            pw.print("    <td>" + LINE_FEED);
            pw.print("<table border=\"1\">" + LINE_FEED);
            pw.print("  <tbody>" + LINE_FEED);
            pw.print("    <tr>" + LINE_FEED);
            pw.print("      <td align=\"center\" bgcolor=\"#C0C0C0\" width=\"400\">");
            pw.print(ProfArb.getString(239));
            pw.print("</td>" + LINE_FEED);
            pw.print("      <td align=\"center\" bgcolor=\"#C0C0C0\" width=\"400\">");
            pw.print(ProfArb.getString(109));
            pw.print("</td>" + LINE_FEED);
            pw.print("      <td align=\"center\" bgcolor=\"#C0C0C0\" width=\"80\">");
            pw.print(ProfArb.getString(54));
            pw.print("</td>" + LINE_FEED);
            pw.print("      <td align=\"center\" bgcolor=\"#C0C0C0\" width=\"80\">" + ProfArb.getString(190) + "</td>" + LINE_FEED);
            pw.print("  </tr>" + LINE_FEED);
            pw.print("    <tr>" + LINE_FEED);
            pw.print("      <td colspan=\"2\"><b>");
            pw.print(ProfArb.getString(122));
            pw.print("</b></td>" + LINE_FEED);
            pw.print("    <td align=\"right\">");
            pw.print(SampleTable.pFormat((double)citem.getCallCount() / (double)citem.calledTotal));
            pw.print("</td>" + LINE_FEED);
            pw.print("    <td align=\"right\">");
            pw.print(Integer.toString(citem.getCallCount()));
            pw.print("</td>" + LINE_FEED);
            pw.print("  </tr>" + LINE_FEED);
            clist = citem.getCalledList();
            max = clist.size();
            j = 0;
            while (j < max) {
                scc = (SubCallCount)clist.get(j);
                CallCountItem cci = (CallCountItem)scc.ref;
                pw.print(this.TABLE_Row(HTMLSaver.HTML_Escape(cci.getPseudoClass()), this.URLLink("det" + cci.getRef(), cci.getPseudoName() + cci.getNiceSignature()), SampleTable.pFormat((double)scc.count / (double)citem.calledTotal), Integer.toString(scc.count)));
                ++j;
            }
            pw.print("</tbody>" + LINE_FEED);
            pw.print("</table>" + LINE_FEED);
            pw.print("    </td>" + LINE_FEED);
            pw.print("  </tr>" + LINE_FEED);
            pw.print("</table>" + LINE_FEED);
            pw.print("<HR>");
            pw.print(LINE_FEED);
            ++i;
        }
        pw.print(HT_FOOTER);
    }

    private void saveEventTable(PrintWriter pw) {
        ProfileEvent citem;
        pw.print(HT_HEADER1);
        pw.print(IdeUtil.getIdeIanaEncoding());
        pw.print(HT_HEADER2);
        pw.print(ProfArb.getString(145));
        pw.print(HT_HEADER3);
        pw.print("<table border=\"1\">" + LINE_FEED);
        pw.print("  <tbody>" + LINE_FEED);
        pw.print("    <tr>" + LINE_FEED);
        pw.print("      <td align=\"center\" bgcolor=\"#C0C0C0\" width=\"100\">" + ProfArb.getString(313) + "</td>" + LINE_FEED);
        pw.print("      <td align=\"center\" bgcolor=\"#C0C0C0\" width=\"400\">" + ProfArb.getString(170) + "</td>" + LINE_FEED);
        pw.print("      <td align=\"center\" bgcolor=\"#C0C0C0\" width=\"400\">" + ProfArb.getString(231) + "</td>" + LINE_FEED);
        pw.print("      <td align=\"center\" bgcolor=\"#C0C0C0\" width=\"80\">" + ProfArb.getString(224) + "</td>" + LINE_FEED);
        pw.print("      <td align=\"center\" bgcolor=\"#C0C0C0\" width=\"80\">" + ProfArb.getString(284) + "</td>" + LINE_FEED);
        pw.print("      <td align=\"center\" bgcolor=\"#C0C0C0\" width=\"80\">" + ProfArb.getString(303) + "</td>" + LINE_FEED);
        pw.print("    </tr>" + LINE_FEED);
        int i = 0;
        while (i < this.events.length) {
            String comment;
            citem = this.events[i];
            String shortComm = citem.getShortCommentS();
            comment = shortComm.equals(comment = citem.getCommentS()) ? HTMLSaver.HTML_Escape(shortComm) : this.URLTag("l" + i) + HTMLSaver.HTML_Escape(shortComm) + " " + this.URLLink("d" + i, "+++");
            pw.print(this.TABLE_Row(HTMLSaver.HTML_Escape(citem.getIdS()), comment, HTMLSaver.HTML_Escape(citem.getPosS()), citem.getStartS(), citem.getEndS(), citem.getDurationS()));
            ++i;
        }
        pw.print("  </tbody>" + LINE_FEED);
        pw.print("</table>" + LINE_FEED);
        i = 0;
        while (i < this.events.length) {
            String comment;
            citem = this.events[i];
            String shortComm = citem.getShortCommentS();
            if (!shortComm.equals(comment = citem.getCommentS())) {
                pw.print("</p>" + this.URLTag("d" + i) + this.URLLink("l" + i, ProfArb.getString(26)) + "<br>" + ProfArb.getString(313) + " : " + HTMLSaver.HTML_Escape(citem.getIdS()) + "<br>" + ProfArb.getString(231) + " : " + HTMLSaver.HTML_Escape(citem.getPosS()) + "<br>" + ProfArb.getString(224) + " : " + HTMLSaver.HTML_Escape(citem.getStartS()) + "<br>" + ProfArb.getString(284) + " : " + HTMLSaver.HTML_Escape(citem.getEndS()) + "<br>" + ProfArb.getString(303) + " : " + HTMLSaver.HTML_Escape(citem.getDurationS()) + "<br>" + ProfArb.getString(170) + " : <br>" + HTMLSaver.HTML_Escape_ln(comment) + "</p> " + LINE_FEED);
                pw.print("<HR>");
            }
            ++i;
        }
    }

    public void SaveToFile(Context context) {
        PrintWriter pw = HTMLSaver.getPrintWriter(context);
        if (pw != null) {
            if (this.table != null) {
                this.saveSampleTable(pw);
            } else if (this.memTable != null) {
                this.saveMemSampleTable(pw);
            } else if (this.events != null) {
                this.saveEventTable(pw);
            }
            pw.flush();
            pw.close();
        }
    }
}

