/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.profile;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import oracle.ide.util.IntHashMap;
import oracle.jdevimpl.runner.profile.ProfArb;
import oracle.jdevimpl.runner.profile.VMMethod;

class HeapDetailStat {
    VMMethod method;
    int line;
    int nb;
    int nballoc;
    int nbfreed;
    int size;
    int sizealloc;
    int sizefreed;
    String name;

    private void $init$() {
        this.name = null;
    }

    public HeapDetailStat(VMMethod pmethod, int pline, int pnb, int pnballoc, int pnbfreed, int psize, int psizealloc, int psizefreed) {
        this.$init$();
        this.method = pmethod;
        this.line = pline;
        this.nb = pnb;
        this.nballoc = pnballoc;
        this.nbfreed = pnbfreed;
        this.size = psize;
        this.sizealloc = psizealloc;
        this.sizefreed = psizefreed;
    }

    public HeapDetailStat(HeapDetailStat src) {
        this.$init$();
        this.method = src.method;
        this.line = src.line;
        this.nb = src.nb;
        this.nballoc = src.nballoc;
        this.nbfreed = src.nbfreed;
        this.size = src.size;
        this.sizealloc = src.sizealloc;
        this.sizefreed = src.sizefreed;
    }

    void saveToFile(DataOutputStream stream) throws IOException {
        if (this.method == null) {
            stream.writeInt(0);
        } else {
            stream.writeInt(this.method.methodDescriptor);
        }
        stream.writeInt(this.line);
        stream.writeInt(this.nb);
        stream.writeInt(this.nballoc);
        stream.writeInt(this.nbfreed);
        stream.writeInt(this.size);
        stream.writeInt(this.sizealloc);
        stream.writeInt(this.sizefreed);
    }

    static HeapDetailStat readFromFile(DataInputStream stream, IntHashMap mmap) throws IOException {
        int mindex = stream.readInt();
        VMMethod method = null;
        if (mindex != 0) {
            method = (VMMethod)mmap.get(mindex);
        }
        int line = stream.readInt();
        int nb = stream.readInt();
        int nballoc = stream.readInt();
        int nbfreed = stream.readInt();
        int size = stream.readInt();
        int sizealloc = stream.readInt();
        int sizefreed = stream.readInt();
        return new HeapDetailStat(method, line, nb, nballoc, nbfreed, size, sizealloc, sizefreed);
    }

    public void clearDiffs() {
        this.nballoc = 0;
        this.nbfreed = 0;
        this.sizealloc = 0;
        this.sizefreed = 0;
    }

    public void clearValues() {
        this.nb = 0;
        this.size = 0;
    }

    public void update(int pnb, int pnballoc, int pnbfreed, int psize, int psizealloc, int psizefreed) {
        this.nb += pnb;
        this.nballoc += pnballoc;
        this.nbfreed += pnbfreed;
        this.size += psize;
        this.sizealloc += psizealloc;
        this.sizefreed += psizefreed;
    }

    public int getNbDiff() {
        return this.nballoc - this.nbfreed;
    }

    public int getSizeDiff() {
        return this.sizealloc - this.sizefreed;
    }

    String getFileName() {
        return this.method.clazz.fileName;
    }

    int getLine() {
        return this.line;
    }

    String getPackage() {
        return this.method.clazz.packageName;
    }

    public String getName() {
        if (this.name == null) {
            this.name = ProfArb.format(322, this.method.toString(), Integer.toString(this.line));
        }
        return this.name;
    }

    public void subtract(int pnb, int pnballoc, int pnbfreed, int psize, int psizealloc, int psizefreed) {
        this.nb -= pnb;
        this.nballoc -= pnballoc;
        this.nbfreed -= pnbfreed;
        this.size -= psize;
        this.sizealloc -= psizealloc;
        this.sizefreed -= psizefreed;
    }
}

