/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.profile;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import oracle.ide.util.IntHashMap;
import oracle.jdevimpl.runner.profile.VMClass;

class HeapStat {
    VMClass clazz;
    int nb;
    int nballoc;
    int nbfreed;
    int size;
    int sizealloc;
    int sizefreed;

    public int getClassDesc() {
        return this.clazz.classDescriptor;
    }

    public VMClass getClazz() {
        return this.clazz;
    }

    public HeapStat(HeapStat hs) {
        this.clazz = hs.clazz;
        this.nb = hs.nb;
        this.nballoc = hs.nballoc;
        this.nbfreed = hs.nbfreed;
        this.size = hs.size;
        this.sizealloc = hs.sizealloc;
        this.sizefreed = hs.sizefreed;
    }

    public HeapStat(VMClass pclazz, int pnb, int pnballoc, int pnbfreed, int psize, int psizealloc, int psizefreed) {
        this.clazz = pclazz;
        this.nb = pnb;
        this.nballoc = pnballoc;
        this.nbfreed = pnbfreed;
        this.size = psize;
        this.sizealloc = psizealloc;
        this.sizefreed = psizefreed;
    }

    void saveToFile(DataOutputStream stream) throws IOException {
        stream.writeInt(this.clazz.classDescriptor);
        stream.writeInt(this.nb);
        stream.writeInt(this.nballoc);
        stream.writeInt(this.nbfreed);
        stream.writeInt(this.size);
        stream.writeInt(this.sizealloc);
        stream.writeInt(this.sizefreed);
    }

    static HeapStat readFromFile(DataInputStream stream, IntHashMap cmap) throws IOException {
        int cindex = stream.readInt();
        VMClass clazz = (VMClass)cmap.get(cindex);
        int nb = stream.readInt();
        int nballoc = stream.readInt();
        int nbfreed = stream.readInt();
        int size = stream.readInt();
        int sizealloc = stream.readInt();
        int sizefreed = stream.readInt();
        return new HeapStat(clazz, nb, nballoc, nbfreed, size, sizealloc, sizefreed);
    }

    public void clearDiffs() {
        this.nballoc = 0;
        this.nbfreed = 0;
        this.sizealloc = 0;
        this.sizefreed = 0;
    }

    public void update(int pnb, int pnballoc, int pnbfreed, int psize, int psizealloc, int psizefreed) {
        this.nb = pnb;
        this.nballoc = pnballoc;
        this.nbfreed = pnbfreed;
        this.size = psize;
        this.sizealloc = psizealloc;
        this.sizefreed = psizefreed;
    }

    public int getNbDiff() {
        return this.nballoc - this.nbfreed;
    }

    public int getSizeDiff() {
        return this.sizealloc - this.sizefreed;
    }

    public String getName() {
        return this.clazz.toString();
    }
}

