/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.profile;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.text.DecimalFormat;
import javax.swing.JComponent;
import oracle.javatools.util.SwingUtils;

public class HorzRule
extends JComponent {
    private float _nScale;
    private static DecimalFormat timeFormat = new DecimalFormat("###0.####");

    private void $init$() {
        this._nScale = 1.0f;
    }

    public void setScale(float nScale) {
        this._nScale = nScale;
        this.repaint();
    }

    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Dimension d = this.getSize();
        Rectangle rClip = g.getClipBounds();
        int nStart = rClip.x;
        int nStop = rClip.x + rClip.width;
        nStart = Math.max(0, nStart / 100 - 1);
        float f = this._nScale * (float)nStart;
        nStart *= 100;
        FontMetrics fm = g.getFontMetrics();
        int textpos = d.height - 3;
        while (nStart <= nStop) {
            g.setColor(Color.black);
            f = (float)Math.round(f * 10000.0f) / 10000.0f;
            String s = timeFormat.format(f);
            SwingUtils.drawString((Graphics)g, (String)s, (int)(nStart - fm.stringWidth(s) / 2), (int)textpos);
            f += this._nScale / 2.0f;
            f = (float)Math.round(f * 10000.0f) / 10000.0f;
            s = timeFormat.format(f);
            SwingUtils.drawString((Graphics)g, (String)s, (int)((nStart += 50) - fm.stringWidth(s) / 2), (int)textpos);
            nStart += 50;
            f += this._nScale / 2.0f;
        }
    }

    public HorzRule() {
        this.$init$();
    }
}

