/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.profile;

import java.awt.Component;
import java.util.Map;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.ide.Addin;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeConstants;
import oracle.ide.compiler.BuildSystemListener;
import oracle.ide.compiler.BuildSystemVetoException;
import oracle.ide.compiler.Compiler;
import oracle.ide.config.ClientSetting;
import oracle.ide.config.IdeSettings;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.MenuManager;
import oracle.ide.controller.Menubar;
import oracle.ide.controls.ToggleAction;
import oracle.ide.keyboard.KeyStrokeContextRegistry;
import oracle.ide.model.Observer;
import oracle.ide.model.Project;
import oracle.ide.model.UpdateMessage;
import oracle.ide.panels.Navigable;
import oracle.ide.runner.Profiler;
import oracle.ide.runner.Runner;
import oracle.ide.util.ArrayResourceBundle;
import oracle.ide.view.View;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.util.Copyable;
import oracle.jdeveloper.JDeveloperMenuConstants;
import oracle.jdeveloper.compiler.UnifiedBuildSystem;
import oracle.jdeveloper.library.JDK;
import oracle.jdeveloper.runner.RunConfiguration;
import oracle.jdevimpl.runner.Helpers;
import oracle.jdevimpl.runner.profile.EventTable;
import oracle.jdevimpl.runner.profile.EventsConfigurationPanel;
import oracle.jdevimpl.runner.profile.FileSavable;
import oracle.jdevimpl.runner.profile.HTMLSavable;
import oracle.jdevimpl.runner.profile.LocationProvider;
import oracle.jdevimpl.runner.profile.MemoryConfigurationPanel;
import oracle.jdevimpl.runner.profile.MemoryDetailTable;
import oracle.jdevimpl.runner.profile.MemoryTable;
import oracle.jdevimpl.runner.profile.ProfArb;
import oracle.jdevimpl.runner.profile.ProfWindow;
import oracle.jdevimpl.runner.profile.ProfileConfiguration;
import oracle.jdevimpl.runner.profile.ProfileConfigurationPanel;
import oracle.jdevimpl.runner.profile.ProfilerDockableFactory;
import oracle.jdevimpl.runner.profile.ProfilerSettings;
import oracle.jdevimpl.runner.profile.ProfilerSettingsPanel;
import oracle.jdevimpl.runner.profile.ProfilingProcess;
import oracle.jdevimpl.runner.profile.SampleConfigurationPanel;
import oracle.jdevimpl.runner.profile.SampleTable;
import oracle.jdevimpl.runner.profile.UpdatableSettings;
import oracle.jdevimpl.runner.profile.VMClass;
import oracle.jdevimpl.runner.profile.VMMethod;

public class JProfiler
extends Profiler
implements Controller,
ContextMenuListener,
Observer,
Addin,
BuildSystemListener {
    ProfilerDockableFactory dockFactory;
    static IdeAction actionStart;
    static IdeAction actionStartEvent;
    static JMenuItem startEventMenu;
    static IdeAction actionStartSample;
    static JMenuItem startSampleMenu;
    static IdeAction actionStartMemory;
    static JMenuItem startMemoryMenu;
    static IdeAction actionStartFromFile;
    static JMenuItem startFromFileMenu;
    static ContextMenu contextMenu;
    private static IdeAction actionHTMLSave;
    private static IdeAction actionFileSave;
    private static IdeAction actionFindSource;
    private static IdeAction actionHTMLSaveAll;
    private static IdeAction actionGetDetail;
    private static IdeAction actionSetSettings;
    private static JMenuItem menuHTMLSave;
    private static JMenuItem menuFileSave;
    private static JMenuItem menuFindSource;
    private static JMenuItem menuHTMLSaveAll;
    private static JMenuItem menuGetDetail;
    private static JMenuItem menuSetSettings;
    private Project activeProject;
    private static final int PROFILE_START_CMD_ID;
    private static final int PROFILE_START_SAMPLE_CMD_ID;
    private static final int PROFILE_START_EVENT_CMD_ID;
    private static final int PROFILE_START_MEMORY_CMD_ID;
    private static final int PROFILE_START_FROMFILE_CMD_ID;
    private static final int HTML_SAVE_CMD_ID;
    private static final int FILE_SAVE_CMD_ID;
    private static final int HTML_FIND_SRC_CMD_ID;
    private static final int HTML_SAVE_ALL_CMD_ID;
    private static final int GET_DETAIL_CMD_ID;
    private static final int SET_SETTINGS_CMD_ID;
    static final int PROFTYPE_SAMPLE = 0;
    static final int PROFTYPE_EVENT = 1;
    static final int PROFTYPE_MEMORY = 2;
    static final int PROFTYPE_FILE = 10;
    private static int _runCount;
    private int _currentProfType;
    private boolean _popupActive;

    private void $init$() {
        this._currentProfType = 0;
        this._popupActive = false;
    }

    public JProfiler() {
        this.$init$();
        VMMethod.compareField = 4;
        VMClass.compareField = 3;
    }

    public void addInitialEvent(String s) {
        ProfileConfiguration.addInitialEvent(s);
    }

    public boolean handleEvent(IdeAction action, Context context) {
        int cmdId = action.getCommandId();
        if (cmdId == PROFILE_START_CMD_ID) {
            this.startProcess(this._currentProfType);
            return true;
        }
        if (cmdId == PROFILE_START_SAMPLE_CMD_ID) {
            this._currentProfType = 0;
            actionStart.putValue("SmallIcon", (Object)ProfArb.getIcon(260));
            this.updateStartAction();
            this.startProcess(0);
            return true;
        }
        if (cmdId == PROFILE_START_EVENT_CMD_ID) {
            this._currentProfType = 1;
            actionStart.putValue("SmallIcon", (Object)ProfArb.getIcon(312));
            this.updateStartAction();
            this.startProcess(1);
            return true;
        }
        if (cmdId == PROFILE_START_FROMFILE_CMD_ID) {
            this.startProcess(10);
            return true;
        }
        if (cmdId == PROFILE_START_MEMORY_CMD_ID) {
            this._currentProfType = 2;
            actionStart.putValue("SmallIcon", (Object)ProfArb.getIcon(65));
            this.updateStartAction();
            this.startProcess(2);
            return true;
        }
        if (cmdId == FILE_SAVE_CMD_ID) {
            FileSavable spt = (FileSavable)context.getView();
            if (spt != null) {
                this._popupActive = true;
                spt.saveToFile();
                this._popupActive = false;
            }
            return true;
        }
        if (cmdId == HTML_SAVE_CMD_ID) {
            HTMLSavable spt = (HTMLSavable)context.getView();
            if (spt != null) {
                this._popupActive = true;
                spt.saveToHTML(false);
                this._popupActive = false;
            }
            return true;
        }
        if (cmdId == HTML_FIND_SRC_CMD_ID) {
            LocationProvider spt = (LocationProvider)context.getView();
            if (spt != null) {
                spt.findSource();
            }
            return true;
        }
        if (cmdId == HTML_SAVE_ALL_CMD_ID) {
            HTMLSavable spt = (HTMLSavable)context.getView();
            if (spt != null) {
                this._popupActive = true;
                spt.saveToHTML(true);
                this._popupActive = false;
            }
            return true;
        }
        if (cmdId == GET_DETAIL_CMD_ID) {
            MemoryTable mt = (MemoryTable)context.getView();
            mt.showDetail();
            return true;
        }
        if (cmdId == SET_SETTINGS_CMD_ID) {
            UpdatableSettings mt = (UpdatableSettings)context.getView();
            this._popupActive = true;
            mt.changeSettings();
            this._popupActive = false;
            return true;
        }
        return false;
    }

    public boolean update(IdeAction action, Context context) {
        int cmdId = action.getCommandId();
        if (cmdId == PROFILE_START_CMD_ID || cmdId == PROFILE_START_EVENT_CMD_ID || cmdId == PROFILE_START_SAMPLE_CMD_ID || cmdId == PROFILE_START_MEMORY_CMD_ID) {
            action.setEnabled(this.canStartProcess());
            return true;
        }
        if (cmdId == PROFILE_START_FROMFILE_CMD_ID) {
            action.setEnabled(Ide.getActiveWorkspace() != null && this.activeProject != null);
            return true;
        }
        return false;
    }

    public void menuWillShow(ContextMenu popup) {
        Context context = popup.getContext();
        View view = context.getView();
        if (view instanceof LocationProvider) {
            LocationProvider lp = (LocationProvider)view;
            popup.add((Component)menuFindSource, JDeveloperMenuConstants.SECTION_NAVIGATE_CTXT_MENU);
            menuFindSource.setEnabled(lp.canFindSource());
        }
        if (view instanceof SampleTable || view instanceof EventTable) {
            popup.add((Component)menuHTMLSave, 1.0f);
        }
        if (view instanceof MemoryDetailTable) {
            popup.add((Component)menuHTMLSave, 1.0f);
            popup.add((Component)menuHTMLSaveAll, 1.0f);
        }
        if (view instanceof MemoryTable) {
            MemoryTable mt = (MemoryTable)view;
            popup.add((Component)menuGetDetail, JDeveloperMenuConstants.SECTION_DYNAMIC_CTXT_MENU);
            menuGetDetail.setEnabled(mt.canShowDetail());
            popup.add((Component)menuHTMLSave, 1.0f);
            popup.add((Component)menuHTMLSaveAll, 1.0f);
        }
        if (view instanceof FileSavable) {
            popup.add((Component)menuFileSave, 1.0f);
        }
        if (view instanceof UpdatableSettings) {
            popup.add((Component)menuSetSettings, JDeveloperMenuConstants.SECTION_TOOLS_CTXT_MENU);
        }
    }

    public void menuWillHide(ContextMenu popup) {
    }

    public boolean isPopupActive() {
        return this._popupActive;
    }

    public boolean handleDefaultAction(Context context) {
        return false;
    }

    private void activeProjectChanged() {
        if (this.activeProject != null) {
            this.activeProject.detach((Observer)this);
        }
        this.activeProject = Ide.getActiveProject();
        if (this.activeProject != null) {
            this.activeProject.attach((Observer)this);
        }
    }

    public void update(Object observed, UpdateMessage change) {
        1 runnable = new 1(this, change, observed);
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    public void initialize() {
    }

    public void buildWillStart(Context context) throws BuildSystemVetoException {
        SwingUtilities.invokeLater(new 2());
    }

    public void buildFinished(int errorCount, int warningCount, int infoCount) throws BuildSystemVetoException {
        new 3("JProfilerWaitForCompiler").start();
    }

    public void cleanWillStart(Context context) throws BuildSystemVetoException {
    }

    public void cleanFinished(Context context) throws BuildSystemVetoException {
    }

    private IdeAction myGetAction(int id, String mnemonic) {
        IdeAction action = IdeAction.get((int)id, null, (String)mnemonic);
        int mindex = mnemonic.indexOf("&");
        if (mindex != -1) {
            action.putValue("MnemonicKey", (Object)new Integer(mnemonic.charAt(mindex + 1)));
        }
        return action;
    }

    private void createMenus() {
        Menubar menuMgr = Ide.getMenubar();
        JMenu runMenu = MenuManager.getJMenu((String)"Run");
        String cat = runMenu.getText();
        actionStart = IdeAction.get((int)PROFILE_START_CMD_ID, null, (String)ProfArb.getString(63), (String)cat, (Integer)ProfArb.getInteger(78), (ArrayResourceBundle)ProfArb.getInstance(), (int)260, null, (boolean)false);
        actionStart.addController((Controller)this);
        actionStart.putValue("NoCtxName", (Object)ProfArb.getString(63));
        actionStartEvent = IdeAction.get((int)PROFILE_START_EVENT_CMD_ID, null, (String)ProfArb.getString(216), (String)cat, (Integer)ProfArb.getInteger(5), (ArrayResourceBundle)ProfArb.getInstance(), (int)312, null, (boolean)false);
        actionStartEvent.addController((Controller)this);
        actionStartEvent.putValue("NoCtxName", (Object)ProfArb.getString(216));
        startEventMenu = menuMgr.createMenuItem((ToggleAction)actionStartEvent, JDeveloperMenuConstants.WEIGHT_RUN_PROFILE_EVENTS);
        menuMgr.add((Component)startEventMenu, runMenu, JDeveloperMenuConstants.SECTION_RUN_PROFILE);
        actionStartSample = IdeAction.get((int)PROFILE_START_SAMPLE_CMD_ID, null, (String)ProfArb.getString(309), (String)cat, (Integer)ProfArb.getInteger(149), (ArrayResourceBundle)ProfArb.getInstance(), (int)260, null, (boolean)false);
        actionStartSample.addController((Controller)this);
        actionStartSample.putValue("NoCtxName", (Object)ProfArb.getString(309));
        startSampleMenu = menuMgr.createMenuItem((ToggleAction)actionStartSample, JDeveloperMenuConstants.WEIGHT_RUN_PROFILE_EXECUTION);
        menuMgr.add((Component)startSampleMenu, runMenu, JDeveloperMenuConstants.SECTION_RUN_PROFILE);
        actionStartMemory = IdeAction.get((int)PROFILE_START_MEMORY_CMD_ID, null, (String)ProfArb.getString(19), (String)cat, (Integer)ProfArb.getInteger(225), (ArrayResourceBundle)ProfArb.getInstance(), (int)65, null, (boolean)false);
        actionStartMemory.addController((Controller)this);
        actionStartMemory.putValue("NoCtxName", (Object)ProfArb.getString(19));
        startMemoryMenu = menuMgr.createMenuItem((ToggleAction)actionStartMemory, JDeveloperMenuConstants.WEIGHT_RUN_PROFILE_MEMORY);
        menuMgr.add((Component)startMemoryMenu, runMenu, JDeveloperMenuConstants.SECTION_RUN_PROFILE);
        actionStartFromFile = IdeAction.get((int)PROFILE_START_FROMFILE_CMD_ID, null, (String)ProfArb.getString(21), (String)cat, (Integer)ProfArb.getInteger(252), null, null, (boolean)false);
        actionStartFromFile.addController((Controller)this);
        actionStartFromFile.putValue("NoCtxName", (Object)ProfArb.getString(21));
        startFromFileMenu = menuMgr.createMenuItem((ToggleAction)actionStartFromFile, JDeveloperMenuConstants.WEIGHT_RUN_PROFILE_LOAD);
        menuMgr.add((Component)startFromFileMenu, runMenu, JDeveloperMenuConstants.SECTION_RUN_PROFILE);
        actionHTMLSave = this.myGetAction(HTML_SAVE_CMD_ID, ProfArb.getString(101));
        actionHTMLSave.addController((Controller)this);
        actionFileSave = this.myGetAction(FILE_SAVE_CMD_ID, ProfArb.getString(128));
        actionFileSave.addController((Controller)this);
        actionFindSource = this.myGetAction(HTML_FIND_SRC_CMD_ID, ProfArb.getString(37));
        actionFindSource.addController((Controller)this);
        actionHTMLSaveAll = this.myGetAction(HTML_SAVE_ALL_CMD_ID, ProfArb.getString(276));
        actionHTMLSaveAll.addController((Controller)this);
        actionGetDetail = this.myGetAction(GET_DETAIL_CMD_ID, ProfArb.getString(281));
        actionGetDetail.addController((Controller)this);
        actionSetSettings = this.myGetAction(SET_SETTINGS_CMD_ID, ProfArb.getString(86));
        actionSetSettings.addController((Controller)this);
        contextMenu = new ContextMenu();
        contextMenu.addContextMenuListener((ContextMenuListener)this);
        menuHTMLSave = contextMenu.createMenuItem((ToggleAction)actionHTMLSave);
        menuFileSave = contextMenu.createMenuItem((ToggleAction)actionFileSave);
        menuFindSource = contextMenu.createMenuItem((ToggleAction)actionFindSource);
        menuHTMLSaveAll = contextMenu.createMenuItem((ToggleAction)actionHTMLSaveAll);
        menuGetDetail = contextMenu.createMenuItem((ToggleAction)actionGetDetail);
        menuSetSettings = contextMenu.createMenuItem((ToggleAction)actionSetSettings);
        KeyStrokeContextRegistry keyStrokeContextRegistry = Ide.getKeyStrokeContextRegistry();
        keyStrokeContextRegistry.addAcceleratorDefinitionFile(this.getClass().getClassLoader(), "oracle/jdevimpl/runner/profile/accelerators.xml");
    }

    private static void initializeIDESettings() {
        ClientSetting clientSetting = ClientSetting.findOrCreate((String)"oracle.jdeveloper");
        if (!clientSetting.hasData("ProfilerSettings")) {
            clientSetting.putData("ProfilerSettings", (Copyable)new ProfilerSettings());
        }
        ProfilerSettings profilerSettings = ProfilerSettings.getInstance();
        profilerSettings.addChangeListener(new 4());
    }

    private static void registerSettingsPanels() {
        Navigable[] childNavigables = new Navigable[]{new Navigable(ProfArb.getString(83), EventsConfigurationPanel.class), new Navigable(ProfArb.getString(17), SampleConfigurationPanel.class), new Navigable(ProfArb.getString(105), MemoryConfigurationPanel.class)};
        Navigable navigable = new Navigable(ProfArb.getString(58), ProfileConfigurationPanel.class, childNavigables);
        Runner.getRunner().addRunConfigurationToolNavigable(navigable);
        navigable = new Navigable(ProfArb.getString(58), ProfilerSettingsPanel.class);
        IdeSettings.registerUI((Navigable)navigable);
    }

    private void updateProfileActions() {
        Context context = Ide.getMainWindow().getLastActiveView().getContext();
        this.update(actionStart, context);
        this.update(actionStartEvent, context);
        this.update(actionStartSample, context);
        this.update(actionStartMemory, context);
    }

    private void updateStartMenu() {
        Context context = Ide.getMainWindow().getLastActiveView().getContext();
        this.update(actionStart, context);
        this.updateStartAction();
    }

    private void updateStartAction() {
        String projectShortLabel = "";
        if (this.activeProject != null) {
            projectShortLabel = this.activeProject.getShortLabel();
        }
        String startLabel = ProfArb.getString(216) + projectShortLabel;
        actionStartEvent.putValue("Name", (Object)startLabel);
        if (this._currentProfType == 1) {
            actionStart.putValue("Name", (Object)startLabel);
        }
        startLabel = ProfArb.getString(309) + projectShortLabel;
        actionStartSample.putValue("Name", (Object)startLabel);
        if (this._currentProfType == 0) {
            actionStart.putValue("Name", (Object)startLabel);
        }
        startLabel = ProfArb.getString(19) + projectShortLabel;
        actionStartMemory.putValue("Name", (Object)startLabel);
        if (this._currentProfType == 2) {
            actionStart.putValue("Name", (Object)startLabel);
        }
    }

    private boolean canStartProcess() {
        if (Compiler.getCompiler().isBusy(null)) {
            return false;
        }
        if (Ide.getActiveWorkspace() != null && this.activeProject != null) {
            RunConfiguration rc;
            if (this.activeProject.isOpen() && !(rc = RunConfiguration.getInstance((PropertyStorage)this.activeProject)).isRemoteDebuggingProfiling()) {
                JDK jdkDefinition = Helpers.getActiveJdkDefinition(this.activeProject);
                return rc.usingOJVM(jdkDefinition);
            }
            return true;
        }
        return false;
    }

    void reStartProcess(int proftype, ProfWindow lwin, Map dmap) {
        if (Ide.getActiveWorkspace() != null && this.activeProject != null) {
            ProfilingProcess profilingProcess = new ProfilingProcess(this, proftype, ++_runCount, lwin, dmap);
            profilingProcess.start();
        }
    }

    private void startProcess(int proftype) {
        if (Ide.getActiveWorkspace() != null && this.activeProject != null) {
            ProfilingProcess profilingProcess = new ProfilingProcess(this, proftype, ++_runCount);
            profilingProcess.start();
        }
    }

    static {
        PROFILE_START_CMD_ID = Ide.findOrCreateCmdID((String)"ProfileStartCommand");
        PROFILE_START_SAMPLE_CMD_ID = Ide.findOrCreateCmdID((String)"ProfileStartSampleCommand");
        PROFILE_START_EVENT_CMD_ID = Ide.findOrCreateCmdID((String)"ProfileStartEventCommand");
        PROFILE_START_MEMORY_CMD_ID = Ide.findOrCreateCmdID((String)"ProfileStartMemoryCommand");
        PROFILE_START_FROMFILE_CMD_ID = Ide.findOrCreateCmdID((String)"ProfileStartFromFileCommand");
        HTML_SAVE_CMD_ID = Ide.findOrCreateCmdID((String)"ProfilerSaveToHTML");
        FILE_SAVE_CMD_ID = Ide.findOrCreateCmdID((String)"ProfilerSaveToFile");
        HTML_FIND_SRC_CMD_ID = Ide.findOrCreateCmdID((String)"ProfilerFindSource");
        HTML_SAVE_ALL_CMD_ID = Ide.findOrCreateCmdID((String)"ProfilerSaveAllToHTML");
        GET_DETAIL_CMD_ID = Ide.findOrCreateCmdID((String)"ProfilerMemoryGetDetail");
        SET_SETTINGS_CMD_ID = Ide.findOrCreateCmdID((String)"ProfilerSetSettings");
        _runCount = 0;
    }

    static void mav$updateProfileActions(JProfiler jProfiler) {
        jProfiler.updateProfileActions();
    }

    static void mav$activeProjectChanged(JProfiler jProfiler) {
        jProfiler.activeProjectChanged();
    }

    static void mav$updateStartMenu(JProfiler jProfiler) {
        jProfiler.updateStartMenu();
    }

    final class 1
    implements Runnable {
        private final /* synthetic */ UpdateMessage v$change;
        private final /* synthetic */ Object v$observed;
        final /* synthetic */ JProfiler this$0;

        public void run() {
            int messageID = this.v$change.getMessageID();
            if (this.v$observed == Ide.getSystem()) {
                if (messageID == IdeConstants.ACTIVE_PROJECT_CHANGED) {
                    JProfiler.mav$activeProjectChanged(this.this$0);
                    JProfiler.mav$updateStartMenu(this.this$0);
                }
            } else if (this.v$observed instanceof Project && messageID == UpdateMessage.PROPERTY_SET) {
                JProfiler.mav$updateStartMenu(this.this$0);
                ProfilerDockableFactory.enumerateProfWindow();
            }
        }

        public 1(JProfiler jProfiler, UpdateMessage updateMessage, Object object) {
            this.v$observed = object;
            this.v$change = updateMessage;
            this.this$0 = jProfiler;
        }
    }

    final class 2
    implements Runnable {
        public void run() {
            JProfiler.mav$updateProfileActions(JProfiler.this);
        }
    }

    final class 3
    extends Thread {
        public void run() {
            try {
                UnifiedBuildSystem.getInstance().join(0L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            SwingUtilities.invokeLater(new 1());
        }

        public 3(String string) {
            super(string);
        }

        final class 1
        implements Runnable {
            public void run() {
                JProfiler.mav$updateProfileActions(JProfiler.this);
            }
        }
    }

    static final class 4
    implements ChangeListener {
        public void stateChanged(ChangeEvent e) {
            ProfilerDockableFactory.enumerateProfWindow();
        }
    }
}

