/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.profile;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import oracle.jdevimpl.runner.profile.GenerateDiffDialog;
import oracle.jdevimpl.runner.profile.MemoryUseTable;
import oracle.jdevimpl.runner.profile.ProfArb;
import oracle.jdevimpl.runner.profile.VMClass;

final class MemoryAllocTable
extends JPanel {
    private static final int COLUMN_PACKAGENAME = 0;
    private static final int COLUMN_CLASSNAME = 1;
    private static final int COLUMN_INSTANCES = 2;
    private static final int COLUMN_SIZE = 3;
    private static final int N_COLUMNS = 4;
    private static final int TABLE_DYNAMIC = 0;
    private static final int TABLE_SNAPSHOT = 1;
    private static final int TABLE_DIFF = 2;
    private List classArray;
    private JTable table;
    private MemoryUseTable parent;
    private JButton diffButton;
    private int nAllocations;
    private int allocSize;
    private int tableType;
    private String title;
    static final String PACKAGE_TITLE = ProfArb.getString(113);
    static final String NAME_TITLE = ProfArb.getString(294);
    static final String INSTANCES_TITLE = ProfArb.getString(226);
    static final String SIZE_TITLE = ProfArb.getString(291);

    public MemoryAllocTable(MemoryUseTable parent, Object[] array, int tableType) {
        this.parent = parent;
        if (array == null) {
            tableType = 0;
            this.classArray = new ArrayList();
        } else {
            this.tableType = tableType;
            Arrays.sort(array);
            int size = array.length;
            this.classArray = new ArrayList(size);
            int i = 0;
            while (i < size) {
                this.classArray.add(array[i]);
                ++i;
            }
            this.nAllocations = 0;
            this.allocSize = 0;
        }
        this.initialize();
    }

    public MemoryAllocTable(MemoryUseTable parent) {
        this(parent, null, 0);
    }

    public MemoryAllocTable(MemoryUseTable parent, Object[] array) {
        this(parent, array, 1);
    }

    private void initialize() {
        1 dataModel = new 1();
        this.table = new JTable(dataModel);
        this.addMouseListenerToHeaderInTable();
        TableColumnModel tableColumnModel = this.table.getColumnModel();
        TableColumn tableColumn = tableColumnModel.getColumn(0);
        tableColumn.setPreferredWidth((int)((double)tableColumn.getWidth() * 2.0));
        tableColumn = tableColumnModel.getColumn(2);
        tableColumn.setPreferredWidth((int)((double)tableColumn.getWidth() * 0.5));
        tableColumn = tableColumnModel.getColumn(3);
        tableColumn.setPreferredWidth((int)((double)tableColumn.getWidth() * 0.5));
        Dimension spacing = new Dimension(0, 0);
        this.table.setIntercellSpacing(spacing);
        ListSelectionModel listSelectionModel = this.table.getSelectionModel();
        listSelectionModel.setSelectionMode(0);
        JPanel controlsPanel = new JPanel();
        controlsPanel.setLayout(new BoxLayout(controlsPanel, 0));
        if (this.tableType == 1) {
            this.diffButton = new JButton(ProfArb.getString(111));
            this.enableGenerateDiff();
            this.diffButton.addActionListener(new 2());
            controlsPanel.add(this.diffButton);
            controlsPanel.add(new JLabel("  "));
        } else if (this.tableType == 0) {
            JButton snapShotButton = new JButton(ProfArb.getString(84));
            snapShotButton.addActionListener(new 3());
            controlsPanel.add(snapShotButton);
            controlsPanel.add(new JLabel("  "));
        }
        JComboBox filterCBox = new JComboBox();
        controlsPanel.add(new JLabel(ProfArb.getString(236)));
        controlsPanel.add(filterCBox);
        this.setLayout(new BoxLayout(this, 1));
        this.add(controlsPanel);
        this.add(new JScrollPane(this.table));
    }

    private void addMouseListenerToHeaderInTable() {
        JTable tableView = this.table;
        tableView.setColumnSelectionAllowed(false);
        4 lMouseListener = new 4(this, tableView);
        JTableHeader th = tableView.getTableHeader();
        th.addMouseListener(lMouseListener);
    }

    private void SortArray(int column) {
        if (VMClass.compareField == column) {
            VMClass.ascending ^= true;
        } else {
            VMClass.compareField = column;
        }
        Object[] array = this.classArray.toArray();
        Arrays.sort(array);
        int size = this.classArray.size();
        this.classArray = new ArrayList(size);
        int i = 0;
        while (i < size) {
            this.classArray.add(array[i]);
            ++i;
        }
    }

    private synchronized void generateSnapshot() {
        MemoryAllocTable snapshotTable = new MemoryAllocTable(this.parent, this.classArray.toArray());
        snapshotTable.title = this.parent.addSnaphotTable(snapshotTable);
    }

    public void enableGenerateDiff() {
        this.diffButton.setEnabled(this.parent.getNMemorySnapshots() > 1);
    }

    private synchronized void generateDiff() {
        String[] availSnapshots = this.parent.getMemorySnapshotNames();
        if (availSnapshots != null && availSnapshots.length > 1) {
            int l = availSnapshots.length;
            String[] availSources = new String[l - 1];
            int j = 0;
            int i = 0;
            while (i < l) {
                if (availSnapshots[i].compareTo(this.title) != 0) {
                    availSources[j++] = availSnapshots[i];
                }
                ++i;
            }
            GenerateDiffDialog d = new GenerateDiffDialog(availSources);
            boolean ok = GenerateDiffDialog.runDialog(d);
            if (ok) {
                String tableName = d.getSelected();
                MemoryAllocTable table = this.parent.getMemorySnapshot(tableName);
                List source = table.classArray;
                int sourceLen = source.size();
                int len = this.classArray.size();
                int length = Math.max(len, sourceLen);
                ArrayList<VMClass> difference = new ArrayList<VMClass>(length);
                int i2 = 0;
                while (i2 < sourceLen) {
                    VMClass m = (VMClass)source.get(i2);
                    VMClass n = new VMClass();
                    n.packageName = m.packageName;
                    n.name = m.name;
                    n.fileName = m.fileName;
                    int index = this.classArray.indexOf(m);
                    if (index > -1) {
                        VMClass current = (VMClass)this.classArray.get(index);
                        n.nAllocations = m.nAllocations - current.nAllocations;
                        n.allocSize = m.allocSize - current.allocSize;
                    } else {
                        n.nAllocations = m.nAllocations;
                        n.allocSize = m.allocSize;
                    }
                    if (n.nAllocations != 0) {
                        difference.add(n);
                    }
                    ++i2;
                }
                int i3 = 0;
                while (i3 < len) {
                    VMClass m = (VMClass)this.classArray.get(i3);
                    VMClass n = new VMClass();
                    n.packageName = m.packageName;
                    n.name = m.name;
                    n.fileName = m.fileName;
                    if (difference.indexOf(m) == -1) {
                        int index = source.indexOf(m);
                        if (index > -1) {
                            VMClass current = (VMClass)source.get(index);
                            n.nAllocations = m.nAllocations - current.nAllocations;
                            n.allocSize = m.allocSize - current.allocSize;
                        } else {
                            n.nAllocations = m.nAllocations;
                            n.allocSize = m.allocSize;
                        }
                        if (n.nAllocations != 0) {
                            difference.add(n);
                        }
                    }
                    ++i3;
                }
                MemoryAllocTable diffTable = new MemoryAllocTable(this.parent, difference.toArray(), 2);
                diffTable.title = this.parent.addDiffTable(diffTable);
            }
        }
    }

    public void update(VMClass clazz) {
        if (clazz.nAllocations == 1) {
            this.classArray.add(clazz);
        } else {
            int i = this.classArray.indexOf(clazz);
            this.classArray.set(i, clazz);
        }
    }

    public void updateList(Object[] array, int totalAllocations, int totalSize) {
        Arrays.sort(array);
        int size = array.length;
        this.classArray = new ArrayList(size);
        int i = 0;
        while (i < size) {
            this.classArray.add(array[i]);
            ++i;
        }
        this.nAllocations = totalAllocations;
        this.allocSize = totalSize;
        this.table.tableChanged(new TableModelEvent(this.table.getModel()));
    }

    static void mav$SortArray(MemoryAllocTable memoryAllocTable, int n) {
        memoryAllocTable.SortArray(n);
    }

    static List ra$classArray(MemoryAllocTable memoryAllocTable) {
        return memoryAllocTable.classArray;
    }

    static int ra$tableType(MemoryAllocTable memoryAllocTable) {
        return memoryAllocTable.tableType;
    }

    static int ra$nAllocations(MemoryAllocTable memoryAllocTable) {
        return memoryAllocTable.nAllocations;
    }

    static int ra$allocSize(MemoryAllocTable memoryAllocTable) {
        return memoryAllocTable.allocSize;
    }

    static void mav$generateDiff(MemoryAllocTable memoryAllocTable) {
        memoryAllocTable.generateDiff();
    }

    static void mav$generateSnapshot(MemoryAllocTable memoryAllocTable) {
        memoryAllocTable.generateSnapshot();
    }

    final class 1
    extends AbstractTableModel {
        public int getColumnCount() {
            return 4;
        }

        public int getRowCount() {
            return MemoryAllocTable.ra$classArray(MemoryAllocTable.this).size();
        }

        public String getColumnName(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return PACKAGE_TITLE;
                }
                case 1: {
                    return NAME_TITLE;
                }
                case 2: {
                    return INSTANCES_TITLE;
                }
                case 3: {
                    return SIZE_TITLE;
                }
            }
            return "Error";
        }

        public Object getValueAt(int row, int col) {
            VMClass m = (VMClass)MemoryAllocTable.ra$classArray(MemoryAllocTable.this).get(row);
            switch (col) {
                case 0: {
                    return m.packageName;
                }
                case 1: {
                    return m.name;
                }
                case 2: {
                    if (MemoryAllocTable.ra$tableType(MemoryAllocTable.this) != 0) {
                        return new Integer(m.nAllocations);
                    }
                    return new String(new Integer(m.nAllocations) + " (" + new Double((double)m.nAllocations / (double)MemoryAllocTable.ra$nAllocations(MemoryAllocTable.this) * 100.0) + " %)");
                }
                case 3: {
                    if (MemoryAllocTable.ra$tableType(MemoryAllocTable.this) != 0) {
                        return new Long(m.allocSize);
                    }
                    return new String(new Long(m.allocSize) + " (" + new Double((double)m.allocSize / (double)MemoryAllocTable.ra$allocSize(MemoryAllocTable.this) * 100.0) + ")%");
                }
            }
            return m;
        }
    }

    final class 2
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            MemoryAllocTable.mav$generateDiff(MemoryAllocTable.this);
        }
    }

    final class 3
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            MemoryAllocTable.mav$generateSnapshot(MemoryAllocTable.this);
        }
    }

    final class 4
    extends MouseAdapter {
        private final /* synthetic */ JTable v$tableView;
        final /* synthetic */ MemoryAllocTable this$0;

        public void mouseClicked(MouseEvent e) {
            TableColumnModel columnModel = this.v$tableView.getColumnModel();
            int viewColumn = columnModel.getColumnIndexAtX(e.getX());
            int column = this.v$tableView.convertColumnIndexToModel(viewColumn);
            if (e.getClickCount() == 1 && column != -1) {
                MemoryAllocTable.mav$SortArray(this.this$0, column);
            }
        }

        public 4(MemoryAllocTable memoryAllocTable, JTable jTable) {
            this.v$tableView = jTable;
            this.this$0 = memoryAllocTable;
        }
    }
}

