/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.profile;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.ide.help.HelpSystem;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.Namespace;
import oracle.ide.util.ResourceUtils;
import oracle.jdeveloper.runner.RunConfiguration;
import oracle.jdeveloper.runner.RunConfigurationEditorUtil;
import oracle.jdevimpl.runner.profile.ProfArb;
import oracle.jdevimpl.runner.profile.ProfileConfiguration;

public class MemoryConfigurationPanel
extends DefaultTraversablePanel
implements ChangeListener {
    private JSpinner sliderDepthSpinBoxField;
    private JSpinner memoryIntervalSpinBoxField;
    private JTextField excludedInstances;
    private JTextField includedInstances;
    private JLabel message;
    private JCheckBox manualSamplingCheckBox;
    private final Color messageColor;

    private void $init$() {
        this.messageColor = new Color(192, 0, 0);
    }

    public MemoryConfigurationPanel() {
        this.$init$();
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void stateChanged(ChangeEvent c) {
        if (this.manualSamplingCheckBox.isSelected()) {
            this.memoryIntervalSpinBoxField.setEnabled(false);
        } else {
            this.memoryIntervalSpinBoxField.setEnabled(true);
        }
    }

    public void onEntry(TraversableContext tc) {
        ProfileConfiguration profileConfiguration = MemoryConfigurationPanel.getProfileConfiguration(tc);
        this.loadFrom(profileConfiguration);
    }

    public void onExit(TraversableContext tc) throws TraversalException {
        if (!this.checkValues()) {
            throw new TraversalException(this.getErrorMessage());
        }
        ProfileConfiguration profileConfiguration = MemoryConfigurationPanel.getProfileConfiguration(tc);
        this.commitTo(profileConfiguration);
    }

    private static ProfileConfiguration getProfileConfiguration(TraversableContext tc) {
        RunConfiguration runConfiguration = RunConfigurationEditorUtil.getRunConfiguration((Namespace)tc);
        return ProfileConfiguration.getInstance(runConfiguration);
    }

    private void loadFrom(ProfileConfiguration profileConfiguration) {
        this.sliderDepthSpinBoxField.setValue(new Integer(profileConfiguration.getSliderDepth()));
        int interval = profileConfiguration.getMemoryUpdateInterval();
        if (interval != 0) {
            this.manualSamplingCheckBox.setSelected(false);
            this.memoryIntervalSpinBoxField.setEnabled(true);
            this.memoryIntervalSpinBoxField.setValue(new Double((double)profileConfiguration.getMemoryUpdateInterval() / 10.0));
        } else {
            this.manualSamplingCheckBox.setSelected(true);
            this.memoryIntervalSpinBoxField.setEnabled(false);
        }
        String s = profileConfiguration.getExcludedInstances();
        this.excludedInstances.setText(s != null ? s : "");
        s = profileConfiguration.getIncludedInstances();
        this.includedInstances.setText(s != null ? s : "");
    }

    private void commitTo(ProfileConfiguration profileConfiguration) {
        Number num = (Number)this.sliderDepthSpinBoxField.getValue();
        profileConfiguration.setSliderDepth(num.intValue());
        if (this.manualSamplingCheckBox.isSelected()) {
            profileConfiguration.setMemoryUpdateInterval(0);
        } else {
            num = (Number)this.memoryIntervalSpinBoxField.getValue();
            int config = (int)(num.doubleValue() * 10.0);
            profileConfiguration.setMemoryUpdateInterval(config);
        }
        profileConfiguration.setExcludedInstances(this.excludedInstances.getText());
        profileConfiguration.setIncludedInstances(this.includedInstances.getText());
    }

    private void jbInit() throws Exception {
        HelpSystem.getHelpSystem().registerTopic((JComponent)((Object)this), ProfArb.getString(14));
        this.setLayout(new GridBagLayout());
        this.manualSamplingCheckBox = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.manualSamplingCheckBox, (String)ProfArb.getString(133));
        this.manualSamplingCheckBox.addChangeListener(this);
        JLabel memoryIntervalLabel = new JLabel();
        SpinnerNumberModel model = new SpinnerNumberModel(1.0, 0.5, 100000.0, 0.1);
        this.memoryIntervalSpinBoxField = new JSpinner(model);
        JSpinner.NumberEditor editor = new JSpinner.NumberEditor(this.memoryIntervalSpinBoxField, "0.0");
        this.memoryIntervalSpinBoxField.setEditor(editor);
        ResourceUtils.resLabel((JLabel)memoryIntervalLabel, (Component)this.memoryIntervalSpinBoxField, (String)ProfArb.getString(227));
        JLabel sliderDepthLabel = new JLabel();
        model = new SpinnerNumberModel(20, 2, 500, 1);
        this.sliderDepthSpinBoxField = new JSpinner(model);
        ResourceUtils.resLabel((JLabel)sliderDepthLabel, (Component)this.sliderDepthSpinBoxField, (String)ProfArb.getString(167));
        JLabel includedInstancesLabel = new JLabel();
        this.includedInstances = new JTextField();
        ResourceUtils.resLabel((JLabel)includedInstancesLabel, (Component)this.includedInstances, (String)ProfArb.getString(91));
        JLabel excludedInstancesLabel = new JLabel();
        this.excludedInstances = new JTextField();
        ResourceUtils.resLabel((JLabel)excludedInstancesLabel, (Component)this.excludedInstances, (String)ProfArb.getString(293));
        this.message = new JLabel(" ");
        this.message.setForeground(this.messageColor);
        int x = 0;
        int y = 0;
        this.add(this.manualSamplingCheckBox, new GridBagConstraints(x++, y, 4, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 5, 0), 0, 0));
        x = 0;
        this.add(memoryIntervalLabel, new GridBagConstraints(x++, ++y, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.memoryIntervalSpinBoxField, new GridBagConstraints(x++, y, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 8, 0, 0), 0, 0));
        this.add(sliderDepthLabel, new GridBagConstraints(x++, y, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 30, 0, 0), 0, 0));
        this.add(this.sliderDepthSpinBoxField, new GridBagConstraints(x, y++, 0, 1, 0.0, 0.0, 17, 0, new Insets(0, 8, 0, 0), 0, 0));
        this.add(includedInstancesLabel, new GridBagConstraints(0, y++, 0, 1, 0.0, 0.0, 17, 0, new Insets(10, 0, 2, 0), 0, 0));
        this.add(this.includedInstances, new GridBagConstraints(0, y++, 0, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add(excludedInstancesLabel, new GridBagConstraints(0, y++, 0, 1, 0.0, 0.0, 17, 0, new Insets(10, 0, 2, 0), 0, 0));
        this.add(this.excludedInstances, new GridBagConstraints(0, y++, 0, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.message, new GridBagConstraints(0, y, 0, 1, 1.0, 1.0, 16, 1, new Insets(10, 0, 0, 0), 0, 0));
    }

    private boolean checkValues() {
        return true;
    }

    private String getErrorMessage() {
        return " ";
    }
}

