/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.profile;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import oracle.ide.Context;
import oracle.ide.controller.Controller;
import oracle.ide.help.HelpInfo;
import oracle.ide.resource.ControlsArb;
import oracle.ide.util.IntHashMap;
import oracle.ide.util.PropertyAccess;
import oracle.ide.view.View;
import oracle.jdeveloper.runner.Source;
import oracle.jdevimpl.runner.profile.DefaultAllignRenderer;
import oracle.jdevimpl.runner.profile.HTMLSavable;
import oracle.jdevimpl.runner.profile.HeapDetailStat;
import oracle.jdevimpl.runner.profile.JProfiler;
import oracle.jdevimpl.runner.profile.LocationProvider;
import oracle.jdevimpl.runner.profile.MemoryTable;
import oracle.jdevimpl.runner.profile.ProfArb;
import oracle.jdevimpl.runner.profile.ProfWindow;
import oracle.jdevimpl.runner.profile.ProfilerSettings;
import oracle.jdevimpl.runner.profile.ProfilingProcess;
import oracle.jdevimpl.runner.profile.RightAllignRenderer;
import oracle.jdevimpl.runner.profile.UpdatableSettings;
import oracle.jdevimpl.runner.profile.VMClass;
import oracle.jdevimpl.runner.profile.VMMethod;

public final class MemoryDetailTable
extends ProfWindow
implements LocationProvider,
HTMLSavable,
UpdatableSettings {
    private static final int INITIAL_HEAPSTATSIZE = 20;
    private static final String PROFILES_MEMORY_DETAIL_TABLE_ID = "Profiler.MemoryDetailTable";
    private static final int MAX_TABLE_COL = 9;
    private static final int[] _colToIndex = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9};
    private ProfilingProcess process;
    private String title;
    private JPanel mainPanel;
    private IntHashMap methodMap;
    private Map localDetailMap;
    private VMClass clazz;
    private int heapStatSize;
    private int heapStatSizeUsed;
    private HeapDetailStat[] heapStatArray;
    private int compareField;
    private boolean ascending;
    private int currentTableSize;
    private HeapDetailStat[] currentHeapStatArray;
    private HeapDetailStat[][] heapStatArray_Hist;
    private int[] compareField_Hist;
    private boolean[] ascending_Hist;
    private int currentCompareField;
    private boolean currentAscending;
    private int lastHistorySelected;
    private JTable table;
    private JLabel noDataLabel;
    private JScrollPane mainScrollPane;
    private AbstractTableModel tableModel;
    private boolean[] columnShowing;
    private TableColumn[] column;
    heapDetailComparator hcomp;
    int currentSize;
    int maxSize;
    private MethodKey mkey;
    static final String LOCATION_TITLE = ProfArb.getString(262);
    static final String COUNT_TITLE = ProfArb.getString(29);
    static final String SIZE_TITLE = ProfArb.getString(233);
    static final String ALLOC_COUNT_TITLE = ProfArb.getString(20);
    static final String ALLOC_SIZE_TITLE = ProfArb.getString(10);
    static final String FREED_COUNT_TITLE = ProfArb.getString(45);
    static final String FREED_SIZE_TITLE = ProfArb.getString(265);
    static final String DIFF_COUNT_TITLE = ProfArb.getString(198);
    static final String DIFF_SIZE_TITLE = ProfArb.getString(272);
    private static final HelpInfo HELP_TOPIC = new HelpInfo("prf_aanalyze_mem_results.html");
    private static final Icon ARROW_UP = ControlsArb.getIcon((int)12);
    private static final Icon ARROW_DOWN = ControlsArb.getIcon((int)13);

    private void $init$() {
        this.columnShowing = new boolean[10];
        this.column = new TableColumn[9];
    }

    public MemoryDetailTable(ProfilingProcess p, VMClass pclazz, IntHashMap pmethodMap) {
        this.$init$();
        this.hcomp = new heapDetailComparator();
        this.currentCompareField = 2;
        this.currentAscending = false;
        this.setClazz(pclazz);
        this.initValues(p, pmethodMap);
        this.initialize();
        this.updateSettings();
    }

    private void initValues(ProfilingProcess p, IntHashMap pmethodMap) {
        this.process = p;
        this.methodMap = pmethodMap;
        this.heapStatSize = 20;
        this.heapStatSizeUsed = 0;
        this.heapStatArray = new HeapDetailStat[20];
        this.localDetailMap = new HashMap(20);
        this.mkey = new MethodKey(0, 0);
        this.maxSize = this.maxSize = p.getSliderDepth();
        this.currentSize = 0;
        this.heapStatArray_Hist = new HeapDetailStat[this.maxSize][];
        this.compareField_Hist = new int[this.maxSize];
        this.ascending_Hist = new boolean[this.maxSize];
    }

    void resetProcess(ProfilingProcess p, IntHashMap pmethodMap) {
        this.initValues(p, pmethodMap);
    }

    public Component getGUI() {
        return this.mainPanel;
    }

    public Controller getController() {
        return null;
    }

    public Context getContext(EventObject event) {
        Context context = this.process.getContext();
        context.setView((View)this);
        context.setEvent(event);
        return context;
    }

    public void initialize() {
        this.title = ProfArb.getString(50) + this.process.getRunTitle();
        this.mainPanel = this.createGUI();
    }

    public String getTabName() {
        return ProfArb.getString(50);
    }

    public Icon getTabIcon() {
        return this.process.getIcon();
    }

    public String getTitleName() {
        return this.title;
    }

    public void findSource() {
        int row = this.table.getSelectedRow();
        if (row == -1) {
            return;
        }
        HeapDetailStat citem = this.currentHeapStatArray[row];
        int line = citem.getLine();
        if (line == -1) {
            return;
        }
        Context context = this.getContext();
        Source.showSourceFile(context.getWorkspace(), context.getProject(), citem.getPackage(), null, citem.getFileName(), line, true);
    }

    public boolean canFindSource() {
        int row = this.table.getSelectedRow();
        if (row == -1) {
            return false;
        }
        HeapDetailStat citem = this.currentHeapStatArray[row];
        int line = citem.getLine();
        return line != -1;
    }

    public void changeSettings() {
        this.process.showSettings();
    }

    public void updateSettings() {
        ProfilerSettings ps = ProfilerSettings.getInstance();
        boolean[] show = ps.getMemColumnVisible();
        boolean isChanged = false;
        int i = 0;
        while (i < 9) {
            if (this.columnShowing[_colToIndex[i]] != show[_colToIndex[i]]) {
                isChanged = true;
                this.columnShowing[MemoryDetailTable._colToIndex[i]] = show[_colToIndex[i]];
                if (show[_colToIndex[i]]) {
                    this.table.addColumn(this.column[i]);
                } else {
                    this.table.removeColumn(this.column[i]);
                }
            }
            ++i;
        }
        if (isChanged) {
            this.tableModel.fireTableChanged(new TableModelEvent(this.tableModel, 0, this.currentTableSize - 1, -1));
        }
    }

    public void saveToHTML(boolean full) {
        this.process.saveMemSampleToHTML(full);
    }

    private JPanel createGUI() {
        GridBagLayout gridbag = new GridBagLayout();
        JPanel panel = new JPanel(gridbag);
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.ipady = 3;
        c.anchor = 17;
        c.fill = 0;
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        JLabel lb = new JLabel(ProfArb.getString(153) + " " + this.clazz.toString());
        Font curfont = lb.getFont();
        Font boldfont = curfont.deriveFont(1);
        lb.setFont(boldfont);
        panel.add((Component)lb, c);
        c.gridx = 0;
        ++c.gridy;
        this.tableModel = new 1();
        this.table = new JTable(this.tableModel);
        this.table.addMouseListener(new 2());
        this.addMouseListenerToHeaderInTable();
        TableColumnModel tableColumnModel = this.table.getColumnModel();
        int i = 0;
        while (i < 9) {
            this.column[i] = tableColumnModel.getColumn(i);
            this.columnShowing[MemoryDetailTable._colToIndex[i]] = true;
            ++i;
        }
        DefaultAllignRenderer defaultAllignRenderer = new DefaultAllignRenderer(this.process);
        this.column[0].setPreferredWidth(600);
        this.column[0].setCellRenderer(defaultAllignRenderer);
        RightAllignRenderer rightAllignRenderer = new RightAllignRenderer(this.process);
        int i2 = 1;
        while (i2 < 9) {
            this.column[i2].setPreferredWidth(100);
            this.column[i2].setCellRenderer(rightAllignRenderer);
            ++i2;
        }
        Dimension spacing = new Dimension(0, 0);
        this.table.setIntercellSpacing(spacing);
        ListSelectionModel listSelectionModel = this.table.getSelectionModel();
        listSelectionModel.setSelectionMode(0);
        listSelectionModel.addListSelectionListener(new 3());
        c.fill = 1;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        this.mainScrollPane = new JScrollPane(this.table);
        panel.add((Component)this.mainScrollPane, c);
        this.noDataLabel = new JLabel(ProfArb.getString(235));
        curfont = this.noDataLabel.getFont();
        boldfont = curfont.deriveFont(1, 20.0f);
        this.noDataLabel.setFont(boldfont);
        this.noDataLabel.setForeground(Color.red);
        JPanel dummyPane = new JPanel();
        dummyPane.add(this.noDataLabel);
        panel.add((Component)dummyPane, c);
        return panel;
    }

    public HelpInfo getHelpInfo() {
        return HELP_TOPIC;
    }

    HeapDetailStat[] checkCapacity(int newcap) {
        if (newcap < this.heapStatSize) {
            return this.heapStatArray;
        }
        HeapDetailStat[] res = new HeapDetailStat[this.heapStatSize * 2];
        System.arraycopy(this.heapStatArray, 0, res, 0, this.heapStatSize);
        this.heapStatSize *= 2;
        return res;
    }

    void historySelect(int index) {
        if (index == 0) {
            this.currentTableSize = this.heapStatSizeUsed;
            this.currentHeapStatArray = this.heapStatArray;
            this.mainScrollPane.setVisible(true);
            this.noDataLabel.setVisible(false);
            if (this.currentAscending != this.ascending || this.currentCompareField != this.compareField) {
                this.ascending = this.currentAscending;
                this.compareField = this.currentCompareField;
                Arrays.sort(this.currentHeapStatArray, 0, this.currentTableSize, this.hcomp);
            }
            this.tableModel.fireTableDataChanged();
        } else {
            int target = index - 1;
            this.currentHeapStatArray = this.heapStatArray_Hist[target];
            this.currentTableSize = this.currentHeapStatArray != null ? this.currentHeapStatArray.length : 0;
            if (this.currentTableSize == 0) {
                this.mainScrollPane.setVisible(false);
                this.noDataLabel.setVisible(true);
            } else {
                this.mainScrollPane.setVisible(true);
                this.noDataLabel.setVisible(false);
                if (this.currentAscending != this.ascending_Hist[target] || this.currentCompareField != this.compareField_Hist[target]) {
                    this.ascending_Hist[target] = this.currentAscending;
                    this.compareField_Hist[target] = this.currentCompareField;
                    Arrays.sort(this.currentHeapStatArray, 0, this.currentTableSize, this.hcomp);
                }
                this.tableModel.fireTableDataChanged();
            }
        }
        this.lastHistorySelected = index;
    }

    int getTableSize(int index) {
        if (index == 0) {
            return this.heapStatSizeUsed;
        }
        int target = index - 1;
        if (this.heapStatArray_Hist[target] != null) {
            return this.heapStatArray_Hist[target].length;
        }
        return 0;
    }

    HeapDetailStat[] getSampleArray(int index) {
        HeapDetailStat[] res = null;
        if (index == 0) {
            res = this.heapStatArray;
            if (this.currentAscending != this.ascending || this.currentCompareField != this.compareField) {
                this.ascending = this.currentAscending;
                this.compareField = this.currentCompareField;
                Arrays.sort(res, 0, this.currentTableSize, this.hcomp);
            }
        } else {
            int target = index - 1;
            res = this.heapStatArray_Hist[target];
            if (res != null) {
                if (res.length == 0) {
                    res = null;
                } else if (this.currentAscending != this.ascending_Hist[target] || this.currentCompareField != this.compareField_Hist[target]) {
                    this.ascending_Hist[target] = this.currentAscending;
                    this.compareField_Hist[target] = this.currentCompareField;
                    Arrays.sort(res, 0, res.length, this.hcomp);
                }
            }
        }
        return res;
    }

    VMClass getClazz() {
        return this.clazz;
    }

    void setClazz(VMClass pclazz) {
        this.clazz = pclazz;
    }

    private void saveCurrentArray() {
        System.arraycopy(this.heapStatArray_Hist, 0, this.heapStatArray_Hist, 1, this.maxSize - 1);
        System.arraycopy(this.compareField_Hist, 0, this.compareField_Hist, 1, this.maxSize - 1);
        System.arraycopy(this.ascending_Hist, 0, this.ascending_Hist, 1, this.maxSize - 1);
        this.heapStatArray_Hist[0] = new HeapDetailStat[this.heapStatSizeUsed];
        this.compareField_Hist[0] = this.currentCompareField;
        this.ascending_Hist[0] = this.currentAscending;
        HeapDetailStat[] had = this.heapStatArray_Hist[0];
        HeapDetailStat[] has = this.heapStatArray;
        int i = 0;
        while (i < had.length) {
            had[i] = new HeapDetailStat(has[i]);
            ++i;
        }
    }

    void setDataAtPosition(int pos, HeapDetailStat[] table) {
        if (pos == 0) {
            this.heapStatSizeUsed = table.length;
            this.heapStatArray = table;
        } else {
            this.heapStatArray_Hist[--pos] = table;
            this.compareField_Hist[pos] = -1;
        }
    }

    void setCurrentSize(int size) {
        this.currentSize = size;
    }

    void startUpdate() {
        this.saveCurrentArray();
        HeapDetailStat[] ha = this.heapStatArray;
        int limit = this.heapStatSizeUsed;
        int i = 0;
        while (i < limit) {
            ha[i].clearDiffs();
            ++i;
        }
        if (this.currentSize < this.maxSize - 1) {
            ++this.currentSize;
        }
    }

    void clearValues() {
        HeapDetailStat[] ha = this.heapStatArray;
        int limit = this.heapStatSizeUsed;
        int i = 0;
        while (i < limit) {
            ha[i].clearValues();
            ++i;
        }
    }

    void addOrUpdateHeapData(int mref, int line, int nb, int size, int nballoc, int sizealloc, int nbfreed, int sizefreed) {
        MethodKey key = this.mkey;
        key.m = mref;
        key.ln = line;
        HeapDetailStat chs = (HeapDetailStat)this.localDetailMap.get(key);
        if (chs == null) {
            VMMethod m = (VMMethod)this.methodMap.get(mref);
            chs = new HeapDetailStat(m, line, nb, nballoc, nbfreed, size, sizealloc, sizefreed);
            key = new MethodKey(mref, line);
            this.localDetailMap.put(key, chs);
            int newcap = this.heapStatSizeUsed;
            HeapDetailStat[] newarray = this.checkCapacity(newcap);
            newarray[newcap] = chs;
            this.heapStatArray = newarray;
            this.heapStatSizeUsed = ++newcap;
            return;
        }
        chs.update(nb, nballoc, nbfreed, size, sizealloc, sizefreed);
    }

    void endUpdate() {
        this.compareField = -1;
        this.historySelect(0);
    }

    private String toolTipFromCol(int col) {
        switch (col) {
            case 0: {
                return ProfArb.getString(56);
            }
            case 1: {
                return ProfArb.getString(64);
            }
            case 2: {
                return ProfArb.getString(319);
            }
            case 3: {
                return ProfArb.getString(285);
            }
            case 4: {
                return ProfArb.getString(112);
            }
            case 5: {
                return ProfArb.getString(126);
            }
            case 6: {
                return ProfArb.getString(266);
            }
            case 7: {
                return ProfArb.getString(304);
            }
            case 8: {
                return ProfArb.getString(202);
            }
        }
        return "";
    }

    private void addMouseListenerToHeaderInTable() {
        JTable tableView = this.table;
        tableView.setColumnSelectionAllowed(false);
        4 listMouseListener = new 4(this, tableView);
        5 headerRenderer = new 5();
        headerRenderer.setHorizontalAlignment(0);
        JTableHeader th = tableView.getTableHeader();
        th.addMouseListener(listMouseListener);
        th.setDefaultRenderer(headerRenderer);
    }

    private void switchSort(int column) {
        if (this.currentCompareField == column) {
            this.currentAscending ^= true;
        } else {
            this.currentCompareField = column;
        }
        this.table.getTableHeader().repaint();
    }

    public void loadLayout(PropertyAccess layout) {
    }

    public void saveLayout(PropertyAccess layout) {
    }

    public int getType() {
        return 1;
    }

    public void stateChange(int newState) {
        switch (newState) {
            case 3: {
                this.process.stopMethodDetails(this.clazz);
                this.currentHeapStatArray = null;
                this.heapStatArray = null;
                this.heapStatArray_Hist = null;
                this.methodMap = null;
                this.localDetailMap = null;
                break;
            }
        }
        super.stateChange(newState);
    }

    static int ra$currentCompareField(MemoryDetailTable memoryDetailTable) {
        return memoryDetailTable.currentCompareField;
    }

    static boolean ra$currentAscending(MemoryDetailTable memoryDetailTable) {
        return memoryDetailTable.currentAscending;
    }

    static void mav$switchSort(MemoryDetailTable memoryDetailTable, int n) {
        memoryDetailTable.switchSort(n);
    }

    static int ra$lastHistorySelected(MemoryDetailTable memoryDetailTable) {
        return memoryDetailTable.lastHistorySelected;
    }

    static Icon ra$ARROW_UP() {
        return ARROW_UP;
    }

    static Icon ra$ARROW_DOWN() {
        return ARROW_DOWN;
    }

    static ProfilingProcess ra$process(MemoryDetailTable memoryDetailTable) {
        return memoryDetailTable.process;
    }

    static String mav$toolTipFromCol(MemoryDetailTable memoryDetailTable, int n) {
        return memoryDetailTable.toolTipFromCol(n);
    }

    static HeapDetailStat[] ra$currentHeapStatArray(MemoryDetailTable memoryDetailTable) {
        return memoryDetailTable.currentHeapStatArray;
    }

    static int ra$currentTableSize(MemoryDetailTable memoryDetailTable) {
        return memoryDetailTable.currentTableSize;
    }

    final class 1
    extends AbstractTableModel {
        public int getColumnCount() {
            return 9;
        }

        public int getRowCount() {
            return MemoryDetailTable.ra$currentTableSize(MemoryDetailTable.this);
        }

        public String getColumnName(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return LOCATION_TITLE;
                }
                case 1: {
                    return COUNT_TITLE;
                }
                case 2: {
                    return SIZE_TITLE;
                }
                case 3: {
                    return ALLOC_COUNT_TITLE;
                }
                case 4: {
                    return ALLOC_SIZE_TITLE;
                }
                case 5: {
                    return FREED_COUNT_TITLE;
                }
                case 6: {
                    return FREED_SIZE_TITLE;
                }
                case 7: {
                    return DIFF_COUNT_TITLE;
                }
                case 8: {
                    return DIFF_SIZE_TITLE;
                }
            }
            return "Error";
        }

        public Object getValueAt(int row, int col) {
            HeapDetailStat hs = MemoryDetailTable.ra$currentHeapStatArray(MemoryDetailTable.this)[row];
            switch (col) {
                case 0: {
                    return hs.getName();
                }
                case 1: {
                    return String.valueOf(hs.nb);
                }
                case 2: {
                    return MemoryTable.numberFormat.format(hs.size);
                }
                case 3: {
                    return String.valueOf(hs.nballoc);
                }
                case 4: {
                    return MemoryTable.numberFormat.format(hs.sizealloc);
                }
                case 5: {
                    return String.valueOf(hs.nbfreed);
                }
                case 6: {
                    return MemoryTable.numberFormat.format(hs.sizefreed);
                }
                case 7: {
                    return String.valueOf(hs.getNbDiff());
                }
                case 8: {
                    return MemoryTable.numberFormat.format(hs.getSizeDiff());
                }
            }
            return "Error";
        }
    }

    final class 2
    extends MouseAdapter {
        public void mousePressed(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        public void mouseReleased(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        private void maybeShowPopup(MouseEvent e) {
            if (e.isPopupTrigger()) {
                Context context = MemoryDetailTable.this.getContext(e);
                JProfiler.contextMenu.show(context);
            }
        }

        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() == 2) {
                MemoryDetailTable.this.findSource();
            }
        }
    }

    final class 3
    implements ListSelectionListener {
        public void valueChanged(ListSelectionEvent e) {
            if (e.getValueIsAdjusting()) {
                return;
            }
            ListSelectionModel lsm = (ListSelectionModel)e.getSource();
            if (!lsm.isSelectionEmpty()) {
                int n = lsm.getMinSelectionIndex();
            }
        }
    }

    static class MethodKey {
        int m;
        int ln;

        public MethodKey(int meth, int line) {
            this.m = meth;
            this.ln = line;
        }

        public boolean equals(Object o) {
            MethodKey k = (MethodKey)o;
            return k.m == this.m && k.ln == this.ln;
        }

        public int hashCode() {
            return this.m + this.ln;
        }
    }

    final class 4
    extends MouseAdapter {
        private final /* synthetic */ JTable v$tableView;
        final /* synthetic */ MemoryDetailTable this$0;

        public void mouseClicked(MouseEvent e) {
            TableColumnModel columnModel = this.v$tableView.getColumnModel();
            int viewColumn = columnModel.getColumnIndexAtX(e.getX());
            int column = this.v$tableView.convertColumnIndexToModel(viewColumn);
            if (e.getClickCount() == 1 && column != -1) {
                MemoryDetailTable.mav$switchSort(this.this$0, column);
                this.this$0.historySelect(MemoryDetailTable.ra$lastHistorySelected(this.this$0));
            }
        }

        public 4(MemoryDetailTable memoryDetailTable, JTable jTable) {
            this.v$tableView = jTable;
            this.this$0 = memoryDetailTable;
        }
    }

    final class 5
    extends DefaultTableCellRenderer {
        private int _col;

        public String getToolTipText(MouseEvent event) {
            if (MemoryDetailTable.ra$process(MemoryDetailTable.this).isPopupActive()) {
                return null;
            }
            return MemoryDetailTable.mav$toolTipFromCol(MemoryDetailTable.this, this._col);
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            int col;
            JTableHeader header;
            if (table != null && (header = table.getTableHeader()) != null) {
                this.setForeground(header.getForeground());
                this.setBackground(header.getBackground());
                this.setFont(header.getFont());
            }
            this._col = col = table.convertColumnIndexToModel(column);
            if (col == MemoryDetailTable.ra$currentCompareField(MemoryDetailTable.this)) {
                if (MemoryDetailTable.ra$currentAscending(MemoryDetailTable.this)) {
                    this.setIcon(MemoryDetailTable.ra$ARROW_UP());
                } else {
                    this.setIcon(MemoryDetailTable.ra$ARROW_DOWN());
                }
            } else {
                this.setIcon(null);
            }
            this.setText((String)value);
            this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class heapDetailComparator
    implements Comparator {
        public int compare(Object o1, Object o2) {
            int result;
            HeapDetailStat m1 = (HeapDetailStat)o1;
            HeapDetailStat m2 = (HeapDetailStat)o2;
            switch (MemoryDetailTable.ra$currentCompareField(MemoryDetailTable.this)) {
                default: {
                    result = m1.getName().compareTo(m2.getName());
                    break;
                }
                case 1: {
                    result = m1.nb - m2.nb;
                    break;
                }
                case 2: {
                    result = m1.size - m2.size;
                    break;
                }
                case 3: {
                    result = m1.nballoc - m2.nballoc;
                    break;
                }
                case 4: {
                    result = m1.sizealloc - m2.sizealloc;
                    break;
                }
                case 5: {
                    result = m1.nbfreed - m2.nbfreed;
                    break;
                }
                case 6: {
                    result = m1.sizefreed - m2.sizefreed;
                    break;
                }
                case 7: {
                    result = m1.getNbDiff() - m2.getNbDiff();
                    break;
                }
                case 8: {
                    result = m1.getSizeDiff() - m2.getSizeDiff();
                    break;
                }
            }
            if (!MemoryDetailTable.ra$currentAscending(MemoryDetailTable.this)) {
                result = 0 - result;
            }
            return result;
        }

        heapDetailComparator() {
        }
    }
}

