/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.profile;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;
import oracle.javatools.util.SwingUtils;
import oracle.jdevimpl.runner.profile.ProfArb;

class MemoryGraph
extends JPanel
implements Runnable {
    private static final String memAvailStr = ProfArb.getString(237);
    private static final String memUsedStr = ProfArb.getString(166);
    private static final float blockWidth = 20.0f;
    private static final int maxMonitorAmount = 300;
    private static final Color graphColor = new Color(10, 100, 50);
    private static final Font font = new Font("Times New Roman", 0, 11);
    private boolean started;
    public Thread thread;
    private int sleepAmount;
    private int timeDelta;
    private int monitorAmount;
    private int width;
    private int height;
    private BufferedImage bimg;
    private Graphics2D bmp;
    private int columnInc;
    private int ptNum;
    private int[] pts;
    private boolean[] gcs;
    private int[] mms;
    private int[] ptPoints;
    private int[] mmPoints;
    private int ascent;
    private int descent;
    private float graphH;
    private int graphY;
    private final int nGaugeBlocks;
    private boolean gcOccurred;
    private float maxMemory;
    private float totalMemory;
    private float usedMemory;
    private float freeMemory;

    private void $init$() {
        this.sleepAmount = 1000;
        this.timeDelta = 1;
        this.nGaugeBlocks = 20;
    }

    public MemoryGraph() {
        this.$init$();
        this.setBackground(Color.black);
        this.gcOccurred = false;
        this.started = false;
        this.monitorAmount = 60;
        this.pts = new int[300];
        this.gcs = new boolean[300];
        this.mms = new int[300];
        this.ptPoints = new int[300];
        this.mmPoints = new int[300];
        this.ptNum = 0;
    }

    public synchronized void gcOccurred() {
        this.gcOccurred = true;
    }

    public synchronized void gcUpdate(int used, int total) {
        this.setUsedMemory(used);
        this.setTotalMemory(total);
        this.freeMemory = this.totalMemory - this.usedMemory;
    }

    public void start() {
        this.thread = new Thread(this);
        this.thread.setPriority(1);
        this.thread.setName("MemoryMonitor");
        this.thread.start();
    }

    public synchronized void stop() {
        this.sleepAmount = -1;
        this.thread = null;
        this.notify();
    }

    public synchronized void setSleepAmount(int ms) {
        this.sleepAmount = ms;
        this.timeDelta = ms / 1000;
        this.update();
        this.repaint();
    }

    public synchronized void setTotalMemory(int f) {
        this.totalMemory = f;
        if (this.totalMemory > this.maxMemory) {
            this.maxMemory = this.totalMemory;
            this.recalcPoints();
        }
    }

    public synchronized void setUsedMemory(int f) {
        this.usedMemory = f;
    }

    public synchronized void setMonitorAmount(int i) {
        this.monitorAmount = i * 60;
        this.update();
        this.repaint();
    }

    private void recalcPoints() {
        int j = 0;
        while (j < this.ptNum) {
            this.ptPoints[j] = (int)((float)this.graphY + (this.graphH - this.graphH * ((float)this.pts[j] / this.maxMemory)));
            this.mmPoints[j] = (int)((float)this.graphY + (this.graphH - this.graphH * ((float)this.mms[j] / this.maxMemory)));
            ++j;
        }
    }

    private synchronized void updatePoints() {
        this.pts[this.ptNum] = (int)this.usedMemory;
        this.gcs[this.ptNum] = this.gcOccurred;
        this.gcOccurred = false;
        this.mms[this.ptNum] = (int)this.totalMemory;
        this.ptPoints[this.ptNum] = (int)((float)this.graphY + (this.graphH - this.graphH * (this.usedMemory / this.maxMemory)));
        this.mmPoints[this.ptNum] = (int)((float)this.graphY + (this.graphH - this.graphH * (this.totalMemory / this.maxMemory)));
        if (this.ptNum + 2 >= 300) {
            int j = 1;
            while (j < this.ptNum) {
                this.pts[j - 1] = this.pts[j];
                this.gcs[j - 1] = this.gcs[j];
                this.mms[j - 1] = this.mms[j];
                this.ptPoints[j - 1] = this.ptPoints[j];
                this.mmPoints[j - 1] = this.mmPoints[j];
                ++j;
            }
            --this.ptNum;
        } else {
            ++this.ptNum;
        }
    }

    private synchronized void update() {
        int columnWidth;
        this.bmp.clearRect(0, 0, this.width, this.height);
        this.bmp.setColor(Color.green);
        SwingUtils.drawString((Graphics2D)this.bmp, (String)(String.valueOf((int)this.totalMemory / 1024) + memAvailStr), (float)4.0f, (float)((float)this.ascent + 0.5f));
        SwingUtils.drawString((Graphics)this.bmp, (String)(String.valueOf((int)this.usedMemory / 1024) + memUsedStr), (int)4, (int)(this.height - this.descent));
        float ssH = this.ascent + this.descent;
        float remainingHeight = (float)this.height - ssH * 2.0f - 0.5f;
        float blockHeight = remainingHeight / 20.0f;
        float remainingWidth = (float)this.width - 20.0f - 10.0f;
        Rectangle2D.Float fRect = new Rectangle2D.Float();
        this.bmp.setColor(Color.red);
        int MemUsage = (int)(this.freeMemory / this.totalMemory * 20.0f);
        int i = 0;
        while (i < MemUsage) {
            ((Rectangle2D)fRect).setRect(5.0, ssH + (float)i * blockHeight, 20.0, blockHeight - 1.0f);
            this.bmp.fill(fRect);
            ++i;
        }
        this.bmp.setColor(Color.green);
        while (i < 20) {
            ((Rectangle2D)fRect).setRect(5.0, ssH + (float)i * blockHeight, 20.0, blockHeight - 1.0f);
            this.bmp.fill(fRect);
            ++i;
        }
        this.bmp.setColor(graphColor);
        int graphX = 30;
        this.graphY = (int)ssH;
        int graphW = this.width - graphX - 5;
        this.bmp.drawRect(graphX, this.graphY, graphW, (int)this.graphH);
        int graphRow = (int)this.graphH / 10;
        int j = this.graphY;
        while ((float)j <= this.graphH + (float)this.graphY) {
            this.bmp.drawLine(graphX, j, graphX + graphW, j);
            j += graphRow;
        }
        int numPoints = this.ptNum / this.timeDelta;
        int graphDelta = graphW / this.monitorAmount;
        int graphColumn = columnWidth = graphDelta * 10;
        if (this.columnInc <= 0) {
            this.columnInc = graphColumn;
        }
        int j2 = graphX + this.columnInc;
        while (j2 < graphW + graphX) {
            this.bmp.drawLine(j2, this.graphY, j2, this.graphY + (int)this.graphH);
            j2 += graphColumn;
        }
        this.columnInc -= graphDelta * this.timeDelta;
        int lastMaxMemory = this.mms[1];
        int lastMaxMemoryStart = graphX + graphW - this.ptNum;
        int firstPoint = Math.max(this.ptNum - this.monitorAmount, 0);
        int gx = Math.max(graphX, graphX + graphW - numPoints * (graphDelta *= this.timeDelta));
        int point = firstPoint;
        while (point < this.ptNum) {
            int gxDelta = Math.min(gx + graphDelta, graphX + graphW);
            int mmlevel = this.mmPoints[point];
            this.bmp.setColor(Color.white);
            this.bmp.drawLine(gx, mmlevel, gxDelta, mmlevel);
            if (point >= this.timeDelta) {
                if (this.mms[point - this.timeDelta] != this.mms[point]) {
                    int memlevel1 = this.mmPoints[point - this.timeDelta];
                    int memlevel2 = this.mmPoints[point];
                    this.bmp.setColor(Color.white);
                    this.bmp.drawLine(gx, memlevel1, gx, memlevel2);
                }
                boolean paintgc = false;
                int gcpoint = point - this.timeDelta;
                while (gcpoint < point) {
                    if (this.gcs[gcpoint]) {
                        paintgc = true;
                        break;
                    }
                    ++gcpoint;
                }
                if (paintgc) {
                    this.bmp.setColor(Color.red);
                    this.bmp.drawLine(gx, this.graphY, gx, (int)((float)this.graphY + this.graphH));
                }
                this.bmp.setColor(Color.yellow);
                int point1 = this.ptPoints[point - this.timeDelta];
                int point2 = this.ptPoints[point];
                this.bmp.drawLine(gx, point1, gxDelta, point2);
            } else {
                this.bmp.setColor(Color.yellow);
                int mp = this.ptPoints[point];
                this.bmp.drawLine(gx, mp, gxDelta, mp);
            }
            point += this.timeDelta;
            gx += graphDelta;
        }
        if (gx < graphX + graphW) {
            point = this.ptPoints[point - this.timeDelta];
            this.bmp.drawLine(gx, point, graphX + graphW, point);
        }
    }

    public void paint(Graphics g) {
        if (!this.started || this.bmp == null) {
            return;
        }
        g.drawImage(this.bimg, 0, 0, this);
    }

    private synchronized void resized() {
        Dimension d = this.getSize();
        if (d.width != this.width || d.height != this.height) {
            this.width = d.width;
            if (d.height != this.height) {
                this.height = d.height;
                this.graphH = (float)(this.height - this.graphY * 2) - 0.5f;
                this.recalcPoints();
            }
            this.bimg = (BufferedImage)this.createImage(this.width, this.height);
            if (this.bimg != null) {
                this.bmp = this.bimg.createGraphics();
                if (this.bmp != null) {
                    this.bmp.setFont(font);
                    this.bmp.setBackground(this.getBackground());
                    this.update();
                    this.repaint();
                }
            }
        }
    }

    /*
     * Loose catch block
     */
    public void run() {
        this.started = true;
        do {
            this.resized();
            if (this.bimg != null) continue;
            try {
                Thread.sleep(100);
            }
            catch (Exception exception) {
                // empty catch block
            }
        } while (this.bimg == null);
        FontMetrics fm = this.bmp.getFontMetrics();
        this.ascent = fm.getAscent();
        this.descent = fm.getDescent();
        this.graphY = this.ascent + this.descent;
        this.graphH = (float)(this.height - this.graphY * 2) - 0.5f;
        this.addComponentListener(new 1());
        block5: while (true) {
            if (this.height > 50 && this.width > 50) {
                this.update();
                this.repaint();
            }
            if (this.sleepAmount < 0) {
                return;
            }
            int sleptFor = 0;
            while (true) {
                if (sleptFor >= this.sleepAmount) continue block5;
                Thread.sleep(1000L);
                this.updatePoints();
                sleptFor += 1000;
            }
            break;
        }
        catch (InterruptedException e) {
            return;
        }
    }

    static void mav$resized(MemoryGraph memoryGraph) {
        memoryGraph.resized();
    }

    final class 1
    extends ComponentAdapter {
        public void componentResized(ComponentEvent e) {
            MemoryGraph.mav$resized(MemoryGraph.this);
        }

        public void componentMoved(ComponentEvent e) {
        }
    }
}

