/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.profile;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.EventObject;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;
import oracle.ide.Context;
import oracle.ide.controller.Controller;
import oracle.ide.docking.DockableWindow;
import oracle.ide.model.Node;
import oracle.ide.model.Project;
import oracle.ide.util.PropertyAccess;
import oracle.ide.view.View;
import oracle.jdevimpl.runner.profile.MemoryGraph;
import oracle.jdevimpl.runner.profile.ProfArb;
import oracle.jdevimpl.runner.profile.ProfilingProcess;

public class MemoryMonitor
extends DockableWindow {
    static final String PROFILER_WINDOW_ID = "ProfilerGCGraph";
    private Project project;
    private String title;
    private MemoryGraph graph;
    private JScrollPane scrollPane;
    private ProfilingProcess process;

    public MemoryMonitor(ProfilingProcess process) {
        super(PROFILER_WINDOW_ID);
        this.process = process;
        this.project = process.getJProject();
        this.setType(32);
        this.initialize();
    }

    public Component getGUI() {
        return this.scrollPane;
    }

    public Controller getController() {
        return null;
    }

    public Context getContext(EventObject event) {
        Context context = Context.newIdeContext((Node)this.project);
        context.setView((View)this);
        return context;
    }

    public void initialize() {
        this.title = ProfArb.getString(43) + this.process.getRunTitle();
        this.scrollPane = this.createGUI();
        this.graph.start();
    }

    public String getTabName() {
        return this.title;
    }

    public String getTitleName() {
        return this.title;
    }

    private JScrollPane createGUI() {
        this.graph = new MemoryGraph();
        JPanel monitorPanel = new JPanel();
        monitorPanel.setBorder(new TitledBorder(BorderFactory.createEtchedBorder(), ProfArb.getString(43)));
        monitorPanel.setLayout(new BorderLayout());
        monitorPanel.add(this.graph);
        JPanel timePanel = new JPanel();
        timePanel.setLayout(new BoxLayout(timePanel, 0));
        String[] timeStrings = new String[]{"1", "5", "10", "30", "60"};
        JComboBox<String> cbTimes = new JComboBox<String>(timeStrings);
        cbTimes.setSelectedIndex(0);
        cbTimes.addActionListener(new 1());
        timePanel.add(new JLabel(ProfArb.getString(196)));
        timePanel.add(cbTimes);
        String[] monitorStrings = new String[]{"1", "2", "3", "4", "5"};
        JComboBox<String> cbMonitor = new JComboBox<String>(monitorStrings);
        cbMonitor.setSelectedIndex(0);
        cbMonitor.addActionListener(new 2());
        timePanel.add(new JLabel(ProfArb.getString(295)));
        timePanel.add(cbMonitor);
        JButton gcButton = new JButton(ProfArb.getString(183));
        gcButton.addActionListener(new 3());
        timePanel.add(gcButton);
        monitorPanel.add((Component)timePanel, "South");
        return new JScrollPane(monitorPanel);
    }

    public void GCInit(int totalSpace) {
        this.graph.setTotalMemory(totalSpace);
    }

    public void GCUpdate(int usedSpace, int totalSpace) {
        this.graph.gcUpdate(usedSpace, totalSpace);
    }

    public void GCStart() {
    }

    public void GCEnd(int usedSpace, int totalSpace) {
        this.graph.gcOccurred();
        this.graph.setTotalMemory(totalSpace);
        this.graph.setUsedMemory(usedSpace);
    }

    public void GCAlloc(int size, int usedSpace) {
        this.graph.setUsedMemory(usedSpace);
    }

    public void stop() {
        if (this.graph != null) {
            this.graph.stop();
        }
    }

    public void loadLayout(PropertyAccess layout) {
    }

    public void saveLayout(PropertyAccess layout) {
    }

    static MemoryGraph ra$graph(MemoryMonitor memoryMonitor) {
        return memoryMonitor.graph;
    }

    static ProfilingProcess ra$process(MemoryMonitor memoryMonitor) {
        return memoryMonitor.process;
    }

    final class 1
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            JComboBox cb = (JComboBox)e.getSource();
            String time = (String)cb.getSelectedItem();
            MemoryMonitor.ra$graph(MemoryMonitor.this).setSleepAmount(Integer.parseInt(time) * 1000);
        }
    }

    final class 2
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            JComboBox cb = (JComboBox)e.getSource();
            String time = (String)cb.getSelectedItem();
            MemoryMonitor.ra$graph(MemoryMonitor.this).setMonitorAmount(Integer.parseInt(time));
        }
    }

    final class 3
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            MemoryMonitor.ra$process(MemoryMonitor.this).performGC();
        }
    }
}

