/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.profile;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.DataOutputStream;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeConstants;
import oracle.ide.config.DTCache;
import oracle.ide.controller.Controller;
import oracle.ide.help.HelpInfo;
import oracle.ide.resource.ControlsArb;
import oracle.ide.resource.IdeArb;
import oracle.ide.util.IntHashMap;
import oracle.ide.view.View;
import oracle.jdevimpl.runner.debug.DbgArb;
import oracle.jdevimpl.runner.profile.DefaultAllignRenderer;
import oracle.jdevimpl.runner.profile.FileSavable;
import oracle.jdevimpl.runner.profile.FileSaver;
import oracle.jdevimpl.runner.profile.HTMLSavable;
import oracle.jdevimpl.runner.profile.HeapDetailStat;
import oracle.jdevimpl.runner.profile.HeapStat;
import oracle.jdevimpl.runner.profile.JProfiler;
import oracle.jdevimpl.runner.profile.MemoryDetailTable;
import oracle.jdevimpl.runner.profile.PatternError;
import oracle.jdevimpl.runner.profile.ProfArb;
import oracle.jdevimpl.runner.profile.ProfWindow;
import oracle.jdevimpl.runner.profile.ProfilerSettings;
import oracle.jdevimpl.runner.profile.ProfilingProcess;
import oracle.jdevimpl.runner.profile.RightAllignRenderer;
import oracle.jdevimpl.runner.profile.UpdatableSettings;
import oracle.jdevimpl.runner.profile.VMClass;
import oracle.jdevimpl.runner.profile.Wild;
import oracle.jdevimpl.runner.run.RunArb;

public final class MemoryTable
extends ProfWindow
implements ActionListener,
HTMLSavable,
UpdatableSettings,
FileSavable {
    static final DecimalFormat numberFormat = new DecimalFormat("#,##0");
    static final String SAVED_FILTER_KEY = "MemoryTable.SAVED_FILTER_KEY";
    static final int MAX_SAVED_FILTERS = 10;
    public static final int MAX_COLUMNS = 10;
    public static final int COL_CLASS = 0;
    public static final int COL_LOC = 1;
    public static final int COL_NB = 2;
    public static final int COL_SIZE = 3;
    public static final int COL_NB_ALLOC = 4;
    public static final int COL_ALLOC = 5;
    public static final int COL_NB_FREED = 6;
    public static final int COL_FREED = 7;
    public static final int COL_NB_DIFF = 8;
    public static final int COL_DIFF = 9;
    private static final int INITIAL_HEAPSTATSIZE = 20;
    private static final int MAX_TABLE_COL = 9;
    private static final int[] _colToIndex = new int[]{0, 2, 3, 4, 5, 6, 7, 8, 9};
    private ProfilingProcess process;
    private String title;
    private JPanel mainPanel;
    private IntHashMap classMap;
    private IntHashMap localClassMap;
    private int heapStatSize;
    private int heapStatSizeUsed;
    private HeapStat[] heapStatArray;
    private int compareField;
    private boolean ascending;
    private HeapDetailStat totals;
    private int currentTableSize;
    private HeapStat[] currentHeapStatArray;
    private HeapDetailStat currentTotals;
    private HeapStat[][] heapStatArray_Hist;
    private HeapDetailStat[] totals_Hist;
    private int[] compareField_Hist;
    private boolean[] ascending_Hist;
    private int currentCompareField;
    private boolean currentAscending;
    private JTable table;
    private JLabel sampleLabel;
    private JSlider slider;
    private JButton sliderUp;
    private JButton sliderDown;
    private JButton buttonRestart;
    private JButton buttonSnapshot;
    private JButton buttonTerminate;
    private JButton buttonRun;
    private JButton buttonPause;
    private AbstractTableModel tableModel;
    private boolean[] columnShowing;
    private TableColumn[] column;
    heapComparator hcomp;
    private int currentSize;
    private int maxSize;
    private int totalSample;
    private String filterString;
    private Wild filterMatcher;
    static final JLabel ON_LABEL = new JLabel(DbgArb.getIcon(606));
    static final JLabel OFF_LABEL = new JLabel(DbgArb.getIcon(284));
    static final String CLASS_NAME_TITLE = ProfArb.getString(35);
    static final String COUNT_TITLE = ProfArb.getString(29);
    static final String SIZE_TITLE = ProfArb.getString(233);
    static final String ALLOC_COUNT_TITLE = ProfArb.getString(20);
    static final String ALLOC_SIZE_TITLE = ProfArb.getString(10);
    static final String FREED_COUNT_TITLE = ProfArb.getString(45);
    static final String FREED_SIZE_TITLE = ProfArb.getString(265);
    static final String DIFF_COUNT_TITLE = ProfArb.getString(198);
    static final String DIFF_SIZE_TITLE = ProfArb.getString(272);
    private static final HelpInfo HELP_TOPIC = new HelpInfo(ProfArb.getString(55));
    private static final Icon ARROW_UP = ControlsArb.getIcon((int)12);
    private static final Icon ARROW_DOWN = ControlsArb.getIcon((int)13);

    private void $init$() {
        this.columnShowing = new boolean[10];
        this.column = new TableColumn[9];
        this.filterString = "";
        this.filterMatcher = new Wild();
    }

    public MemoryTable(ProfilingProcess p, IntHashMap pclassMap) {
        this.$init$();
        this.hcomp = new heapComparator();
        this.currentCompareField = 2;
        this.currentAscending = false;
        this.initValues(p, pclassMap);
        this.initialize();
    }

    public void saveToFile() {
        FileSaver fs = new FileSaver(this);
        fs.save(this.getContext());
    }

    public void saveToFile(DataOutputStream stream) throws IOException {
        HeapStat[] ctable;
        stream.writeInt(2);
        this.process.saveMapsToFile(stream);
        stream.writeInt(this.totalSample);
        int maxindex = 0;
        while ((ctable = this.getSampleArray(++maxindex)) != null) {
        }
        if (maxindex > this.maxSize) {
            maxindex = this.maxSize;
        }
        stream.writeInt(maxindex);
        int i = maxindex;
        do {
            this.saveOneSampleTable(stream, --i);
        } while (i != 0);
    }

    void saveOneSampleTable(DataOutputStream stream, int ind) throws IOException {
        this.getSampleTotals(ind).saveToFile(stream);
        int csize = this.getTableSize(ind);
        HeapStat[] ctable = this.getSampleArray(ind);
        stream.writeInt(csize);
        int i = 0;
        while (i < csize) {
            ctable[i].saveToFile(stream);
            ++i;
        }
        int nit = 0;
        Iterator it = this.process.getMemoryDetailTableIterator();
        while (it.hasNext()) {
            MemoryDetailTable mdt = (MemoryDetailTable)it.next();
            HeapDetailStat[] details = mdt.getSampleArray(ind);
            if (details == null) continue;
            ++nit;
        }
        stream.writeInt(nit);
        if (nit != 0) {
            it = this.process.getMemoryDetailTableIterator();
            while (it.hasNext()) {
                MemoryDetailTable mdt = (MemoryDetailTable)it.next();
                HeapDetailStat[] details = mdt.getSampleArray(ind);
                if (details == null) continue;
                stream.writeInt(mdt.getClazz().classDescriptor);
                csize = mdt.getTableSize(ind);
                stream.writeInt(csize);
                i = 0;
                while (i < csize) {
                    details[i].saveToFile(stream);
                    ++i;
                }
            }
        }
    }

    void initValues(ProfilingProcess p, IntHashMap pclassMap) {
        this.process = p;
        this.classMap = pclassMap;
        this.heapStatSize = 20;
        this.heapStatSizeUsed = 0;
        this.heapStatArray = new HeapStat[20];
        this.localClassMap = new IntHashMap(20);
        this.totals = new HeapDetailStat(null, 0, 0, 0, 0, 0, 0, 0);
        this.maxSize = p.getSliderDepth();
        this.currentSize = 0;
        this.totalSample = 0;
        this.heapStatArray_Hist = new HeapStat[this.maxSize][];
        this.totals_Hist = new HeapDetailStat[this.maxSize];
        this.compareField_Hist = new int[this.maxSize];
        this.ascending_Hist = new boolean[this.maxSize];
    }

    public void resetProcess(ProfilingProcess p, IntHashMap pclassMap) {
        this.initValues(p, pclassMap);
        this.buttonRestart.setEnabled(true);
        this.buttonSnapshot.setEnabled(true);
        this.buttonTerminate.setEnabled(true);
        this.buttonRun.setEnabled(false);
        this.buttonPause.setEnabled(true);
        this.slider.setValue(this.currentSize);
        if (this.slider.getMaximum() != this.maxSize - 1) {
            this.slider.setMaximum(this.maxSize - 1);
        }
    }

    public Component getGUI() {
        return this.mainPanel;
    }

    public Controller getController() {
        return null;
    }

    public Context getContext(EventObject event) {
        Context context = this.process.getContext();
        context.setView((View)this);
        context.setEvent(event);
        return context;
    }

    public void initialize() {
        this.title = ProfArb.getString(321) + this.process.getRunTitle();
        this.mainPanel = this.createGUI();
        this.updateSettings();
    }

    public String getTabName() {
        return this.process.getTabName();
    }

    public Icon getTabIcon() {
        return this.process.getIcon();
    }

    public String getTitleName() {
        return this.title;
    }

    void showDetail() {
        int row = this.table.getSelectedRow();
        if (row == -1) {
            return;
        }
        HeapStat hs = this.currentHeapStatArray[row];
        if (hs.getClassDesc() != 0) {
            this.slider.setValue(this.currentSize);
            this.process.askMethodDetails(hs);
        }
    }

    boolean canShowDetail() {
        int row = this.table.getSelectedRow();
        if (row == -1) {
            return false;
        }
        if (!this.process.isProcessActive()) {
            return false;
        }
        HeapStat hs = this.currentHeapStatArray[row];
        return hs.getClassDesc() != 0;
    }

    public void changeSettings() {
        this.process.showSettings();
    }

    public void updateSettings() {
        ProfilerSettings ps = ProfilerSettings.getInstance();
        boolean[] show = ps.getMemColumnVisible();
        boolean isChanged = false;
        int i = 0;
        while (i < 9) {
            if (this.columnShowing[_colToIndex[i]] != show[_colToIndex[i]]) {
                isChanged = true;
                this.columnShowing[MemoryTable._colToIndex[i]] = show[_colToIndex[i]];
                if (show[_colToIndex[i]]) {
                    this.table.addColumn(this.column[i]);
                } else {
                    this.table.removeColumn(this.column[i]);
                }
            }
            ++i;
        }
        if (isChanged) {
            this.tableModel.fireTableChanged(new TableModelEvent(this.tableModel, 0, this.currentTableSize - 1, -1));
        }
        this.process.updateChildSettings();
    }

    public void saveToHTML(boolean full) {
        this.process.saveMemSampleToHTML(full);
    }

    int getCurrentPos() {
        return this.currentSize - this.slider.getValue();
    }

    public void notifyProcessEnd() {
        SwingUtilities.invokeLater(new EventRunner(0));
    }

    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        this.whenActionPerformed(source);
    }

    private void whenActionPerformed(Object source) {
        if (source == this.buttonRun) {
            this.process.performRunCommand();
            this.buttonRun.setEnabled(false);
            this.slider.setEnabled(false);
            this.sliderUp.setEnabled(false);
            this.sliderDown.setEnabled(false);
            this.buttonPause.setEnabled(true);
            this.buttonPause.requestFocus();
            this.buttonSnapshot.setEnabled(true);
        } else if (source == this.buttonPause) {
            this.process.performPauseCommand();
            this.buttonRun.setEnabled(true);
            this.buttonRun.requestFocus();
            this.slider.setEnabled(true);
            this.sliderUp.setEnabled(true);
            this.sliderDown.setEnabled(true);
            this.buttonPause.setEnabled(false);
            this.buttonSnapshot.setEnabled(false);
        } else if (source == this.sliderUp) {
            int pos = this.slider.getValue();
            if (pos < this.currentSize) {
                this.slider.setValue(pos + 1);
            }
        } else if (source == this.sliderDown) {
            int pos = this.slider.getValue();
            if (pos > 0) {
                this.slider.setValue(pos - 1);
            }
        } else if (source == this.buttonSnapshot) {
            this.process.performSnapshotCommand();
        } else if (source == this.buttonRestart) {
            this.process.performRestartCommand();
        } else if (source == this.buttonTerminate) {
            this.process.performTerminateCommand();
        }
    }

    private void setAllSizes(JComponent c, Dimension d) {
        c.setMinimumSize(d);
        c.setMaximumSize(d);
        c.setPreferredSize(d);
    }

    private JPanel createGUI() {
        JPanel panel = new JPanel(new BorderLayout());
        Dimension buttonSize = new Dimension(24, 24);
        JPanel headPanel = new JPanel(new BorderLayout());
        JToolBar tb1 = new JToolBar();
        JToolBar tb2 = new JToolBar();
        headPanel.add((Component)tb1, "West");
        headPanel.add((Component)tb2, "East");
        panel.add((Component)headPanel, "North");
        tb1.setFloatable(false);
        tb1.setRollover(true);
        tb1.setBorder(IdeConstants.TOOLBAR_EMPTY_BORDER);
        tb2.setFloatable(false);
        tb2.setRollover(true);
        tb2.setBorder(IdeConstants.TOOLBAR_EMPTY_BORDER);
        this.buttonRestart = new JButton(RunArb.getIcon(17));
        this.buttonRestart.setToolTipText(ProfArb.getString(68));
        this.registerActionMnemonic(panel, this.buttonRestart, ProfArb.getMnemonic(328));
        this.buttonRestart.addActionListener(this);
        tb1.add(this.buttonRestart);
        this.buttonRestart.setEnabled(true);
        this.buttonRun = new JButton(DbgArb.getIcon(584));
        this.buttonRun.setToolTipText(ProfArb.getString(317));
        this.registerActionMnemonic(panel, this.buttonRun, ProfArb.getMnemonic(76));
        this.buttonRun.addActionListener(this);
        tb1.add(this.buttonRun);
        this.buttonRun.setEnabled(false);
        this.buttonPause = new JButton(DbgArb.getIcon(684));
        this.buttonPause.setToolTipText(ProfArb.getString(142));
        this.registerActionMnemonic(panel, this.buttonPause, ProfArb.getMnemonic(117));
        this.buttonPause.addActionListener(this);
        tb1.add(this.buttonPause);
        this.buttonPause.setEnabled(true);
        this.buttonSnapshot = new JButton(IdeArb.getIcon((int)79));
        this.buttonSnapshot.setToolTipText(ProfArb.getString(228));
        this.registerActionMnemonic(panel, this.buttonSnapshot, ProfArb.getMnemonic(264));
        this.buttonSnapshot.addActionListener(this);
        tb1.add(this.buttonSnapshot);
        this.buttonSnapshot.setEnabled(true);
        this.buttonTerminate = new JButton(IdeArb.getIcon((int)343));
        this.buttonTerminate.setToolTipText(ProfArb.getString(219));
        this.registerActionMnemonic(panel, this.buttonTerminate, ProfArb.getMnemonic(148));
        this.buttonTerminate.addActionListener(this);
        tb1.add(this.buttonTerminate);
        this.buttonTerminate.setEnabled(true);
        this.sliderDown = new JButton(ProfArb.getIcon(107));
        this.sliderDown.setToolTipText(ProfArb.getString(220));
        this.registerActionMnemonic(panel, this.sliderDown, ProfArb.getMnemonic(299));
        this.sliderDown.addActionListener(this);
        tb1.add(this.sliderDown);
        this.sliderDown.setEnabled(false);
        this.slider = new JSlider(0, this.maxSize - 1, this.currentSize);
        this.slider.setToolTipText(ProfArb.getString(210));
        this.slider.setPaintTrack(true);
        this.slider.setPaintLabels(true);
        this.slider.setSnapToTicks(true);
        MySliderLabels ml = new MySliderLabels();
        this.slider.addChangeListener(ml);
        this.slider.setLabelTable(ml);
        this.slider.setEnabled(false);
        headPanel.add((Component)this.slider, "Center");
        this.sliderUp = new JButton(ProfArb.getIcon(57));
        this.sliderUp.setToolTipText(ProfArb.getString(232));
        this.registerActionMnemonic(panel, this.sliderUp, ProfArb.getMnemonic(134));
        this.sliderUp.addActionListener(this);
        tb2.add(this.sliderUp);
        this.sliderUp.setEnabled(false);
        this.sampleLabel = new JLabel("99999/99999", 0);
        Font curfont = this.sampleLabel.getFont();
        Font boldfont = curfont.deriveFont(1, 20.0f);
        this.sampleLabel.setFont(boldfont);
        this.setAllSizes(this.sampleLabel, this.sampleLabel.getPreferredSize());
        this.sampleLabel.setText("0/0");
        tb2.add(this.sampleLabel);
        this.tableModel = new 1();
        this.table = new JTable(this.tableModel);
        this.table.addMouseListener(new 2());
        this.addMouseListenerToHeaderInTable();
        TableColumnModel tableColumnModel = this.table.getColumnModel();
        int i = 0;
        while (i < 9) {
            this.column[i] = tableColumnModel.getColumn(i);
            this.columnShowing[MemoryTable._colToIndex[i]] = true;
            ++i;
        }
        DefaultAllignRenderer defaultAllignRenderer = new DefaultAllignRenderer(this.process);
        this.column[0].setPreferredWidth(600);
        this.column[0].setCellRenderer(defaultAllignRenderer);
        RightAllignRenderer rightAllignRenderer = new RightAllignRenderer(this.process);
        int i2 = 1;
        while (i2 < 9) {
            this.column[i2].setPreferredWidth(100);
            this.column[i2].setCellRenderer(rightAllignRenderer);
            ++i2;
        }
        Dimension spacing = new Dimension(0, 0);
        this.table.setIntercellSpacing(spacing);
        ListSelectionModel listSelectionModel = this.table.getSelectionModel();
        listSelectionModel.setSelectionMode(0);
        listSelectionModel.addListSelectionListener(new 3());
        panel.add((Component)new JScrollPane(this.table), "Center");
        JPanel filter = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 13;
        JLabel filterLabel = new JLabel(ProfArb.getString(289));
        c.gridwidth = -1;
        c.fill = 0;
        c.weightx = 0.0;
        c.insets = new Insets(0, 2, 0, 0);
        filter.add((Component)filterLabel, c);
        List savedFilters = this.getSavedFilters();
        JComboBox<Object> filterText = new JComboBox<Object>(savedFilters.toArray());
        filterText.setEditable(true);
        c.gridwidth = 0;
        c.fill = 2;
        c.weightx = 1.0;
        c.insets = new Insets(0, 0, 0, 0);
        filter.add(filterText, c);
        panel.add((Component)filter, "South");
        filterText.addActionListener(new 4(this, filterText));
        if (savedFilters.size() > 0) {
            this.setFilter((String)savedFilters.get(0));
        }
        return panel;
    }

    void addUniqueItem(JComboBox filterText, String text) {
        int found = -1;
        int count = filterText.getItemCount();
        int i = 0;
        while (i < count) {
            String item = (String)filterText.getItemAt(i);
            if (item.equals(text)) {
                found = i;
                break;
            }
            ++i;
        }
        if (found > 0) {
            filterText.removeItemAt(found);
        }
        if (found != 0) {
            filterText.insertItemAt(text, 0);
        }
        filterText.setSelectedIndex(0);
        while (filterText.getItemCount() > 10) {
            filterText.removeItemAt(filterText.getItemCount() - 1);
        }
        int newCount = filterText.getItemCount();
        ArrayList list = new ArrayList(newCount);
        int i2 = 0;
        while (i2 < newCount) {
            list.add(filterText.getItemAt(i2));
            ++i2;
        }
        this.saveFilters(list);
    }

    List getSavedFilters() {
        DTCache dtcache = Ide.getDTCache();
        ArrayList list = (ArrayList)dtcache.getData(SAVED_FILTER_KEY);
        if (list == null) {
            list = new ArrayList(0);
        }
        return list;
    }

    void saveFilters(List filters) {
        DTCache dtcache = Ide.getDTCache();
        dtcache.putData(SAVED_FILTER_KEY, filters);
    }

    void registerActionMnemonic(JPanel panel, JButton button, char mnemonic) {
        InputMap im = panel.getInputMap(1);
        ActionMap am = panel.getActionMap();
        MyAction action = new MyAction(button);
        KeyStroke ks = KeyStroke.getKeyStroke((int)mnemonic, 2);
        im.put(ks, action);
        am.put(action, action);
    }

    public HelpInfo getHelpInfo() {
        return HELP_TOPIC;
    }

    HeapStat[] checkCapacity(int newcap) {
        if (newcap < this.heapStatSize) {
            return this.heapStatArray;
        }
        HeapStat[] res = new HeapStat[this.heapStatSize * 2];
        System.arraycopy(this.heapStatArray, 0, res, 0, this.heapStatSize);
        this.heapStatSize *= 2;
        return res;
    }

    private void setFilter(String filter) {
        if (!filter.equals(this.filterString)) {
            this.filterString = filter;
            try {
                this.filterMatcher.parse(filter);
            }
            catch (PatternError e) {
                this.filterMatcher.reset();
            }
            this.tableUpdate();
        }
    }

    private void dynamicFilter() {
        ArrayList<HeapStat> filtered = new ArrayList<HeapStat>();
        HeapDetailStat filteredTotals = new HeapDetailStat(this.currentTotals);
        int i = 0;
        while (i < this.currentTableSize) {
            HeapStat stat = this.currentHeapStatArray[i];
            if (this.filterMatcher.match(stat.getName())) {
                filtered.add(stat);
            } else {
                filteredTotals.subtract(stat.nb, stat.nballoc, stat.nbfreed, stat.size, stat.sizealloc, stat.sizefreed);
            }
            ++i;
        }
        if (filtered.size() != this.currentTableSize) {
            this.currentHeapStatArray = filtered.toArray(new HeapStat[filtered.size()]);
            this.currentTableSize = filtered.size();
            this.currentTotals = filteredTotals;
        }
    }

    private void tableUpdate() {
        this.historySelect(this.currentSize - this.slider.getValue());
    }

    private void historySelect(int index) {
        if (index == 0) {
            this.currentTableSize = this.heapStatSizeUsed;
            this.currentHeapStatArray = this.heapStatArray;
            this.currentTotals = this.totals;
            if (this.filterMatcher.canFail()) {
                this.dynamicFilter();
            }
            if (this.currentAscending != this.ascending || this.currentCompareField != this.compareField) {
                this.ascending = this.currentAscending;
                this.compareField = this.currentCompareField;
                Arrays.sort(this.currentHeapStatArray, 0, this.currentTableSize, this.hcomp);
            }
            this.sampleLabel.setText(this.totalSample + "/" + this.totalSample);
            this.tableModel.fireTableDataChanged();
            this.table.getTableHeader().repaint();
        } else {
            int target = index - 1;
            this.currentHeapStatArray = this.heapStatArray_Hist[target];
            this.currentTotals = this.totals_Hist[target];
            this.currentTableSize = this.currentHeapStatArray.length;
            if (this.filterMatcher.canFail()) {
                this.dynamicFilter();
            }
            if (this.currentAscending != this.ascending_Hist[target] || this.currentCompareField != this.compareField_Hist[target]) {
                this.ascending_Hist[target] = this.currentAscending;
                this.compareField_Hist[target] = this.currentCompareField;
                Arrays.sort(this.currentHeapStatArray, 0, this.currentTableSize, this.hcomp);
            }
            this.sampleLabel.setText(this.totalSample - index + "/" + this.totalSample);
            this.tableModel.fireTableDataChanged();
            this.table.getTableHeader().repaint();
        }
    }

    int getTableSize(int index) {
        if (index == 0) {
            return this.heapStatSizeUsed;
        }
        int target = index - 1;
        return this.heapStatArray_Hist[target].length;
    }

    HeapDetailStat getSampleTotals(int index) {
        if (index == 0) {
            return this.totals;
        }
        int target = index - 1;
        return this.totals_Hist[target];
    }

    HeapStat[] getSampleArray(int index) {
        HeapStat[] res = null;
        if (index == 0) {
            res = this.heapStatArray;
            if (this.currentAscending != this.ascending || this.currentCompareField != this.compareField) {
                this.ascending = this.currentAscending;
                this.compareField = this.currentCompareField;
                Arrays.sort(res, 0, this.heapStatSizeUsed, this.hcomp);
            }
        } else {
            int target = index - 1;
            if (target < this.maxSize) {
                res = this.heapStatArray_Hist[target];
            }
            if (res != null && (this.currentAscending != this.ascending_Hist[target] || this.currentCompareField != this.compareField_Hist[target])) {
                this.ascending_Hist[target] = this.currentAscending;
                this.compareField_Hist[target] = this.currentCompareField;
                Arrays.sort(res, 0, res.length, this.hcomp);
            }
        }
        return res;
    }

    int getSampleNumber(int index) {
        return this.totalSample - index;
    }

    int getTotalSampleNumber() {
        return this.totalSample;
    }

    private void saveCurrentArray() {
        System.arraycopy(this.heapStatArray_Hist, 0, this.heapStatArray_Hist, 1, this.maxSize - 1);
        System.arraycopy(this.totals_Hist, 0, this.totals_Hist, 1, this.maxSize - 1);
        System.arraycopy(this.compareField_Hist, 0, this.compareField_Hist, 1, this.maxSize - 1);
        System.arraycopy(this.ascending_Hist, 0, this.ascending_Hist, 1, this.maxSize - 1);
        this.heapStatArray_Hist[0] = new HeapStat[this.heapStatSizeUsed];
        this.totals_Hist[0] = this.totals;
        this.compareField_Hist[0] = this.currentCompareField;
        this.ascending_Hist[0] = this.currentAscending;
        HeapStat[] had = this.heapStatArray_Hist[0];
        HeapStat[] has = this.heapStatArray;
        int i = 0;
        while (i < had.length) {
            had[i] = new HeapStat(has[i]);
            ++i;
        }
    }

    void setDataAtPosition(int pos, HeapDetailStat tot, HeapStat[] table) {
        if (pos == 0) {
            this.heapStatSizeUsed = table.length;
            this.heapStatArray = table;
            this.totals = tot;
        } else {
            this.heapStatArray_Hist[--pos] = table;
            this.totals_Hist[pos] = tot;
            this.compareField_Hist[pos] = -1;
        }
    }

    void setCurrentSize(int size) {
        this.currentSize = size;
    }

    void setTotalSample(int t) {
        this.totalSample = t;
    }

    void finishedLoading() {
        this.slider.setValue(this.currentSize);
    }

    void startUpdate() {
        this.saveCurrentArray();
        this.totals = new HeapDetailStat(null, 0, this.totals.nb, 0, 0, this.totals.size, 0, 0);
        HeapStat[] ha = this.heapStatArray;
        int limit = this.heapStatSizeUsed;
        int i = 0;
        while (i < limit) {
            ha[i].clearDiffs();
            ++i;
        }
        if (this.currentSize < this.maxSize - 1) {
            ++this.currentSize;
        }
    }

    void addOrUpdateHeapData(int cref, int nb, int size, int nballoc, int sizealloc, int nbfreed, int sizefreed) {
        this.totals.update(nb, nballoc, nbfreed, size, sizealloc, sizefreed);
        HeapStat chs = (HeapStat)this.localClassMap.get(cref);
        if (chs == null) {
            chs = new HeapStat((VMClass)this.classMap.get(cref), nb, nballoc, nbfreed, size, sizealloc, sizefreed);
            this.localClassMap.put(cref, (Object)chs);
            int newcap = this.heapStatSizeUsed;
            HeapStat[] newarray = this.checkCapacity(newcap);
            newarray[newcap] = chs;
            this.heapStatArray = newarray;
            this.heapStatSizeUsed = ++newcap;
            return;
        }
        this.totals.nb -= chs.nb;
        this.totals.size -= chs.size;
        chs.update(nb, nballoc, nbfreed, size, sizealloc, sizefreed);
    }

    void endUpdate() {
        ++this.totalSample;
        this.compareField = -1;
        if (this.slider.getValue() != this.currentSize) {
            this.slider.setValue(this.currentSize);
        } else {
            this.tableUpdate();
        }
    }

    private String toolTipFromCol(int col) {
        switch (col) {
            case 0: {
                return ProfArb.getString(100);
            }
            case 1: {
                return ProfArb.getString(64);
            }
            case 2: {
                return ProfArb.getString(319);
            }
            case 3: {
                return ProfArb.getString(285);
            }
            case 4: {
                return ProfArb.getString(112);
            }
            case 5: {
                return ProfArb.getString(126);
            }
            case 6: {
                return ProfArb.getString(266);
            }
            case 7: {
                return ProfArb.getString(304);
            }
            case 8: {
                return ProfArb.getString(202);
            }
        }
        return "";
    }

    private void addMouseListenerToHeaderInTable() {
        JTable tableView = this.table;
        tableView.setColumnSelectionAllowed(false);
        5 listMouseListener = new 5(this, tableView);
        HeaderRenderer hr = new HeaderRenderer();
        JTableHeader th = tableView.getTableHeader();
        th.addMouseListener(listMouseListener);
        th.setDefaultRenderer(hr);
    }

    private void switchSort(int column) {
        if (this.currentCompareField == column) {
            this.currentAscending ^= true;
        } else {
            this.currentCompareField = column;
        }
        this.table.getTableHeader().repaint();
    }

    public void stateChange(int newState) {
        switch (newState) {
            case 3: {
                this.process.stopAllMethodDetails();
                this.currentHeapStatArray = null;
                this.heapStatArray = null;
                this.heapStatArray_Hist = null;
                this.classMap = null;
                this.localClassMap = null;
                break;
            }
        }
        super.stateChange(newState);
    }

    static JButton ra$buttonRestart(MemoryTable memoryTable) {
        return memoryTable.buttonRestart;
    }

    static JButton ra$buttonSnapshot(MemoryTable memoryTable) {
        return memoryTable.buttonSnapshot;
    }

    static JButton ra$buttonTerminate(MemoryTable memoryTable) {
        return memoryTable.buttonTerminate;
    }

    static JButton ra$buttonRun(MemoryTable memoryTable) {
        return memoryTable.buttonRun;
    }

    static JButton ra$buttonPause(MemoryTable memoryTable) {
        return memoryTable.buttonPause;
    }

    static JSlider ra$slider(MemoryTable memoryTable) {
        return memoryTable.slider;
    }

    static JButton ra$sliderUp(MemoryTable memoryTable) {
        return memoryTable.sliderUp;
    }

    static JButton ra$sliderDown(MemoryTable memoryTable) {
        return memoryTable.sliderDown;
    }

    static int ra$currentSize(MemoryTable memoryTable) {
        return memoryTable.currentSize;
    }

    static int ra$maxSize(MemoryTable memoryTable) {
        return memoryTable.maxSize;
    }

    static void mav$historySelect(MemoryTable memoryTable, int n) {
        memoryTable.historySelect(n);
    }

    static ProfilingProcess ra$process(MemoryTable memoryTable) {
        return memoryTable.process;
    }

    static void mav$whenActionPerformed(MemoryTable memoryTable, Object object) {
        memoryTable.whenActionPerformed(object);
    }

    static int ra$currentCompareField(MemoryTable memoryTable) {
        return memoryTable.currentCompareField;
    }

    static boolean ra$currentAscending(MemoryTable memoryTable) {
        return memoryTable.currentAscending;
    }

    static Icon ra$ARROW_UP() {
        return ARROW_UP;
    }

    static Icon ra$ARROW_DOWN() {
        return ARROW_DOWN;
    }

    static HeapDetailStat ra$currentTotals(MemoryTable memoryTable) {
        return memoryTable.currentTotals;
    }

    static String mav$toolTipFromCol(MemoryTable memoryTable, int n) {
        return memoryTable.toolTipFromCol(n);
    }

    static void mav$switchSort(MemoryTable memoryTable, int n) {
        memoryTable.switchSort(n);
    }

    static void mav$tableUpdate(MemoryTable memoryTable) {
        memoryTable.tableUpdate();
    }

    static HeapStat[] ra$currentHeapStatArray(MemoryTable memoryTable) {
        return memoryTable.currentHeapStatArray;
    }

    static int ra$currentTableSize(MemoryTable memoryTable) {
        return memoryTable.currentTableSize;
    }

    static JTable ra$table(MemoryTable memoryTable) {
        return memoryTable.table;
    }

    static void mav$setFilter(MemoryTable memoryTable, String string) {
        memoryTable.setFilter(string);
    }

    class EventRunner
    implements Runnable {
        static final int PROC_END_ACTION = 0;
        int _type;

        EventRunner(int type) {
            this._type = type;
        }

        public void run() {
            switch (this._type) {
                case 0: {
                    MemoryTable.ra$buttonRestart(MemoryTable.this).setEnabled(true);
                    MemoryTable.ra$buttonSnapshot(MemoryTable.this).setEnabled(false);
                    MemoryTable.ra$buttonTerminate(MemoryTable.this).setEnabled(false);
                    MemoryTable.ra$buttonRun(MemoryTable.this).setEnabled(false);
                    MemoryTable.ra$buttonPause(MemoryTable.this).setEnabled(false);
                    MemoryTable.ra$slider(MemoryTable.this).setEnabled(true);
                    MemoryTable.ra$sliderUp(MemoryTable.this).setEnabled(true);
                    MemoryTable.ra$sliderDown(MemoryTable.this).setEnabled(true);
                    break;
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class MySliderLabels
    extends Dictionary
    implements ChangeListener {
        @Override
        public void stateChanged(ChangeEvent e) {
            JSlider sl = (JSlider)e.getSource();
            if (!sl.getValueIsAdjusting()) {
                int pos = sl.getValue();
                if (pos > MemoryTable.ra$currentSize(MemoryTable.this)) {
                    sl.setValue(MemoryTable.ra$currentSize(MemoryTable.this));
                } else {
                    MemoryTable.mav$historySelect(MemoryTable.this, MemoryTable.ra$currentSize(MemoryTable.this) - pos);
                    MemoryTable.ra$process(MemoryTable.this).setChildHistoryPos(MemoryTable.ra$currentSize(MemoryTable.this) - pos);
                }
            }
        }

        @Override
        public int size() {
            return MemoryTable.ra$maxSize(MemoryTable.this);
        }

        @Override
        public boolean isEmpty() {
            return MemoryTable.ra$maxSize(MemoryTable.this) == 0;
        }

        public Enumeration keys() {
            return new MyEnum();
        }

        public Enumeration elements() {
            return null;
        }

        public Object get(Object key) {
            Integer val = (Integer)key;
            if (val <= MemoryTable.ra$currentSize(MemoryTable.this)) {
                return ON_LABEL;
            }
            return OFF_LABEL;
        }

        public Object put(Object key, Object value) {
            return null;
        }

        public Object remove(Object key) {
            return null;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class MyEnum
        implements Enumeration {
            int curpos = 0;

            @Override
            public boolean hasMoreElements() {
                return this.curpos < MemoryTable.ra$maxSize(MemoryTable.this);
            }

            public Object nextElement() {
                return new Integer(this.curpos++);
            }
        }
    }

    final class 1
    extends AbstractTableModel {
        public int getColumnCount() {
            return 9;
        }

        public int getRowCount() {
            return MemoryTable.ra$currentTableSize(MemoryTable.this);
        }

        public String getColumnName(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return CLASS_NAME_TITLE;
                }
                case 1: {
                    return COUNT_TITLE;
                }
                case 2: {
                    return SIZE_TITLE;
                }
                case 3: {
                    return ALLOC_COUNT_TITLE;
                }
                case 4: {
                    return ALLOC_SIZE_TITLE;
                }
                case 5: {
                    return FREED_COUNT_TITLE;
                }
                case 6: {
                    return FREED_SIZE_TITLE;
                }
                case 7: {
                    return DIFF_COUNT_TITLE;
                }
                case 8: {
                    return DIFF_SIZE_TITLE;
                }
            }
            return "Error";
        }

        public Object getValueAt(int row, int col) {
            HeapStat hs = MemoryTable.ra$currentHeapStatArray(MemoryTable.this)[row];
            switch (col) {
                case 0: {
                    return hs.getName();
                }
                case 1: {
                    return String.valueOf(hs.nb);
                }
                case 2: {
                    return numberFormat.format(hs.size);
                }
                case 3: {
                    return String.valueOf(hs.nballoc);
                }
                case 4: {
                    return numberFormat.format(hs.sizealloc);
                }
                case 5: {
                    return String.valueOf(hs.nbfreed);
                }
                case 6: {
                    return numberFormat.format(hs.sizefreed);
                }
                case 7: {
                    return String.valueOf(hs.getNbDiff());
                }
                case 8: {
                    return numberFormat.format(hs.getSizeDiff());
                }
            }
            return "Error";
        }
    }

    final class 2
    extends MouseAdapter {
        public void mousePressed(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        public void mouseReleased(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        private void maybeShowPopup(MouseEvent e) {
            if (e.isPopupTrigger()) {
                MemoryTable.ra$table(MemoryTable.this).requestFocus();
                Context context = MemoryTable.this.getContext(e);
                JProfiler.contextMenu.show(context);
            }
        }

        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() == 2) {
                MemoryTable.this.showDetail();
            }
        }
    }

    final class 3
    implements ListSelectionListener {
        public void valueChanged(ListSelectionEvent e) {
            if (e.getValueIsAdjusting()) {
                return;
            }
            ListSelectionModel lsm = (ListSelectionModel)e.getSource();
            if (!lsm.isSelectionEmpty()) {
                int n = lsm.getMinSelectionIndex();
            }
        }
    }

    final class 4
    implements ActionListener {
        private final /* synthetic */ JComboBox v$filterText;
        final /* synthetic */ MemoryTable this$0;

        public void actionPerformed(ActionEvent e) {
            String text = (String)this.v$filterText.getSelectedItem();
            MemoryTable.mav$setFilter(this.this$0, text);
            this.this$0.addUniqueItem(this.v$filterText, text);
        }

        public 4(MemoryTable memoryTable, JComboBox jComboBox) {
            this.v$filterText = jComboBox;
            this.this$0 = memoryTable;
        }
    }

    class MyAction
    extends AbstractAction {
        JButton _src;

        MyAction(JButton src) {
            this._src = src;
        }

        public void actionPerformed(ActionEvent e) {
            MemoryTable.mav$whenActionPerformed(MemoryTable.this, this._src);
        }
    }

    class HeaderRenderer
    extends JPanel
    implements TableCellRenderer {
        private JLabel _label1;
        private JLabel _label2;
        private int _col;

        private void $init$() {
            this._label1 = new JLabel("");
            this._label2 = new JLabel("");
        }

        public HeaderRenderer() {
            super(new BorderLayout());
            this.$init$();
            this._label1.setHorizontalAlignment(0);
            this._label1.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
            this._label2.setHorizontalAlignment(4);
            this._label2.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
            this.add((Component)this._label1, "North");
            this.add((Component)this._label2, "South");
        }

        public String getToolTipText(MouseEvent event) {
            if (MemoryTable.ra$process(MemoryTable.this).isPopupActive()) {
                return null;
            }
            return MemoryTable.mav$toolTipFromCol(MemoryTable.this, this._col);
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            int col;
            this._col = col = table.convertColumnIndexToModel(column);
            if (col == MemoryTable.ra$currentCompareField(MemoryTable.this)) {
                if (MemoryTable.ra$currentAscending(MemoryTable.this)) {
                    this._label1.setIcon(MemoryTable.ra$ARROW_UP());
                } else {
                    this._label1.setIcon(MemoryTable.ra$ARROW_DOWN());
                }
            } else {
                this._label1.setIcon(null);
            }
            this._label1.setText((String)value);
            if (MemoryTable.ra$currentTotals(MemoryTable.this) != null) {
                switch (col) {
                    case 0: {
                        this._label2.setText(ProfArb.getString(130));
                        break;
                    }
                    case 1: {
                        this._label2.setText(String.valueOf(MemoryTable.ra$currentTotals((MemoryTable)MemoryTable.this).nb));
                        break;
                    }
                    case 2: {
                        this._label2.setText(numberFormat.format(MemoryTable.ra$currentTotals((MemoryTable)MemoryTable.this).size));
                        break;
                    }
                    case 3: {
                        this._label2.setText(String.valueOf(MemoryTable.ra$currentTotals((MemoryTable)MemoryTable.this).nballoc));
                        break;
                    }
                    case 4: {
                        this._label2.setText(numberFormat.format(MemoryTable.ra$currentTotals((MemoryTable)MemoryTable.this).sizealloc));
                        break;
                    }
                    case 5: {
                        this._label2.setText(String.valueOf(MemoryTable.ra$currentTotals((MemoryTable)MemoryTable.this).nbfreed));
                        break;
                    }
                    case 6: {
                        this._label2.setText(numberFormat.format(MemoryTable.ra$currentTotals((MemoryTable)MemoryTable.this).sizefreed));
                        break;
                    }
                    case 7: {
                        this._label2.setText(String.valueOf(MemoryTable.ra$currentTotals(MemoryTable.this).getNbDiff()));
                        break;
                    }
                    case 8: {
                        this._label2.setText(numberFormat.format(MemoryTable.ra$currentTotals(MemoryTable.this).getSizeDiff()));
                        break;
                    }
                    default: {
                        this._label2.setText(" ");
                        break;
                    }
                }
            } else {
                this._label2.setText(" ");
            }
            return this;
        }
    }

    final class 5
    extends MouseAdapter {
        private final /* synthetic */ JTable v$tableView;
        final /* synthetic */ MemoryTable this$0;

        public void mouseClicked(MouseEvent e) {
            TableColumnModel columnModel = this.v$tableView.getColumnModel();
            int viewColumn = columnModel.getColumnIndexAtX(e.getX());
            int column = this.v$tableView.convertColumnIndexToModel(viewColumn);
            if (e.getClickCount() == 1 && column != -1) {
                MemoryTable.mav$switchSort(this.this$0, column);
                MemoryTable.mav$tableUpdate(this.this$0);
            }
        }

        public 5(MemoryTable memoryTable, JTable jTable) {
            this.v$tableView = jTable;
            this.this$0 = memoryTable;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class heapComparator
    implements Comparator {
        public int compare(Object o1, Object o2) {
            int result;
            HeapStat m1 = (HeapStat)o1;
            HeapStat m2 = (HeapStat)o2;
            switch (MemoryTable.ra$currentCompareField(MemoryTable.this)) {
                default: {
                    result = m1.getName().compareTo(m2.getName());
                    break;
                }
                case 1: {
                    result = m1.nb - m2.nb;
                    break;
                }
                case 2: {
                    result = m1.size - m2.size;
                    break;
                }
                case 3: {
                    result = m1.nballoc - m2.nballoc;
                    break;
                }
                case 4: {
                    result = m1.sizealloc - m2.sizealloc;
                    break;
                }
                case 5: {
                    result = m1.nbfreed - m2.nbfreed;
                    break;
                }
                case 6: {
                    result = m1.sizefreed - m2.sizefreed;
                    break;
                }
                case 7: {
                    result = m1.getNbDiff() - m2.getNbDiff();
                    break;
                }
                case 8: {
                    result = m1.getSizeDiff() - m2.getSizeDiff();
                    break;
                }
            }
            if (!MemoryTable.ra$currentAscending(MemoryTable.this)) {
                result = 0 - result;
            }
            return result;
        }

        heapComparator() {
        }
    }
}

