/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.profile;

import java.awt.Component;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JTabbedPane;
import oracle.ide.Context;
import oracle.ide.controller.Controller;
import oracle.ide.docking.DockableWindow;
import oracle.ide.model.Node;
import oracle.ide.model.Project;
import oracle.ide.util.PropertyAccess;
import oracle.ide.view.View;
import oracle.jdevimpl.runner.profile.MemoryAllocTable;
import oracle.jdevimpl.runner.profile.ProfArb;
import oracle.jdevimpl.runner.profile.ProfilingProcess;
import oracle.jdevimpl.runner.profile.VMClass;

final class MemoryUseTable
extends DockableWindow {
    private static final String PROFILER_MEMORY_TABLE_ID = "ProfilerMemoryTable";
    private Map memorySnapshots;
    private ProfilingProcess process;
    private Project project;
    private String title;
    private JTabbedPane uiPanel;
    private MemoryAllocTable tablePanel;
    private int nSnapshots;
    private int nDiffs;

    public MemoryUseTable(ProfilingProcess p) {
        this(p, null);
    }

    public MemoryUseTable(ProfilingProcess p, Object[] array) {
        super(PROFILER_MEMORY_TABLE_ID);
        this.process = p;
        this.project = p.getJProject();
        this.title = ProfArb.getString(250) + this.process.getRunTitle();
        this.setType(32);
        this.initialize();
    }

    public Component getGUI() {
        return this.uiPanel;
    }

    public Controller getController() {
        return null;
    }

    public Context getContext(EventObject event) {
        Context context = Context.newIdeContext((Node)this.project);
        context.setView((View)this);
        return context;
    }

    public void initialize() {
        this.uiPanel = this.createGUI();
    }

    public String getTabName() {
        return this.title;
    }

    public String getTitleName() {
        return this.title;
    }

    private JTabbedPane createGUI() {
        JTabbedPane tabbedPane = new JTabbedPane(3);
        this.tablePanel = new MemoryAllocTable(this, null);
        tabbedPane.addTab(ProfArb.getString(31), null, this.tablePanel, ProfArb.getString(176));
        return tabbedPane;
    }

    public String addSnaphotTable(MemoryAllocTable snapshotTable) {
        if (this.memorySnapshots == null) {
            this.memorySnapshots = new HashMap(10);
        }
        ++this.nSnapshots;
        String name = ProfArb.getString(179) + this.nSnapshots;
        this.uiPanel.addTab(name, null, snapshotTable, ProfArb.getString(46));
        this.memorySnapshots.put(name, snapshotTable);
        Object[] o = this.memorySnapshots.values().toArray();
        int l = o.length;
        int i = 0;
        while (i < l) {
            MemoryAllocTable m = (MemoryAllocTable)o[i];
            m.enableGenerateDiff();
            ++i;
        }
        return name;
    }

    public String[] getMemorySnapshotNames() {
        if (this.memorySnapshots == null) {
            return null;
        }
        Object[] o = this.memorySnapshots.keySet().toArray();
        int l = o.length;
        String[] s = new String[l];
        int i = 0;
        while (i < l) {
            s[i] = new String((String)o[i]);
            ++i;
        }
        return s;
    }

    public int getNMemorySnapshots() {
        if (this.memorySnapshots == null) {
            return 0;
        }
        return this.memorySnapshots.size();
    }

    public MemoryAllocTable getMemorySnapshot(String name) {
        if (this.memorySnapshots == null) {
            return null;
        }
        return (MemoryAllocTable)this.memorySnapshots.get(name);
    }

    public String addDiffTable(MemoryAllocTable snapshotTable) {
        ++this.nDiffs;
        String name = ProfArb.getString(24) + this.nDiffs;
        this.uiPanel.addTab(name, null, snapshotTable, ProfArb.getString(182));
        return name;
    }

    public void update(VMClass clazz) {
        this.tablePanel.update(clazz);
    }

    public void updateList(Object[] array, int totalAllocations, int totalSize) {
        this.tablePanel.updateList(array, totalAllocations, totalSize);
    }

    public void loadLayout(PropertyAccess layout) {
    }

    public void saveLayout(PropertyAccess layout) {
    }
}

