/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.profile;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import oracle.ide.util.IntHashMap;
import oracle.jdevimpl.runner.profile.CallCountItem;
import oracle.jdevimpl.runner.profile.VMMethod;

class MethodCallCountItem
extends CallCountItem {
    VMMethod m;
    int callCount;
    int onStackCount;

    public MethodCallCountItem(int rf, VMMethod m, int callCount, int onStackCount) {
        super(rf);
        this.m = m;
        this.callCount = callCount;
        this.onStackCount = onStackCount;
        this.name = "";
    }

    public MethodCallCountItem() {
    }

    public void saveToFile(DataOutputStream stream) throws IOException {
        stream.writeByte(0);
        super.saveToFile(stream);
        stream.writeInt(this.m.methodDescriptor);
        stream.writeInt(this.callCount);
        stream.writeInt(this.onStackCount);
    }

    public void initFromFile(DataInputStream stream, IntHashMap methodMap) throws IOException {
        super.initFromFile(stream);
        this.m = (VMMethod)methodMap.get(stream.readInt());
        this.callCount = stream.readInt();
        this.onStackCount = stream.readInt();
    }

    String getPseudoClass() {
        return this.m.clazz.toString();
    }

    String getPseudoName() {
        return this.m.name;
    }

    int getCallCount() {
        return this.callCount;
    }

    int getOnStackCount() {
        return this.onStackCount;
    }

    String getNiceSignature() {
        return this.m.getNiceSignature();
    }

    String getFileName() {
        return this.m.clazz.fileName;
    }

    int getLine() {
        return this.m.firstLine;
    }

    String getPackage() {
        return this.m.clazz.packageName;
    }
}

