/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.profile;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.TexturePaint;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.JPanel;
import oracle.jdevimpl.runner.profile.ProfHistModel;

public class ProfHist
extends JPanel {
    public static final int SCALE_SIZE = 100;
    private static Color COLOR_HIGHLIGHT = new Color(0, 0, 0, 35);
    public static final String SELECTION = "selection";
    private static final boolean LABEL_IN_RECT = false;
    private static final boolean DRAW_FOCUS = false;
    private ProfHistModel _model;
    private int _nRowHeight;
    private int[] _nSelected;
    private int _nScaleM;
    private int _nScaleD;
    private int _nCurrentCursor;
    private int _maxX;
    private ArrayList _listeners;
    private static TexturePaint EVENT_HIGHLIGHT;

    private void $init$() {
        this._nRowHeight = 18;
        this._nSelected = null;
        this._nScaleM = 1;
        this._nScaleD = 100;
    }

    static {
        BufferedImage bIm = new BufferedImage(6, 6, 2);
        Graphics2D gr = (Graphics2D)bIm.getGraphics();
        gr.setColor(new Color(0, 0, 0, 0));
        gr.fillRect(0, 0, 6, 6);
        gr.setColor(Color.black);
        gr.drawLine(0, 0, 5, 5);
        gr.setColor(Color.white);
        gr.drawLine(0, 1, 4, 5);
        gr.drawLine(5, 0, 5, 0);
        EVENT_HIGHLIGHT = new TexturePaint(bIm, new Rectangle(6, 6));
    }

    public ProfHist(ProfHistModel model) {
        this.$init$();
        this._model = model;
        this.setBackground(Color.white);
        this.setRowHeight(18);
        this.addMouseListener(new 1());
        this.addMouseMotionListener(new 2());
    }

    public void addSelectionListener(PropertyChangeListener l) {
        if (this._listeners == null) {
            this._listeners = new ArrayList();
        }
        this._listeners.add(l);
    }

    public void removeSelectionListener(PropertyChangeListener l) {
        if (this._listeners != null) {
            this._listeners.remove(l);
        }
    }

    private void fireSelectionChangeEvent(int[] nFrom, int[] nTo) {
        PropertyChangeEvent e = null;
        int i = this._listeners.size() - 1;
        while (i >= 0) {
            if (e == null) {
                e = new PropertyChangeEvent(this, SELECTION, nFrom, nTo);
            }
            PropertyChangeListener l = (PropertyChangeListener)this._listeners.get(i);
            l.propertyChange(e);
            --i;
        }
    }

    public void setScale(int nScaleM, int nScaleD) {
        this._nScaleM = nScaleM;
        this._nScaleD = nScaleD;
        this.setPreferredSize(null);
    }

    private int scaler(int x) {
        return x * this._nScaleM / this._nScaleD;
    }

    public int getRowHeight() {
        return this._nRowHeight;
    }

    public void setRowHeight(int nRowHeight) {
        this._nRowHeight = nRowHeight;
        this.setPreferredSize(null);
    }

    private void whenMousePressed(MouseEvent e) {
        this.grabFocus();
        Point pt = e.getPoint();
        int n = this._model.getRowCount();
        Rectangle r = new Rectangle();
        int min = Math.max(0, pt.y / this._nRowHeight - 2);
        int max = Math.min(n, pt.y / this._nRowHeight + 2);
        int i = min;
        while (i < max) {
            this.getFullRect(i, r);
            if (r.contains(pt)) {
                int[] s = new int[]{i};
                this.setSelected(s, true);
                break;
            }
            ++i;
        }
    }

    private void whenMouseMoved(MouseEvent e) {
        Point pt = e.getPoint();
        int n = this._model.getRowCount();
        Rectangle r = new Rectangle();
        int nCursor = 13;
        int min = Math.max(0, pt.y / this._nRowHeight - 2);
        int max = Math.min(n, pt.y / this._nRowHeight + 2);
        int i = min;
        while (i < max) {
            this.getEventRect(i, r);
            if (r.y <= pt.y && pt.y <= r.y + r.width) {
                this.getFullRect(i, r);
                if (r.contains(pt)) {
                    nCursor = 12;
                    break;
                }
            }
            ++i;
        }
        if (this._nCurrentCursor != nCursor) {
            this.setCursor(Cursor.getPredefinedCursor(nCursor));
            this._nCurrentCursor = nCursor;
        }
    }

    public void setSelected(int[] nEvents, boolean updateTable) {
        if (nEvents != null) {
            Arrays.sort(nEvents);
        }
        if (updateTable && this._nSelected != null && nEvents != null) {
            this.fireSelectionChangeEvent(this._nSelected, nEvents);
        }
        this._nSelected = nEvents;
        this.repaint();
    }

    public int[] getSelected() {
        return this._nSelected;
    }

    public void setModel(ProfHistModel model) {
        this._model = model;
        this.invalidate();
    }

    public ProfHistModel getModel() {
        return this._model;
    }

    private int getEventMaxBound(int i) {
        int duration = this._model.getEventElapsed(i);
        int res = duration != Integer.MAX_VALUE ? this._model.getEventStart(i) + duration : this._model.getEventStart(i);
        return res;
    }

    private int getLastEvent() {
        int nRows = this._model.getRowCount();
        int nMax = 0;
        int nLast = 0;
        int i = 0;
        while (i < nRows) {
            int j = this.getEventMaxBound(i);
            if (j > nMax) {
                nLast = i;
                nMax = j;
            }
            ++i;
        }
        return nLast;
    }

    private Rectangle getFullRect(int nEvent, Rectangle rEvent) {
        this.getEventRect(nEvent, rEvent);
        return rEvent;
    }

    public Dimension getPreferredSize() {
        if (!this.isPreferredSizeSet()) {
            int nLastEvent = this.getLastEvent();
            this._maxX = this.scaler(this.getEventMaxBound(nLastEvent));
            this.setPreferredSize(new Dimension(this._maxX, this._model.getRowCount() * this.getRowHeight()));
        }
        return super.getPreferredSize();
    }

    public boolean isFocusTraversable() {
        return true;
    }

    public Rectangle getEventBounds(int nEvent) {
        Rectangle r = new Rectangle();
        return this.getFullRect(nEvent, r);
    }

    private Rectangle getEventRect(int nEvent, Rectangle rTarget) {
        int nElapsed;
        int nStart;
        int nRows = this._model.getRowCount();
        if (nEvent < nRows) {
            nStart = this._model.getEventStart(nEvent);
            nElapsed = this._model.getEventElapsed(nEvent);
        } else {
            nStart = 0;
            nElapsed = 0;
        }
        if (nElapsed == Integer.MAX_VALUE) {
            rTarget.setRect(this.scaler(nStart), nEvent * this.getRowHeight(), this._maxX - this.scaler(nStart), this.getRowHeight());
        } else {
            rTarget.setRect(this.scaler(nStart), nEvent * this.getRowHeight(), Math.max(1, this.scaler(nElapsed)), this.getRowHeight());
        }
        return rTarget;
    }

    protected void paintComponent(Graphics g1) {
        super.paintComponent(g1);
        Graphics2D g = (Graphics2D)g1;
        Dimension dThis = this.getSize();
        int n = this._model.getRowCount();
        Rectangle r = new Rectangle();
        Rectangle rClip = g.getClipBounds();
        int nStart = rClip.x;
        int nStop = rClip.x + rClip.width;
        nStart = Math.max(0, nStart / 100 - 1);
        nStart *= 100;
        g.setColor(Color.gray);
        while (nStart <= nStop) {
            g.drawLine(nStart, 0, nStart, dThis.height);
            nStart += 50;
        }
        int min = Math.max(0, rClip.y / this._nRowHeight - 2);
        int max = Math.min(n, (rClip.y + rClip.height) / this._nRowHeight + 2);
        int i = min;
        while (i < max) {
            this.getEventRect(i, r);
            if (g.hitClip(0, r.y, dThis.width, r.y)) {
                g.drawLine(0, r.y, dThis.width, r.y);
                r.y += this._nRowHeight;
                g.drawLine(0, r.y, dThis.width, r.y);
            }
            ++i;
        }
        int i2 = min;
        while (i2 < max) {
            Color crEvent = this._model.getEventColor(i2);
            this.getEventRect(i2, r);
            if (g.hitClip(r.x, r.y, r.width, r.height)) {
                g.setColor(crEvent);
                ++r.width;
                ++r.height;
                g.fillRect(r.x, r.y + 1, r.width, r.height - 2);
            }
            ++i2;
        }
        if (this._nSelected != null) {
            int j = 0;
            while (j < this._nSelected.length) {
                this.getEventRect(this._nSelected[j], r);
                g.setPaint(EVENT_HIGHLIGHT);
                ++r.y;
                --r.height;
                g.fill(r);
                r.y = 0;
                r.height = dThis.height;
                g.setColor(COLOR_HIGHLIGHT);
                ++r.width;
                g.fillRect(r.x, 0, r.width, dThis.height);
                ++j;
            }
        }
    }

    private void paintSelection(Graphics2D g, Rectangle r) {
        g.setColor(Color.black);
        g.draw(r);
    }

    static void mav$whenMousePressed(ProfHist profHist, MouseEvent mouseEvent) {
        profHist.whenMousePressed(mouseEvent);
    }

    static void mav$whenMouseMoved(ProfHist profHist, MouseEvent mouseEvent) {
        profHist.whenMouseMoved(mouseEvent);
    }

    final class 1
    extends MouseAdapter {
        public void mousePressed(MouseEvent e) {
            ProfHist.mav$whenMousePressed(ProfHist.this, e);
        }
    }

    final class 2
    implements MouseMotionListener {
        public void mouseDragged(MouseEvent e) {
        }

        public void mouseMoved(MouseEvent e) {
            ProfHist.mav$whenMouseMoved(ProfHist.this, e);
        }
    }
}

