/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.profile;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import oracle.ide.resource.IdeArb;
import oracle.jdevimpl.runner.profile.HorzRule;
import oracle.jdevimpl.runner.profile.ProfHist;
import oracle.jdevimpl.runner.profile.ProfHistModel;

public class ProfHistPanel
extends JPanel
implements ActionListener {
    private ProfHist _hist;
    private JButton _butScaleIn;
    private JButton _butScaleOut;
    private Point _ptLastDrag;
    private int _nScale;
    private JScrollPane _graphScrollPane;

    private void $init$() {
        this._nScale = 0;
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this._butScaleIn) {
            this.whenButScalePressed(e, true);
        }
        if (e.getSource() == this._butScaleOut) {
            this.whenButScalePressed(e, false);
        }
    }

    public ProfHistPanel(ProfHistModel model) {
        this.$init$();
        this.setLayout(new GridBagLayout());
        this._graphScrollPane = new JScrollPane();
        this._graphScrollPane.setBorder(BorderFactory.createEmptyBorder());
        this._hist = new ProfHist(model);
        this._graphScrollPane.setViewportView(this._hist);
        this._graphScrollPane.setHorizontalScrollBarPolicy(32);
        this._graphScrollPane.setVerticalScrollBarPolicy(22);
        this.setHorzRuler(new HorzRule());
        this._butScaleIn = new JButton(IdeArb.getIcon((int)181));
        this._butScaleIn.setRequestFocusEnabled(false);
        this._butScaleIn.setBorder(BorderFactory.createBevelBorder(0));
        this._butScaleIn.addActionListener(this);
        this._butScaleOut = new JButton(IdeArb.getIcon((int)104));
        this._butScaleOut.setRequestFocusEnabled(false);
        this._butScaleOut.setBorder(BorderFactory.createBevelBorder(0));
        this._butScaleOut.addActionListener(this);
        JScrollBar hScroll = new JScrollBar(0);
        this._graphScrollPane.setHorizontalScrollBar(hScroll);
        this._hist.addMouseMotionListener(new 1());
        this._hist.addMouseListener(new 2());
        this.setScale(1, 1000, 1.0f);
        this._nScale = 1;
        this.add((Component)this._graphScrollPane, new GridBagConstraints(0, 0, 0, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)hScroll, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this._butScaleIn, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this._butScaleOut, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
    }

    void setVerticalScrollBar(JScrollBar sb) {
        this._graphScrollPane.setVerticalScrollBar(sb);
    }

    JViewport getColumnHeader() {
        return this._graphScrollPane.getColumnHeader();
    }

    public void addSelectionListener(PropertyChangeListener l) {
        this._hist.addSelectionListener(l);
    }

    public void removeSelectionListener(PropertyChangeListener l) {
        this._hist.removeSelectionListener(l);
    }

    public HorzRule getHorzRuler() {
        HorzRule ret = null;
        JViewport vp = this._graphScrollPane.getColumnHeader();
        if (vp != null) {
            ret = (HorzRule)vp.getView();
        }
        return ret;
    }

    public void setHorzRuler(HorzRule ruler) {
        this._graphScrollPane.setColumnHeaderView(ruler);
    }

    public void setScale(int nScaleM, int nScaleD, float nScaleU) {
        HorzRule hr = this.getHorzRuler();
        this._hist.setScale(nScaleM, nScaleD);
        hr.setScale(nScaleU);
        this.updateScrollbars();
    }

    public int getRowHeight() {
        return this._hist.getRowHeight();
    }

    public void setRowHeight(int rowHeight) {
        this._hist.setRowHeight(rowHeight);
    }

    public void updateDatas() {
        this._hist.setPreferredSize(null);
        this.updateScrollbars();
    }

    public void setSelected(int[] nSelected) {
        this._hist.setSelected(nSelected, false);
    }

    public int[] getSelected() {
        return this._hist.getSelected();
    }

    public Rectangle getEventBounds(int nEvent) {
        return this._hist.getEventBounds(nEvent);
    }

    public void addNotify() {
        super.addNotify();
        Dimension dPref = new Dimension(this._hist.getPreferredSize().width, 20);
        this.getHorzRuler().setPreferredSize(dPref);
    }

    private void whenMousePressed(MouseEvent e) {
        Point pt = this._graphScrollPane.getViewport().getViewPosition();
        this._ptLastDrag = new Point(e.getPoint());
        this._ptLastDrag.x -= pt.x;
        this._ptLastDrag.y -= pt.y;
    }

    private void whenMouseDragged(MouseEvent e) {
        Point pt = this._graphScrollPane.getViewport().getViewPosition();
        Dimension dimViewport = this._graphScrollPane.getViewport().getSize();
        Dimension dimView = this._graphScrollPane.getViewport().getViewSize();
        Point ptMouse = e.getPoint();
        ptMouse.x -= pt.x;
        ptMouse.y -= pt.y;
        pt.translate(this._ptLastDrag.x - ptMouse.x, this._ptLastDrag.y - ptMouse.y);
        if (pt.x < 0) {
            pt.x = 0;
        }
        if (dimView.width > dimViewport.width) {
            if (pt.x + dimViewport.width > dimView.width) {
                pt.x = dimView.width - dimViewport.width;
            }
        } else {
            pt.x = 0;
        }
        if (pt.y < 0) {
            pt.y = 0;
        }
        if (dimView.height > dimViewport.height) {
            if (pt.y + dimViewport.height > dimView.height) {
                pt.y = dimView.height - dimViewport.height;
            }
        } else {
            pt.y = 0;
        }
        this._graphScrollPane.getViewport().setViewPosition(pt);
        this._ptLastDrag = ptMouse;
    }

    private void whenMouseReleased(MouseEvent e) {
        this._ptLastDrag = null;
    }

    private void whenButScalePressed(ActionEvent e, boolean isIn) {
        if (isIn && this._nScale != 4) {
            this._nScale = (this._nScale + 1) % 5;
        } else if (this._nScale != 0) {
            this._nScale = (this._nScale + 4) % 5;
        }
        this._butScaleIn.setEnabled(this._nScale != 4);
        this._butScaleOut.setEnabled(this._nScale != 0);
        switch (this._nScale) {
            case 1: {
                this.setScale(1, 1000, 1.0f);
                break;
            }
            case 2: {
                this.setScale(1, 100, 0.1f);
                break;
            }
            case 3: {
                this.setScale(1, 10, 0.01f);
                break;
            }
            case 4: {
                this.setScale(1, 1, 0.001f);
                break;
            }
            case 0: {
                this.setScale(1, 10000, 10.0f);
                break;
            }
        }
        this.scrollGraphToVisible();
    }

    void updateScrollbars() {
        this._graphScrollPane.getViewport().setView(this._hist);
        this.addNotify();
    }

    public void scrollGraphToVisible() {
        JViewport vp = this._graphScrollPane.getViewport();
        int[] nSel = this.getSelected();
        if (nSel != null && nSel.length != 0) {
            Rectangle rBar = this.getEventBounds(nSel[0]);
            Dimension dView = vp.getViewSize();
            Rectangle rView = vp.getViewRect();
            if (!rView.contains(rBar)) {
                int x = Math.min(rBar.x - 5, dView.width - rView.width);
                x = Math.max(x, 0);
                vp.setViewPosition(new Point(x, rView.y));
            }
        }
    }

    static void mav$whenMouseDragged(ProfHistPanel profHistPanel, MouseEvent mouseEvent) {
        profHistPanel.whenMouseDragged(mouseEvent);
    }

    static void mav$whenMouseReleased(ProfHistPanel profHistPanel, MouseEvent mouseEvent) {
        profHistPanel.whenMouseReleased(mouseEvent);
    }

    static void mav$whenMousePressed(ProfHistPanel profHistPanel, MouseEvent mouseEvent) {
        profHistPanel.whenMousePressed(mouseEvent);
    }

    final class 1
    implements MouseMotionListener {
        public void mouseDragged(MouseEvent e) {
            ProfHistPanel.mav$whenMouseDragged(ProfHistPanel.this, e);
        }

        public void mouseMoved(MouseEvent e) {
        }
    }

    final class 2
    extends MouseAdapter {
        public void mousePressed(MouseEvent e) {
            ProfHistPanel.mav$whenMousePressed(ProfHistPanel.this, e);
        }

        public void mouseReleased(MouseEvent e) {
            ProfHistPanel.mav$whenMouseReleased(ProfHistPanel.this, e);
        }
    }
}

