/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.profile;

import java.awt.Color;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.StringTokenizer;
import javax.swing.tree.MutableTreeNode;
import oracle.ide.util.Assert;
import oracle.ide.util.IntHashMap;
import oracle.ide.util.ModelUtil;
import oracle.ide.util.TriStateBoolean;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;
import oracle.javatools.data.PropertyStorage;
import oracle.jdeveloper.runner.RunConfiguration;
import oracle.jdevimpl.runner.profile.BasicEvent;
import oracle.jdevimpl.runner.profile.ProfArb;

class ProfileConfiguration
extends HashStructureAdapter {
    private static final String DATA_KEY = ProfileConfiguration.class.getName();
    private transient BasicEvent _eventsTree;
    private transient BasicEvent _unknownEventGroup;
    private transient IntHashMap _eventsMap;
    private transient HashMap _DMSeventsMap;
    private static final String SAMPLE_INTERVAL = "sampleInterval";
    private static final String SLIDER_DEPTH = "sliderDepth";
    private static final String MEMORY_UPDATE_INTERVAL = "memoryUpdateInterval";
    private static final String INCLUDED_CLASSES = "includedClasses";
    private static final String EXCLUDED_CLASSES = "excludedClasses";
    private static final String INCLUDED_INSTANCES = "includedInstances";
    private static final String EXCLUDED_INSTANCES = "excludedInstances";
    private static final String EVENTS = "events";
    private static final String GROUP_ALL_PREFIX = "G(All Events;(";
    private static final String GROUP_ALL_SUFFIX = "));";
    private static String initialEvents = "G(VM Events;(E(0;GC;-16776961;1);E(10;Wait;-65485;0);E(11;Synch Blocks 0;-39322;0);E(12;Synch Blocks 1;-39322;0);E(13;Synch Blocks 2;-39322;0);E(20;Prepare Class;-16751002;0);E(21;Load Class;-16724992;0);E(22;Resolve Class;-16737997;0);));";
    private static final String USE_API = "useAPI";
    private static final String REMOTE_HOST = "remoteHost";
    private static final String REMOTE_PORT = "remotePort";
    private static final String PROMPT_FOR_REMOTE_PROFILING = "promptForRemoteProfiling";
    private static final String DMS_STATE = "DMSstate";
    private static final String DMS_START_ID = "DMSstartID";

    private ProfileConfiguration(HashStructure hash) {
        super(hash);
    }

    static ProfileConfiguration getInstance(PropertyStorage propertyStorage) {
        if (propertyStorage instanceof RunConfiguration) {
            return new ProfileConfiguration(ProfileConfiguration.findOrCreate((PropertyStorage)propertyStorage, (String)DATA_KEY));
        }
        RunConfiguration runConfiguration = RunConfiguration.getInstance(propertyStorage);
        return ProfileConfiguration.getInstance(runConfiguration);
    }

    int getSampleInterval() {
        return this._hash.getInt(SAMPLE_INTERVAL, 5);
    }

    void setSampleInterval(int sampleInterval) {
        if (sampleInterval < 5) {
            sampleInterval = 5;
        }
        this._hash.putInt(SAMPLE_INTERVAL, sampleInterval);
    }

    int getSliderDepth() {
        return this._hash.getInt(SLIDER_DEPTH, 20);
    }

    void setSliderDepth(int sliderDepth) {
        this._hash.putInt(SLIDER_DEPTH, sliderDepth);
    }

    int getMemoryUpdateInterval() {
        return this._hash.getInt(MEMORY_UPDATE_INTERVAL, 10);
    }

    void setMemoryUpdateInterval(int memoryUpdateInterval) {
        this._hash.putInt(MEMORY_UPDATE_INTERVAL, memoryUpdateInterval);
    }

    String getIncludedClasses() {
        return this._hash.getString(INCLUDED_CLASSES, "");
    }

    void setIncludedClasses(String includedClasses) {
        this._hash.putString(INCLUDED_CLASSES, includedClasses);
    }

    String getExcludedClasses() {
        return this._hash.getString(EXCLUDED_CLASSES, "java;javax;sun;sunw;oracle");
    }

    void setExcludedClasses(String excludedClasses) {
        this._hash.putString(EXCLUDED_CLASSES, excludedClasses);
    }

    String getIncludedInstances() {
        return this._hash.getString(INCLUDED_INSTANCES, "");
    }

    void setIncludedInstances(String includedInstances) {
        this._hash.putString(INCLUDED_INSTANCES, includedInstances);
    }

    String getExcludedInstances() {
        return this._hash.getString(EXCLUDED_INSTANCES, "");
    }

    void setExcludedInstances(String excludedInstances) {
        this._hash.putString(EXCLUDED_INSTANCES, excludedInstances);
    }

    static {
        Assert.execute((Runnable)new 1());
    }

    String getEvents() {
        String defaultEvents = GROUP_ALL_PREFIX + initialEvents + GROUP_ALL_SUFFIX;
        return this._hash.getString(EVENTS, defaultEvents);
    }

    void setEvents(String events) {
        String curEvents = this.getEvents();
        if (ModelUtil.areDifferent((Object)curEvents, (Object)events)) {
            this._hash.putString(EVENTS, events);
            this._eventsTree = null;
            this._unknownEventGroup = null;
            this._eventsMap = null;
            this._DMSeventsMap = null;
        }
    }

    boolean isUseAPI() {
        return this._hash.getBoolean(USE_API, false);
    }

    void setUseAPI(boolean useAPI) {
        this._hash.putBoolean(USE_API, useAPI);
    }

    String getRemoteHost() {
        return this._hash.getString(REMOTE_HOST, "");
    }

    void setRemoteHost(String remoteHost) {
        this._hash.putString(REMOTE_HOST, remoteHost);
    }

    int getRemotePort() {
        return this._hash.getInt(REMOTE_PORT, 4000);
    }

    void setRemotePort(int remotePort) {
        this._hash.putInt(REMOTE_PORT, remotePort);
    }

    boolean isPromptForRemoteProfiling() {
        return this._hash.getBoolean(PROMPT_FOR_REMOTE_PROFILING, true);
    }

    void setPromptForRemoteProfiling(boolean promptForRemoteProfiling) {
        this._hash.putBoolean(PROMPT_FOR_REMOTE_PROFILING, promptForRemoteProfiling);
    }

    int getDMSstate() {
        return this._hash.getInt(DMS_STATE, 0);
    }

    void setDMSstate(int DMSstate) {
        this._hash.putInt(DMS_STATE, DMSstate);
    }

    int getDMSstartID() {
        return this._hash.getInt(DMS_START_ID, 20000);
    }

    void setDMSstartID(int DMSstartID) {
        this._hash.putInt(DMS_START_ID, DMSstartID);
    }

    private void addEventInMap(BasicEvent ev) {
        if (ev._color != null) {
            this._eventsMap.put(ev.getId(), (Object)ev);
        } else {
            Enumeration childs = ev.children();
            while (childs.hasMoreElements()) {
                BasicEvent child = (BasicEvent)childs.nextElement();
                this.addEventInMap(child);
            }
        }
    }

    private void regenerateEventsStructures() {
        this._eventsTree = BasicEvent.parseFromString(this.getEvents());
        this._unknownEventGroup = null;
        this._eventsMap = new IntHashMap(30);
        this._DMSeventsMap = new HashMap(30);
        this.addEventInMap(this._eventsTree);
    }

    private String buildEvList(boolean state) {
        if (this._eventsTree == null) {
            this.regenerateEventsStructures();
        }
        Iterator it = this._eventsMap.iterator();
        StringBuffer sb = new StringBuffer();
        while (it.hasNext()) {
            BasicEvent be = (BasicEvent)it.next();
            if (be.getSelected() != state) continue;
            sb.append(',');
            sb.append(be.getId());
        }
        return new String(sb);
    }

    private void appendAllDMSEvents(StringBuffer sb, BasicEvent node) {
        if (node.getColor() != null) {
            sb.append("N|");
            sb.append(node._key);
            sb.append("|");
            sb.append(node._id);
            sb.append(";");
        } else {
            sb.append("G|");
            sb.append(node._key);
            sb.append("|");
            sb.append(node.getChildCount());
            sb.append("|[");
            int i = 0;
            while (i < node.getChildCount()) {
                this.appendAllDMSEvents(sb, (BasicEvent)((Object)node.getChildAt(i)));
                ++i;
            }
            sb.append("];");
        }
    }

    String buildDMSEvList() {
        if (this._eventsTree == null) {
            this.regenerateEventsStructures();
        }
        StringBuffer sb = new StringBuffer();
        sb.append(this.getDMSstate());
        int i = 0;
        while (i < this._eventsTree.getChildCount()) {
            BasicEvent ev = (BasicEvent)((Object)this._eventsTree.getChildAt(i));
            if ("DMS_ROOT".equals(ev._key)) {
                this.appendAllDMSEvents(sb, ev);
            }
            ++i;
        }
        return new String(sb);
    }

    String exclEventList() {
        return this.buildEvList(false);
    }

    String inclEventList() {
        return this.buildEvList(true);
    }

    private void checkUnknownEventGroup() {
        if (this._unknownEventGroup != null) {
            return;
        }
        if (this._eventsTree == null) {
            this.regenerateEventsStructures();
        }
        int i = 0;
        while (i < this._eventsTree.getChildCount()) {
            BasicEvent cev = (BasicEvent)((Object)this._eventsTree.getChildAt(i));
            if (cev.getColor() == null && cev._key.equals(ProfArb.getString(71))) {
                this._unknownEventGroup = cev;
                break;
            }
            ++i;
        }
        if (this._unknownEventGroup == null) {
            this._unknownEventGroup = new BasicEvent(ProfArb.getString(71));
            this._eventsTree.add((MutableTreeNode)((Object)this._unknownEventGroup));
        }
    }

    BasicEvent eventFromId(int id) {
        BasicEvent res;
        if (this._eventsTree == null) {
            this.regenerateEventsStructures();
        }
        if ((res = (BasicEvent)this._eventsMap.get(id)) != null) {
            return res;
        }
        this.checkUnknownEventGroup();
        res = new BasicEvent(id, ProfArb.format(137, Integer.toString(id)), Color.blue, TriStateBoolean.TRUE);
        this._unknownEventGroup.add((MutableTreeNode)((Object)res));
        this._eventsMap.put(id, (Object)res);
        this.setEvents(this._eventsTree.getStringValue());
        return res;
    }

    BasicEvent eventFromId(int id, BasicEvent def) {
        BasicEvent res;
        if (this._eventsTree == null) {
            this.regenerateEventsStructures();
        }
        if ((res = (BasicEvent)this._eventsMap.get(id)) != null) {
            return res;
        }
        this.checkUnknownEventGroup();
        res = def;
        this._unknownEventGroup.add((MutableTreeNode)((Object)res));
        this._eventsMap.put(id, (Object)res);
        this.setEvents(this._eventsTree.getStringValue());
        return res;
    }

    private static boolean keyMatch(String s, String key) {
        if (key.endsWith("*")) {
            return s.startsWith(key.substring(0, key.length() - 1));
        }
        return s.equals(key);
    }

    BasicEvent eventFromDMS(String comment) {
        int firstSpace;
        String cpath;
        BasicEvent ev;
        if (this._eventsTree == null) {
            this.regenerateEventsStructures();
        }
        if ((ev = (BasicEvent)this._DMSeventsMap.get(cpath = (firstSpace = comment.indexOf(32)) != -1 ? comment.substring(0, firstSpace) : comment)) != null) {
            return ev;
        }
        boolean created = false;
        StringTokenizer stok = new StringTokenizer(cpath, "/");
        BasicEvent ctreepos = this._eventsTree;
        while (stok.hasMoreTokens()) {
            String cToken = stok.nextToken();
            if (cToken.equals("")) continue;
            ev = null;
            if (!stok.hasMoreTokens()) {
                int i = 0;
                while (i < ctreepos.getChildCount()) {
                    BasicEvent cev = (BasicEvent)((Object)ctreepos.getChildAt(i));
                    if (cev.getColor() != null && ProfileConfiguration.keyMatch(cToken, cev._key)) {
                        ev = cev;
                        break;
                    }
                    ++i;
                }
                if (ev == null) {
                    int id = this.getDMSstartID();
                    this.setDMSstartID(++id);
                    ev = new BasicEvent(id, cToken, Color.blue, TriStateBoolean.TRUE);
                    created = true;
                    ctreepos.add((MutableTreeNode)((Object)ev));
                }
            } else {
                int i = 0;
                while (i < ctreepos.getChildCount()) {
                    BasicEvent cev = (BasicEvent)((Object)ctreepos.getChildAt(i));
                    if (cev.getColor() == null && ProfileConfiguration.keyMatch(cToken, cev._key)) {
                        ev = cev;
                        break;
                    }
                    ++i;
                }
                if (ev == null) {
                    ev = new BasicEvent(cToken, TriStateBoolean.TRUE);
                    created = true;
                    ctreepos.add((MutableTreeNode)((Object)ev));
                }
            }
            ctreepos = ev;
        }
        if (created) {
            this.setEvents(this._eventsTree.getStringValue());
        }
        this._DMSeventsMap.put(cpath, ev);
        return ev;
    }

    static void addInitialEvent(String s) {
        try {
            BasicEvent newEventsTree = BasicEvent.parseFromString(s);
            if (newEventsTree != null) {
                initialEvents = initialEvents + s;
            }
        }
        catch (Exception e) {
            Assert.printStackTrace((Throwable)e);
        }
    }

    static void wa$initialEvents(String string) {
        initialEvents = string;
    }

    static final class 1
    implements Runnable {
        public void run() {
            ProfileConfiguration.wa$initialEvents("G(VM Events;(E(0;GC;-16776961;1);E(1;GC Details;-16764109;0);E(2;GC Details;-16764109;0);E(3;GC Details;-16764109;0);E(10;Wait;-65485;0);E(11;Synch Blocks 0;-39322;0);E(12;Synch Blocks 1;-39322;0);E(13;Synch Blocks 2;-39322;0);E(20;Prepare Class;-16751002;0);E(21;Load Class;-16724992;0);E(22;Resolve Class;-16737997;0);));G(IDE Events;(E(2000;JavaSrcStructureBuilder.updateTree;-16776961;0);E(2001;JavaSrcStructureBuilder.parse;-16776961;0);E(100;Generic;-16727872;0);E(101;IDE Startup;-16727872;0);E(102;Key Pressed;-16727872;0);E(104;Dock Layout;-16727872;0);E(105;Get Dockable;-16727872;0);E(106;Unknown event 106;-16776961;0);E(3318;MainWindow Paint;-16727872;0);E(3319;RepaintManager.addDirtyRegion;-16727872;0);));G(JOT Events;(E(3026;ClassBody BuildModel;-16776961;0);E(3000;ClsFile Create;-16711936;0);E(3001;SrcFile Create;-16515128;0);E(3002;ClsFile parse;-16776961;0);E(3003;SrcFile parse;-16725761;0);E(3004;GetClassList;-5592406;0);E(3005;GetFileList;-8882056;0);E(3006;GetDirList;-11842741;0);E(3007;Build SrcFile Model;-16776961;0);E(3008;Build SrcClass model;-16776961;0);E(3009;ClassManager.getClass;-65281;0);E(3010;JotType.getJotClass;-5439488;0);E(3011;ClassManager._getClass;-21761;0);E(3012;BuildIntefaceList;-21931;0);E(3013;GetMethods;-21931;0);E(3014;GetMethods2;-21931;0);E(3015;GetMethod;-21931;0);E(3016;GetFields;-21931;0);E(3017;GetField;-21931;0);E(3018;CommitFile;-21931;0);E(3019;GetDeclaredConstructors;-39271;0);E(3020;GetDeclaredConstructor;-26164;0);E(3021;GetDeclaredMethods;-3355393;0);E(3022;GetDeclaredMethods2;-3355393;0);E(3023;GetDeclaredMethod;-3355393;0);E(3024;GetDeclaredFields;-16737895;0);E(3025;GetDeclaredField;-16737895;0);E(3026;ClassBody.buildModel;-16737895;0);));G(CMT Events;(G(CmtComponent Events;(E(3100;Setup Class;-5445006;0);E(3101;Get Supercomponent;-5445006;0);E(3102;Load PME;-5445006;0);E(3103;Build Properties;-5445006;0);E(3104;Build Methods;-5445006;0);E(3105;Build Events;-5445006;0);E(3106;Add Import;-5445006;0);E(3107;Build Subcomponents;-5445006;0);E(3108;Add Subcomponent;-5445006;0);E(3109;Remove Subcomponent;-5445006;0);E(3110;Rename Subcomponent;-5445006;0);E(3111;Prepare jbInit;-5445006;0);E(3112;Instantiate Proxy;-5445006;0);E(3113;Make Subcomponent;-5445006;0);E(3114;Get BeanInfo;-5445006;0);E(3115;Update;-5445006;0);E(3116;Update Failed;-5445006;0);E(3117;Notify Failure;-5445006;0);E(3118;Notify Changing;-5445006;0);E(3119;Notify Success;-5445006;0);E(3120;Add Property;-5445006;0);));G(CmtSubcomponent Events;(E(3134;Copy Subcomponent;-16556117;0);E(3135;Get Property State;-16556117;0);E(3136;Build Properties;-16556117;0);E(3137;Build Events;-16556117;0);E(3138;Get Event State;-16556117;0);E(3139;Get Property Setting;-16556117;0);E(3140;Add Property Setting;-16556117;0);E(3141;Remove Property Setting;-16556117;0);E(3142;Create Instance;-16556117;0);E(3143;Get Live Instance;-16556117;0);));));G(IDE Startup;(E(3200;IDE Startup Impl;-3342388;1);E(3208;Load IdeSettings;-10040320;1);E(3320;Initialize Main Window Frame;-10040320;1);E(3205;Init Core Addins;-3342439;1);E(3207;Initialize Addin;-6684826;1);E(3206;Init Product and User Addins;-3342439;1);E(3317;Main Window Frame Init;-6697984;1);G(Main Window Startup;(E(3300;Post Initialize;-52;1);E(3316;Paint;-103;1);E(3301;Activate Layout;-103;1);E(3303;Activate Editor;-103;1);E(3302;Open CmdLine Args;-103;1);E(3202;Activate;-3355648;1);E(3304;Load Valid Layout;-13210;1);E(3305;TitledPanel Load Layout;-13210;1);E(3306;Add Client Component;-13210;1);E(3307;Get or Create Component;-13210;1);E(3308;Create Tree;-26215;1);E(3309;NavigatorWindowImpl Load Layout;-26215;1);E(3310;Restore Expansion State;-26215;1);E(3203;Get Hosted Component;-13210;1);E(3311;Add Children;-26266;1);E(3314;Get Context;-39322;1);E(3315;Create Editor;-39322;1);E(3312;Get Child Filter;-26266;1);E(3313;Create Editors;-39322;1);E(3400;Initialize Editor;-6724096;1);E(3401;Create Editor Pane;-6750208;1);));E(3201;Main Window Opened;-3342439;1);));E(3209;BackGroundLoader Thread;-3368449;1);E(3210;Preloader;-3381505;1);E(3204;Get ImageIcon;-16724788;1);E(3500;Initialize Help System;-16776961;0);E(3501;Show Help Topic;-16776961;0);G(Connection Events;(E(3402;Init ConnectionManager;-3342388;0);E(3403;Register CM Objects;-3342388;0);E(3404;Misc CM init;-3342388;0);E(3405;Open ConnectionNode;-6710785;0);E(3406;Open ConnectionBrowser;-3355393;0);E(3407;Load JDBC Connection Children;-16776961;0);E(3408;Create Run Proc;-16776961;0);E(3409;Drop Run Proc;-16776961;0);));G(EJB;(E(3600;EntityEngine.getFields();-52429;0);));");
        }
    }
}

