/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.profile;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import oracle.ide.Ide;
import oracle.ide.help.HelpSystem;
import oracle.ide.model.Project;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.IdeUtil;
import oracle.ide.util.Namespace;
import oracle.ide.util.ResourceUtils;
import oracle.jdeveloper.dialogs.ClassPackageListBrowser;
import oracle.jdeveloper.runner.RunConfiguration;
import oracle.jdeveloper.runner.RunConfigurationEditorUtil;
import oracle.jdevimpl.runner.profile.ProfArb;
import oracle.jdevimpl.runner.profile.ProfileConfiguration;

public class ProfileConfigurationPanel
extends DefaultTraversablePanel
implements ActionListener {
    private JTextField includedClasses;
    private JButton includedClassesButton;
    private JTextField excludedClasses;
    private JButton excludedClassesButton;
    private JCheckBox useAPICheckBox;
    private JTextField remoteHostTextField;
    private JTextField remotePortTextField;
    private JCheckBox promptCheckBox;

    public ProfileConfigurationPanel() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void onEntry(TraversableContext tc) {
        ProfileConfiguration profileConfiguration = ProfileConfigurationPanel.getProfileConfiguration(tc);
        this.loadFrom(profileConfiguration);
    }

    public void onExit(TraversableContext tc) throws TraversalException {
        ProfileConfiguration profileConfiguration = ProfileConfigurationPanel.getProfileConfiguration(tc);
        this.commitTo(profileConfiguration);
    }

    private static ProfileConfiguration getProfileConfiguration(TraversableContext tc) {
        RunConfiguration runConfiguration = RunConfigurationEditorUtil.getRunConfiguration((Namespace)tc);
        return ProfileConfiguration.getInstance(runConfiguration);
    }

    private void loadFrom(ProfileConfiguration profileConfiguration) {
        String s = profileConfiguration.getExcludedClasses();
        this.excludedClasses.setText(s != null ? s : "");
        s = profileConfiguration.getIncludedClasses();
        this.includedClasses.setText(s != null ? s : "");
        this.useAPICheckBox.setSelected(profileConfiguration.isUseAPI());
        this.remoteHostTextField.setText(profileConfiguration.getRemoteHost());
        this.remotePortTextField.setText(Integer.toString(profileConfiguration.getRemotePort()));
        this.promptCheckBox.setSelected(profileConfiguration.isPromptForRemoteProfiling());
    }

    private void commitTo(ProfileConfiguration profileConfiguration) throws TraversalException {
        int port;
        try {
            port = Integer.parseInt(this.remotePortTextField.getText());
        }
        catch (Exception e) {
            throw new TraversalException(ProfArb.getString(212));
        }
        profileConfiguration.setExcludedClasses(this.excludedClasses.getText());
        profileConfiguration.setIncludedClasses(this.includedClasses.getText());
        profileConfiguration.setUseAPI(this.useAPICheckBox.isSelected());
        profileConfiguration.setRemoteHost(this.remoteHostTextField.getText());
        profileConfiguration.setRemotePort(port);
        profileConfiguration.setPromptForRemoteProfiling(this.promptCheckBox.isSelected());
    }

    private void jbInit() throws Exception {
        HelpSystem.getHelpSystem().registerTopic((JComponent)((Object)this), ProfArb.getString(296));
        JLabel includedClassesLabel = new JLabel();
        this.includedClasses = new JTextField();
        this.includedClassesButton = new JButton();
        JLabel excludedClassesLabel = new JLabel();
        this.excludedClasses = new JTextField();
        this.excludedClassesButton = new JButton();
        this.useAPICheckBox = new JCheckBox();
        JLabel remoteInfoLabel = new JLabel();
        JLabel remoteHostLabel = new JLabel();
        this.remoteHostTextField = new JTextField();
        JLabel remotePortLabel = new JLabel();
        this.remotePortTextField = new JTextField();
        this.promptCheckBox = new JCheckBox();
        ResourceUtils.resLabel((JLabel)includedClassesLabel, (Component)this.includedClasses, (String)ProfArb.getString(90));
        ResourceUtils.resButton((AbstractButton)this.includedClassesButton, (String)ProfArb.getString(279));
        ResourceUtils.resLabel((JLabel)excludedClassesLabel, (Component)this.excludedClasses, (String)ProfArb.getString(318));
        ResourceUtils.resButton((AbstractButton)this.excludedClassesButton, (String)ProfArb.getString(315));
        ResourceUtils.resButton((AbstractButton)this.useAPICheckBox, (String)ProfArb.getString(223));
        remoteInfoLabel.setText(ProfArb.getString(280));
        ResourceUtils.resLabel((JLabel)remoteHostLabel, (Component)this.remoteHostTextField, (String)ProfArb.getString(138));
        ResourceUtils.resLabel((JLabel)remotePortLabel, (Component)this.remotePortTextField, (String)ProfArb.getString(191));
        ResourceUtils.resButton((AbstractButton)this.promptCheckBox, (String)ProfArb.getString(310));
        this.setLayout(new GridBagLayout());
        int y = 0;
        this.add(includedClassesLabel, new GridBagConstraints(0, y++, 0, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 2, 0), 0, 0));
        this.add(this.includedClasses, new GridBagConstraints(0, y, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.includedClassesButton, new GridBagConstraints(1, y++, 0, 1, 0.0, 0.0, 17, 0, new Insets(0, 8, 0, 0), 0, 0));
        this.add(excludedClassesLabel, new GridBagConstraints(0, y++, 0, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 2, 5), 0, 0));
        this.add(this.excludedClasses, new GridBagConstraints(0, y, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.excludedClassesButton, new GridBagConstraints(1, y++, 0, 1, 0.0, 0.0, 17, 0, new Insets(0, 8, 0, 0), 0, 0));
        this.add(this.useAPICheckBox, new GridBagConstraints(0, y++, 0, 1, 0.0, 0.0, 17, 0, new Insets(10, 0, 0, 0), 0, 0));
        this.add(this.makeRemotePanel(remoteInfoLabel, remoteHostLabel, remotePortLabel), new GridBagConstraints(0, y++, 0, 1, 1.0, 0.0, 17, 2, new Insets(10, 0, 0, 0), 0, 0));
        this.add(new JLabel(), new GridBagConstraints(0, y++, 0, 1, 0.0, 1.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.includedClassesButton.addActionListener(this);
        this.excludedClassesButton.addActionListener(this);
        if (Ide.getActiveProject() == null) {
            this.includedClassesButton.setEnabled(false);
            this.excludedClassesButton.setEnabled(false);
        }
    }

    private JPanel makeRemotePanel(JLabel remoteInfoLabel, JLabel remoteHostLabel, JLabel remotePortLabel) {
        JPanel remotePanel = new JPanel(new GridBagLayout());
        int y = 0;
        remotePanel.add((Component)remoteInfoLabel, new GridBagConstraints(0, y++, 0, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        remotePanel.add((Component)remoteHostLabel, new GridBagConstraints(0, y, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 20, 0, 0), 0, 0));
        remotePanel.add((Component)this.remoteHostTextField, new GridBagConstraints(1, y++, 0, 1, 1.0, 0.0, 17, 2, new Insets(2, 5, 0, 0), 0, 0));
        remotePanel.add((Component)remotePortLabel, new GridBagConstraints(0, y, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 20, 0, 0), 0, 0));
        remotePanel.add((Component)this.remotePortTextField, new GridBagConstraints(1, y++, 0, 1, 1.0, 0.0, 17, 2, new Insets(2, 5, 0, 0), 0, 0));
        remotePanel.add((Component)this.promptCheckBox, new GridBagConstraints(0, y++, 0, 1, 1.0, 0.0, 17, 0, new Insets(2, 20, 0, 0), 0, 0));
        return remotePanel;
    }

    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.includedClassesButton) {
            String title = ProfArb.getString(49);
            String s = this.includedClasses.getText();
            ArrayList list = new ArrayList();
            IdeUtil.string2List((String)s, list);
            String HELP_ID = "f1_idedclasspkginclexcl_html";
            Project project = Ide.getActiveProject();
            if (ClassPackageListBrowser.browseClassPackageList((Component)((Object)this), title, project, true, true, list, "f1_idedclasspkginclexcl_html")) {
                s = IdeUtil.list2String(list);
                this.includedClasses.setText(s);
            }
        } else if (source == this.excludedClassesButton) {
            String title = ProfArb.getString(288);
            String s = this.excludedClasses.getText();
            ArrayList list = new ArrayList();
            IdeUtil.string2List((String)s, list);
            String HELP_ID = "f1_idedclasspkginclexcl_html";
            Project project = Ide.getActiveProject();
            if (ClassPackageListBrowser.browseClassPackageList((Component)((Object)this), title, project, true, true, list, "f1_idedclasspkginclexcl_html")) {
                s = IdeUtil.list2String(list);
                this.excludedClasses.setText(s);
            }
        }
    }
}

