/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.profile;

import java.awt.Rectangle;
import java.util.ArrayList;
import oracle.ide.docking.DockStation;
import oracle.ide.docking.Dockable;
import oracle.ide.docking.DockableFactory;
import oracle.ide.docking.DockingParam;
import oracle.ide.layout.ViewId;
import oracle.jdevimpl.runner.profile.ProfDockWindowStub;
import oracle.jdevimpl.runner.profile.ProfWindow;
import oracle.jdevimpl.runner.profile.UpdatableSettings;

public final class ProfilerDockableFactory
implements DockableFactory {
    private static ArrayList memoryTables = new ArrayList(2);
    private static ArrayList sampleTables = new ArrayList(2);
    private static ArrayList eventTables = new ArrayList(2);
    private static ArrayList memDetTables = new ArrayList(2);
    private static Object reserved = new Object();
    private static final String profWindowPrefix = "Profiler.";
    private static final String profSampleWindowId = "samples_";
    private static final String profEventWindowId = "events_";
    private static final String profMemoryWindowId = "memory_";
    private static final String profMemDetWindowId = "memdet_";

    public ProfilerDockableFactory() {
        DockStation.getDockStation().registerDockableFactory("Profiler", (DockableFactory)this);
    }

    private void defaultDock(Dockable w) {
        DockingParam dockingParam = new DockingParam();
        dockingParam.setFloatingPosition(new Rectangle(10, 10, 800, 400));
        dockingParam.setFloating(true);
        dockingParam.setFloatOnTop(false);
        DockStation.getDockStation().dock(w, dockingParam);
    }

    private ProfDockWindowStub getFreeWindow(ArrayList pool, String prefix, ProfWindow ct) {
        ProfDockWindowStub res;
        int i = 0;
        while (i < pool.size()) {
            res = (ProfDockWindowStub)((Object)pool.get(i));
            if (res == null) {
                String id = profWindowPrefix + prefix + i;
                res = new ProfDockWindowStub(id);
                if (!prefix.equals(profMemDetWindowId)) {
                    this.defaultDock((Dockable)res);
                }
                pool.set(i, res);
                res.setContent(ct);
                return res;
            }
            if (res.getGUI() == null) {
                res.setContent(ct);
                return res;
            }
            ++i;
        }
        String id = profWindowPrefix + prefix + i;
        res = new ProfDockWindowStub(id);
        pool.add(res);
        res.setContent(ct);
        if (!prefix.equals(profMemDetWindowId)) {
            this.defaultDock((Dockable)res);
        }
        return res;
    }

    public void install() {
    }

    ProfDockWindowStub getSampleWindow(ProfWindow ct) {
        ProfDockWindowStub res = this.getFreeWindow(sampleTables, profSampleWindowId, ct);
        return res;
    }

    ProfDockWindowStub getEventWindow(ProfWindow ct) {
        ProfDockWindowStub res = this.getFreeWindow(eventTables, profEventWindowId, ct);
        return res;
    }

    ProfDockWindowStub getMemoryWindow(ProfWindow ct) {
        ProfDockWindowStub res = this.getFreeWindow(memoryTables, profMemoryWindowId, ct);
        return res;
    }

    ProfDockWindowStub getMemoryDetailWindow(ProfWindow ct) {
        ProfDockWindowStub res = this.getFreeWindow(memDetTables, profMemDetWindowId, ct);
        return res;
    }

    public Dockable getDockable(ViewId viewId) {
        String id = viewId.getName();
        ArrayList pool = null;
        if (id.startsWith(profSampleWindowId)) {
            pool = sampleTables;
        } else if (id.startsWith(profEventWindowId)) {
            pool = eventTables;
        } else if (id.startsWith(profMemoryWindowId)) {
            pool = memoryTables;
        } else if (id.startsWith(profMemDetWindowId)) {
            pool = memDetTables;
        }
        if (pool == null) {
            return null;
        }
        int index = Integer.parseInt(id.substring(id.lastIndexOf(95) + 1));
        while (pool.size() <= index) {
            pool.add(null);
        }
        ProfDockWindowStub res = (ProfDockWindowStub)((Object)pool.get(index));
        if (res == null) {
            res = new ProfDockWindowStub(viewId.getId());
            res.setDockableVisible(false);
            pool.set(index, res);
        }
        return res;
    }

    private static void enumeratePool(ArrayList pool) {
        int i = 0;
        while (i < pool.size()) {
            ProfWindow win;
            ProfDockWindowStub res = (ProfDockWindowStub)((Object)pool.get(i));
            if (res != null && res.getGUI() != null && (win = res.getContent()) instanceof UpdatableSettings) {
                ((UpdatableSettings)((Object)win)).updateSettings();
            }
            ++i;
        }
    }

    static void enumerateProfWindow() {
        ProfilerDockableFactory.enumeratePool(memoryTables);
        ProfilerDockableFactory.enumeratePool(sampleTables);
        ProfilerDockableFactory.enumeratePool(eventTables);
        ProfilerDockableFactory.enumeratePool(memDetTables);
    }
}

