/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.profile;

import java.io.DataInputStream;

public class ProfilerMessage {
    int messageId;
    byte[] buffer;
    int offset;
    int size;
    public ProfilerMessage next;

    ProfilerMessage(int size, DataInputStream inputStream) {
        this.size = size;
        this.buffer = new byte[size];
        try {
            inputStream.readFully(this.buffer);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.messageId = this.getByte();
    }

    public int getByte() {
        return this.buffer[this.offset++];
    }

    public int getUByte() {
        int ret = this.getByte();
        if (ret < 0) {
            ret = 256 + ret;
        }
        return ret;
    }

    public int getInt() {
        return (this.getUByte() << 24) + (this.getUByte() << 16) + (this.getUByte() << 8) + this.getUByte();
    }

    public String getString() {
        String s = "";
        int length = this.getInt();
        if (length != 0) {
            byte[] buf = new byte[length];
            System.arraycopy(this.buffer, this.offset, buf, 0, length);
            this.offset += length;
            try {
                s = new String(buf, "UTF-8");
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        return s;
    }

    public long getLong() {
        return (this.getInt() << 32) + this.getInt();
    }

    public int getMessageId() {
        return this.messageId;
    }

    public Object readObject(char type) {
        switch (type) {
            case 'L': 
            case '[': {
                int i = this.getInt();
                if (i == 0) {
                    return "null";
                }
                return Integer.toString(i, 16);
            }
            case 'X': {
                return this.getString();
            }
            case 'V': {
                return "void";
            }
            case 'Z': {
                return new Boolean(this.getInt() != 0);
            }
            case 'B': {
                return new Byte((byte)this.getInt());
            }
            case 'C': {
                return new Character((char)this.getInt());
            }
            case 'S': {
                return new Short((short)this.getInt());
            }
            case 'I': {
                return new Integer(this.getInt());
            }
            case 'D': {
                return new Double(this.getLong());
            }
            case 'F': {
                return new Float(this.getInt());
            }
            case 'J': {
                return new Long(this.getLong());
            }
        }
        System.out.println("Unknown type" + type);
        return null;
    }
}

