/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.profile;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import oracle.ide.Ide;
import oracle.jdevimpl.runner.profile.ProfArb;
import oracle.jdevimpl.runner.profile.ProfilerMessage;
import oracle.jdevimpl.runner.profile.ProfilingProcess;

class ProfilerMessageReader
implements Runnable {
    private static final boolean DEBUG = false;
    private DataInputStream inputStream;
    private DataOutputStream outputStream;
    private Socket clientSock;
    private ProfilerMessage head;
    private ProfilerMessage tail;
    private ProfilingProcess process;
    private int port;
    private String host;
    private boolean connected;

    public ProfilerMessageReader(ProfilingProcess process, String host, int port) {
        this.process = process;
        this.host = host;
        this.port = port;
        this.connected = true;
    }

    public void openConnection() throws IOException {
        InetAddress addr = InetAddress.getByName(this.host);
        this.clientSock = new Socket(addr, this.port);
        this.clientSock.setTcpNoDelay(true);
        this.clientSock.setSoTimeout(250);
    }

    public void closeConnection() {
        this.connected = false;
        this.clientSock = null;
    }

    public synchronized void connect() throws Exception {
        boolean localThrow = false;
        int retry = 5;
        int sleeptime = 100;
        boolean isremote = this.process.getRunConfiguration().isRemoteDebuggingProfiling();
        if (isremote) {
            String tryMsg = this.process.getConfiguration().isPromptForRemoteProfiling() ? ProfArb.format(214, this.host, Integer.toString(this.port)) : ProfArb.format(263, this.host, Integer.toString(this.port));
            this.process.getLogPage().log((Object)tryMsg);
        }
        while (true) {
            try {
                Thread.sleep(sleeptime);
                this.openConnection();
                this.inputStream = new DataInputStream(new BufferedInputStream(this.clientSock.getInputStream(), 32768));
                this.outputStream = new DataOutputStream(new BufferedOutputStream(this.clientSock.getOutputStream()));
                this.connected = true;
                if (isremote) {
                    this.process.getLogPage().log((Object)"\n");
                }
                Ide.getStatusBar().setText("");
                return;
            }
            catch (Exception e) {
                this.process.getLogPage().log((Object)".");
                Ide.getStatusBar().setText(ProfArb.getString(152));
                if (retry-- == 0) {
                    if (isremote) {
                        this.process.getLogPage().log((Object)"\n");
                        this.process.getLogPage().log((Object)ProfArb.getString(72));
                    }
                    this.closeConnection();
                    Ide.getStatusBar().setText("");
                    this.disconnect();
                    if (localThrow) {
                        throw (Exception)e.fillInStackTrace();
                    }
                    throw new Exception();
                }
                sleeptime *= 2;
                continue;
            }
            break;
        }
    }

    public synchronized void disconnect() throws Exception {
        throw new Exception("Socket error");
    }

    public synchronized void disconnectLow(Exception e) throws Exception {
        this.disconnect();
    }

    private ProfilerMessage receiveProfilerMessage() {
        try {
            int length = this.inputStream.readInt();
            this.clientSock.setSoTimeout(0);
            ProfilerMessage profilerMessage = new ProfilerMessage(length, this.inputStream);
            return profilerMessage;
        }
        catch (Exception e) {
            ProfilerMessage profilerMessage = null;
            return profilerMessage;
        }
    }

    private synchronized void sendByte(int b) throws Exception {
        if (this.outputStream == null) {
            System.out.println("null outputstream");
            return;
        }
        try {
            this.outputStream.writeByte(b);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.disconnectLow(e);
        }
    }

    private synchronized void sendInt(int i) throws Exception {
        if (this.outputStream == null) {
            return;
        }
        try {
            this.outputStream.writeInt(i);
        }
        catch (Exception e) {
            this.disconnectLow(e);
        }
    }

    public void sendMessage(int m) throws Exception {
        this.sendByte(m);
        this.flush();
    }

    public synchronized void sendMessageInt(int m, int data) throws Exception {
        this.sendByte(m);
        this.sendInt(data);
        this.flush();
    }

    public synchronized void sendMessageString(int m, String s) {
        try {
            this.sendByte(m);
            this.sendString(s);
            this.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private synchronized void sendString(String s) throws Exception {
        if (this.outputStream == null) {
            return;
        }
        try {
            if (s != null) {
                this.outputStream.writeInt(s.length());
                this.outputStream.writeBytes(s);
            } else {
                this.outputStream.writeInt(0);
            }
        }
        catch (Exception e) {
            this.disconnectLow(e);
        }
    }

    private synchronized void flush() throws Exception {
        try {
            this.outputStream.flush();
        }
        catch (Exception e) {
            this.disconnectLow(e);
        }
    }

    private synchronized void postMessage(ProfilerMessage p) {
        if (this.tail == null) {
            this.tail = p;
            if (this.head != null) {
                System.out.println("postMessage error");
            }
        }
        if (this.head != null) {
            this.head.next = p;
        }
        this.head = p;
    }

    public synchronized ProfilerMessage getMessage() throws Exception {
        if (this.tail != null) {
            ProfilerMessage p = this.tail;
            this.tail = this.tail.next;
            if (this.tail == null) {
                this.head = null;
            }
            return p;
        }
        if (!this.connected) {
            throw new Exception();
        }
        return null;
    }

    private void read() throws Exception {
        try {
            while (true) {
                if (this.inputStream.available() > 0) {
                    ProfilerMessage p = this.receiveProfilerMessage();
                    if (p == null) continue;
                    this.postMessage(p);
                    continue;
                }
                if (this.process.hasFinished()) {
                    this.connected = false;
                }
                Thread.sleep(10);
                if (!this.connected) break;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void run() {
        try {
            this.connect();
            this.read();
        }
        catch (Exception e) {
            this.process.terminateProcess();
        }
        this.connected = false;
    }

    public boolean isConnected() {
        return this.connected;
    }
}

