/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.profile;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import oracle.ide.help.HelpSystem;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;
import oracle.jdevimpl.runner.profile.ProfArb;
import oracle.jdevimpl.runner.profile.ProfilerSettings;

public class ProfilerSettingsPanel
extends DefaultTraversablePanel {
    private JCheckBox showEventColumnEventCheckBox;
    private JCheckBox showEventColumnMessCheckBox;
    private JCheckBox showEventColumnLocCheckBox;
    private JCheckBox showEventColumnStartCheckBox;
    private JCheckBox showEventColumnEndCheckBox;
    private JCheckBox showEventColumnDurCheckBox;
    private JCheckBox showSampleColumnClassCheckBox;
    private JCheckBox showSampleColumnMethodCheckBox;
    private JCheckBox showSampleColumnSignCheckBox;
    private JCheckBox showSampleColumnHitPCheckBox;
    private JCheckBox showSampleColumnHitTCheckBox;
    private JCheckBox showSampleColumnStackPCheckBox;
    private JCheckBox showSampleColumnStackTCheckBox;
    private JCheckBox showMemColumnClassCheckBox;
    private JCheckBox showMemColumnCountCheckBox;
    private JCheckBox showMemColumnLocCheckBox;
    private JCheckBox showMemColumnSizeCheckBox;
    private JCheckBox showMemColumnNbAllocCheckBox;
    private JCheckBox showMemColumnAllocCheckBox;
    private JCheckBox showMemColumnNbFreedCheckBox;
    private JCheckBox showMemColumnFreedCheckBox;
    private JCheckBox showMemColumnNbDiffCheckBox;
    private JCheckBox showMemColumnDiffCheckBox;

    public ProfilerSettingsPanel() {
        HelpSystem.getHelpSystem().registerTopic((JComponent)((Object)this), "f1_prf_preferences_html");
        JPanel eventColumnsPanel = this.makeEventColumnsPanel();
        JPanel sampleColumnsPanel = this.makeSampleColumnsPanel();
        JPanel memColumnsPanel = this.makeMemColumnsPanel();
        this.setLayout(new GridBagLayout());
        int y = 0;
        this.add(eventColumnsPanel, new GridBagConstraints(0, y++, 0, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 3, 0), 0, 0));
        this.add(sampleColumnsPanel, new GridBagConstraints(0, y++, 0, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 3, 0), 0, 0));
        this.add(memColumnsPanel, new GridBagConstraints(0, y++, 0, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 3, 0), 0, 0));
        this.add(new JLabel(), new GridBagConstraints(0, y, 0, 1, 1.0, 1.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
    }

    public void onEntry(TraversableContext tc) {
        ProfilerSettings profilerSettings = (ProfilerSettings)((Object)tc.find("ProfilerSettings"));
        this.loadFrom(profilerSettings);
    }

    public void onExit(TraversableContext tc) throws TraversalException {
        ProfilerSettings profilerSettings = (ProfilerSettings)((Object)tc.find("ProfilerSettings"));
        this.commitTo(profilerSettings);
    }

    private void loadFrom(ProfilerSettings profilerSettings) {
        boolean[] eventColumnVisible = profilerSettings.getEventColumnVisible();
        this.showEventColumnEventCheckBox.setSelected(eventColumnVisible[0]);
        this.showEventColumnMessCheckBox.setSelected(eventColumnVisible[1]);
        this.showEventColumnLocCheckBox.setSelected(eventColumnVisible[2]);
        this.showEventColumnStartCheckBox.setSelected(eventColumnVisible[3]);
        this.showEventColumnEndCheckBox.setSelected(eventColumnVisible[4]);
        this.showEventColumnDurCheckBox.setSelected(eventColumnVisible[5]);
        boolean[] sampleColumnVisible = profilerSettings.getSampleColumnVisible();
        this.showSampleColumnClassCheckBox.setSelected(sampleColumnVisible[0]);
        this.showSampleColumnMethodCheckBox.setSelected(sampleColumnVisible[1]);
        this.showSampleColumnSignCheckBox.setSelected(sampleColumnVisible[2]);
        this.showSampleColumnHitPCheckBox.setSelected(sampleColumnVisible[3]);
        this.showSampleColumnHitTCheckBox.setSelected(sampleColumnVisible[4]);
        this.showSampleColumnStackPCheckBox.setSelected(sampleColumnVisible[5]);
        this.showSampleColumnStackTCheckBox.setSelected(sampleColumnVisible[6]);
        boolean[] memColumnVisible = profilerSettings.getMemColumnVisible();
        this.showMemColumnClassCheckBox.setSelected(memColumnVisible[0]);
        this.showMemColumnLocCheckBox.setSelected(memColumnVisible[1]);
        this.showMemColumnCountCheckBox.setSelected(memColumnVisible[2]);
        this.showMemColumnSizeCheckBox.setSelected(memColumnVisible[3]);
        this.showMemColumnNbAllocCheckBox.setSelected(memColumnVisible[4]);
        this.showMemColumnAllocCheckBox.setSelected(memColumnVisible[5]);
        this.showMemColumnNbFreedCheckBox.setSelected(memColumnVisible[6]);
        this.showMemColumnFreedCheckBox.setSelected(memColumnVisible[7]);
        this.showMemColumnNbDiffCheckBox.setSelected(memColumnVisible[8]);
        this.showMemColumnDiffCheckBox.setSelected(memColumnVisible[9]);
    }

    private void commitTo(ProfilerSettings profilerSettings) throws TraversalException {
        boolean[] eventColumnVisible = profilerSettings.getEventColumnVisible();
        eventColumnVisible[0] = this.showEventColumnEventCheckBox.isSelected();
        eventColumnVisible[1] = this.showEventColumnMessCheckBox.isSelected();
        eventColumnVisible[2] = this.showEventColumnLocCheckBox.isSelected();
        eventColumnVisible[3] = this.showEventColumnStartCheckBox.isSelected();
        eventColumnVisible[4] = this.showEventColumnEndCheckBox.isSelected();
        eventColumnVisible[5] = this.showEventColumnDurCheckBox.isSelected();
        boolean[] sampleColumnVisible = profilerSettings.getSampleColumnVisible();
        sampleColumnVisible[0] = this.showSampleColumnClassCheckBox.isSelected();
        sampleColumnVisible[1] = this.showSampleColumnMethodCheckBox.isSelected();
        sampleColumnVisible[2] = this.showSampleColumnSignCheckBox.isSelected();
        sampleColumnVisible[3] = this.showSampleColumnHitPCheckBox.isSelected();
        sampleColumnVisible[4] = this.showSampleColumnHitTCheckBox.isSelected();
        sampleColumnVisible[5] = this.showSampleColumnStackPCheckBox.isSelected();
        sampleColumnVisible[6] = this.showSampleColumnStackTCheckBox.isSelected();
        boolean[] memColumnVisible = profilerSettings.getMemColumnVisible();
        memColumnVisible[0] = this.showMemColumnClassCheckBox.isSelected();
        memColumnVisible[1] = this.showMemColumnLocCheckBox.isSelected();
        memColumnVisible[2] = this.showMemColumnCountCheckBox.isSelected();
        memColumnVisible[3] = this.showMemColumnSizeCheckBox.isSelected();
        memColumnVisible[4] = this.showMemColumnNbAllocCheckBox.isSelected();
        memColumnVisible[5] = this.showMemColumnAllocCheckBox.isSelected();
        memColumnVisible[6] = this.showMemColumnNbFreedCheckBox.isSelected();
        memColumnVisible[7] = this.showMemColumnFreedCheckBox.isSelected();
        memColumnVisible[8] = this.showMemColumnNbDiffCheckBox.isSelected();
        memColumnVisible[9] = this.showMemColumnDiffCheckBox.isSelected();
    }

    private JPanel makeEventColumnsPanel() {
        this.showEventColumnEventCheckBox = new JCheckBox();
        this.showEventColumnMessCheckBox = new JCheckBox();
        this.showEventColumnLocCheckBox = new JCheckBox();
        this.showEventColumnStartCheckBox = new JCheckBox();
        this.showEventColumnEndCheckBox = new JCheckBox();
        this.showEventColumnDurCheckBox = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.showEventColumnEventCheckBox, (String)ProfArb.getString(199));
        ResourceUtils.resButton((AbstractButton)this.showEventColumnMessCheckBox, (String)ProfArb.getString(204));
        ResourceUtils.resButton((AbstractButton)this.showEventColumnLocCheckBox, (String)ProfArb.getString(300));
        ResourceUtils.resButton((AbstractButton)this.showEventColumnStartCheckBox, (String)ProfArb.getString(241));
        ResourceUtils.resButton((AbstractButton)this.showEventColumnEndCheckBox, (String)ProfArb.getString(261));
        ResourceUtils.resButton((AbstractButton)this.showEventColumnDurCheckBox, (String)ProfArb.getString(52));
        JPanel panel = new JPanel(new GridLayout(2, 3, 2, 2));
        panel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(ProfArb.getString(151)), BorderFactory.createEmptyBorder(0, 8, 8, 8)));
        panel.add(this.showEventColumnEventCheckBox);
        panel.add(this.showEventColumnMessCheckBox);
        panel.add(this.showEventColumnLocCheckBox);
        panel.add(this.showEventColumnStartCheckBox);
        panel.add(this.showEventColumnEndCheckBox);
        panel.add(this.showEventColumnDurCheckBox);
        return panel;
    }

    private JPanel makeSampleColumnsPanel() {
        this.showSampleColumnClassCheckBox = new JCheckBox();
        this.showSampleColumnMethodCheckBox = new JCheckBox();
        this.showSampleColumnSignCheckBox = new JCheckBox();
        this.showSampleColumnHitPCheckBox = new JCheckBox();
        this.showSampleColumnHitTCheckBox = new JCheckBox();
        this.showSampleColumnStackPCheckBox = new JCheckBox();
        this.showSampleColumnStackTCheckBox = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.showSampleColumnClassCheckBox, (String)ProfArb.getString(256));
        ResourceUtils.resButton((AbstractButton)this.showSampleColumnMethodCheckBox, (String)ProfArb.getString(119));
        ResourceUtils.resButton((AbstractButton)this.showSampleColumnSignCheckBox, (String)ProfArb.getString(278));
        ResourceUtils.resButton((AbstractButton)this.showSampleColumnHitPCheckBox, (String)ProfArb.getString(218));
        ResourceUtils.resButton((AbstractButton)this.showSampleColumnHitTCheckBox, (String)ProfArb.getString(66));
        ResourceUtils.resButton((AbstractButton)this.showSampleColumnStackPCheckBox, (String)ProfArb.getString(302));
        ResourceUtils.resButton((AbstractButton)this.showSampleColumnStackTCheckBox, (String)ProfArb.getString(163));
        JPanel panel = new JPanel(new GridLayout(3, 3, 2, 2));
        panel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(ProfArb.getString(106)), BorderFactory.createEmptyBorder(0, 8, 8, 8)));
        panel.add(this.showSampleColumnClassCheckBox);
        panel.add(this.showSampleColumnMethodCheckBox);
        panel.add(this.showSampleColumnSignCheckBox);
        panel.add(this.showSampleColumnHitPCheckBox);
        panel.add(this.showSampleColumnHitTCheckBox);
        panel.add(this.showSampleColumnStackPCheckBox);
        panel.add(this.showSampleColumnStackTCheckBox);
        return panel;
    }

    private JPanel makeMemColumnsPanel() {
        this.showMemColumnClassCheckBox = new JCheckBox();
        this.showMemColumnCountCheckBox = new JCheckBox();
        this.showMemColumnLocCheckBox = new JCheckBox();
        this.showMemColumnSizeCheckBox = new JCheckBox();
        this.showMemColumnNbAllocCheckBox = new JCheckBox();
        this.showMemColumnAllocCheckBox = new JCheckBox();
        this.showMemColumnNbFreedCheckBox = new JCheckBox();
        this.showMemColumnFreedCheckBox = new JCheckBox();
        this.showMemColumnNbDiffCheckBox = new JCheckBox();
        this.showMemColumnDiffCheckBox = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.showMemColumnClassCheckBox, (String)ProfArb.getString(244));
        ResourceUtils.resButton((AbstractButton)this.showMemColumnCountCheckBox, (String)ProfArb.getString(221));
        ResourceUtils.resButton((AbstractButton)this.showMemColumnLocCheckBox, (String)ProfArb.getString(108));
        ResourceUtils.resButton((AbstractButton)this.showMemColumnSizeCheckBox, (String)ProfArb.getString(307));
        ResourceUtils.resButton((AbstractButton)this.showMemColumnNbAllocCheckBox, (String)ProfArb.getString(140));
        ResourceUtils.resButton((AbstractButton)this.showMemColumnAllocCheckBox, (String)ProfArb.getString(85));
        ResourceUtils.resButton((AbstractButton)this.showMemColumnNbFreedCheckBox, (String)ProfArb.getString(162));
        ResourceUtils.resButton((AbstractButton)this.showMemColumnFreedCheckBox, (String)ProfArb.getString(325));
        ResourceUtils.resButton((AbstractButton)this.showMemColumnNbDiffCheckBox, (String)ProfArb.getString(141));
        ResourceUtils.resButton((AbstractButton)this.showMemColumnDiffCheckBox, (String)ProfArb.getString(36));
        JPanel panel = new JPanel(new GridLayout(4, 3, 2, 2));
        panel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(ProfArb.getString(185)), BorderFactory.createEmptyBorder(0, 8, 8, 8)));
        panel.add(this.showMemColumnClassCheckBox);
        panel.add(this.showMemColumnLocCheckBox);
        panel.add(this.showMemColumnCountCheckBox);
        panel.add(this.showMemColumnSizeCheckBox);
        panel.add(this.showMemColumnNbAllocCheckBox);
        panel.add(this.showMemColumnAllocCheckBox);
        panel.add(this.showMemColumnNbFreedCheckBox);
        panel.add(this.showMemColumnFreedCheckBox);
        panel.add(this.showMemColumnNbDiffCheckBox);
        panel.add(this.showMemColumnDiffCheckBox);
        return panel;
    }
}

