/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.profile;

import java.awt.Frame;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import oracle.ide.Ide;
import oracle.ide.docking.DockStation;
import oracle.ide.docking.Dockable;
import oracle.ide.docking.DockingParam;
import oracle.ide.model.Node;
import oracle.ide.util.IdeUtil;
import oracle.ide.util.IntHashMap;
import oracle.javatools.data.PropertyStorage;
import oracle.jdeveloper.library.JDK;
import oracle.jdeveloper.profiler.ProfilerAPI;
import oracle.jdeveloper.runner.JRunProcess;
import oracle.jdeveloper.runner.JStarterFactory;
import oracle.jdeveloper.runner.RemoteConnectDialog;
import oracle.jdevimpl.runner.Helpers;
import oracle.jdevimpl.runner.profile.BasicEvent;
import oracle.jdevimpl.runner.profile.CallCountItem;
import oracle.jdevimpl.runner.profile.EventTable;
import oracle.jdevimpl.runner.profile.FileSaver;
import oracle.jdevimpl.runner.profile.HTMLSaver;
import oracle.jdevimpl.runner.profile.HeapDetailStat;
import oracle.jdevimpl.runner.profile.HeapStat;
import oracle.jdevimpl.runner.profile.JProfiler;
import oracle.jdevimpl.runner.profile.MemoryDetailTable;
import oracle.jdevimpl.runner.profile.MemoryMonitor;
import oracle.jdevimpl.runner.profile.MemoryTable;
import oracle.jdevimpl.runner.profile.MethodCallCountItem;
import oracle.jdevimpl.runner.profile.ProfArb;
import oracle.jdevimpl.runner.profile.ProfDockWindowStub;
import oracle.jdevimpl.runner.profile.ProfWindow;
import oracle.jdevimpl.runner.profile.ProfileConfiguration;
import oracle.jdevimpl.runner.profile.ProfileEvent;
import oracle.jdevimpl.runner.profile.ProfilerMessage;
import oracle.jdevimpl.runner.profile.ProfilerMessageReader;
import oracle.jdevimpl.runner.profile.RootCallCountItem;
import oracle.jdevimpl.runner.profile.SampleTable;
import oracle.jdevimpl.runner.profile.SubCallCount;
import oracle.jdevimpl.runner.profile.ThreadCallCountItem;
import oracle.jdevimpl.runner.profile.VMClass;
import oracle.jdevimpl.runner.profile.VMMethod;
import oracle.jdevimpl.runner.profile.VMThread;
import oracle.jdevimpl.runner.profile.VMTypes;

final class ProfilingProcess
extends JRunProcess {
    static final String PROFILES_MEMORY_TABLE_ID = "Profiler.MemoryTable";
    private JProfiler jprofiler;
    private boolean expectMethodCallTracking;
    private ProfDockWindowStub winStub;
    private IntHashMap methodMap;
    private IntHashMap classMap;
    private IntHashMap threadMap;
    private int runNumber;
    private int localport;
    private String host;
    private String runTitle;
    private String tabName;
    private ProfilerMessageReader messageReader;
    private VMMethod lastMethod;
    private SampleTable sampleTable;
    private MemoryMonitor memoryMonitor;
    private MemoryTable memoryTable;
    private EventTable eventTable;
    private Map memoryDetailMap;
    private boolean processIsActive;
    private int sliderDepth;
    private int _profType;
    private ProfWindow lastWindow;
    private static final boolean DEBUG = false;
    private static final int PRF_FIRST_EVENT_ID = 1200;
    private static final int PRF_RECEIVE_ID = 1200;
    private static final int PRF_SEND_ID = 1201;
    private static final boolean PRF_RECEIVE_ON = ProfilerAPI.isActive && ProfilerAPI.isEventActive((int)1200);
    private static final boolean PRF_SEND_ON = ProfilerAPI.isActive && ProfilerAPI.isEventActive((int)1201);
    private static final int PROFMSG_ACK_PROCESS_END = 1;
    private static final int PROFMSG_PERFORM_GC = 2;
    private static final int PROFMSG_DUMP_GC = 3;
    private static final int PROFMSG_TERMINATE = 4;
    private static final int PROFMSG_RUN = 5;
    private static final int PROFMSG_PAUSE = 7;
    private static final int PROFMSG_ASK_ALLOC_DETAIL = 8;
    private static final int PROFMSG_STOP_ALLOC_DETAIL = 9;
    private static final int PROFMSG_CLEAR_SAMPLES = 10;
    private static final int PROFMSG_SEND_OPTIONS = 11;
    private static final int PROFMSG_PROCESS_START = 0;
    private static final int PROFMSG_CLASS_LOAD = 1;
    private static final int PROFMSG_CLASS_DATA = 2;
    private static final int PROFMSG_METHOD_DATA = 3;
    private static final int PROFMSG_METHOD_START = 4;
    private static final int PROFMSG_METHOD_END = 5;
    private static final int PROFMSG_METHOD_ENTER = 6;
    private static final int PROFMSG_METHOD_EXIT = 7;
    private static final int PROFMSG_METHOD_RETURNVALUE = 8;
    private static final int PROFMSG_THREAD_START = 9;
    private static final int PROFMSG_THREAD_END = 10;
    private static final int PROFMSG_PROCESS_END = 11;
    private static final int PROFMSG_TIME_DUMP_START = 12;
    private static final int PROFMSG_GC_INIT = 13;
    private static final int PROFMSG_GC_UPDATE = 14;
    private static final int PROFMSG_GC_START = 15;
    private static final int PROFMSG_GC_END = 16;
    private static final int PROFMSG_GC_ALLOC = 17;
    private static final int PROFMSG_GC_OBJ_ALLOC = 18;
    private static final int PROFMSG_GC_OBJ_DUMP_START = 19;
    private static final int PROFMSG_GC_OBJ_DUMP_END = 20;
    private static final int PROFMSG_PARAM_LIST_START = 21;
    private static final int PROFMSG_CALLCOUNT_SAMPLE_DUMP_START = 22;
    private static final int PROFMSG_METHOD_LINES_DUMP_START = 23;
    private static final int PROFMSG_GC_SNAPSHOT_START = 24;
    private static final int PROFMSG_GC_SNAPSHOT_END = 25;
    private static final int PROFMSG_STACKDUMP_START = 26;
    private static final int PROFMSG_STACKDUMP_END = 27;
    private static final int PROFMSG_METHOD_MEMORY_DUMP_START = 28;
    private static final int PROFMSG_SEND_ALLOCATION_DIFF = 29;
    private static final int PROFMSG_SEND_ALLOCATION_DETAIL_DIFF = 30;
    private static final int PROFMSG_SEND_ALLOCATION_DIFF_P = 31;
    private static final int PROFMSG_SEND_ALLOCATION_DETAIL_DIFF_P = 32;
    private static final int PROFMSG_START_ALLOC_DUMP = 33;
    private static final int PROFMSG_END_ALLOC_DUMP = 34;
    private static final int PROFMSG_DUMP_EVENTS = 35;

    private void $init$() {
        this.host = "";
    }

    ProfilingProcess(JProfiler jprofiler, int profType, int runNumber) {
        this(jprofiler, profType, runNumber, null, null);
    }

    ProfilingProcess(JProfiler jprofiler, int profType, int runNumber, ProfWindow win, Map detMap) {
        this.$init$();
        this.lastWindow = win;
        this.jprofiler = jprofiler;
        this._profType = profType;
        this.runNumber = runNumber;
        this.expectMethodCallTracking = false;
        if (profType == 10) {
            return;
        }
        this.methodMap = new IntHashMap(10000);
        this.classMap = new IntHashMap(1000);
        this.threadMap = new IntHashMap(25);
        if (profType == 2) {
            this.memoryDetailMap = detMap == null ? new HashMap(5) : detMap;
        }
        VMClass clazz = new VMClass();
        clazz.classDescriptor = 0;
        clazz.packageName = "";
        clazz.name = ProfArb.getString(208);
        clazz.fileName = "";
        clazz.methodCount = 0;
        Object methodArray = null;
        clazz.methodArray = null;
        this.classMap.put(0, (Object)clazz);
        ProfileConfiguration pc = this.getConfiguration();
        this.sliderDepth = pc.getSliderDepth();
    }

    ProfileConfiguration getConfiguration() {
        return ProfileConfiguration.getInstance((PropertyStorage)this.getJProject());
    }

    void saveMapToFile(IntHashMap map, DataOutputStream stream) throws IOException {
        int size = map.size();
        stream.writeInt(size);
        for (VMTypes m : map) {
            m.saveToFile(stream);
        }
    }

    void saveMapsToFile(DataOutputStream stream) throws IOException {
        this.saveMapToFile(this.threadMap, stream);
        this.saveMapToFile(this.classMap, stream);
        this.saveMapToFile(this.methodMap, stream);
    }

    void readMapsFromFile(DataInputStream stream) throws IOException {
        int sz = stream.readInt();
        this.threadMap = new IntHashMap(sz);
        int i = 0;
        while (i < sz) {
            VMThread t = VMThread.readFromFile(stream);
            this.threadMap.put(t.threadDescriptor, (Object)t);
            ++i;
        }
        sz = stream.readInt();
        this.classMap = new IntHashMap(sz);
        i = 0;
        while (i < sz) {
            VMClass t = VMClass.readFromFile(stream);
            this.classMap.put(t.classDescriptor, (Object)t);
            ++i;
        }
        sz = stream.readInt();
        this.methodMap = new IntHashMap(sz);
        i = 0;
        while (i < sz) {
            VMMethod t = VMMethod.readFromFile(stream, this.classMap);
            this.methodMap.put(t.methodDescriptor, (Object)t);
            ++i;
        }
    }

    void readSampleArrayFromFile(DataInputStream stream) throws IOException {
        int totalCalls = stream.readInt();
        int sz = stream.readInt();
        IntHashMap mainMap = new IntHashMap(sz * 2);
        ArrayList<CallCountItem> v = new ArrayList<CallCountItem>(sz);
        int i = 0;
        while (i < sz) {
            CallCountItem m = CallCountItem.readFromFile(stream, this.methodMap);
            mainMap.put(m.ref, (Object)m);
            v.add(m);
            ++i;
        }
        i = 0;
        while (i < v.size()) {
            CallCountItem cit = (CallCountItem)v.get(i);
            ArrayList called = cit.getCalledList();
            cit.calledTotal = cit.getCallCount();
            int j = 0;
            while (j < called.size()) {
                SubCallCount sbc = (SubCallCount)called.get(j);
                cit.calledTotal += sbc.count;
                CallCountItem cci = (CallCountItem)mainMap.get(((Integer)sbc.ref).intValue());
                SubCallCount sc = new SubCallCount(sbc.count, cit);
                cci.callerTotal += sbc.count;
                cci.getCallerList().add(sc);
                sbc.ref = cci;
                ++j;
            }
            ++i;
        }
        SampleTable table = this.getSampleTable();
        table.setData(totalCalls, v);
        table.notifyProcessEnd();
    }

    void readEventsArrayFromFile(DataInputStream stream) throws IOException {
        ProfileConfiguration pc = this.getConfiguration();
        int sz = stream.readInt();
        int i = 0;
        while (i < sz) {
            BasicEvent ev = BasicEvent.readFromFile(stream);
            pc.eventFromId(ev._id, ev);
            ++i;
        }
        sz = stream.readInt();
        ProfileEvent[] array = new ProfileEvent[sz];
        int i2 = 0;
        while (i2 < sz) {
            int id = stream.readInt();
            int mid = stream.readInt();
            String com = stream.readUTF();
            int line = stream.readInt();
            int start = stream.readInt();
            int end = stream.readInt();
            array[i2] = new ProfileEvent(pc.eventFromId(id), start, end, (VMMethod)this.methodMap.get(mid), line, com);
            ++i2;
        }
        EventTable et = this.getEventTable();
        et.setData(array);
        et.notifyProcessEnd();
    }

    void readMemorySessionFromFile(DataInputStream stream) throws IOException {
        int nbSamples;
        int totalSample = stream.readInt();
        this.sliderDepth = nbSamples = stream.readInt();
        this.memoryDetailMap = new HashMap(5);
        MemoryTable mt = this.getMemoryTable();
        mt.setCurrentSize(nbSamples - 1);
        mt.setTotalSample(totalSample);
        int n = nbSamples;
        while (--n >= 0) {
            HeapDetailStat total = HeapDetailStat.readFromFile(stream, this.methodMap);
            int tsize = stream.readInt();
            HeapStat[] table = new HeapStat[tsize];
            int i = 0;
            while (i < tsize) {
                table[i] = HeapStat.readFromFile(stream, this.classMap);
                ++i;
            }
            mt.setDataAtPosition(n, total, table);
            int nbdet = stream.readInt();
            while (--nbdet >= 0) {
                int cindex = stream.readInt();
                VMClass clazz = (VMClass)this.classMap.get(cindex);
                MemoryDetailTable mdt = this.getMemoryDetailTable(clazz, false);
                mdt.setCurrentSize(nbSamples - 1);
                tsize = stream.readInt();
                HeapDetailStat[] dets = new HeapDetailStat[tsize];
                i = 0;
                while (i < tsize) {
                    dets[i] = HeapDetailStat.readFromFile(stream, this.methodMap);
                    ++i;
                }
                mdt.setDataAtPosition(n, dets);
            }
        }
        mt.notifyProcessEnd();
        mt.finishedLoading();
    }

    int getSliderDepth() {
        return this.sliderDepth;
    }

    public boolean canRun(String runType, Object cookie, Node node, List errors) {
        if ("Java".equals(runType)) {
            return this.canRunJava(node, errors);
        }
        if ("Database".equals(runType)) {
            errors.add(ProfArb.format(81, node.getShortLabel()));
            return false;
        }
        if ("XSLT".equals(runType)) {
            errors.add(ProfArb.format(48, node.getShortLabel()));
            return false;
        }
        if ("XQuery".equals(runType)) {
            errors.add(ProfArb.format(248, node.getShortLabel()));
            return false;
        }
        return false;
    }

    private boolean canRunJava(Node node, List errors) {
        if (!this.runConfiguration.isRemoteDebuggingProfiling()) {
            JDK jdkDefinition = this.getJdkDefinition();
            if (this.runConfiguration.usingOJVM(jdkDefinition)) {
                return true;
            }
            errors.add(ProfArb.format(51, node.getShortLabel()));
            return false;
        }
        return true;
    }

    public Object getValue(String runType, Object cookie, String key) {
        if ("Java".equals(runType) && "FirstJavaCommandOptions".equals(key)) {
            return this.getFirstJavaCommandOptions();
        }
        if ("Database".equals(runType)) {
            // empty if block
        }
        if ("XSLT".equals(runType)) {
            // empty if block
        }
        return null;
    }

    private String[] getFirstJavaCommandOptions() {
        String options = "-XXtimeport" + this.localport;
        return IdeUtil.convertStringToStringArray((String)options);
    }

    public String getExtraOptions() {
        String options = null;
        ProfileConfiguration pc = this.getConfiguration();
        switch (this._profType) {
            case 0: {
                options = new String("execution,");
                options = options + "sample" + pc.getSampleInterval();
                break;
            }
            case 1: {
                options = new String("events,useapi");
                options = options + ",evex(" + pc.exclEventList() + ")";
                options = options + ",dmsid( " + pc.buildDMSEvList() + ")";
                break;
            }
            case 2: {
                options = new String("monitormemory,");
                options = options + "update" + pc.getMemoryUpdateInterval();
                options = options + ",excli(" + pc.getExcludedInstances() + ")";
                options = options + ",incli(" + pc.getIncludedInstances() + ")";
                if (this.memoryDetailMap.size() == 0) break;
                options = options + ",memdet(";
                Iterator it = this.getMemoryDetailTableIterator();
                while (it.hasNext()) {
                    MemoryDetailTable mdt = (MemoryDetailTable)it.next();
                    options = options + mdt.getClazz().getInternalName() + ';';
                }
                options = options + ')';
                break;
            }
        }
        if (pc.isUseAPI()) {
            options = options + ",useapi";
        }
        options = options + ",excl(" + pc.getExcludedClasses() + ")";
        options = options + ",incl(" + pc.getIncludedClasses() + ")";
        return options;
    }

    public String getTabName() {
        return this.tabName;
    }

    public String getProcessLabelPrefix() {
        return ProfArb.getString(173);
    }

    public Icon getIcon() {
        switch (this._profType) {
            case 0: {
                return ProfArb.getIcon(260);
            }
            case 1: {
                return ProfArb.getIcon(312);
            }
            case 2: {
                return ProfArb.getIcon(65);
            }
        }
        return null;
    }

    private void superTerminate() {
        super.terminate();
    }

    protected Class getStarterFactorySubClass() {
        return JStarterFactory.class;
    }

    protected void determineTargetAndStarter(Class starterFactorySubClass) {
        if (this._profType != 10 && !this.runConfiguration.isRemoteDebuggingProfiling()) {
            super.determineTargetAndStarter(starterFactorySubClass);
        }
    }

    protected boolean compile() {
        if (this._profType == 10 || this.runConfiguration.isRemoteDebuggingProfiling()) {
            return true;
        }
        return super.compile();
    }

    protected boolean startTarget() {
        ProfileConfiguration pc = this.getConfiguration();
        if (this._profType == 10) {
            URL url = FileSaver.chooseFileName(this.getContext());
            if (url != null) {
                this.runTitle = new File(url.getFile()).getName();
                DataInputStream resStream = FileSaver.selectResultStream(url);
                if (resStream != null) {
                    this.readDataFromStream(resStream);
                }
            }
            return false;
        }
        if (this.runConfiguration.isRemoteDebuggingProfiling()) {
            this.host = pc.getRemoteHost();
            this.localport = pc.getRemotePort();
            if (pc.isPromptForRemoteProfiling()) {
                String[] names = new String[2];
                String[] values = new String[2];
                boolean[] allowBlanks = new boolean[2];
                boolean[] save = new boolean[1];
                names[0] = ProfArb.getString(270);
                values[0] = this.host;
                allowBlanks[0] = true;
                names[1] = ProfArb.getString(324);
                values[1] = Integer.toString(this.localport);
                allowBlanks[1] = false;
                boolean ok = RemoteConnectDialog.showRemoteConnectDialog(ProfArb.getString(168), names, values, allowBlanks, save, ProfArb.getString(207));
                if (!ok) {
                    return false;
                }
                this.host = values[0];
                try {
                    this.localport = Integer.parseInt(values[1]);
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (save[0] || this.runConfiguration.isCustom()) {
                    pc.setRemoteHost(values[0]);
                    pc.setRemotePort(this.localport);
                }
                if (save[0]) {
                    pc.setPromptForRemoteProfiling(false);
                }
            }
        } else {
            this.host = "";
            this.localport = Helpers.getLocalPort();
            if (!super.startTarget()) {
                return false;
            }
        }
        this.runTitle = ProfArb.format(306, Integer.toString(this.runNumber), this.getShortLabel());
        this.tabName = "#" + this.runNumber + " " + this.getShortLabel();
        1 t = new 1();
        t.start();
        if (this.runConfiguration.isRemoteDebuggingProfiling()) {
            super.started();
        }
        return true;
    }

    public boolean canTerminate() {
        return true;
    }

    public void terminate() {
        if (this.starter != null && this.starter.canTerminateGracefully()) {
            this.starter.terminateGracefully();
            return;
        }
        this.terminateProcess();
    }

    private MemoryTable getMemoryTable() {
        if (this.memoryTable == null) {
            if (this.lastWindow == null) {
                this.memoryTable = new MemoryTable(this, this.classMap);
                this.winStub = this.jprofiler.dockFactory.getMemoryWindow(this.memoryTable);
                this.setDockableVisible(this.winStub.getId(), true);
                this.memoryTable.setStub(this.winStub);
            } else {
                Iterator it = this.getMemoryDetailTableIterator();
                while (it.hasNext()) {
                    MemoryDetailTable mdt = (MemoryDetailTable)it.next();
                    mdt.resetProcess(this, this.methodMap);
                }
                this.memoryTable = (MemoryTable)this.lastWindow;
                this.memoryTable.resetProcess(this, this.classMap);
                this.winStub = this.memoryTable.getStub();
            }
            this.lastWindow = this.memoryTable;
        }
        return this.memoryTable;
    }

    private EventTable getEventTable() {
        if (this.eventTable == null) {
            if (this.lastWindow == null) {
                this.eventTable = new EventTable(this);
                this.winStub = this.jprofiler.dockFactory.getEventWindow(this.eventTable);
                this.setDockableVisible(this.winStub.getId(), true);
                this.eventTable.setStub(this.winStub);
            } else {
                this.eventTable = (EventTable)this.lastWindow;
                this.eventTable.resetProcess(this);
            }
            this.lastWindow = this.eventTable;
        }
        return this.eventTable;
    }

    private SampleTable getSampleTable() {
        if (this.sampleTable == null) {
            if (this.lastWindow == null) {
                this.sampleTable = new SampleTable(this);
                this.winStub = this.jprofiler.dockFactory.getSampleWindow(this.sampleTable);
                this.setDockableVisible(this.winStub.getId(), true);
                this.sampleTable.setStub(this.winStub);
            } else {
                this.sampleTable = (SampleTable)this.lastWindow;
                this.sampleTable.resetProcess(this);
            }
            this.lastWindow = this.sampleTable;
        }
        return this.sampleTable;
    }

    private synchronized MemoryDetailTable getMemoryDetailTable(VMClass clazz, boolean ispulse) {
        MemoryDetailTable memoryDetailTable = (MemoryDetailTable)this.memoryDetailMap.get(clazz.toString());
        if (memoryDetailTable == null && !ispulse) {
            memoryDetailTable = new MemoryDetailTable(this, clazz, this.methodMap);
            this.memoryDetailMap.put(clazz.toString(), memoryDetailTable);
            ProfDockWindowStub wstub = this.jprofiler.dockFactory.getMemoryDetailWindow(memoryDetailTable);
            memoryDetailTable.setStub(wstub);
            DockingParam dockingParam = new DockingParam();
            dockingParam.setPosition((Dockable)this.winStub, 3);
            SwingUtilities.invokeLater(new 2(this, wstub, dockingParam));
        }
        memoryDetailTable.setClazz(clazz);
        return memoryDetailTable;
    }

    synchronized Iterator getMemoryDetailTableIterator() {
        return this.memoryDetailMap.values().iterator();
    }

    boolean isProcessActive() {
        return this.processIsActive;
    }

    boolean askMethodDetails(HeapStat hs) {
        try {
            if (this.processIsActive) {
                if (PRF_SEND_ON) {
                    ProfilerAPI.pulseEvent((int)1201, (String)("PROFMSG_ASK_ALLOC_DETAIL " + hs.getClassDesc()));
                }
                this.messageReader.sendMessageInt(8, hs.getClassDesc());
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            boolean bl = false;
            return bl;
        }
    }

    boolean stopMethodDetails(VMClass clazz) {
        try {
            Object o = this.memoryDetailMap.remove(clazz.toString());
            if (o != null && this.processIsActive) {
                if (PRF_SEND_ON) {
                    ProfilerAPI.pulseEvent((int)1201, (String)("PROFMSG_STOP_ALLOC_DETAIL " + clazz.getInternalName()));
                }
                this.messageReader.sendMessageString(9, clazz.getInternalName());
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            boolean bl = false;
            return bl;
        }
    }

    void stopAllMethodDetails() {
        boolean redo;
        do {
            redo = false;
            try {
                Iterator it = this.getMemoryDetailTableIterator();
                while (it.hasNext()) {
                    MemoryDetailTable mdt = (MemoryDetailTable)it.next();
                    DockStation.getDockStation().undock((Dockable)mdt.getStub());
                }
            }
            catch (ConcurrentModificationException e) {
                redo = true;
            }
            catch (Exception e) {
                // empty catch block
            }
        } while (redo);
        this.terminateProcess();
    }

    void terminateProcess() {
        try {
            if (this.processIsActive) {
                if (PRF_SEND_ON) {
                    ProfilerAPI.pulseEvent((int)1201, (String)"PROFMSG_TERMINATE ");
                }
                this.messageReader.sendMessage(4);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.processEnded();
    }

    boolean performGC() {
        try {
            if (this.processIsActive) {
                if (PRF_SEND_ON) {
                    ProfilerAPI.pulseEvent((int)1201, (String)"PROFMSG_PERFORM_GC ");
                }
                this.messageReader.sendMessage(2);
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            boolean bl = false;
            return bl;
        }
    }

    boolean performRunCommand() {
        try {
            if (this.processIsActive) {
                if (PRF_SEND_ON) {
                    ProfilerAPI.pulseEvent((int)1201, (String)"PROFMSG_RUN ");
                }
                this.messageReader.sendMessage(5);
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            boolean bl = false;
            return bl;
        }
    }

    boolean performPauseCommand() {
        try {
            if (this.processIsActive) {
                if (PRF_SEND_ON) {
                    ProfilerAPI.pulseEvent((int)1201, (String)"PROFMSG_PAUSE ");
                }
                this.messageReader.sendMessage(7);
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            boolean bl = false;
            return bl;
        }
    }

    boolean performSnapshotCommand() {
        try {
            if (this.processIsActive) {
                if (PRF_SEND_ON) {
                    ProfilerAPI.pulseEvent((int)1201, (String)"PROFMSG_PAUSE (Snapshot)");
                }
                this.messageReader.sendMessage(7);
                if (PRF_SEND_ON) {
                    ProfilerAPI.pulseEvent((int)1201, (String)"PROFMSG_RUN (Snapshot)");
                }
                this.messageReader.sendMessage(5);
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            boolean bl = false;
            return bl;
        }
    }

    boolean performRestartCommand() {
        try {
            if (this.processIsActive) {
                this.terminate();
            }
            this.jprofiler.reStartProcess(this._profType, this.lastWindow, this.memoryDetailMap);
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            boolean bl = false;
            return bl;
        }
    }

    boolean performTerminateCommand() {
        try {
            if (this.processIsActive) {
                this.terminate();
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            boolean bl = false;
            return bl;
        }
    }

    boolean performClearSampleCommand() {
        try {
            if (this.processIsActive) {
                if (PRF_SEND_ON) {
                    ProfilerAPI.pulseEvent((int)1201, (String)"PROFMSG_CLEAR_SAMPLES");
                }
                this.messageReader.sendMessage(10);
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            boolean bl = false;
            return bl;
        }
    }

    public boolean isPopupActive() {
        return this.jprofiler.isPopupActive();
    }

    private void processEnded() {
        this.processIsActive = false;
        if (this.memoryMonitor != null) {
            this.memoryMonitor.stop();
        }
        if (this.memoryTable != null) {
            this.memoryTable.notifyProcessEnd();
        }
        if (this.sampleTable != null) {
            this.sampleTable.notifyProcessEnd();
        }
        if (this.eventTable != null) {
            this.eventTable.notifyProcessEnd();
        }
        if (this.runConfiguration.isRemoteDebuggingProfiling()) {
            SwingUtilities.invokeLater(new 3());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void read() {
        while (this.messageReader.isConnected()) {
            try {
                block24: while (true) {
                    ProfilerMessage p;
                    ProfilingProcess profilingProcess = this;
                    synchronized (profilingProcess) {
                        p = this.messageReader.getMessage();
                    }
                    if (p != null) {
                        int evId = -1;
                        switch (p.getMessageId()) {
                            case 0: {
                                if (PRF_RECEIVE_ON) {
                                    evId = ProfilerAPI.startEvent((int)1200, (String)"PROFMSG_PROCESS_START");
                                }
                                this.ProcessStart(p);
                                if (!PRF_RECEIVE_ON) continue block24;
                                ProfilerAPI.endEvent((int)evId);
                                continue block24;
                            }
                            case 1: {
                                if (PRF_RECEIVE_ON) {
                                    evId = ProfilerAPI.startEvent((int)1200, (String)"PROFMSG_CLASS_LOAD");
                                }
                                this.LoadClass(p);
                                if (!PRF_RECEIVE_ON) continue block24;
                                ProfilerAPI.endEvent((int)evId);
                                continue block24;
                            }
                            case 2: {
                                if (PRF_RECEIVE_ON) {
                                    evId = ProfilerAPI.startEvent((int)1200, (String)"PROFMSG_CLASS_DATA");
                                }
                                this.ClassData(p);
                                if (!PRF_RECEIVE_ON) continue block24;
                                ProfilerAPI.endEvent((int)evId);
                                continue block24;
                            }
                            case 3: {
                                if (PRF_RECEIVE_ON) {
                                    evId = ProfilerAPI.startEvent((int)1200, (String)"PROFMSG_METHOD_DATA");
                                }
                                this.MethodData(p);
                                if (!PRF_RECEIVE_ON) continue block24;
                                ProfilerAPI.endEvent((int)evId);
                                continue block24;
                            }
                            case 9: {
                                if (PRF_RECEIVE_ON) {
                                    evId = ProfilerAPI.startEvent((int)1200, (String)"PROFMSG_THREAD_START");
                                }
                                this.ThreadStart(p);
                                if (!PRF_RECEIVE_ON) continue block24;
                                ProfilerAPI.endEvent((int)evId);
                                continue block24;
                            }
                            case 10: {
                                if (PRF_RECEIVE_ON) {
                                    evId = ProfilerAPI.startEvent((int)1200, (String)"PROFMSG_THREAD_END");
                                }
                                this.ThreadEnd(p);
                                if (!PRF_RECEIVE_ON) continue block24;
                                ProfilerAPI.endEvent((int)evId);
                                continue block24;
                            }
                            case 11: {
                                if (PRF_RECEIVE_ON) {
                                    evId = ProfilerAPI.startEvent((int)1200, (String)"PROFMSG_PROCESS_END");
                                }
                                this.processEnded();
                                this.messageReader.sendMessage(1);
                                this.messageReader.closeConnection();
                                if (PRF_RECEIVE_ON) {
                                    ProfilerAPI.endEvent((int)evId);
                                }
                                return;
                            }
                            case 22: {
                                if (PRF_RECEIVE_ON) {
                                    evId = ProfilerAPI.startEvent((int)1200, (String)"PROFMSG_CALLCOUNT_SAMPLE_DUMP_START");
                                }
                                this.CallCountSampleDump(p);
                                if (!PRF_RECEIVE_ON) continue block24;
                                ProfilerAPI.endEvent((int)evId);
                                continue block24;
                            }
                            case 23: {
                                if (PRF_RECEIVE_ON) {
                                    evId = ProfilerAPI.startEvent((int)1200, (String)"PROFMSG_METHOD_LINES_DUMP_START");
                                }
                                this.MethodLinesDump(p);
                                if (!PRF_RECEIVE_ON) continue block24;
                                ProfilerAPI.endEvent((int)evId);
                                continue block24;
                            }
                            case 29: {
                                if (PRF_RECEIVE_ON) {
                                    evId = ProfilerAPI.startEvent((int)1200, (String)"PROFMSG_SEND_ALLOCATION_DIFF");
                                }
                                this.getHeapDiff(p, false);
                                if (!PRF_RECEIVE_ON) continue block24;
                                ProfilerAPI.endEvent((int)evId);
                                continue block24;
                            }
                            case 30: {
                                if (PRF_RECEIVE_ON) {
                                    evId = ProfilerAPI.startEvent((int)1200, (String)"PROFMSG_SEND_ALLOCATION_DETAIL_DIFF");
                                }
                                this.getHeapDetailDiff(p, false);
                                if (!PRF_RECEIVE_ON) continue block24;
                                ProfilerAPI.endEvent((int)evId);
                                continue block24;
                            }
                            case 31: {
                                if (PRF_RECEIVE_ON) {
                                    evId = ProfilerAPI.startEvent((int)1200, (String)"PROFMSG_SEND_ALLOCATION_DIFF_P");
                                }
                                this.getHeapDiff(p, true);
                                if (!PRF_RECEIVE_ON) continue block24;
                                ProfilerAPI.endEvent((int)evId);
                                continue block24;
                            }
                            case 32: {
                                if (PRF_RECEIVE_ON) {
                                    evId = ProfilerAPI.startEvent((int)1200, (String)"PROFMSG_SEND_ALLOCATION_DETAIL_DIFF_P");
                                }
                                this.getHeapDetailDiff(p, true);
                                if (!PRF_RECEIVE_ON) continue block24;
                                ProfilerAPI.endEvent((int)evId);
                                continue block24;
                            }
                            case 33: {
                                if (PRF_RECEIVE_ON) {
                                    evId = ProfilerAPI.startEvent((int)1200, (String)"PROFMSG_START_ALLOC_DUMP");
                                }
                                this.startPulseDump();
                                if (!PRF_RECEIVE_ON) continue block24;
                                ProfilerAPI.endEvent((int)evId);
                                continue block24;
                            }
                            case 34: {
                                if (PRF_RECEIVE_ON) {
                                    evId = ProfilerAPI.startEvent((int)1200, (String)"PROFMSG_END_ALLOC_DUMP");
                                }
                                this.endPulseDump();
                                if (!PRF_RECEIVE_ON) continue block24;
                                ProfilerAPI.endEvent((int)evId);
                                continue block24;
                            }
                            case 35: {
                                if (PRF_RECEIVE_ON) {
                                    evId = ProfilerAPI.startEvent((int)1200, (String)"PROFMSG_DUMP_EVENTS");
                                }
                                this.getEventsArray(p);
                                if (!PRF_RECEIVE_ON) continue block24;
                                ProfilerAPI.endEvent((int)evId);
                                continue block24;
                            }
                        }
                        System.out.println("Invalid response: " + p.getMessageId());
                        continue;
                    }
                    Thread.sleep(10);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void ProcessStart(ProfilerMessage p) {
        this.messageReader.sendMessageString(11, this.getExtraOptions());
        this.processIsActive = true;
        if (this._profType == 2) {
            this.getMemoryTable();
        }
    }

    void showSettings() {
        String[] path = new String[]{ProfArb.getString(58)};
        Ide.getSettings().showDialog((Frame)Ide.getMainWindow(), path);
    }

    void saveMemSampleToHTML(boolean full) {
        MemoryTable mt = this.getMemoryTable();
        int index = full ? -1 : mt.getCurrentPos();
        HTMLSaver sv = new HTMLSaver(mt, this.memoryDetailMap.values().toArray(new MemoryDetailTable[0]), index);
        sv.SaveToFile(mt.getContext());
    }

    void setChildHistoryPos(int index) {
        Iterator it = this.getMemoryDetailTableIterator();
        while (it.hasNext()) {
            MemoryDetailTable mdt = (MemoryDetailTable)it.next();
            mdt.historySelect(index);
        }
    }

    void updateChildSettings() {
        Iterator it = this.getMemoryDetailTableIterator();
        while (it.hasNext()) {
            MemoryDetailTable mdt = (MemoryDetailTable)it.next();
            mdt.updateSettings();
        }
    }

    private void startPulseDump() {
        MemoryTable mt = this.getMemoryTable();
        mt.startUpdate();
        Iterator it = this.getMemoryDetailTableIterator();
        while (it.hasNext()) {
            MemoryDetailTable mdt = (MemoryDetailTable)it.next();
            mdt.startUpdate();
        }
    }

    private void endPulseDump() {
        Iterator it = this.getMemoryDetailTableIterator();
        while (it.hasNext()) {
            MemoryDetailTable mdt = (MemoryDetailTable)it.next();
            mdt.endUpdate();
        }
        MemoryTable mt = this.getMemoryTable();
        mt.endUpdate();
    }

    private void getEventsArray(ProfilerMessage p) throws Exception {
        ProfileConfiguration pc = this.getConfiguration();
        int count = p.getInt();
        ProfileEvent[] array = new ProfileEvent[count];
        while (--count >= 0) {
            int id = p.getInt();
            int start = p.getInt();
            int end = p.getInt();
            int method = p.getInt();
            int line = p.getInt();
            String com = p.getString();
            VMMethod m = (VMMethod)this.methodMap.get(method);
            array[count] = id != -99 ? new ProfileEvent(pc.eventFromId(id), start, end, m, line, com) : new ProfileEvent(pc.eventFromDMS(com), start, end, m, line, com);
        }
        EventTable et = this.getEventTable();
        et.setData(array);
    }

    private void getHeapDiff(ProfilerMessage p, boolean ispulse) throws Exception {
        MemoryTable mt = this.getMemoryTable();
        int count = p.getInt();
        if (!ispulse) {
            mt.startUpdate();
        }
        while (--count >= 0) {
            int cref = p.getInt();
            int nb = p.getInt();
            int sz = p.getInt();
            int nba = p.getInt();
            int sza = p.getInt();
            int nbf = p.getInt();
            int szf = p.getInt();
            mt.addOrUpdateHeapData(cref, nb, sz, nba, sza, nbf, szf);
        }
        if (!ispulse) {
            mt.endUpdate();
        }
    }

    private void getHeapDetailDiff(ProfilerMessage p, boolean ispulse) throws Exception {
        int cref = p.getInt();
        VMClass clazz = (VMClass)this.classMap.get(cref);
        MemoryDetailTable mt = this.getMemoryDetailTable(clazz, ispulse);
        if (mt == null) {
            return;
        }
        int count = p.getInt();
        if (!ispulse) {
            mt.startUpdate();
        }
        mt.clearValues();
        while (--count >= 0) {
            int mref = p.getInt();
            int ln = p.getInt();
            int nb = p.getInt();
            int sz = p.getInt();
            int nba = p.getInt();
            int sza = p.getInt();
            int nbf = p.getInt();
            int szf = p.getInt();
            mt.addOrUpdateHeapData(mref, ln, nb, sz, nba, sza, nbf, szf);
        }
        if (!ispulse) {
            mt.endUpdate();
        }
    }

    private void LoadClass(ProfilerMessage p) throws Exception {
        int classDescriptor;
        VMClass clazz = new VMClass();
        clazz.classDescriptor = classDescriptor = p.getInt();
        clazz.packageName = p.getString().replace('/', '.');
        clazz.name = p.getString();
        clazz.fileName = p.getString();
        clazz.methodCount = p.getInt();
        ArrayList<Object> methodArray = new ArrayList<Object>();
        int i = 0;
        while (i < clazz.methodCount) {
            int methodDescriptor = p.getInt();
            VMMethod method = new VMMethod(clazz, p.getString(), p.getString(), p.getInt());
            method.methodDescriptor = methodDescriptor;
            method.firstLine = p.getInt();
            method.lastLine = p.getInt();
            methodArray.add(method);
            this.methodMap.put(methodDescriptor, (Object)method);
            ++i;
        }
        clazz.methodArray = methodArray;
        this.classMap.put(classDescriptor, (Object)clazz);
    }

    private void ClassData(ProfilerMessage p) throws Exception {
        int classDescriptor;
        VMClass clazz = new VMClass();
        clazz.classDescriptor = classDescriptor = p.getInt();
        clazz.packageName = p.getString().replace('/', '.');
        clazz.name = p.getString();
        clazz.fileName = p.getString();
        clazz.methodArray = new ArrayList(1);
        this.classMap.put(classDescriptor, (Object)clazz);
    }

    private void MethodData(ProfilerMessage p) throws Exception {
        int methodDescriptor = p.getInt();
        int classDescriptor = p.getInt();
        VMClass c = (VMClass)this.classMap.get(classDescriptor);
        VMMethod method = new VMMethod(c, p.getString(), p.getString(), p.getInt());
        method.methodDescriptor = methodDescriptor;
        method.firstLine = p.getInt();
        method.lastLine = p.getInt();
        c.methodArray.add((Object)method);
        this.methodMap.put(methodDescriptor, (Object)method);
    }

    private ArrayList ReadCallElem(ProfilerMessage p) throws Exception {
        int ncall = p.getInt();
        ArrayList<SubCallCount> res = new ArrayList<SubCallCount>(ncall);
        while (--ncall >= 0) {
            Integer ref = new Integer(p.getInt());
            int cnt = p.getInt();
            SubCallCount sbc = new SubCallCount(cnt, ref);
            res.add(sbc);
        }
        return res;
    }

    private void CallCountSampleDump(ProfilerMessage p) throws Exception {
        int rf;
        int nMethods = p.getInt();
        int nThreads = p.getInt();
        int totalCalls = p.getInt();
        IntHashMap mainMap = new IntHashMap((nMethods + nThreads + 1) * 2);
        ArrayList<CallCountItem> v = new ArrayList<CallCountItem>(nMethods + nThreads + 1);
        int i = 0;
        while (i < nMethods) {
            rf = p.getInt();
            int ncall = p.getInt();
            int ocall = p.getInt();
            MethodCallCountItem m = new MethodCallCountItem(rf, (VMMethod)this.methodMap.get(rf), ncall, ocall);
            m.setCalledList(this.ReadCallElem(p));
            mainMap.put(rf, (Object)m);
            v.add(m);
            ++i;
        }
        i = 0;
        while (i < nThreads) {
            rf = p.getInt();
            String name = p.getString();
            int callCount = p.getInt();
            int onStackCount = p.getInt();
            ThreadCallCountItem t = new ThreadCallCountItem(rf, name, callCount, onStackCount);
            t.setCalledList(this.ReadCallElem(p));
            mainMap.put(rf, (Object)t);
            v.add(t);
            ++i;
        }
        RootCallCountItem r = new RootCallCountItem(0, totalCalls);
        r.setCalledList(this.ReadCallElem(p));
        mainMap.put(0, (Object)r);
        v.add(r);
        i = 0;
        while (i < v.size()) {
            CallCountItem cit = (CallCountItem)v.get(i);
            ArrayList called = cit.getCalledList();
            cit.calledTotal = cit.getCallCount();
            int j = 0;
            while (j < called.size()) {
                SubCallCount sbc = (SubCallCount)called.get(j);
                cit.calledTotal += sbc.count;
                CallCountItem cci = (CallCountItem)mainMap.get(((Integer)sbc.ref).intValue());
                SubCallCount sc = new SubCallCount(sbc.count, cit);
                cci.callerTotal += sbc.count;
                cci.getCallerList().add(sc);
                sbc.ref = cci;
                ++j;
            }
            ++i;
        }
        SampleTable table = this.getSampleTable();
        table.setData(totalCalls, v);
    }

    private void MethodLinesDump(ProfilerMessage p) throws Exception {
        int nMethods = p.getInt();
        ArrayList v = new ArrayList(nMethods);
        int i = 0;
        while (i < nMethods) {
            VMMethod m = (VMMethod)this.methodMap.get(p.getInt());
            int nLines = p.getInt();
            int l = 0;
            while (l < nLines) {
                int lineNumber = p.getInt();
                int nHits = p.getInt();
                ++l;
            }
            ++i;
        }
    }

    private void ThreadStart(ProfilerMessage p) throws Exception {
        VMThread t = new VMThread();
        t.threadDescriptor = p.getInt();
        t.name = p.getString();
        t.groupName = p.getString();
        t.callStackTreeNode = null;
        t.callStackTop = null;
        this.threadMap.put(t.threadDescriptor, (Object)t);
    }

    private void ThreadEnd(ProfilerMessage p) throws Exception {
        VMThread t = (VMThread)this.threadMap.get(p.getInt());
    }

    String getRunTitle() {
        return this.runTitle;
    }

    void readDataFromStream(DataInputStream resStream) {
        try {
            this._profType = resStream.readInt();
            switch (this._profType) {
                case 0: {
                    this.readMapsFromFile(resStream);
                    this.readSampleArrayFromFile(resStream);
                    break;
                }
                case 1: {
                    this.readMapsFromFile(resStream);
                    this.readEventsArrayFromFile(resStream);
                    break;
                }
                case 2: {
                    this.readMapsFromFile(resStream);
                    this.readMemorySessionFromFile(resStream);
                    break;
                }
                default: {
                    System.out.println("Profiler type " + this._profType + " not supported yet");
                    break;
                }
            }
            resStream.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void setDockableVisible(String id, boolean visible) {
        SwingUtilities.invokeLater(new 4(this, id, visible));
    }

    static String ra$host(ProfilingProcess profilingProcess) {
        return profilingProcess.host;
    }

    static int ra$localport(ProfilingProcess profilingProcess) {
        return profilingProcess.localport;
    }

    static void wa$messageReader(ProfilingProcess profilingProcess, ProfilerMessageReader profilerMessageReader) {
        profilingProcess.messageReader = profilerMessageReader;
    }

    static ProfilerMessageReader ra$messageReader(ProfilingProcess profilingProcess) {
        return profilingProcess.messageReader;
    }

    static void mav$read(ProfilingProcess profilingProcess) {
        profilingProcess.read();
    }

    static MemoryMonitor ra$memoryMonitor(ProfilingProcess profilingProcess) {
        return profilingProcess.memoryMonitor;
    }

    final class 1
    extends Thread {
        public void run() {
            try {
                ProfilingProcess.wa$messageReader(ProfilingProcess.this, new ProfilerMessageReader(ProfilingProcess.this, ProfilingProcess.ra$host(ProfilingProcess.this), ProfilingProcess.ra$localport(ProfilingProcess.this)));
                Thread t2 = new Thread(ProfilingProcess.ra$messageReader(ProfilingProcess.this));
                t2.setPriority(6);
                t2.start();
                ProfilingProcess.mav$read(ProfilingProcess.this);
            }
            catch (Exception e) {
                System.out.println("Profiling process terminating");
                System.out.println(e);
            }
            if (ProfilingProcess.ra$memoryMonitor(ProfilingProcess.this) != null) {
                ProfilingProcess.ra$memoryMonitor(ProfilingProcess.this).stop();
            }
        }
    }

    final class 2
    implements Runnable {
        private final /* synthetic */ ProfDockWindowStub v$wstub;
        private final /* synthetic */ DockingParam v$dockingParam;
        final /* synthetic */ ProfilingProcess this$0;

        public void run() {
            DockStation dockStation = DockStation.getDockStation();
            dockStation.dock((Dockable)this.v$wstub, this.v$dockingParam);
            dockStation.setDockableVisible((Dockable)this.v$wstub, true);
        }

        public 2(ProfilingProcess profilingProcess, ProfDockWindowStub profDockWindowStub, DockingParam dockingParam) {
            this.v$dockingParam = dockingParam;
            this.v$wstub = profDockWindowStub;
            this.this$0 = profilingProcess;
        }
    }

    final class 3
    implements Runnable {
        public void run() {
            ProfilingProcess.this.finished();
        }
    }

    final class 4
    implements Runnable {
        private final /* synthetic */ String v$id;
        private final /* synthetic */ boolean v$visible;
        final /* synthetic */ ProfilingProcess this$0;

        public void run() {
            DockStation.getDockStation().setDockableVisible(this.v$id, this.v$visible);
        }

        public 4(ProfilingProcess profilingProcess, String string, boolean bl) {
            this.v$visible = bl;
            this.v$id = string;
            this.this$0 = profilingProcess;
        }
    }
}

