/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.profile;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.JLabel;
import oracle.ide.controls.JNumericSpinBox;
import oracle.ide.help.HelpSystem;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.Namespace;
import oracle.ide.util.ResourceUtils;
import oracle.jdeveloper.runner.RunConfiguration;
import oracle.jdeveloper.runner.RunConfigurationEditorUtil;
import oracle.jdevimpl.runner.profile.ProfArb;
import oracle.jdevimpl.runner.profile.ProfileConfiguration;

public class SampleConfigurationPanel
extends DefaultTraversablePanel {
    private JNumericSpinBox sampleIntervalSpinBox;

    public SampleConfigurationPanel() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void onEntry(TraversableContext tc) {
        ProfileConfiguration profileConfiguration = SampleConfigurationPanel.getProfileConfiguration(tc);
        this.loadFrom(profileConfiguration);
    }

    public void onExit(TraversableContext tc) throws TraversalException {
        ProfileConfiguration profileConfiguration = SampleConfigurationPanel.getProfileConfiguration(tc);
        this.commitTo(profileConfiguration);
    }

    private static ProfileConfiguration getProfileConfiguration(TraversableContext tc) {
        RunConfiguration runConfiguration = RunConfigurationEditorUtil.getRunConfiguration((Namespace)tc);
        return ProfileConfiguration.getInstance(runConfiguration);
    }

    private void loadFrom(ProfileConfiguration profileConfiguration) {
        this.sampleIntervalSpinBox.setIntValue(profileConfiguration.getSampleInterval());
    }

    private void commitTo(ProfileConfiguration profileConfiguration) {
        profileConfiguration.setSampleInterval(this.sampleIntervalSpinBox.getIntValue());
    }

    private void jbInit() throws Exception {
        HelpSystem.getHelpSystem().registerTopic((JComponent)((Object)this), ProfArb.getString(171));
        JLabel lblSampleInterval = new JLabel();
        this.sampleIntervalSpinBox = new JNumericSpinBox(5, 10000);
        ResourceUtils.resLabel((JLabel)lblSampleInterval, (Component)this.sampleIntervalSpinBox, (String)ProfArb.getString(187));
        this.setLayout(new GridBagLayout());
        int y = 0;
        this.add(lblSampleInterval, new GridBagConstraints(0, y, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 0, 3, 0), 0, 0));
        this.add((Component)this.sampleIntervalSpinBox, new GridBagConstraints(1, y++, 0, 1, 0.0, 0.0, 17, 0, new Insets(3, 8, 3, 0), 0, 0));
        this.add(new JLabel(), new GridBagConstraints(0, y, 0, 1, 1.0, 1.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
    }
}

