/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.profile;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.DataOutputStream;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.EventObject;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import oracle.ide.Context;
import oracle.ide.IdeConstants;
import oracle.ide.controller.Controller;
import oracle.ide.controls.CustomJSplitPane;
import oracle.ide.help.HelpInfo;
import oracle.ide.icons.IdeIcons;
import oracle.ide.resource.ControlsArb;
import oracle.ide.resource.IdeArb;
import oracle.ide.view.View;
import oracle.ideimpl.controls.OneLineBorder;
import oracle.jdeveloper.runner.Source;
import oracle.jdevimpl.runner.debug.DbgArb;
import oracle.jdevimpl.runner.profile.CallCountItem;
import oracle.jdevimpl.runner.profile.DefaultAllignRenderer;
import oracle.jdevimpl.runner.profile.FileSavable;
import oracle.jdevimpl.runner.profile.FileSaver;
import oracle.jdevimpl.runner.profile.HTMLSavable;
import oracle.jdevimpl.runner.profile.HTMLSaver;
import oracle.jdevimpl.runner.profile.JProfiler;
import oracle.jdevimpl.runner.profile.LocationProvider;
import oracle.jdevimpl.runner.profile.ProfArb;
import oracle.jdevimpl.runner.profile.ProfWindow;
import oracle.jdevimpl.runner.profile.ProfilerSettings;
import oracle.jdevimpl.runner.profile.ProfilingProcess;
import oracle.jdevimpl.runner.profile.RightAllignRenderer;
import oracle.jdevimpl.runner.profile.SubCallCount;
import oracle.jdevimpl.runner.profile.UpdatableSettings;
import oracle.jdevimpl.runner.run.RunArb;

public final class SampleTable
extends ProfWindow
implements ActionListener,
HTMLSavable,
LocationProvider,
UpdatableSettings,
FileSavable {
    public static final int MAX_COLUMNS = 7;
    public static final int COL_CLASS = 0;
    public static final int COL_METHOD = 1;
    public static final int COL_SIGNATURE = 2;
    public static final int COL_HIT_P = 3;
    public static final int COL_HIT_TIME = 4;
    public static final int COL_STACK_P = 5;
    public static final int COL_STACK_TIME = 6;
    private static final int INITIAL_HEAPSTATSIZE = 20;
    private static final int MAX_TABLE_DET = 5;
    private ProfilingProcess process;
    private int nCalls;
    private String title;
    private JScrollPane mainScrollPane;
    private JScrollPane callerScrollPane;
    private JScrollPane calledScrollPane;
    private JLabel methodNameLabel;
    private JLabel methodFreq;
    private JLabel methodCumFreq;
    private JLabel onTopFreq;
    private JLabel methodTime;
    private JLabel methodCumTime;
    private JLabel onTopTime;
    private JSplitPane mainSplitPane;
    private JPanel detailPanel;
    private CallCountItem[] methodArray;
    private CallCountItem currentItem;
    private JTable table;
    private JTable callerTable;
    private JTable calledTable;
    private AbstractTableModel dataModel;
    private AbstractTableModel callerDataModel;
    private AbstractTableModel calledDataModel;
    int compareField;
    boolean ascending;
    SampleComparator scomp;
    private JButton buttonRestart;
    private JButton buttonSnapshot;
    private JButton buttonTerminate;
    private JButton buttonRun;
    private JButton buttonPause;
    private JButton buttonClear;
    private JLabel samplesLabel;
    private boolean[] columnShowing;
    private TableColumn[] column;
    private TableColumn[] calledColumn;
    private TableColumn[] callerColumn;
    private static DecimalFormat percentformat = new DecimalFormat("  ##0.00%");
    RightAllignRenderer rightAllignRenderer;
    DefaultAllignRenderer defaultAllignRenderer;
    private static final HelpInfo HELP_TOPIC = new HelpInfo(ProfArb.getString(206));
    static final String CLASS_TITLE = ProfArb.getString(234);
    static final String METHOD_TITLE = ProfArb.getString(82);
    static final String SIGNATURE_TITLE = ProfArb.getString(161);
    static final String HITP_TITLE = ProfArb.getString(188);
    static final String HITT_TITLE = ProfArb.getString(34);
    static final String ONSTACKP_TITLE = ProfArb.getString(127);
    static final String ONSTACKT_TITLE = ProfArb.getString(74);
    private static final Icon arrowUp = ControlsArb.getIcon((int)12);
    private static final Icon arrowDown = ControlsArb.getIcon((int)13);

    private void $init$() {
        this.columnShowing = new boolean[7];
        this.column = new TableColumn[7];
        this.calledColumn = new TableColumn[5];
        this.callerColumn = new TableColumn[5];
    }

    static String pFormat(double d) {
        Double dbl = new Double(d);
        if (dbl.isNaN() || dbl.isInfinite()) {
            return ProfArb.getString(184);
        }
        return percentformat.format(d);
    }

    public SampleTable(ProfilingProcess p) {
        this.$init$();
        this.rightAllignRenderer = new RightAllignRenderer(p);
        this.defaultAllignRenderer = new DefaultAllignRenderer(p);
        this.process = p;
        this.nCalls = 0;
        this.methodArray = new CallCountItem[0];
        this.scomp = new SampleComparator();
        this.ascending = false;
        this.compareField = 3;
        this.initialize();
    }

    public void setData(int totalCalls, List mList) {
        this.nCalls = totalCalls;
        this.samplesLabel.setText(Integer.toString(totalCalls));
        this.methodArray = new CallCountItem[mList.size()];
        int i = 0;
        while (i < mList.size()) {
            this.methodArray[i] = (CallCountItem)mList.get(i);
            ++i;
        }
        Arrays.sort(this.methodArray, this.scomp);
        this.dataModel.fireTableDataChanged();
        this.selectByRow(0);
    }

    public void resetProcess(ProfilingProcess p) {
        this.process = p;
        this.buttonRestart.setEnabled(true);
        this.buttonSnapshot.setEnabled(true);
        this.buttonTerminate.setEnabled(true);
        this.buttonRun.setEnabled(false);
        this.buttonPause.setEnabled(true);
        this.buttonClear.setEnabled(true);
        this.setData(0, new ArrayList(0));
    }

    public void notifyProcessEnd() {
        this.buttonRestart.setEnabled(true);
        this.buttonSnapshot.setEnabled(false);
        this.buttonTerminate.setEnabled(false);
        this.buttonRun.setEnabled(false);
        this.buttonPause.setEnabled(false);
        this.buttonClear.setEnabled(false);
    }

    public void saveToHTML(boolean full) {
        HTMLSaver hsv = new HTMLSaver(this.methodArray, this.nCalls);
        hsv.SaveToFile(this.getContext());
    }

    public void saveToFile() {
        FileSaver fs = new FileSaver(this);
        fs.save(this.getContext());
    }

    public void saveToFile(DataOutputStream stream) throws IOException {
        stream.writeInt(0);
        this.process.saveMapsToFile(stream);
        stream.writeInt(this.nCalls);
        FileSaver.saveVMObjectToFile(this.methodArray, stream);
    }

    public Component getGUI() {
        return this.mainSplitPane;
    }

    public Controller getController() {
        return null;
    }

    public Context getContext(EventObject event) {
        Context context = this.process.getContext();
        context.setView((View)this);
        context.setEvent(event);
        return context;
    }

    public void initialize() {
        this.title = ProfArb.getString(205) + this.process.getRunTitle();
        JPanel panel = this.createGUI();
        this.detailPanel = this.createDetailPanel();
        this.mainSplitPane = new CustomJSplitPane(1, true, (Component)panel, (Component)this.detailPanel);
        this.mainSplitPane.setBorder(BorderFactory.createEmptyBorder());
        this.mainSplitPane.setDividerLocation(0.6);
        this.updateSettings();
    }

    public HelpInfo getHelpInfo() {
        return HELP_TOPIC;
    }

    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        this.whenActionPerformed(source);
    }

    private void whenActionPerformed(Object source) {
        if (source == this.buttonRun) {
            this.process.performRunCommand();
            this.buttonRun.setEnabled(false);
            this.buttonClear.setEnabled(true);
            this.buttonPause.setEnabled(true);
            this.buttonPause.requestFocus();
        } else if (source == this.buttonPause) {
            this.process.performPauseCommand();
            this.buttonRun.setEnabled(true);
            this.buttonRun.requestFocus();
            this.buttonClear.setEnabled(true);
            this.buttonPause.setEnabled(false);
        } else if (source == this.buttonClear) {
            this.process.performClearSampleCommand();
        } else if (source == this.buttonSnapshot) {
            this.process.performSnapshotCommand();
        } else if (source == this.buttonRestart) {
            this.process.performRestartCommand();
        } else if (source == this.buttonTerminate) {
            this.process.performTerminateCommand();
        }
    }

    private JPanel createDetailPanel() {
        this.callerDataModel = new 1();
        2 callerHeaderRenderer = new 2();
        this.calledDataModel = new 3();
        4 calledHeaderRenderer = new 4();
        this.callerTable = new JTable(this.callerDataModel);
        this.callerTable.addMouseListener(new subTreeMouseAdapter(this.callerTable, true));
        TableColumnModel tableColumnModel = this.callerTable.getColumnModel();
        int i = 0;
        while (i < 5) {
            this.callerColumn[i] = tableColumnModel.getColumn(i);
            ++i;
        }
        this.callerColumn[0].setCellRenderer(this.defaultAllignRenderer);
        this.callerColumn[0].setPreferredWidth(500);
        this.callerColumn[1].setCellRenderer(this.defaultAllignRenderer);
        this.callerColumn[1].setPreferredWidth(400);
        this.callerColumn[2].setCellRenderer(this.defaultAllignRenderer);
        this.callerColumn[2].setPreferredWidth(300);
        this.callerColumn[3].setCellRenderer(this.rightAllignRenderer);
        this.callerColumn[3].setPreferredWidth(100);
        this.callerColumn[4].setCellRenderer(this.rightAllignRenderer);
        this.callerColumn[4].setPreferredWidth(100);
        callerHeaderRenderer.setHorizontalAlignment(0);
        JTableHeader th = this.callerTable.getTableHeader();
        th.setDefaultRenderer(callerHeaderRenderer);
        this.calledTable = new JTable(this.calledDataModel);
        this.calledTable.addMouseListener(new subTreeMouseAdapter(this.calledTable, false));
        tableColumnModel = this.calledTable.getColumnModel();
        int i2 = 0;
        while (i2 < 5) {
            this.calledColumn[i2] = tableColumnModel.getColumn(i2);
            ++i2;
        }
        this.calledColumn[0].setCellRenderer(this.defaultAllignRenderer);
        this.calledColumn[0].setPreferredWidth(500);
        this.calledColumn[1].setCellRenderer(this.defaultAllignRenderer);
        this.calledColumn[1].setPreferredWidth(400);
        this.calledColumn[2].setCellRenderer(this.defaultAllignRenderer);
        this.calledColumn[2].setPreferredWidth(300);
        this.calledColumn[3].setCellRenderer(this.rightAllignRenderer);
        this.calledColumn[3].setPreferredWidth(100);
        this.calledColumn[4].setCellRenderer(this.rightAllignRenderer);
        this.calledColumn[4].setPreferredWidth(100);
        calledHeaderRenderer.setHorizontalAlignment(0);
        th = this.calledTable.getTableHeader();
        th.setDefaultRenderer(calledHeaderRenderer);
        GridBagLayout gridbag = new GridBagLayout();
        JPanel panel = new JPanel(gridbag);
        panel.setBorder(BorderFactory.createEmptyBorder());
        GridBagConstraints c = new GridBagConstraints();
        int x = 0;
        int y = 0;
        JLabel textlabel = new JLabel(ProfArb.getString(222));
        Font curfont = textlabel.getFont();
        Font boldfont = curfont.deriveFont(1);
        panel.add((Component)textlabel, new GridBagConstraints(0, y++, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 5, 0, 0), 0, 0));
        JScrollPane jscall = new JScrollPane(this.callerTable);
        jscall.setBorder((Border)new OneLineBorder(3, null));
        panel.add((Component)jscall, new GridBagConstraints(0, y++, 0, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.methodNameLabel = new JLabel(" ");
        this.methodNameLabel.setFont(boldfont);
        Dimension d = this.methodNameLabel.getPreferredSize();
        d.width = 1;
        this.methodNameLabel.setMinimumSize(d);
        panel.add((Component)this.methodNameLabel, new GridBagConstraints(x, y++, 0, 1, 1.0, 0.0, 17, 1, new Insets(3, 5, 0, 0), 0, 0));
        JPanel temp = new JPanel();
        textlabel = new JLabel(ProfArb.getString(147));
        temp.add(textlabel);
        this.methodTime = new JLabel("");
        this.methodTime.setFont(boldfont);
        this.methodFreq = new JLabel("");
        this.methodFreq.setFont(boldfont);
        temp.add(this.methodTime);
        temp.add(this.methodFreq);
        textlabel = new JLabel(ProfArb.getString(87));
        temp.add(textlabel);
        this.methodCumTime = new JLabel("");
        this.methodCumTime.setFont(boldfont);
        this.methodCumFreq = new JLabel("");
        this.methodCumFreq.setFont(boldfont);
        temp.add(this.methodCumTime);
        temp.add(this.methodCumFreq);
        panel.add((Component)temp, new GridBagConstraints(0, y, 0, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        x = 0;
        textlabel = new JLabel(ProfArb.getString(323));
        panel.add((Component)textlabel, new GridBagConstraints(x++, ++y, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 5, 0, 0), 0, 0));
        textlabel = new JLabel(ProfArb.getString(164));
        textlabel.setHorizontalAlignment(4);
        panel.add((Component)textlabel, new GridBagConstraints(x++, y, 1, 1, 1.0, 0.0, 17, 2, new Insets(3, 5, 0, 0), 0, 0));
        this.onTopFreq = new JLabel("");
        this.onTopFreq.setFont(boldfont);
        this.onTopTime = new JLabel("");
        this.onTopTime.setFont(boldfont);
        panel.add((Component)this.onTopTime, new GridBagConstraints(x++, y, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 5, 0, 0), 0, 0));
        panel.add((Component)this.onTopFreq, new GridBagConstraints(x++, y++, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 5, 0, 0), 0, 0));
        x = 0;
        jscall = new JScrollPane(this.calledTable);
        jscall.setBorder((Border)new OneLineBorder(1, null));
        panel.add((Component)jscall, new GridBagConstraints(0, y++, 0, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        return panel;
    }

    public void changeSettings() {
        this.process.showSettings();
    }

    public void updateSettings() {
        ProfilerSettings ps = ProfilerSettings.getInstance();
        boolean[] show = ps.getSampleColumnVisible();
        boolean isChanged = false;
        boolean isDetChanged = false;
        int i = 0;
        while (i < 7) {
            if (this.columnShowing[i] != show[i]) {
                isChanged = true;
                this.columnShowing[i] = show[i];
                if (show[i]) {
                    this.table.addColumn(this.column[i]);
                } else {
                    this.table.removeColumn(this.column[i]);
                }
                if (i < 5) {
                    isDetChanged = true;
                    if (show[i]) {
                        this.callerTable.addColumn(this.callerColumn[i]);
                        this.calledTable.addColumn(this.calledColumn[i]);
                    } else {
                        this.callerTable.removeColumn(this.callerColumn[i]);
                        this.calledTable.removeColumn(this.calledColumn[i]);
                    }
                }
            }
            ++i;
        }
        if (isChanged) {
            this.dataModel.fireTableChanged(new TableModelEvent(this.dataModel, 0, this.dataModel.getRowCount() - 1, -1));
        }
        if (isDetChanged) {
            this.callerDataModel.fireTableChanged(new TableModelEvent(this.callerDataModel, 0, this.callerDataModel.getRowCount() - 1, -1));
            this.calledDataModel.fireTableChanged(new TableModelEvent(this.calledDataModel, 0, this.calledDataModel.getRowCount() - 1, -1));
        }
    }

    public void findSource() {
        int row = this.table.getSelectedRow();
        if (row == -1) {
            return;
        }
        CallCountItem citem = this.methodArray[row];
        int line = citem.getLine();
        if (line == -1) {
            return;
        }
        Context context = this.getContext();
        Source.showSourceFile(context.getWorkspace(), context.getProject(), citem.getPackage(), null, citem.getFileName(), citem.getLine(), true);
    }

    public boolean canFindSource() {
        int row = this.table.getSelectedRow();
        if (row == -1) {
            return false;
        }
        CallCountItem citem = this.methodArray[row];
        int line = citem.getLine();
        return line != -1;
    }

    private JPanel createGUI() {
        JPanel panel = new JPanel(new BorderLayout());
        JPanel header = new JPanel(new BorderLayout());
        JToolBar tb = new JToolBar();
        JPanel header2 = new JPanel(new FlowLayout(2));
        Dimension buttonSize = new Dimension(24, 24);
        panel.add((Component)header, "North");
        header.add((Component)tb, "West");
        header.add((Component)header2, "East");
        panel.setBorder(BorderFactory.createEmptyBorder());
        tb.setFloatable(false);
        tb.setRollover(true);
        tb.setBorder(IdeConstants.TOOLBAR_EMPTY_BORDER);
        this.buttonRestart = new JButton(RunArb.getIcon(17));
        this.buttonRestart.setToolTipText(ProfArb.getString(68));
        this.registerActionMnemonic(panel, this.buttonRestart, ProfArb.getMnemonic(328));
        this.buttonRestart.addActionListener(this);
        tb.add(this.buttonRestart);
        this.buttonRestart.setEnabled(true);
        this.buttonRun = new JButton(DbgArb.getIcon(584));
        this.buttonRun.setToolTipText(ProfArb.getString(317));
        this.registerActionMnemonic(panel, this.buttonRun, ProfArb.getMnemonic(76));
        this.buttonRun.addActionListener(this);
        tb.add(this.buttonRun);
        this.buttonRun.setEnabled(false);
        this.buttonPause = new JButton(DbgArb.getIcon(684));
        this.buttonPause.setToolTipText(ProfArb.getString(142));
        this.registerActionMnemonic(panel, this.buttonPause, ProfArb.getMnemonic(117));
        this.buttonPause.addActionListener(this);
        tb.add(this.buttonPause);
        this.buttonPause.setEnabled(true);
        this.buttonSnapshot = new JButton(IdeArb.getIcon((int)79));
        this.buttonSnapshot.setToolTipText(ProfArb.getString(228));
        this.registerActionMnemonic(panel, this.buttonSnapshot, ProfArb.getMnemonic(264));
        this.buttonSnapshot.addActionListener(this);
        tb.add(this.buttonSnapshot);
        this.buttonSnapshot.setEnabled(true);
        this.buttonClear = new JButton(IdeIcons.getIcon((int)6));
        this.buttonClear.setToolTipText(ProfArb.getString(131));
        this.registerActionMnemonic(panel, this.buttonClear, ProfArb.getMnemonic(114));
        this.buttonClear.addActionListener(this);
        tb.add(this.buttonClear);
        this.buttonClear.setEnabled(true);
        this.buttonTerminate = new JButton(IdeArb.getIcon((int)343));
        this.buttonTerminate.setToolTipText(ProfArb.getString(219));
        this.registerActionMnemonic(panel, this.buttonTerminate, ProfArb.getMnemonic(148));
        this.buttonTerminate.addActionListener(this);
        tb.add(this.buttonTerminate);
        this.buttonTerminate.setEnabled(true);
        JLabel textlabel = new JLabel(ProfArb.getString(9));
        textlabel.setHorizontalAlignment(4);
        header2.add(textlabel);
        this.samplesLabel = new JLabel("1000");
        header2.add(this.samplesLabel);
        this.dataModel = new 5();
        this.table = new JTable(this.dataModel);
        this.table.addMouseListener(new 6());
        this.addMouseListenerToHeaderInTable();
        TableColumnModel tableColumnModel = this.table.getColumnModel();
        int i = 0;
        while (i < 7) {
            this.column[i] = tableColumnModel.getColumn(i);
            this.columnShowing[i] = true;
            ++i;
        }
        this.column[0].setCellRenderer(this.defaultAllignRenderer);
        this.column[0].setPreferredWidth(500);
        this.column[1].setCellRenderer(this.defaultAllignRenderer);
        this.column[1].setPreferredWidth(400);
        this.column[2].setCellRenderer(this.defaultAllignRenderer);
        this.column[2].setPreferredWidth(300);
        this.column[3].setCellRenderer(this.rightAllignRenderer);
        this.column[3].setPreferredWidth(100);
        this.column[5].setCellRenderer(this.rightAllignRenderer);
        this.column[5].setPreferredWidth(100);
        this.column[4].setCellRenderer(this.rightAllignRenderer);
        this.column[4].setPreferredWidth(100);
        this.column[6].setCellRenderer(this.rightAllignRenderer);
        this.column[6].setPreferredWidth(100);
        Dimension spacing = new Dimension(0, 0);
        this.table.setIntercellSpacing(spacing);
        ListSelectionModel listSelectionModel = this.table.getSelectionModel();
        listSelectionModel.setSelectionMode(0);
        listSelectionModel.addListSelectionListener(new 7());
        this.mainScrollPane = new JScrollPane(this.table);
        this.mainScrollPane.setBorder((Border)new OneLineBorder(1, null));
        panel.add((Component)this.mainScrollPane, "Center");
        return panel;
    }

    void registerActionMnemonic(JPanel panel, JButton button, char mnemonic) {
        InputMap im = panel.getInputMap(1);
        ActionMap am = panel.getActionMap();
        MyAction action = new MyAction(button);
        KeyStroke ks = KeyStroke.getKeyStroke((int)mnemonic, 2);
        im.put(ks, action);
        am.put(action, action);
    }

    private void addMouseListenerToHeaderInTable() {
        JTable tableView = this.table;
        tableView.setColumnSelectionAllowed(false);
        8 listMouseListener = new 8(this, tableView);
        9 headerRenderer = new 9();
        headerRenderer.setHorizontalAlignment(0);
        JTableHeader th = tableView.getTableHeader();
        th.addMouseListener(listMouseListener);
        th.setDefaultRenderer(headerRenderer);
    }

    private void selectByRow(int row) {
        ListSelectionModel lsm = this.table.getSelectionModel();
        lsm.clearSelection();
        lsm.addSelectionInterval(row, row);
        JViewport vp = this.mainScrollPane.getViewport();
        Rectangle r = this.table.getCellRect(row, 0, true);
        Rectangle rv = vp.getViewRect();
        r.y -= rv.y;
        vp.scrollRectToVisible(r);
    }

    private void selectByObject(CallCountItem o) {
        int i = 0;
        while (i < this.methodArray.length) {
            if (o == this.methodArray[i]) {
                this.selectByRow(i);
                return;
            }
            ++i;
        }
    }

    private void sortArray(int column) {
        if (this.compareField == column) {
            this.ascending ^= true;
        } else {
            this.compareField = column;
        }
        Arrays.sort(this.methodArray, this.scomp);
    }

    public String getTabName() {
        return this.process.getTabName();
    }

    public Icon getTabIcon() {
        return this.process.getIcon();
    }

    public String getTitleName() {
        return this.title;
    }

    public void stateChange(int newState) {
        switch (newState) {
            case 3: {
                this.process.terminateProcess();
                this.methodArray = null;
                this.currentItem = null;
                break;
            }
        }
        super.stateChange(newState);
    }

    static CallCountItem ra$currentItem(SampleTable sampleTable) {
        return sampleTable.currentItem;
    }

    static void mav$selectByObject(SampleTable sampleTable, CallCountItem callCountItem) {
        sampleTable.selectByObject(callCountItem);
    }

    static void mav$whenActionPerformed(SampleTable sampleTable, Object object) {
        sampleTable.whenActionPerformed(object);
    }

    static void mav$sortArray(SampleTable sampleTable, int n) {
        sampleTable.sortArray(n);
    }

    static Icon ra$arrowUp() {
        return arrowUp;
    }

    static Icon ra$arrowDown() {
        return arrowDown;
    }

    static ProfilingProcess ra$process(SampleTable sampleTable) {
        return sampleTable.process;
    }

    static CallCountItem[] ra$methodArray(SampleTable sampleTable) {
        return sampleTable.methodArray;
    }

    static int ra$nCalls(SampleTable sampleTable) {
        return sampleTable.nCalls;
    }

    static JTable ra$table(SampleTable sampleTable) {
        return sampleTable.table;
    }

    static void wa$currentItem(SampleTable sampleTable, CallCountItem callCountItem) {
        sampleTable.currentItem = callCountItem;
    }

    static JLabel ra$methodNameLabel(SampleTable sampleTable) {
        return sampleTable.methodNameLabel;
    }

    static JLabel ra$onTopFreq(SampleTable sampleTable) {
        return sampleTable.onTopFreq;
    }

    static JLabel ra$onTopTime(SampleTable sampleTable) {
        return sampleTable.onTopTime;
    }

    static JLabel ra$methodFreq(SampleTable sampleTable) {
        return sampleTable.methodFreq;
    }

    static JLabel ra$methodTime(SampleTable sampleTable) {
        return sampleTable.methodTime;
    }

    static JLabel ra$methodCumFreq(SampleTable sampleTable) {
        return sampleTable.methodCumFreq;
    }

    static JLabel ra$methodCumTime(SampleTable sampleTable) {
        return sampleTable.methodCumTime;
    }

    static AbstractTableModel ra$callerDataModel(SampleTable sampleTable) {
        return sampleTable.callerDataModel;
    }

    static AbstractTableModel ra$calledDataModel(SampleTable sampleTable) {
        return sampleTable.calledDataModel;
    }

    class subTreeMouseAdapter
    extends MouseAdapter {
        private JTable tbl;
        private boolean iscaller;

        public subTreeMouseAdapter(JTable t, boolean isc) {
            this.tbl = t;
            this.iscaller = isc;
        }

        public void mouseClicked(MouseEvent e) {
            super.mouseClicked(e);
            if (e.getClickCount() != 2) {
                return;
            }
            int row = this.tbl.getSelectedRow();
            if (row == -1) {
                return;
            }
            SubCallCount sc = this.iscaller ? (SubCallCount)SampleTable.ra$currentItem(SampleTable.this).getCallerList().get(row) : (SubCallCount)SampleTable.ra$currentItem(SampleTable.this).getCalledList().get(row);
            SampleTable.mav$selectByObject(SampleTable.this, (CallCountItem)sc.ref);
        }
    }

    final class 1
    extends AbstractTableModel {
        public int getColumnCount() {
            return 5;
        }

        public int getRowCount() {
            if (SampleTable.ra$currentItem(SampleTable.this) != null && SampleTable.ra$currentItem(SampleTable.this).getCallerList() != null) {
                return SampleTable.ra$currentItem(SampleTable.this).getCallerList().size();
            }
            return 0;
        }

        public String getColumnName(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return CLASS_TITLE;
                }
                case 1: {
                    return METHOD_TITLE;
                }
                case 2: {
                    return SIGNATURE_TITLE;
                }
                case 3: {
                    return HITP_TITLE;
                }
                case 4: {
                    return HITT_TITLE;
                }
            }
            return "Error";
        }

        public Object getValueAt(int row, int col) {
            SubCallCount sc = (SubCallCount)SampleTable.ra$currentItem(SampleTable.this).getCallerList().get(row);
            CallCountItem cci = (CallCountItem)sc.ref;
            switch (col) {
                case 0: {
                    return cci.getPseudoClass();
                }
                case 1: {
                    return cci.getPseudoName();
                }
                case 2: {
                    return cci.getNiceSignature();
                }
                case 3: {
                    return SampleTable.pFormat((double)sc.count / (double)SampleTable.ra$currentItem((SampleTable)SampleTable.this).callerTotal);
                }
                case 4: {
                    return Integer.toString(sc.count);
                }
            }
            return "Error";
        }
    }

    final class 2
    extends DefaultTableCellRenderer {
        private int _col;

        public String getToolTipText(MouseEvent event) {
            if (SampleTable.ra$process(SampleTable.this).isPopupActive()) {
                return null;
            }
            switch (this._col) {
                case 0: {
                    return ProfArb.getString(135);
                }
                case 1: {
                    return ProfArb.getString(94);
                }
                case 2: {
                    return ProfArb.getString(139);
                }
                case 3: {
                    return ProfArb.getString(53);
                }
                case 4: {
                    return ProfArb.getString(271);
                }
            }
            return "";
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            int col;
            this._col = col = table.convertColumnIndexToModel(column);
            this.setText((String)value);
            this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
            return this;
        }
    }

    final class 3
    extends AbstractTableModel {
        public int getColumnCount() {
            return 5;
        }

        public int getRowCount() {
            if (SampleTable.ra$currentItem(SampleTable.this) != null && SampleTable.ra$currentItem(SampleTable.this).getCalledList() != null) {
                return SampleTable.ra$currentItem(SampleTable.this).getCalledList().size();
            }
            return 0;
        }

        public String getColumnName(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return CLASS_TITLE;
                }
                case 1: {
                    return METHOD_TITLE;
                }
                case 2: {
                    return SIGNATURE_TITLE;
                }
                case 3: {
                    return HITP_TITLE;
                }
                case 4: {
                    return HITT_TITLE;
                }
            }
            return "Error";
        }

        public Object getValueAt(int row, int col) {
            SubCallCount sc = (SubCallCount)SampleTable.ra$currentItem(SampleTable.this).getCalledList().get(row);
            CallCountItem cci = (CallCountItem)sc.ref;
            switch (col) {
                case 0: {
                    return cci.getPseudoClass();
                }
                case 1: {
                    return cci.getPseudoName();
                }
                case 2: {
                    return cci.getNiceSignature();
                }
                case 3: {
                    return SampleTable.pFormat((double)sc.count / (double)SampleTable.ra$currentItem((SampleTable)SampleTable.this).calledTotal);
                }
                case 4: {
                    return Integer.toString(sc.count);
                }
            }
            return "Error";
        }
    }

    final class 4
    extends DefaultTableCellRenderer {
        private int _col;

        public String getToolTipText(MouseEvent event) {
            if (SampleTable.ra$process(SampleTable.this).isPopupActive()) {
                return null;
            }
            switch (this._col) {
                case 0: {
                    return ProfArb.getString(255);
                }
                case 1: {
                    return ProfArb.getString(311);
                }
                case 2: {
                    return ProfArb.getString(103);
                }
                case 3: {
                    return ProfArb.getString(13);
                }
                case 4: {
                    return ProfArb.getString(242);
                }
            }
            return "";
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            int col;
            this._col = col = table.convertColumnIndexToModel(column);
            this.setText((String)value);
            this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
            return this;
        }
    }

    final class 5
    extends AbstractTableModel {
        public int getColumnCount() {
            return 7;
        }

        public int getRowCount() {
            if (SampleTable.ra$methodArray(SampleTable.this) == null) {
                return 0;
            }
            return SampleTable.ra$methodArray(SampleTable.this).length;
        }

        public String getColumnName(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return CLASS_TITLE;
                }
                case 1: {
                    return METHOD_TITLE;
                }
                case 2: {
                    return SIGNATURE_TITLE;
                }
                case 3: {
                    return HITP_TITLE;
                }
                case 4: {
                    return HITT_TITLE;
                }
                case 5: {
                    return ONSTACKP_TITLE;
                }
                case 6: {
                    return ONSTACKT_TITLE;
                }
            }
            return "Error";
        }

        public Object getValueAt(int row, int col) {
            CallCountItem m = SampleTable.ra$methodArray(SampleTable.this)[row];
            switch (col) {
                case 0: {
                    return m.getPseudoClass();
                }
                case 1: {
                    return m.getPseudoName();
                }
                case 2: {
                    return m.getNiceSignature();
                }
                case 3: {
                    return SampleTable.pFormat((double)m.getCallCount() / (double)SampleTable.ra$nCalls(SampleTable.this));
                }
                case 4: {
                    return Integer.toString(m.getCallCount());
                }
                case 5: {
                    return SampleTable.pFormat((double)m.getOnStackCount() / (double)SampleTable.ra$nCalls(SampleTable.this));
                }
                case 6: {
                    return Integer.toString(m.getOnStackCount());
                }
            }
            return null;
        }
    }

    final class 6
    extends MouseAdapter {
        public void mousePressed(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        public void mouseReleased(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        private void maybeShowPopup(MouseEvent e) {
            if (e.isPopupTrigger()) {
                SampleTable.ra$table(SampleTable.this).requestFocus();
                Context context = SampleTable.this.getContext(e);
                JProfiler.contextMenu.show(context);
            }
        }

        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() == 2) {
                SampleTable.this.findSource();
            }
        }
    }

    final class 7
    implements ListSelectionListener {
        public void valueChanged(ListSelectionEvent e) {
            if (e.getValueIsAdjusting()) {
                return;
            }
            ListSelectionModel lsm = (ListSelectionModel)e.getSource();
            if (lsm.isSelectionEmpty()) {
                SampleTable.wa$currentItem(SampleTable.this, null);
                SampleTable.ra$methodNameLabel(SampleTable.this).setText("");
                SampleTable.ra$onTopFreq(SampleTable.this).setText("");
                SampleTable.ra$onTopTime(SampleTable.this).setText("");
                SampleTable.ra$methodFreq(SampleTable.this).setText("");
                SampleTable.ra$methodTime(SampleTable.this).setText("");
                SampleTable.ra$methodCumFreq(SampleTable.this).setText("");
                SampleTable.ra$methodCumTime(SampleTable.this).setText("");
                SampleTable.ra$callerDataModel(SampleTable.this).fireTableDataChanged();
                SampleTable.ra$calledDataModel(SampleTable.this).fireTableDataChanged();
            } else {
                int selectedRow = lsm.getMinSelectionIndex();
                SampleTable.wa$currentItem(SampleTable.this, SampleTable.ra$methodArray(SampleTable.this)[selectedRow]);
                SampleTable.ra$currentItem(SampleTable.this).sortCalls();
                SampleTable.ra$methodNameLabel(SampleTable.this).setText(SampleTable.ra$currentItem(SampleTable.this).getPseudoClass() + "." + SampleTable.ra$currentItem(SampleTable.this).getPseudoName() + SampleTable.ra$currentItem(SampleTable.this).getNiceSignature());
                SampleTable.ra$onTopFreq(SampleTable.this).setText(SampleTable.pFormat((double)SampleTable.ra$currentItem(SampleTable.this).getCallCount() / (double)SampleTable.ra$currentItem((SampleTable)SampleTable.this).calledTotal));
                SampleTable.ra$onTopTime(SampleTable.this).setText(ProfArb.format(203, Integer.toString(SampleTable.ra$currentItem(SampleTable.this).getCallCount())));
                SampleTable.ra$methodFreq(SampleTable.this).setText(SampleTable.pFormat((double)SampleTable.ra$currentItem(SampleTable.this).getCallCount() / (double)SampleTable.ra$nCalls(SampleTable.this)));
                SampleTable.ra$methodTime(SampleTable.this).setText(ProfArb.format(203, Integer.toString(SampleTable.ra$currentItem(SampleTable.this).getCallCount())));
                SampleTable.ra$methodCumFreq(SampleTable.this).setText(SampleTable.pFormat((double)SampleTable.ra$currentItem(SampleTable.this).getOnStackCount() / (double)SampleTable.ra$nCalls(SampleTable.this)));
                SampleTable.ra$methodCumTime(SampleTable.this).setText(ProfArb.format(203, Integer.toString(SampleTable.ra$currentItem(SampleTable.this).getOnStackCount())));
                SampleTable.ra$callerDataModel(SampleTable.this).fireTableDataChanged();
                SampleTable.ra$calledDataModel(SampleTable.this).fireTableDataChanged();
            }
        }
    }

    class MyAction
    extends AbstractAction {
        JButton _src;

        MyAction(JButton src) {
            this._src = src;
        }

        public void actionPerformed(ActionEvent e) {
            SampleTable.mav$whenActionPerformed(SampleTable.this, this._src);
        }
    }

    final class 8
    extends MouseAdapter {
        private final /* synthetic */ JTable v$tableView;
        final /* synthetic */ SampleTable this$0;

        public void mouseClicked(MouseEvent e) {
            TableColumnModel columnModel = this.v$tableView.getColumnModel();
            int viewColumn = columnModel.getColumnIndexAtX(e.getX());
            int column = this.v$tableView.convertColumnIndexToModel(viewColumn);
            if (e.getClickCount() == 1 && column != -1) {
                SampleTable.mav$sortArray(this.this$0, column);
                SampleTable.mav$selectByObject(this.this$0, SampleTable.ra$currentItem(this.this$0));
            }
        }

        public 8(SampleTable sampleTable, JTable jTable) {
            this.v$tableView = jTable;
            this.this$0 = sampleTable;
        }
    }

    final class 9
    extends DefaultTableCellRenderer {
        private int _col;

        public String getToolTipText(MouseEvent event) {
            if (SampleTable.ra$process(SampleTable.this).isPopupActive()) {
                return null;
            }
            switch (this._col) {
                case 0: {
                    return ProfArb.getString(132);
                }
                case 1: {
                    return ProfArb.getString(2);
                }
                case 2: {
                    return ProfArb.getString(320);
                }
                case 3: {
                    return ProfArb.getString(251);
                }
                case 4: {
                    return ProfArb.getString(144);
                }
                case 5: {
                    return ProfArb.getString(80);
                }
                case 6: {
                    return ProfArb.getString(292);
                }
            }
            return "";
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            int col;
            JTableHeader header;
            if (table != null && (header = table.getTableHeader()) != null) {
                this.setForeground(header.getForeground());
                this.setBackground(header.getBackground());
                this.setFont(header.getFont());
            }
            this._col = col = table.convertColumnIndexToModel(column);
            if (col == SampleTable.this.compareField) {
                if (SampleTable.this.ascending) {
                    this.setIcon(SampleTable.ra$arrowUp());
                } else {
                    this.setIcon(SampleTable.ra$arrowDown());
                }
            } else {
                this.setIcon(null);
            }
            this.setText((String)value);
            this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class SampleComparator
    implements Comparator {
        public int compare(Object o1, Object o2) {
            int result;
            CallCountItem m1 = (CallCountItem)o1;
            CallCountItem m2 = (CallCountItem)o2;
            switch (SampleTable.this.compareField) {
                default: {
                    result = m1.getPseudoClass().compareTo(m2.getPseudoClass());
                    break;
                }
                case 1: {
                    result = m1.getPseudoName().compareTo(m2.getPseudoName());
                    break;
                }
                case 2: {
                    result = m1.getNiceSignature().compareTo(m2.getNiceSignature());
                    break;
                }
                case 3: 
                case 4: {
                    result = m1.getCallCount() - m2.getCallCount();
                    break;
                }
                case 5: 
                case 6: {
                    result = m1.getOnStackCount() - m2.getOnStackCount();
                    break;
                }
            }
            if (!SampleTable.this.ascending) {
                result = 0 - result;
            }
            return result;
        }

        SampleComparator() {
        }
    }
}

