/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.profile;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import oracle.jdevimpl.runner.profile.VMTypes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class VMClass
extends VMTypes
implements Comparable {
    public int classDescriptor;
    public String packageName;
    public String fullName;
    public String fileName;
    public int methodCount;
    public List methodArray;
    public int nAllocations;
    public int allocSize;
    static int compareField;
    static boolean ascending;

    public String getInternalName() {
        if (!this.packageName.equals("")) {
            return this.packageName + '.' + this.name;
        }
        return this.name;
    }

    @Override
    public void saveToFile(DataOutputStream stream) throws IOException {
        super.saveToFile(stream);
        stream.writeInt(this.classDescriptor);
        stream.writeUTF(this.packageName);
        stream.writeUTF(this.fileName);
    }

    @Override
    void initFromFile(DataInputStream stream) throws IOException {
        super.initFromFile(stream);
        this.classDescriptor = stream.readInt();
        this.packageName = stream.readUTF();
        this.fileName = stream.readUTF();
    }

    public static VMClass readFromFile(DataInputStream stream) throws IOException {
        VMClass res = new VMClass();
        res.initFromFile(stream);
        return res;
    }

    public String toString() {
        if (this.fullName == null) {
            String part = this.getInternalName();
            StringBuffer res = new StringBuffer();
            char[] org = part.toCharArray();
            StringBuffer dim = new StringBuffer();
            if (org[0] != '[') {
                this.fullName = part;
            } else {
                int i = 0;
                while (org[i] == '[') {
                    dim.append("[]");
                    ++i;
                }
                switch (org[i]) {
                    case 'Z': {
                        res.append("boolean");
                        break;
                    }
                    case 'B': {
                        res.append("byte");
                        break;
                    }
                    case 'C': {
                        res.append("char");
                        break;
                    }
                    case 'S': {
                        res.append("short");
                        break;
                    }
                    case 'I': {
                        res.append("int");
                        break;
                    }
                    case 'F': {
                        res.append("float");
                        break;
                    }
                    case 'J': {
                        res.append("long");
                        break;
                    }
                    case 'D': {
                        res.append("double");
                        break;
                    }
                    case 'L': {
                        ++i;
                        while (org[i] != ';') {
                            res.append(org[i]);
                            ++i;
                        }
                        break;
                    }
                }
                res.append(dim);
                this.fullName = new String(res);
            }
        }
        return this.fullName;
    }

    @Override
    public boolean mayHaveChildren() {
        return true;
    }

    @Override
    public Iterator getChildren() {
        if (this.methodArray == null || this.methodArray.size() == 0) {
            return null;
        }
        return this.methodArray.iterator();
    }

    public int compareTo(Object o) {
        VMClass c = (VMClass)o;
        int result = 0;
        switch (compareField) {
            case 0: {
                result = this.packageName.compareTo(c.packageName);
                if (result != 0) break;
            }
            case 1: {
                result = this.name.compareTo(c.name);
                break;
            }
            case 2: {
                result = this.nAllocations - c.nAllocations;
                break;
            }
            case 3: {
                result = this.allocSize - c.allocSize;
                break;
            }
        }
        if (!ascending) {
            result = 0 - result;
        }
        return result;
    }

    VMClass() {
    }
}

