/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.profile;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import oracle.ide.util.IntHashMap;
import oracle.jdevimpl.runner.profile.VMClass;
import oracle.jdevimpl.runner.profile.VMTypes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class VMMethod
extends VMTypes
implements Comparable {
    public VMClass clazz;
    public int methodDescriptor;
    public String signature;
    public String niceSignature;
    public int firstLine;
    public int lastLine;
    public int callCount;
    public long cumulativeTime;
    public long executionTime;
    public long memoryUsed;
    public char returnType;
    static int compareField;
    static boolean ascending;

    public VMMethod() {
    }

    public VMMethod(VMClass c, String n, String sig, int resultSig) {
        this.clazz = c;
        this.name = n;
        this.signature = sig;
        this.returnType = (char)resultSig;
    }

    @Override
    public void saveToFile(DataOutputStream stream) throws IOException {
        super.saveToFile(stream);
        stream.writeInt(this.methodDescriptor);
        stream.writeInt(this.clazz.classDescriptor);
        stream.writeUTF(this.signature);
        stream.writeInt(this.firstLine);
        stream.writeInt(this.lastLine);
        stream.writeChar(this.returnType);
    }

    void initFromFile(DataInputStream stream, IntHashMap classMap) throws IOException {
        super.initFromFile(stream);
        this.methodDescriptor = stream.readInt();
        this.clazz = (VMClass)classMap.get(stream.readInt());
        this.signature = stream.readUTF();
        this.firstLine = stream.readInt();
        this.lastLine = stream.readInt();
        this.returnType = stream.readChar();
    }

    public static VMMethod readFromFile(DataInputStream stream, IntHashMap classMap) throws IOException {
        VMMethod res = new VMMethod();
        res.initFromFile(stream, classMap);
        return res;
    }

    public String toString() {
        String className = this.clazz.toString();
        if (className.length() > 0) {
            return this.clazz.toString() + "." + this.name;
        }
        return this.name;
    }

    public String getNiceSignature() {
        if (this.niceSignature == null) {
            StringBuffer sres = new StringBuffer();
            StringBuffer carray = new StringBuffer();
            StringBuffer sorg = new StringBuffer(this.signature);
            boolean notdone = true;
            String sep = "";
            while (notdone) {
                char tpe = sorg.charAt(0);
                switch (tpe) {
                    case 'B': 
                    case 'C': 
                    case 'D': 
                    case 'F': 
                    case 'I': 
                    case 'J': 
                    case 'L': 
                    case 'S': 
                    case 'Z': {
                        sres.append(sep);
                        break;
                    }
                }
                switch (tpe) {
                    case '(': 
                    case ')': {
                        sres.append(tpe);
                        break;
                    }
                    case 'L': {
                        sorg.deleteCharAt(0);
                        String strv = new String(sorg);
                        int endpos = strv.indexOf(59);
                        int startpos = strv.lastIndexOf(47, endpos) + 1;
                        sres.append(strv.substring(startpos, endpos));
                        sorg.delete(0, endpos + 1);
                        break;
                    }
                    case '[': {
                        carray.append("[]");
                        break;
                    }
                    case ';': {
                        break;
                    }
                    case 'Z': {
                        sres.append("boolean");
                        break;
                    }
                    case 'B': {
                        sres.append("byte");
                        break;
                    }
                    case 'C': {
                        sres.append("char");
                        break;
                    }
                    case 'S': {
                        sres.append("short");
                        break;
                    }
                    case 'I': {
                        sres.append("int");
                        break;
                    }
                    case 'F': {
                        sres.append("float");
                        break;
                    }
                    case 'J': {
                        sres.append("long");
                        break;
                    }
                    case 'D': {
                        sres.append("double");
                        break;
                    }
                }
                switch (tpe) {
                    case 'L': {
                        sres.append(carray);
                        carray = new StringBuffer();
                        sep = ",";
                        break;
                    }
                    case ')': {
                        notdone = false;
                        break;
                    }
                    case '(': 
                    case '[': {
                        sorg.deleteCharAt(0);
                        break;
                    }
                    case ';': 
                    case 'B': 
                    case 'C': 
                    case 'D': 
                    case 'F': 
                    case 'I': 
                    case 'J': 
                    case 'S': 
                    case 'Z': {
                        sres.append(carray);
                        carray = new StringBuffer();
                        sorg.deleteCharAt(0);
                        sep = ",";
                        break;
                    }
                }
            }
            this.niceSignature = new String(sres);
        }
        return this.niceSignature;
    }

    public int compareTo(Object o) {
        int result;
        VMMethod m = (VMMethod)o;
        switch (compareField) {
            default: {
                result = this.clazz.toString().compareTo(m.clazz.toString());
                break;
            }
            case 1: {
                result = this.name.compareTo(m.name);
                break;
            }
            case 2: {
                result = this.callCount - m.callCount;
                break;
            }
            case 3: {
                result = (int)(this.cumulativeTime - m.cumulativeTime);
                break;
            }
            case 4: {
                result = (int)(this.executionTime - m.executionTime);
                break;
            }
            case 5: {
                result = (int)(this.memoryUsed - m.memoryUsed);
                break;
            }
        }
        if (!ascending) {
            result = 0 - result;
        }
        return result;
    }
}

