/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.run;

import java.awt.Component;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.lang.ref.SoftReference;
import java.net.URL;
import java.util.EventObject;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import oracle.ide.Addin;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeConstants;
import oracle.ide.IdeEvent;
import oracle.ide.IdeListener;
import oracle.ide.compiler.BuildSystemListener;
import oracle.ide.compiler.BuildSystemVetoException;
import oracle.ide.compiler.Compiler;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.Menubar;
import oracle.ide.controls.ToggleAction;
import oracle.ide.exception.SingletonClassException;
import oracle.ide.keyboard.KeyStrokeContextRegistry;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Observer;
import oracle.ide.model.Project;
import oracle.ide.model.ProjectChangeEvent;
import oracle.ide.model.ProjectChangeListener;
import oracle.ide.model.UpdateMessage;
import oracle.ide.model.Workspace;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.runner.RunProcess;
import oracle.ide.runner.Runner;
import oracle.ide.util.ArrayResourceBundle;
import oracle.ide.view.ActiveViewEvent;
import oracle.ide.view.ActiveViewListener;
import oracle.ide.view.View;
import oracle.ide.view.ViewSelectionEvent;
import oracle.ide.view.ViewSelectionListener;
import oracle.ideri.util.Product;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.PropertyStorage;
import oracle.jdeveloper.JDeveloperMenuConstants;
import oracle.jdeveloper.compiler.UnifiedBuildSystem;
import oracle.jdeveloper.runner.RunConfiguration;
import oracle.jdeveloper.runner.RunConfigurations;
import oracle.jdeveloper.runner.RunningProcess;
import oracle.jdevimpl.runner.RunManager;
import oracle.jdevimpl.runner.RunMgrArb;
import oracle.jdevimpl.runner.run.RunArb;

public final class JRunner
implements Controller,
Observer,
Addin,
IdeListener,
ActiveViewListener,
ViewSelectionListener,
BuildSystemListener,
MenuListener {
    private static JRunner instance;
    private View activeView;
    private Project activeProject;
    private static final String RUN_PROJECT_CMD_PREFIX = "RunProjectCommand";
    private static final int RUN_PROJECT_CMD_ID;
    private static IdeAction actionRunProject;
    private static IdeAction actionEmpty;
    private static int[] runProjectCmdIds;
    private static final int RUN_SELECTION_CMD_ID;
    private static IdeAction actionRunSelection;
    private static String actionRunSelectionCategory;
    private static final String RUN_CONTEXT_MENU_CONTEXT = "RunContextMenuContext";
    private static SoftReference<Icon> runContextMenuIcon;
    private static final int RUN_CMD_MRU_CONFIGURATION_ID;
    private static IdeAction actionMRUConfigurationMenuRun;
    public static String MRU_CONFIG_PROJECT_SHORT_NAME;
    public static String MRU_CONFIG_PROJECT_RELATIVE_URL;
    public static String MRU_CONFIG_NAME;
    public static String MRU_RUN_TARGET_URL;
    public static Component runContextMenu;

    public JRunner() throws SingletonClassException {
        if (instance != null) {
            throw new SingletonClassException("oracle.jdevimpl.runner.run.JRunner");
        }
        instance = this;
    }

    public static JRunner getInstance() {
        return instance;
    }

    public static int getContextMenuRunCommandID() {
        return RUN_SELECTION_CMD_ID;
    }

    public void insertRunnableItems(ContextMenu popup, Context context) {
        if (context.getNode() instanceof Project) {
            actionRunSelection.putValue(RUN_CONTEXT_MENU_CONTEXT, null);
            this.update(actionRunProject, context);
            if (actionRunProject.isEnabled()) {
                JMenuItem menuitemContextMenuRun = popup.createMenuItem((ToggleAction)actionRunProject, JDeveloperMenuConstants.WEIGHT_RUN_RUN_PROJECT);
                popup.add((Component)menuitemContextMenuRun, JDeveloperMenuConstants.SECTION_RUN_CTXT_MENU);
            }
        } else {
            actionRunSelection.putValue(RUN_CONTEXT_MENU_CONTEXT, (Object)context);
            this.update(actionRunSelection, context);
            if (actionRunSelection.isEnabled()) {
                JMenuItem menuitemContextMenuRun = popup.createMenuItem((ToggleAction)actionRunSelection, JDeveloperMenuConstants.WEIGHT_RUN_RUN_FILE);
                popup.add((Component)menuitemContextMenuRun, JDeveloperMenuConstants.SECTION_RUN_CTXT_MENU);
            } else {
                actionRunSelection.putValue(RUN_CONTEXT_MENU_CONTEXT, null);
            }
        }
    }

    public boolean handleEvent(IdeAction action, Context context) {
        int cmdId = action.getCommandId();
        if (cmdId == RUN_PROJECT_CMD_ID) {
            this.startMruProcess();
            return true;
        }
        if (cmdId == RUN_CMD_MRU_CONFIGURATION_ID) {
            this.startMruProcess();
            return true;
        }
        if (RunManager.arrayContains(runProjectCmdIds, cmdId)) {
            RunConfiguration runConfiguration = (RunConfiguration)((Object)action.getValue("UserData"));
            RunConfigurations.setActiveRunConfiguration(this.activeProject, runConfiguration);
            this.startProcess(null, true);
            return true;
        }
        if (cmdId == RUN_SELECTION_CMD_ID) {
            if (this.inPopup(context) && action.getValue(RUN_CONTEXT_MENU_CONTEXT) != null) {
                context = (Context)action.getValue(RUN_CONTEXT_MENU_CONTEXT);
            }
            action.putValue(RUN_CONTEXT_MENU_CONTEXT, null);
            Node contextNode = RunProcess.getContextNodeForRun((Context)context);
            if (contextNode != null && !(contextNode instanceof Workspace) && !(contextNode instanceof Project)) {
                context.setProperty(RunProcess.RUN_PROCESS_DO_NOT_CONSIDER_DEFAULT, (Object)Boolean.TRUE);
            }
            this.startProcess(context, false);
            return true;
        }
        return false;
    }

    public static Context prepareMruProcess() {
        Context context = null;
        Workspace currentWorkspace = Ide.getActiveWorkspace();
        if (currentWorkspace != null && Ide.getActiveProject() != null && RunConfigurations.getActiveRunConfiguration(Ide.getActiveProject()) != null) {
            HashStructure userProps = currentWorkspace.getUserPropertiesOnly();
            String projectShortName = null;
            String configName = null;
            String projectRelativeUrl = null;
            String mruTarget = null;
            if (userProps != null) {
                projectShortName = userProps.getString(MRU_CONFIG_PROJECT_SHORT_NAME);
                configName = userProps.getString(MRU_CONFIG_NAME);
                projectRelativeUrl = userProps.getString(MRU_CONFIG_PROJECT_RELATIVE_URL);
                mruTarget = userProps.getString(MRU_RUN_TARGET_URL);
                if (projectShortName != null && configName != null && projectRelativeUrl != null) {
                    context = new Context(Ide.getMainWindow().getLastActiveView().getContext());
                    context.setWorkspace(currentWorkspace);
                    Project runPrj = null;
                    Node node = NodeFactory.find((URL)URLFactory.newURL((URL)URLFileSystem.getParent((URL)currentWorkspace.getURL()), (String)projectRelativeUrl));
                    if (node instanceof Project) {
                        runPrj = (Project)node;
                    }
                    if (runPrj != null && configName.equals(RunConfigurations.getActiveName(runPrj))) {
                        context.setProject(runPrj);
                        Ide.setActiveProject((Project)runPrj);
                        if (mruTarget != null && mruTarget.length() != 0) {
                            Node targetNode = null;
                            URL targetUrl = null;
                            targetUrl = URLFactory.newURL((String)mruTarget);
                            if (targetUrl != null && (targetNode = NodeFactory.find((URL)targetUrl)) != null) {
                                context.setNode(targetNode);
                                context.setProperty(RunProcess.RUN_PROCESS_USE_NODE_FROM_CONTEXT, (Object)RunProcess.RUN_PROCESS_USE_NODE_FROM_CONTEXT);
                            }
                        }
                    } else {
                        context = null;
                    }
                }
            }
        }
        return context;
    }

    private void startMruProcess() {
        Context context = JRunner.prepareMruProcess();
        this.startProcess(context, true);
    }

    public boolean update(IdeAction action, Context context) {
        int cmdId = action.getCommandId();
        if (cmdId == RUN_PROJECT_CMD_ID) {
            this.updateRunProjectAction(action);
            return true;
        }
        if (cmdId == RUN_CMD_MRU_CONFIGURATION_ID) {
            this.updateRunMRUConfigurationAction(action);
            return true;
        }
        if (RunManager.arrayContains(runProjectCmdIds, cmdId)) {
            RunConfiguration runConfiguration = (RunConfiguration)((Object)action.getValue("UserData"));
            action.setState(false);
            return true;
        }
        if (cmdId == RUN_SELECTION_CMD_ID) {
            if (this.inPopup(context) && action.getValue(RUN_CONTEXT_MENU_CONTEXT) != null) {
                actionRunSelection.putValue("Category", null);
                context = (Context)action.getValue(RUN_CONTEXT_MENU_CONTEXT);
                this.updateContextMenuRunAction(action, context);
            } else {
                actionRunSelection.putValue("Category", (Object)actionRunSelectionCategory);
                action.putValue(RUN_CONTEXT_MENU_CONTEXT, null);
                this.updateRunSelectionAction(action, context);
            }
            return true;
        }
        return false;
    }

    public void activeViewChanged(ActiveViewEvent e) {
        if (this.activeView != null) {
            this.activeView.removeViewSelectionListener((ViewSelectionListener)this);
        }
        this.activeView = Ide.getMainWindow().getLastActiveView();
        if (this.activeView != null) {
            this.activeView.addViewSelectionListener((ViewSelectionListener)this);
        }
        this.updateRunActions();
    }

    public void viewSelectionChanged(ViewSelectionEvent e) {
        this.updateRunActions();
    }

    public void update(Object observed, UpdateMessage change) {
        1 runnable = new 1(this, change, observed);
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    public void addinsLoaded(IdeEvent e) {
    }

    public void mainWindowOpened(IdeEvent e) {
        Ide.removeIdeListener((IdeListener)this);
        this.activeViewChanged(null);
        this.activeProjectChanged();
        Ide.getSystem().attach((Observer)this);
        Ide.getMainWindow().addActiveViewListener((ActiveViewListener)this);
        Compiler compiler = Compiler.getCompiler();
        if (compiler != null) {
            compiler.addBuildSystemListener((BuildSystemListener)this);
        }
        Project.addProjectChangeListener((String)"", (ProjectChangeListener)new 2());
    }

    public void mainWindowClosing(IdeEvent e) {
        Ide.getSystem().detach((Observer)this);
        Ide.getMainWindow().removeActiveViewListener((ActiveViewListener)this);
        Compiler compiler = Compiler.getCompiler();
        if (compiler != null) {
            compiler.removeBuildSystemListener((BuildSystemListener)this);
        }
    }

    public void initialize() {
        this.makeActionsAndMenus();
        this.declareShortcuts();
        Runner.getRunner().getRunMenu().addMenuListener(this);
        Ide.addIdeListener((IdeListener)this);
    }

    public void menuCanceled(MenuEvent e) {
    }

    public void menuDeselected(MenuEvent e) {
    }

    public void menuSelected(MenuEvent e) {
        JMenu runMenu;
        Object source = e.getSource();
        if (source == (runMenu = Runner.getRunner().getRunMenu())) {
            runMenu.removeMenuListener(this);
            JRunner.addRunMenuItems(runMenu);
        }
    }

    public void buildWillStart(Context context) throws BuildSystemVetoException {
        SwingUtilities.invokeLater(new 3());
    }

    public void buildFinished(int errorCount, int warningCount, int infoCount) throws BuildSystemVetoException {
        new 4("JRunnerWaitForCompiler").start();
    }

    public void cleanWillStart(Context context) throws BuildSystemVetoException {
    }

    public void cleanFinished(Context context) throws BuildSystemVetoException {
    }

    private void makeActionsAndMenus() {
        JMenu runMenu = Runner.getRunner().getRunMenu();
        String category = runMenu.getText();
        int EMPTY_RUN_PROJECT_CMD_ID = Ide.findOrCreateCmdID((String)"RunProjectCommandEmpty");
        actionEmpty = IdeAction.get((int)EMPTY_RUN_PROJECT_CMD_ID, null, (String)RunMgrArb.getString(33), (String)category, null, null, null, (boolean)false);
        actionRunProject = IdeAction.get((int)RUN_PROJECT_CMD_ID, null, (String)RunArb.getString(8), (String)category, (Integer)RunArb.getInteger(15), (ArrayResourceBundle)RunArb.getInstance(), (int)17, null, (boolean)false);
        actionRunProject.putValue("NoCtxName", (Object)RunArb.getString(8));
        actionRunProject.addController((Controller)this);
        actionRunProject.putValue("ActionMenuActions", (Object)new IdeAction[]{actionEmpty});
        actionRunSelection = IdeAction.get((int)RUN_SELECTION_CMD_ID, null, (String)RunArb.getString(23), (String)category, (Integer)RunArb.getInteger(0), null, null, (boolean)false);
        actionRunSelection.putValue("NoCtxName", (Object)RunArb.getString(23));
        actionRunSelection.addController((Controller)this);
        actionRunSelectionCategory = category;
        actionMRUConfigurationMenuRun = IdeAction.get((int)RUN_CMD_MRU_CONFIGURATION_ID, null, (String)RunMgrArb.getString(33), (String)category, null, null, null, null, (boolean)false);
        actionMRUConfigurationMenuRun.putValue("NoCtxName", (Object)RunArb.getString(8));
        actionMRUConfigurationMenuRun.putValue("Radio", (Object)Boolean.TRUE);
        actionMRUConfigurationMenuRun.addController((Controller)this);
    }

    private static void addRunMenuItems(JMenu runMenu) {
        Menubar menubar = Ide.getMenubar();
        JMenuItem menuRunProject = menubar.createMenuItem((ToggleAction)actionRunProject, JDeveloperMenuConstants.WEIGHT_RUN_RUN_PROJECT);
        if (!Product.isRaptor()) {
            menubar.add((Component)menuRunProject, runMenu, JDeveloperMenuConstants.SECTION_RUN_RUN);
        }
        JMenuItem menuRunSelection = menubar.createMenuItem((ToggleAction)actionRunSelection, JDeveloperMenuConstants.WEIGHT_RUN_RUN_FILE);
        menubar.add((Component)menuRunSelection, runMenu, JDeveloperMenuConstants.SECTION_RUN_RUN);
    }

    private void declareShortcuts() {
        KeyStrokeContextRegistry keyStrokeContextRegistry = Ide.getKeyStrokeContextRegistry();
        keyStrokeContextRegistry.addAcceleratorDefinitionFile(this.getClass().getClassLoader(), "oracle/jdevimpl/runner/run/accelerators.xml");
    }

    private void updateIfVisible(IdeAction action, Context[] context) {
        int cmdId = action.getCommandId();
        if (cmdId == RUN_PROJECT_CMD_ID) {
            if (context[0] == null) {
                context[0] = Ide.getMainWindow().getLastActiveView().getContext();
            }
            this.update(action, context[0]);
        } else if (cmdId == RUN_CMD_MRU_CONFIGURATION_ID) {
            if (context[0] == null) {
                context[0] = Ide.getMainWindow().getLastActiveView().getContext();
            }
            this.update(action, context[0]);
        }
    }

    private void updateRunActions() {
        Context[] context = new Context[1];
        this.updateIfVisible(actionRunProject, context);
        this.updateIfVisible(actionRunSelection, context);
    }

    private String getMRUMenuName() {
        HashStructure userProps;
        Project lastMRUProject = null;
        String shortMruConfigurationLabel = null;
        Workspace currentWorkspace = Ide.getActiveWorkspace();
        if (currentWorkspace != null && (userProps = currentWorkspace.getUserPropertiesOnly()) != null) {
            URL projUrl;
            String projectShortName = userProps.getString(MRU_CONFIG_PROJECT_SHORT_NAME);
            String projectRelativeUrl = userProps.getString(MRU_CONFIG_PROJECT_RELATIVE_URL);
            String configName = userProps.getString(MRU_CONFIG_NAME);
            if (projectShortName != null && projectRelativeUrl != null && configName != null && (projUrl = URLFactory.newURL((URL)URLFileSystem.getParent((URL)currentWorkspace.getURL()), (String)projectRelativeUrl)) != null && URLFileSystem.exists((URL)projUrl)) {
                StringBuilder sb = new StringBuilder();
                sb.append(projectShortName);
                sb.append(":");
                sb.append(configName);
                return sb.toString();
            }
        }
        if (lastMRUProject == null) {
            lastMRUProject = Ide.getActiveProject();
        }
        if (lastMRUProject != null) {
            RunConfiguration activeConfig = RunConfigurations.getActiveRunConfiguration(lastMRUProject);
            if (activeConfig != null) {
                StringBuilder sb = new StringBuilder();
                sb.append(lastMRUProject.getShortLabel());
                sb.append(":");
                sb.append(activeConfig.getName());
                shortMruConfigurationLabel = sb.toString();
            } else {
                shortMruConfigurationLabel = RunMgrArb.getString(33);
            }
        } else {
            shortMruConfigurationLabel = RunMgrArb.getString(33);
        }
        return shortMruConfigurationLabel;
    }

    private void updateRunMRUConfigurationAction(IdeAction action) {
        String mruMenuLabel = this.getMRUMenuName();
        action.setState(true);
        if (RunMgrArb.getString(33).equals(mruMenuLabel)) {
            action.setEnabled(false);
        } else {
            action.setName(mruMenuLabel);
            action.setEnabled(true);
        }
    }

    private Project getMRUProject() {
        Workspace currentWorkspace = Ide.getActiveWorkspace();
        if (currentWorkspace == null) {
            return null;
        }
        HashStructure userProps = currentWorkspace.getUserPropertiesOnly();
        if (userProps != null) {
            Node node;
            String projectShortName = userProps.getString(MRU_CONFIG_PROJECT_SHORT_NAME);
            String configName = userProps.getString(MRU_CONFIG_NAME);
            String projectRelativeUrl = userProps.getString(MRU_CONFIG_PROJECT_RELATIVE_URL);
            if (projectShortName != null && configName != null && projectRelativeUrl != null && (node = NodeFactory.find((URL)URLFactory.newURL((URL)URLFileSystem.getParent((URL)currentWorkspace.getURL()), (String)projectRelativeUrl))) instanceof Project) {
                return (Project)node;
            }
        }
        return null;
    }

    private void updateRunProjectAction(IdeAction action) {
        String name;
        action.setEnabled(this.canStartProcess(null));
        Project mruProject = this.getMRUProject();
        if (mruProject != null) {
            String projectShortLabel = mruProject.getShortLabel();
            name = RunArb.format(6, projectShortLabel);
        } else {
            name = RunArb.getString(8);
        }
        action.putValue("Name", (Object)name);
    }

    private void updateRunSelectionAction(IdeAction action, Context context) {
        String name;
        action.putValue("SmallIcon", null);
        Node node = RunProcess.getContextNodeForRun((Context)context);
        if (node instanceof Project) {
            action.setEnabled(false);
            action.putValue("Name", (Object)RunArb.getString(23));
            return;
        }
        action.setEnabled(this.canStartProcess(context));
        if (node != null && Runner.getRunner().couldNodeBeRunnable(node)) {
            String nodeShortLabel = node.getShortLabel();
            name = RunArb.format(22, nodeShortLabel);
        } else {
            name = RunArb.getString(23);
        }
        action.putValue("Name", (Object)name);
    }

    private void updateContextMenuRunAction(IdeAction action, Context context) {
        action.setEnabled(Runner.getRunner().enableRunDebugActions(context, null) && this.canStartProcess(context));
        action.putValue("Name", (Object)RunArb.getString(2));
        Icon realRunContextMenuIcon = null;
        if (runContextMenuIcon != null) {
            realRunContextMenuIcon = runContextMenuIcon.get();
        }
        if (realRunContextMenuIcon == null) {
            runContextMenuIcon = new SoftReference<Icon>(RunArb.getIcon(1));
            realRunContextMenuIcon = runContextMenuIcon.get();
        }
        action.putValue("SmallIcon", (Object)realRunContextMenuIcon);
    }

    private boolean canStartProcess(Context context) {
        Node node;
        Compiler compiler = Compiler.getCompiler();
        if (compiler != null && compiler.isBusy(null)) {
            return false;
        }
        if (context != null && (node = RunProcess.getContextNodeForRun((Context)context)) instanceof Project && node == context.getProject()) {
            context = null;
        }
        boolean contextOk = false;
        if (context != null) {
            contextOk = this.isContextNodeRunnable(context);
        } else if (Ide.getActiveProject() != null) {
            contextOk = true;
        } else {
            Context activeContext = new Context(Ide.getMainWindow().getLastActiveView().getContext());
            if (activeContext != null) {
                contextOk = this.isContextNodeRunnable(activeContext);
            }
        }
        return contextOk;
    }

    private boolean isContextNodeRunnable(Context context) {
        Node node = RunProcess.getContextNodeForRun((Context)context);
        return node != null && Runner.getRunner().couldNodeBeRunnable(node);
    }

    public void startProcess() {
        System.out.println("Please use oracle.jdeveloper.runner.EmbeddedServer instead of JRunner.startProcess");
        this.startProcess(null, false);
    }

    public void startProcess(Context context, boolean updateMruProperties) {
        RunningProcess runningProcess = this.createRunningProcess(context, updateMruProperties);
        runningProcess.start();
    }

    public static Context prepareProcessContext(Context context, boolean updateMruProperties) {
        Project activeProject;
        HashStructure userProps;
        if (context == null) {
            context = new Context(Ide.getMainWindow().getLastActiveView().getContext());
        }
        if (updateMruProperties && context != null && context.getWorkspace() != null && context.getProject() != null && (userProps = context.getWorkspace().getUserPropertiesOnly()) != null) {
            String projectShortName = userProps.getString(MRU_CONFIG_PROJECT_SHORT_NAME);
            String configName = userProps.getString(MRU_CONFIG_NAME);
            String mruTarget = userProps.getString(MRU_RUN_TARGET_URL);
            if (projectShortName == null || configName == null || !configName.equals(RunConfigurations.getActiveRunConfiguration(Ide.getActiveProject()).getName()) || !projectShortName.equals(Ide.getActiveProject().getShortLabel())) {
                URL targetURL;
                userProps.putString(MRU_CONFIG_PROJECT_SHORT_NAME, context.getProject().getShortLabel());
                userProps.putString(MRU_CONFIG_NAME, RunConfigurations.getActiveName(context.getProject()));
                userProps.putString(MRU_CONFIG_PROJECT_RELATIVE_URL, URLFileSystem.toRelativeSpec((URL)context.getProject().getURL(), (URL)context.getWorkspace().getURL()));
                Node targetNode = context.getNode();
                mruTarget = null;
                if (targetNode != null && (targetURL = targetNode.getURL()) != null) {
                    mruTarget = targetURL.toString();
                }
                userProps.putString(MRU_RUN_TARGET_URL, mruTarget);
                try {
                    context.getWorkspace().saveUserProperties();
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
        }
        if ((activeProject = Ide.getActiveProject()) != null && context != null && RunProcess.getContextNodeForRun((Context)context) == activeProject) {
            context = null;
        }
        if (context != null) {
            Workspace workspace = context.getWorkspace();
            Project project = context.getProject();
            if (workspace == null || project == null) {
                workspace = Ide.getActiveWorkspace();
                project = activeProject;
            }
            context.setWorkspace(workspace);
            context.setProject(project);
        }
        return context;
    }

    private RunningProcess createRunningProcess(Context context, boolean updateMruProperties) {
        Context context2 = JRunner.prepareProcessContext(context, updateMruProperties);
        RunningProcess runningProcess = new RunningProcess(context2);
        return runningProcess;
    }

    private void activeProjectChanged() {
        this.activeProject = Ide.getActiveProject();
        this.updateRunConfigurationList();
        this.updateRunActions();
    }

    private void updateRunConfigurationList() {
        RunConfigurations runConfigurations;
        RunConfiguration[] runConfigs;
        int runConfigsLength;
        IdeAction[] actions = null;
        if (this.activeProject != null && this.activeProject.isOpen() && (runConfigsLength = (runConfigs = (runConfigurations = RunConfigurations.getInstance((PropertyStorage)this.activeProject)).getVisibleRunConfigurations()).length) > 0) {
            runProjectCmdIds = new int[runConfigsLength];
            actions = new IdeAction[runConfigsLength];
            String category = Runner.getRunner().getRunMenu().getText();
            Context context = Ide.getMainWindow().getLastActiveView().getContext();
            int i = 0;
            while (i < runConfigsLength) {
                RunConfiguration runConfiguration = runConfigs[i];
                String name = runConfiguration.getName();
                int cmdId = Ide.findOrCreateCmdID((String)(RUN_PROJECT_CMD_PREFIX + i));
                IdeAction action = IdeAction.get((int)cmdId, null, (String)name, (String)category, null, null, (Object)((Object)runConfiguration), (boolean)true);
                action.putValue("Name", (Object)name);
                action.putValue("UserData", (Object)runConfiguration);
                action.putValue("Radio", (Object)Boolean.TRUE);
                action.addController((Controller)this);
                JRunner.runProjectCmdIds[i] = cmdId;
                actions[i] = action;
                this.update(action, context);
                ++i;
            }
        }
        if (actions == null) {
            runProjectCmdIds = new int[0];
            actions = new IdeAction[]{actionEmpty};
        }
        int i = actions.length;
        IdeAction[] newActions = new IdeAction[i + 2];
        if (actionMRUConfigurationMenuRun != null) {
            newActions = new IdeAction[i + 4];
        }
        System.arraycopy(actions, 0, newActions, 0, i);
        actions = newActions;
        if (actionMRUConfigurationMenuRun != null) {
            actions[i++] = null;
            actions[i++] = actionMRUConfigurationMenuRun;
        }
        actions[i++] = null;
        actions[i++] = RunManager.getManageRunConfigurationsAction();
        actionRunProject.putValue("ActionMenuActions", (Object)actions);
    }

    public Action getActionRunProject() {
        return actionRunProject;
    }

    private boolean inPopup(Context context) {
        if (context.getNode() instanceof Workspace) {
            return false;
        }
        EventObject o = context.getEvent();
        return o instanceof MouseEvent;
    }

    static {
        RUN_PROJECT_CMD_ID = Ide.findOrCreateCmdID((String)RUN_PROJECT_CMD_PREFIX);
        runProjectCmdIds = new int[0];
        RUN_SELECTION_CMD_ID = Ide.findOrCreateCmdID((String)"RunSelectionCommand");
        runContextMenuIcon = null;
        RUN_CMD_MRU_CONFIGURATION_ID = Ide.findOrCreateCmdID((String)"RunMRUConfiguration_ID");
        MRU_CONFIG_PROJECT_SHORT_NAME = "RunMRUConfigProjectShortName";
        MRU_CONFIG_PROJECT_RELATIVE_URL = "RunMRUConfigProjectRelativeUrl";
        MRU_CONFIG_NAME = "RunMRUConfigName";
        MRU_RUN_TARGET_URL = "RunMRUTargetURL";
    }

    static void mav$updateRunActions(JRunner jRunner) {
        jRunner.updateRunActions();
    }

    static Project ra$activeProject(JRunner jRunner) {
        return jRunner.activeProject;
    }

    static void mav$activeProjectChanged(JRunner jRunner) {
        jRunner.activeProjectChanged();
    }

    static void mav$updateRunConfigurationList(JRunner jRunner) {
        jRunner.updateRunConfigurationList();
    }

    final class 1
    implements Runnable {
        private final /* synthetic */ UpdateMessage v$change;
        private final /* synthetic */ Object v$observed;
        final /* synthetic */ JRunner this$0;

        public void run() {
            int messageID = this.v$change.getMessageID();
            if (this.v$observed == Ide.getSystem() && messageID == IdeConstants.ACTIVE_PROJECT_CHANGED) {
                JRunner.mav$activeProjectChanged(this.this$0);
            }
        }

        public 1(JRunner jRunner, UpdateMessage updateMessage, Object object) {
            this.v$observed = object;
            this.v$change = updateMessage;
            this.this$0 = jRunner;
        }
    }

    final class 2
    extends ProjectChangeListener {
        public void projectOpened(Project project) {
            if (project == JRunner.ra$activeProject(JRunner.this)) {
                this.updateNowOrLater();
            }
        }

        public void projectPropertiesChanged(ProjectChangeEvent e) {
            if (e.getProject() == JRunner.ra$activeProject(JRunner.this)) {
                this.updateNowOrLater();
            }
        }

        private void updateNowOrLater() {
            1 runnable = new 1();
            if (SwingUtilities.isEventDispatchThread()) {
                runnable.run();
            } else {
                SwingUtilities.invokeLater(runnable);
            }
        }

        final class 1
        implements Runnable {
            public void run() {
                JRunner.mav$updateRunConfigurationList(JRunner.this);
            }
        }
    }

    final class 3
    implements Runnable {
        public void run() {
            JRunner.mav$updateRunActions(JRunner.this);
        }
    }

    final class 4
    extends Thread {
        public void run() {
            try {
                UnifiedBuildSystem.getInstance().join(0L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            SwingUtilities.invokeLater(new 1());
        }

        public 4(String string) {
            super(string);
        }

        final class 1
        implements Runnable {
            public void run() {
                JRunner.mav$updateRunActions(JRunner.this);
            }
        }
    }
}

