/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.uidebug.debugger;

import java.awt.Component;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import oracle.ide.Addin;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeConstants;
import oracle.ide.IdeMainWindow;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.MenuManager;
import oracle.ide.controller.Menubar;
import oracle.ide.controls.ToggleAction;
import oracle.ide.docking.DockStation;
import oracle.ide.docking.DockUtil;
import oracle.ide.docking.Dockable;
import oracle.ide.docking.DockableFactory;
import oracle.ide.docking.DockableView;
import oracle.ide.docking.DockingParam;
import oracle.ide.keyboard.KeyStrokeContextRegistry;
import oracle.ide.layout.ViewId;
import oracle.ide.model.Observer;
import oracle.ide.model.Project;
import oracle.ide.model.UpdateMessage;
import oracle.ide.util.ArrayResourceBundle;
import oracle.ide.util.BitField;
import oracle.ide.view.View;
import oracle.jdeveloper.JDeveloperMenuConstants;
import oracle.jdevimpl.runner.debug.DbgArb;
import oracle.jdevimpl.runner.uidebug.debugger.Debugger;
import oracle.jdevimpl.runner.uidebug.debugger.DebuggerProcess;
import oracle.jdevimpl.runner.uidebug.debugger.events.DebuggerEvent;
import oracle.jdevimpl.runner.uidebug.debugger.events.DebuggerListener;
import oracle.jdevimpl.runner.uidebug.debugger.events.DebuggerProcessEvent;
import oracle.jdevimpl.runner.uidebug.debugger.events.DebuggerProcessListener;
import oracle.jdevimpl.runner.uidebug.debugger.ui.DebuggerDockable;
import oracle.jdevimpl.runner.uidebug.debugger.ui.DockableListeners;
import oracle.jdevimpl.runner.uidebug.debugger.ui.DockableOutline;
import oracle.jdevimpl.runner.uidebug.debugger.ui.DockableTree;
import oracle.jdevimpl.runner.uidebug.resource.UIDebugArb;

public final class DebuggerAddin
implements Controller,
Addin,
MenuListener,
DockableFactory,
DebuggerListener,
DebuggerProcessListener,
Observer {
    public static final String FACTORY_ID = "UIDebugger";
    private static DebuggerAddin INSTANCE;
    private int VIEW_UIOUTLINE_CMD_ID;
    IdeAction VIEW_UIOUTLINE_ACTION;
    private int VIEW_UITREE_CMD_ID;
    IdeAction VIEW_UITREE_ACTION;
    private int VIEW_UILISTENERS_CMD_ID;
    IdeAction VIEW_UILISTENERS_ACTION;
    private int RUN_UIDEBUG_CMD_ID;
    IdeAction RUN_UIDEBUG_ACTION;
    private Project _activeProject;
    private DebuggerDockable _outline;
    private DebuggerDockable _tree;
    private DebuggerDockable _listeners;

    public DebuggerAddin() {
        INSTANCE = this;
    }

    public static DebuggerAddin getInstance() {
        return INSTANCE;
    }

    private void updateStartMenu() {
        if (SwingUtilities.isEventDispatchThread()) {
            IdeMainWindow mainWindow = Ide.getMainWindow();
            View activeView = mainWindow.getLastActiveView();
            Context context = activeView.getContext();
            this.update(this.RUN_UIDEBUG_ACTION, context);
        } else {
            SwingUtilities.invokeLater(new 1());
        }
    }

    public void initialize() {
        DockStation.getDockStation().registerDockableFactory(FACTORY_ID, (DockableFactory)this);
        KeyStrokeContextRegistry keyStrokeContextRegistry = Ide.getKeyStrokeContextRegistry();
        keyStrokeContextRegistry.addAcceleratorDefinitionFile(this.getClass().getClassLoader(), "oracle/jdevimpl/runner/uidebug/debugger/accelerators.xml");
        Debugger.getInstance().addDebuggerListener(this);
        this.createActions();
        Ide.getSystem().attach((Observer)this);
    }

    private void createActions() {
        this.VIEW_UIOUTLINE_CMD_ID = Ide.findOrCreateCmdID((String)"VIEW_UIOUTLINE_CMD_ID");
        this.VIEW_UIOUTLINE_ACTION = this.createViewAction(38, this.VIEW_UIOUTLINE_CMD_ID, 26, 35);
        this.VIEW_UITREE_CMD_ID = Ide.findOrCreateCmdID((String)"VIEW_UITREE_CMD_ID");
        this.VIEW_UITREE_ACTION = this.createViewAction(10, this.VIEW_UITREE_CMD_ID, 0, 33);
        this.VIEW_UILISTENERS_CMD_ID = Ide.findOrCreateCmdID((String)"VIEW_UILISTENERS_CMD_ID");
        this.VIEW_UILISTENERS_ACTION = this.createViewAction(57, this.VIEW_UILISTENERS_CMD_ID, 56, 9);
        String ACTION_CATEGORY_DEBUG = DbgArb.getString(171);
        this.RUN_UIDEBUG_CMD_ID = Ide.findOrCreateCmdID((String)"RUN_UIDEBUG_CMD_ID");
        this.RUN_UIDEBUG_ACTION = IdeAction.get((int)this.RUN_UIDEBUG_CMD_ID, null, (String)UIDebugArb.getString(34), (String)ACTION_CATEGORY_DEBUG, (Integer)UIDebugArb.getInteger(42), (ArrayResourceBundle)UIDebugArb.getInstance(), (int)7, null, (boolean)true);
        this.RUN_UIDEBUG_ACTION.putValue("NoCtxName", (Object)UIDebugArb.getString(8));
        this.RUN_UIDEBUG_ACTION.addController((Controller)this);
        Menubar menubar = Ide.getMenubar();
        JMenuItem runUiDebug = menubar.createMenuItem((ToggleAction)this.RUN_UIDEBUG_ACTION, JDeveloperMenuConstants.WEIGHT_DEBUG_UI_DEBUG_PROJECT);
        JMenu menuView = menubar.createSubMenu(UIDebugArb.getString(28), UIDebugArb.getInteger(36), JDeveloperMenuConstants.WEIGHT_VIEW_UI_DEBUGGER);
        menuView.addMenuListener(this);
        menubar.add((Component)menuView, MenuManager.getJMenu((String)"View"), JDeveloperMenuConstants.SECTION_VIEW_DEBUG_RUN);
        JMenu debugMenu = oracle.ide.runner.Debugger.getDebugger().getDebugMenu();
        menubar.add((Component)runUiDebug, debugMenu, JDeveloperMenuConstants.SECTION_DEBUG_UI_DEBUG);
    }

    private IdeAction createViewAction(int lblID, int cmdID, int mnemoID, int iconID) {
        String lblView = UIDebugArb.getString(lblID);
        IdeAction action = IdeAction.get((int)cmdID, null, (String)lblView, (String)IdeMainWindow.ACTION_CATEGORY_VIEW, (Integer)UIDebugArb.getInteger(mnemoID), (ArrayResourceBundle)UIDebugArb.getInstance(), (int)iconID, null, (boolean)true);
        action.putValue("NoCtxName", (Object)UIDebugArb.format(27, lblView));
        action.addController((Controller)this);
        return action;
    }

    private void expandViewMenu(JMenu menuView) {
        Menubar menubar = Ide.getMenubar();
        menuView.removeMenuListener(this);
        boolean isProcessConnected = Debugger.getInstance().getActiveDebuggerProcess() != null;
        this.VIEW_UIOUTLINE_ACTION.setEnabled(isProcessConnected);
        this.VIEW_UITREE_ACTION.setEnabled(isProcessConnected);
        this.VIEW_UILISTENERS_ACTION.setEnabled(isProcessConnected);
        JMenuItem viewOutline = menubar.createMenuItem((ToggleAction)this.VIEW_UIOUTLINE_ACTION);
        JMenuItem viewTree = menubar.createMenuItem((ToggleAction)this.VIEW_UITREE_ACTION);
        JMenuItem viewListeners = menubar.createMenuItem((ToggleAction)this.VIEW_UILISTENERS_ACTION);
        menuView.add(viewOutline);
        menuView.add(viewTree);
        menuView.add(viewListeners);
    }

    public boolean handleEvent(IdeAction action, Context context) {
        if (action == this.VIEW_UIOUTLINE_ACTION) {
            DockUtil.showDockableWindow((DockableView)this.getOutline());
            return true;
        }
        if (action == this.VIEW_UITREE_ACTION) {
            DockUtil.showDockableWindow((DockableView)this.getTree());
            return true;
        }
        if (action == this.VIEW_UILISTENERS_ACTION) {
            DockUtil.showDockableWindow((DockableView)this.getListeners());
            return true;
        }
        if (action == this.RUN_UIDEBUG_ACTION) {
            DebuggerAddin.runUIDebug();
            return true;
        }
        return false;
    }

    public boolean update(IdeAction action, Context context) {
        int commandId = action.getCommandId();
        if (commandId == this.VIEW_UIOUTLINE_CMD_ID) {
            DebuggerDockable dockable = this.getOutline();
            DebuggerAddin.updateView(action);
        } else if (commandId == this.VIEW_UITREE_CMD_ID) {
            DebuggerDockable dockable = this.getTree();
            DebuggerAddin.updateView(action);
        } else if (commandId == this.VIEW_UILISTENERS_CMD_ID) {
            DebuggerDockable dockable = this.getListeners();
            DebuggerAddin.updateView(action);
        } else if (commandId == this.RUN_UIDEBUG_CMD_ID) {
            String name;
            if (this._activeProject != null) {
                String projectShortLabel = this._activeProject.getShortLabel();
                name = UIDebugArb.format(34, projectShortLabel);
                int processCount = Debugger.getInstance().getDebuggerProcessCount();
                action.setEnabled(processCount == 0);
            } else {
                name = UIDebugArb.getString(8);
                action.setEnabled(false);
            }
            action.putValue("Name", (Object)name);
        } else {
            return false;
        }
        return true;
    }

    private static void updateView(IdeAction action) {
        boolean isProcessConnected = Debugger.getInstance().getActiveDebuggerProcess() != null;
        action.setEnabled(isProcessConnected);
    }

    private static boolean runUIDebug() {
        if (Ide.getActiveWorkspace() != null && Ide.getActiveProject() != null) {
            Debugger.startUIDebugger(null);
        }
        return true;
    }

    public void update(Object observed, UpdateMessage change) {
        int messageID = change.getMessageID();
        if (observed == Ide.getSystem()) {
            if (messageID == IdeConstants.ACTIVE_PROJECT_CHANGED) {
                if (this._activeProject != null) {
                    this._activeProject.detach((Observer)this);
                }
                this._activeProject = Ide.getActiveProject();
                if (this._activeProject != null) {
                    this._activeProject.attach((Observer)this);
                }
                this.updateStartMenu();
            }
        } else if (observed instanceof Project && messageID == UpdateMessage.PROPERTY_SET) {
            this.updateStartMenu();
        }
    }

    public Dockable getDockable(ViewId viewId) {
        DebuggerDockable ret = null;
        String name = viewId.getName();
        if ("OUTLINE".equals(name)) {
            ret = this.getOutline();
        } else if ("TREE".equals(name)) {
            ret = this.getTree();
        } else if ("LISTENERS".equals(name)) {
            ret = this.getListeners();
        }
        return ret;
    }

    public void install() {
        DockStation ds = DockStation.getDockStation();
        DebuggerDockable tree = this.getTree();
        DockingParam dockingParam = new DockingParam();
        dockingParam.setPosition(1);
        ds.dock((Dockable)tree, dockingParam);
        DebuggerDockable outline = this.getOutline();
        DockingParam dockingParam2 = new DockingParam();
        dockingParam2.setPosition((Dockable)tree, 3);
        ds.dock((Dockable)outline, dockingParam2);
        DebuggerDockable listeners = this.getListeners();
        DockingParam dockingParam3 = new DockingParam();
        dockingParam3.setPosition((Dockable)outline, 3);
        ds.dock((Dockable)listeners, dockingParam3);
    }

    private DebuggerDockable getOutline() {
        if (this._outline == null) {
            this._outline = new DockableOutline();
        }
        return this._outline;
    }

    private DebuggerDockable getTree() {
        if (this._tree == null) {
            this._tree = new DockableTree();
        }
        return this._tree;
    }

    public DebuggerDockable getListeners() {
        if (this._listeners == null) {
            this._listeners = new DockableListeners();
        }
        return this._listeners;
    }

    public void debuggerProcessActivated(DebuggerEvent event) {
    }

    public void debuggerProcessCreated(DebuggerEvent event) {
        DebuggerProcess debuggerProcess = event.getDebuggerProcess();
        debuggerProcess.addDebuggerProcessListener(this);
    }

    public void debuggerProcessDied(DebuggerEvent event) {
        if (Debugger.getInstance().getDebuggerProcessCount() == 1) {
            DockStation ds = DockStation.getDockStation();
            ds.setDockableVisible(DockableListeners.getViewID(), false);
            ds.setDockableVisible(DockableOutline.getViewID(), false);
            ds.setDockableVisible(DockableTree.getViewID(), false);
            event.getDebuggerProcess().removeDebuggerProcessListener(this);
        }
    }

    public void rootChanging(DebuggerProcessEvent event) {
    }

    public void rootChanged(DebuggerProcessEvent event) {
    }

    public void stateChanged(DebuggerProcessEvent event) {
        if (BitField.isSet((int)event.getStateMask(), (int)1)) {
            DebuggerProcess debuggerProcess = event.getSource();
            debuggerProcess.removeDebuggerProcessListener(this);
            this.getTree().show();
            this.getOutline().show();
        }
    }

    public void menuCanceled(MenuEvent e) {
    }

    public void menuDeselected(MenuEvent e) {
    }

    public void menuSelected(MenuEvent e) {
        JMenu menuView = (JMenu)e.getSource();
        if (menuView.getComponentCount() == 0) {
            this.expandViewMenu(menuView);
        }
    }

    static void mav$updateStartMenu(DebuggerAddin debuggerAddin) {
        debuggerAddin.updateStartMenu();
    }

    final class 1
    implements Runnable {
        public void run() {
            DebuggerAddin.mav$updateStartMenu(DebuggerAddin.this);
        }
    }
}

