/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.uidebug.debugger;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.EOFException;
import java.io.IOException;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.model.Node;
import oracle.ide.util.BitField;
import oracle.jdevimpl.debugger.shared.DebugShared;
import oracle.jdevimpl.debugger.support.DebugClassInfo;
import oracle.jdevimpl.debugger.support.DebugConnectArg;
import oracle.jdevimpl.debugger.support.DebugConnector;
import oracle.jdevimpl.debugger.support.DebugLocation;
import oracle.jdevimpl.debugger.support.DebugMethodInfo;
import oracle.jdevimpl.debugger.support.DebugVirtualMachine;
import oracle.jdevimpl.runner.debug.DebuggingProcess;
import oracle.jdevimpl.runner.debug.EvaluatorItem;
import oracle.jdevimpl.runner.debug.JDebugger;
import oracle.jdevimpl.runner.debug.RunWhilePaused;
import oracle.jdevimpl.runner.uidebug.comm.DebugStream;
import oracle.jdevimpl.runner.uidebug.comm.DebugStreamFactory;
import oracle.jdevimpl.runner.uidebug.debugger.Debugger;
import oracle.jdevimpl.runner.uidebug.debugger.ReceiveQueue;
import oracle.jdevimpl.runner.uidebug.debugger.Request;
import oracle.jdevimpl.runner.uidebug.debugger.UIDebugConnectArg;
import oracle.jdevimpl.runner.uidebug.debugger.events.DebuggerProcessEvent;
import oracle.jdevimpl.runner.uidebug.debugger.events.DebuggerProcessListener;
import oracle.jdevimpl.runner.uidebug.debugger.model.XComponent;
import oracle.jdevimpl.runner.uidebug.debugger.reply.ListenerMessage;
import oracle.jdevimpl.runner.uidebug.debugger.reply.RepFullTree;
import oracle.jdevimpl.runner.uidebug.debugger.reply.Reply;
import oracle.jdevimpl.runner.uidebug.debugger.ui.ComponentDetail;
import oracle.jdevimpl.runner.uidebug.debugger.ui.ComponentOutline;
import oracle.jdevimpl.runner.uidebug.debugger.ui.ComponentTree;
import oracle.jdevimpl.runner.uidebug.debugger.ui.ListenersOutput;
import oracle.jdevimpl.runner.uidebug.resource.UIDebugArb;

public final class DebuggerProcess
extends DebuggingProcess {
    public static final int STATE_ACTIVE = 1;
    public static final int STATE_PAUSED = 2;
    private static final int STATE_STARTED = 256;
    private DebugStream _stream;
    private final ReceiveQueue _receiveQueue;
    private final LinkedList _pendingReplies;
    private final ArrayList _references;
    private DebugConnectArg _host;
    private int _stateMask;
    private final DefaultMutableTreeNode _root;
    private XComponent _selection;
    private final ArrayList _selListeners;
    public static final String SELECTION_PROPERTY = "SELECTION";
    private final ArrayList _listeners;
    private ComponentTree _tree;
    private ComponentDetail _detail;
    private ComponentOutline _outline;
    private ListenersOutput _listenerOutput;
    private DebugConnectArg _uiDebugRemotePort;

    private void $init$() {
        this._receiveQueue = new ReceiveQueue();
        this._pendingReplies = new LinkedList();
        this._references = new ArrayList(50);
        this._root = new DefaultMutableTreeNode();
        this._selListeners = new ArrayList(3);
        this._listeners = new ArrayList(3);
    }

    DebuggerProcess(Context context) {
        super(context, null);
        this.$init$();
    }

    protected void checkCommands() {
        super.checkCommands();
        this.updateState();
    }

    private void updateState() {
        int newState = this._stateMask & 0x100 | (BitField.isSet((int)this._stateMask, (int)256) ? 1 : 0) | (this.canPause() ? 0 : 2);
        if (newState != this._stateMask) {
            this._stateMask = newState;
            DebuggerProcessEvent e = new DebuggerProcessEvent(this, 2, this._stateMask);
            this.fireDebuggerProcessEvent(e);
        }
    }

    public String getProcessLabelPrefix() {
        return UIDebugArb.getString(17);
    }

    public Icon getIcon() {
        return UIDebugArb.getIcon(7);
    }

    public boolean canRun(String runType, Object cookie, Node node, List errors) {
        if ("Java".equals(runType)) {
            if ("Embedded Server".equals(cookie)) {
                errors.add(UIDebugArb.format(43, node.getShortLabel()));
                return false;
            }
            return true;
        }
        if ("Database".equals(runType)) {
            errors.add(UIDebugArb.format(45, node.getShortLabel()));
            return false;
        }
        if ("XSLT".equals(runType)) {
            errors.add(UIDebugArb.format(54, node.getShortLabel()));
            return false;
        }
        if ("XQuery".equals(runType)) {
            errors.add(UIDebugArb.format(3, node.getShortLabel()));
            return false;
        }
        return false;
    }

    public Object getValue(String runType, Object cookie, String key) {
        if ("Java".equals(runType)) {
            if ("ClassPath".equals(key)) {
                return this.getClassPath();
            }
            if ("LastJavaCommandOptions".equals(key)) {
                return this.getLastJavaCommandOptions();
            }
        }
        return super.getValue(runType, cookie, key);
    }

    private String getClassPath() {
        String ret = Ide.getLibDirectory() + "jdev-remote.jar";
        return ret;
    }

    private String[] getLastJavaCommandOptions() {
        String[] args = new String[]{"oracle.jdevimpl.runner.uidebug.debuggee.Debuggee", "-silent"};
        return args;
    }

    protected boolean startTarget() {
        boolean ret = super.startTarget();
        if (ret) {
            DebuggerThread thread = new DebuggerThread();
            thread.start();
        }
        return ret;
    }

    public void finished() {
        super.finished();
        this._stateMask = BitField.unset((int)this._stateMask, (int)256);
        this.updateState();
    }

    protected DebugConnectArg[] getDebugConnectArgs(DebugConnector connector) {
        DebugConnectArg[] superArgs = super.getDebugConnectArgs(connector);
        this._host = DebugShared.findConnectArg(superArgs, "hostname");
        this._uiDebugRemotePort = new UIDebugConnectArg();
        DebugConnectArg[] myArgs = new DebugConnectArg[superArgs.length + 1];
        System.arraycopy(superArgs, 0, myArgs, 0, superArgs.length);
        myArgs[superArgs.length] = this._uiDebugRemotePort;
        return myArgs;
    }

    public ReceiveQueue getReceiveQueue() {
        return this._receiveQueue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pushRequest(Request req) {
        try {
            if (req.isWaitForReply()) {
                LinkedList linkedList = this._pendingReplies;
                synchronized (linkedList) {
                    this._pendingReplies.addLast(req);
                }
            }
            this._stream.writeInt(req.getRequestID());
            req.write(this._stream);
            this._stream.flush();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void invokeWhilePaused(Runnable runnable) {
        this.runWhilePaused(new DoWhilePaused(runnable));
    }

    public void addWatch(XComponent xComponent) {
        this.runAfterPaused(new DoWhilePaused(xComponent, 1));
    }

    public void addInspect(XComponent xComponent) {
        this.runAfterPaused(new DoWhilePaused(xComponent, 2));
    }

    public void whenShowSourceFile(XComponent xComponent) {
        this.runWhilePaused(new DoWhilePaused(xComponent, 3));
    }

    public void whenShowSourceFile(DebugMethodInfo method) {
        this.runWhilePaused(new DoWhilePaused(method));
    }

    public ComponentDetail getDetail() {
        if (this._detail == null) {
            this._detail = new ComponentDetail(this);
        }
        return this._detail;
    }

    public boolean isDetailCreated() {
        return this._detail != null;
    }

    public ComponentOutline getOutline() {
        if (this._outline == null) {
            this._outline = new ComponentOutline(this);
        }
        return this._outline;
    }

    public boolean isOutlineCreated() {
        return this._outline != null;
    }

    public ComponentTree getTree() {
        if (this._tree == null) {
            this._tree = new ComponentTree(this);
        }
        return this._tree;
    }

    public boolean isTreeCreated() {
        return this._tree != null;
    }

    public ListenersOutput getListenerOutput() {
        if (this._listenerOutput == null) {
            this._listenerOutput = new ListenersOutput(this);
        }
        return this._listenerOutput;
    }

    public boolean isListenerOutputCreated() {
        return this._listenerOutput != null;
    }

    public void addDebuggerProcessListener(DebuggerProcessListener l) {
        this._listeners.add(l);
    }

    public void removeDebuggerProcessListener(DebuggerProcessListener l) {
        this._listeners.remove(l);
    }

    public void fireDebuggerProcessEvent(DebuggerProcessEvent e) {
        if (SwingUtilities.isEventDispatchThread()) {
            ArrayList listenersCopy = (ArrayList)this._listeners.clone();
            int n = listenersCopy.size();
            int i = 0;
            while (i < n) {
                DebuggerProcessListener l = (DebuggerProcessListener)listenersCopy.get(i);
                switch (e.getEventID()) {
                    case 0: {
                        l.rootChanging(e);
                        break;
                    }
                    case 1: {
                        l.rootChanged(e);
                        break;
                    }
                    case 2: {
                        l.stateChanged(e);
                        break;
                    }
                }
                ++i;
            }
        } else {
            SwingUtilities.invokeLater(new 1(this, e));
        }
    }

    public TreeNode getWindowsRoot() {
        return this._root;
    }

    public int getStateMask() {
        return this._stateMask;
    }

    public XComponent getSelection() {
        return this._selection;
    }

    public void setSelection(XComponent selection) {
        if (this._selection != selection) {
            PropertyChangeEvent e = new PropertyChangeEvent(this, SELECTION_PROPERTY, this._selection, selection);
            this._selection = selection;
            this.fireSelectionChangeEvent(e);
        }
    }

    public void addSelectionListener(PropertyChangeListener l) {
        this._selListeners.add(l);
    }

    public void removeSelectionListener(PropertyChangeListener l) {
        this._selListeners.remove(l);
    }

    private void fireSelectionChangeEvent(PropertyChangeEvent e) {
        int n = this._selListeners.size();
        int i = 0;
        while (i < n) {
            PropertyChangeListener l = (PropertyChangeListener)this._selListeners.get(i);
            l.propertyChange(e);
            ++i;
        }
    }

    public XComponent searchReference(int reference) {
        XComponent xComponent = null;
        if (reference < this._references.size()) {
            xComponent = (XComponent)this._references.get(reference);
        }
        return xComponent;
    }

    public XComponent findReference(int reference) {
        XComponent xComponent = this.searchReference(reference);
        if (xComponent == null) {
            xComponent = new XComponent(reference);
            this._references.ensureCapacity(reference + 1);
            int i = this._references.size() - 1;
            while (i < reference) {
                this._references.add(null);
                ++i;
            }
            this._references.set(reference, xComponent);
        }
        return xComponent;
    }

    public ArrayList filter(String listenerInterface, String listenerClass) {
        ArrayList<DebugMethodInfo> ret = new ArrayList<DebugMethodInfo>();
        List tracingIncludeList = this.getTracingIncludeList();
        List tracingExcludeList = this.getTracingExcludeList();
        DebugClassInfo interfaceInfo = this.vm.findFirstClassByName(listenerInterface);
        DebugMethodInfo[] interfaceMethods = interfaceInfo.getMethods();
        DebugClassInfo classInfo = this.vm.findFirstClassByName(listenerClass);
        int i = 0;
        while (i < interfaceMethods.length) {
            DebugMethodInfo interfaceMethod = interfaceMethods[i];
            DebugClassInfo declaringClass = classInfo;
            DebugMethodInfo matchingMethod = null;
            while (matchingMethod == null && declaringClass != null && this.isInTracing(declaringClass, tracingIncludeList, tracingExcludeList)) {
                DebugMethodInfo[] classMethods = declaringClass.getMethods();
                int j = 0;
                while (j < classMethods.length) {
                    int[] methodLineRange;
                    DebugMethodInfo classMethod = classMethods[j];
                    if (interfaceMethod.getNameWithoutClass().equals(classMethod.getNameWithoutClass()) && (methodLineRange = classMethod.getMethodLineRange()) != null && methodLineRange[0] != methodLineRange[1]) {
                        matchingMethod = classMethod;
                    }
                    ++j;
                }
                declaringClass = declaringClass.getSuperClass(1);
            }
            if (matchingMethod != null) {
                ret.add(matchingMethod);
            }
            ++i;
        }
        return ret;
    }

    private boolean isInTracing(DebugClassInfo declaringClass, List tracingIncludeList, List tracingExcludeList) {
        String className = declaringClass.getName();
        return DebugShared.isClassOrPackageDebuggable(className, tracingIncludeList, tracingExcludeList);
    }

    static DebugConnectArg ra$_host(DebuggerProcess debuggerProcess) {
        return debuggerProcess._host;
    }

    static DebugConnectArg ra$_uiDebugRemotePort(DebuggerProcess debuggerProcess) {
        return debuggerProcess._uiDebugRemotePort;
    }

    static void wa$_stream(DebuggerProcess debuggerProcess, DebugStream debugStream) {
        debuggerProcess._stream = debugStream;
    }

    static DebugStream ra$_stream(DebuggerProcess debuggerProcess) {
        return debuggerProcess._stream;
    }

    static LinkedList ra$_pendingReplies(DebuggerProcess debuggerProcess) {
        return debuggerProcess._pendingReplies;
    }

    static ReceiveQueue ra$_receiveQueue(DebuggerProcess debuggerProcess) {
        return debuggerProcess._receiveQueue;
    }

    static int ra$_stateMask(DebuggerProcess debuggerProcess) {
        return debuggerProcess._stateMask;
    }

    static void wa$_stateMask(DebuggerProcess debuggerProcess, int n) {
        debuggerProcess._stateMask = n;
    }

    static void mav$updateState(DebuggerProcess debuggerProcess) {
        debuggerProcess.updateState();
    }

    static void mav$showSourceFile(DebuggerProcess debuggerProcess, DebugLocation debugLocation, boolean bl) {
        debuggerProcess.showSourceFile(debugLocation, bl);
    }

    static DebugVirtualMachine ra$vm(DebuggerProcess debuggerProcess) {
        return debuggerProcess.vm;
    }

    static void mav$showSourceFile(DebuggerProcess debuggerProcess, DebugClassInfo debugClassInfo) {
        debuggerProcess.showSourceFile(debugClassInfo);
    }

    final class 1
    implements Runnable {
        private final /* synthetic */ DebuggerProcessEvent v$e;
        final /* synthetic */ DebuggerProcess this$0;

        public void run() {
            this.this$0.fireDebuggerProcessEvent(this.v$e);
        }

        public 1(DebuggerProcess debuggerProcess, DebuggerProcessEvent debuggerProcessEvent) {
            this.v$e = debuggerProcessEvent;
            this.this$0 = debuggerProcess;
        }
    }

    private final class DebuggerThread
    extends Thread {
        public DebuggerThread() {
            super("UI-ProcessDebugger");
            this.setDaemon(true);
        }

        public void run() {
            if (this.createConnection()) {
                Debugger.getInstance().addDebugProcess(DebuggerProcess.this);
                DebuggerProcess.wa$_stateMask(DebuggerProcess.this, BitField.set((int)DebuggerProcess.ra$_stateMask(DebuggerProcess.this), (int)256));
                DebuggerProcess.mav$updateState(DebuggerProcess.this);
                this.runRequestLoop();
            }
            Debugger.getInstance().removeDebugProcess(DebuggerProcess.this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void runRequestLoop() {
            try {
                while (true) {
                    int nID = DebuggerProcess.ra$_stream(DebuggerProcess.this).readInt();
                    int nReqType = DebuggerProcess.ra$_stream(DebuggerProcess.this).readInt();
                    Reply reply = null;
                    LinkedList linkedList = DebuggerProcess.ra$_pendingReplies(DebuggerProcess.this);
                    synchronized (linkedList) {
                        Iterator iterator = DebuggerProcess.ra$_pendingReplies(DebuggerProcess.this).iterator();
                        while (iterator.hasNext()) {
                            Reply pendingReply = (Reply)iterator.next();
                            if (pendingReply.getRequestID() != nID) continue;
                            reply = pendingReply;
                            iterator.remove();
                            break;
                        }
                    }
                    if (reply == null) {
                        switch (nReqType) {
                            case 1: {
                                reply = new RepFullTree(nID);
                                break;
                            }
                            case 100: {
                                reply = new ListenerMessage(nID);
                                break;
                            }
                            default: {
                                System.err.println("Invalid request ID:" + nReqType);
                            }
                        }
                    }
                    if (reply == null) continue;
                    Reply finalReply = reply;
                    DebugStream finalStream = DebuggerProcess.ra$_stream(DebuggerProcess.this);
                    ReceiveQueue finalReceiveQueue = DebuggerProcess.ra$_receiveQueue(DebuggerProcess.this);
                    1 runnable = new 1(this, finalReply, finalStream, finalReceiveQueue);
                    SwingUtilities.invokeAndWait(runnable);
                }
            }
            catch (SocketException ex) {
            }
            catch (EOFException ex) {
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }

        private boolean createConnection() {
            InetAddress host;
            try {
                String hostName = DebuggerProcess.ra$_host(DebuggerProcess.this) == null || DebuggerProcess.ra$_host(DebuggerProcess.this).getValue() == null || DebuggerProcess.ra$_host(DebuggerProcess.this).getValue().length() == 0 ? "127.0.0.1" : DebuggerProcess.ra$_host(DebuggerProcess.this).getValue();
                host = InetAddress.getByName(hostName);
            }
            catch (UnknownHostException e) {
                System.err.println(e.getLocalizedMessage());
                boolean bl = false;
                return bl;
            }
            int port = 4030;
            if (DebuggerProcess.ra$_uiDebugRemotePort(DebuggerProcess.this) != null) {
                try {
                    port = Integer.parseInt(DebuggerProcess.ra$_uiDebugRemotePort(DebuggerProcess.this).getValue());
                }
                catch (NumberFormatException e) {
                    System.err.println(e.getLocalizedMessage());
                    boolean bl = false;
                    return bl;
                }
            }
            int i = 0;
            while (i < 5) {
                DebuggerProcess.wa$_stream(DebuggerProcess.this, DebugStreamFactory.createClientSocket((InetAddress)host, (int)port));
                if (DebuggerProcess.ra$_stream(DebuggerProcess.this) != null) break;
                try {
                    DebuggerThread.sleep(2048L);
                }
                catch (InterruptedException ex) {
                    // empty catch block
                }
                ++i;
            }
            return DebuggerProcess.ra$_stream(DebuggerProcess.this) != null;
        }

        final class 1
        implements Runnable {
            private final /* synthetic */ Reply v$finalReply;
            private final /* synthetic */ DebugStream v$finalStream;
            private final /* synthetic */ ReceiveQueue v$finalReceiveQueue;
            final /* synthetic */ DebuggerThread this$0;

            public void run() {
                try {
                    this.v$finalReply.readReply(this.v$finalStream);
                    this.v$finalReceiveQueue.fireReplyEvent(this.v$finalReply);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }

            public 1(DebuggerThread debuggerThread, Reply reply, DebugStream debugStream, ReceiveQueue receiveQueue) {
                this.v$finalReceiveQueue = receiveQueue;
                this.v$finalStream = debugStream;
                this.v$finalReply = reply;
                this.this$0 = debuggerThread;
            }
        }
    }

    private final class DoWhilePaused
    implements RunWhilePaused {
        private static final int DO_WATCH = 1;
        private static final int DO_INSPECT = 2;
        private static final int DO_GOTO_CLASS_SOURCE = 3;
        private static final int DO_GOTO_METHOD_SOURCE = 4;
        private static final int DO_INVOKE_WHILE_PAUSED = 5;
        private final int _doWhat;
        private XComponent _xComponent;
        private String _className;
        private DebugMethodInfo _methodInfo;
        private Runnable _runnable;

        private void $init$() {
            this._xComponent = null;
        }

        public DoWhilePaused(XComponent xComponent, int doWhat) {
            this.$init$();
            this._xComponent = xComponent;
            this._doWhat = doWhat;
        }

        public DoWhilePaused(String className) {
            this.$init$();
            this._className = className;
            this._doWhat = 3;
        }

        public DoWhilePaused(DebugMethodInfo methodInfo) {
            this.$init$();
            this._methodInfo = methodInfo;
            this._doWhat = 4;
        }

        public DoWhilePaused(Runnable runnable) {
            this.$init$();
            this._runnable = runnable;
            this._doWhat = 5;
        }

        public void run(DebuggingProcess debuggingProcess, boolean live) {
            switch (this._doWhat) {
                case 1: {
                    this.doWatch(live);
                    break;
                }
                case 2: {
                    this.doInspect(live);
                    break;
                }
                case 3: {
                    this.doGoToClassSource(live);
                    break;
                }
                case 4: {
                    this.doGoToMethodSource(live);
                    break;
                }
                case 5: {
                    this._runnable.run();
                    break;
                }
            }
        }

        private void doWatch(boolean live) {
            if (live) {
                String expression = "oracle.jdevimpl.runner.uidebug.debuggee.References.INSTANCE._list.elementData[" + this._xComponent.getID() + "].referent";
                EvaluatorItem evaluatorItem = new EvaluatorItem(expression);
                evaluatorItem.setOptions(this._xComponent.toString(), false, DebuggerProcess.this);
                JDebugger debugger = JDebugger.getInstance();
                debugger.addWatch(evaluatorItem);
            }
        }

        private void doInspect(boolean live) {
            if (live) {
                String expression = "oracle.jdevimpl.runner.uidebug.debuggee.References.INSTANCE._list.elementData[" + this._xComponent.getID() + "].referent";
                EvaluatorItem evaluatorItem = new EvaluatorItem(expression);
                evaluatorItem.setOptions(this._xComponent.toString(), false, DebuggerProcess.this);
                JDebugger debugger = JDebugger.getInstance();
                debugger.inspect(evaluatorItem);
            }
        }

        private void doGoToClassSource(boolean live) {
            if (live) {
                String className = this._className == null ? this._xComponent.getClassName() : this._className;
                DebugClassInfo[] dcis = DebuggerProcess.ra$vm(DebuggerProcess.this).listClasses();
                int i = 0;
                while (i < dcis.length) {
                    DebugClassInfo dci = dcis[i];
                    if (className.equals(dci.getName())) {
                        DebuggerProcess.mav$showSourceFile(DebuggerProcess.this, dci);
                    }
                    ++i;
                }
            }
        }

        private void doGoToMethodSource(boolean live) {
            DebugLocation location;
            if (live && (location = this._methodInfo.getFirstLocation()) != null) {
                DebuggerProcess.mav$showSourceFile(DebuggerProcess.this, location, false);
            }
        }
    }
}

