/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.uidebug.debugger.model;

import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import oracle.ide.Ide;
import oracle.ide.IdeMainWindow;
import oracle.ide.util.BitField;
import oracle.jdevimpl.runner.uidebug.debugger.Debugger;
import oracle.jdevimpl.runner.uidebug.debugger.DebuggerAddin;
import oracle.jdevimpl.runner.uidebug.debugger.DebuggerProcess;
import oracle.jdevimpl.runner.uidebug.debugger.model.Listener;
import oracle.jdevimpl.runner.uidebug.debugger.model.Listeners;
import oracle.jdevimpl.runner.uidebug.debugger.request.ReqAddListener;
import oracle.jdevimpl.runner.uidebug.debugger.request.ReqFullTree;
import oracle.jdevimpl.runner.uidebug.debugger.request.ReqHighlight;
import oracle.jdevimpl.runner.uidebug.debugger.request.ReqValidate;
import oracle.jdevimpl.runner.uidebug.debugger.request.ReqVisible;
import oracle.jdevimpl.runner.uidebug.debugger.ui.DebuggerDockable;
import oracle.jdevimpl.runner.uidebug.debugger.ui.ListenersPanel;
import oracle.jdevimpl.runner.uidebug.debugger.ui.ShowListenersPanel;
import oracle.jdevimpl.runner.uidebug.resource.UIDebugArb;

public final class XComponent
extends DefaultMutableTreeNode
implements ActionListener {
    private final int _nID;
    private String _className;
    private Rectangle _bounds;
    private boolean _isVisible;
    private BufferedImage _bufferedImage;
    private Listeners _listeners;
    private static final String MENU_GOTOSOURCE = UIDebugArb.getString(55);
    private static final String MENU_WATCH = UIDebugArb.getString(29);
    private static final String MENU_INSPECT = UIDebugArb.getString(15);
    private static final String MENU_EVENTS = UIDebugArb.getString(14);
    private static final String MENU_HIGHLIGHT = UIDebugArb.getString(37);
    private static final String MENU_HIDE = UIDebugArb.getString(20);
    private static final String MENU_SHOW = UIDebugArb.getString(12);
    private static final String MENU_SHOW_LISTENERS = UIDebugArb.getString(53);
    private static final String MENU_VALIDATE = UIDebugArb.getString(32);

    public XComponent(int nID) {
        this._nID = nID;
    }

    public boolean equals(Object obj) {
        return obj instanceof XComponent && ((XComponent)obj)._nID == this._nID;
    }

    public int compareTo(Object other) {
        XComponent xComponent = (XComponent)other;
        return this._nID - xComponent._nID;
    }

    public String toString() {
        return this._className + "(" + this._nID + ")";
    }

    public int getID() {
        return this._nID;
    }

    public String getClassName() {
        return this._className;
    }

    public void setClassName(String className) {
        this._className = className;
    }

    public Rectangle getBounds() {
        return this._bounds;
    }

    public void setBounds(Rectangle bounds) {
        this.setBounds(bounds.x, bounds.y, bounds.width, bounds.height);
    }

    public void setBounds(int x, int y, int nWidth, int nHeight) {
        if (this._bounds == null) {
            this._bounds = new Rectangle();
        }
        this._bounds.setRect(x, y, nWidth, nHeight);
    }

    public BufferedImage getBufferedImage() {
        return this._bufferedImage;
    }

    public void setBufferedImage(BufferedImage bufferedImage) {
        this._bufferedImage = bufferedImage;
    }

    public boolean isVisible() {
        return this._isVisible;
    }

    public boolean isShowing() {
        boolean bRet = false;
        if (this.isVisible()) {
            TreeNode tn = this.getParent();
            if (tn instanceof XComponent) {
                XComponent parent = (XComponent)tn;
                bRet = parent.isShowing();
            } else {
                bRet = true;
            }
        }
        return bRet;
    }

    public void setVisible(boolean visible) {
        this._isVisible = visible;
    }

    private XComponent getXComponentAt(int i) {
        return (XComponent)this.getChildAt(i);
    }

    public Listeners getListeners() {
        if (this._listeners == null) {
            this._listeners = new Listeners();
        }
        return this._listeners;
    }

    public void paintComponent(Graphics2D g) {
        if (this.isVisible()) {
            g.drawRect(this._bounds.x, this._bounds.y, this._bounds.width, this._bounds.height);
            int n = this.getChildCount();
            if (n != 0) {
                Shape clip = g.getClip();
                g.clipRect(this._bounds.x, this._bounds.y, this._bounds.width, this._bounds.height);
                g.translate(this._bounds.x, this._bounds.y);
                int i = 0;
                while (i < n) {
                    this.getXComponentAt(i).paintComponent(g);
                    ++i;
                }
                g.translate(-this._bounds.x, -this._bounds.y);
                g.setClip(clip);
            }
        }
    }

    public Rectangle getLocation(boolean clipped) {
        Rectangle pos = new Rectangle(this._bounds);
        TreeNode parent = this.getParent();
        while (parent instanceof XComponent) {
            XComponent comp = (XComponent)parent;
            pos.translate(comp._bounds.x, comp._bounds.y);
            if (clipped && pos.intersects(comp._bounds)) {
                pos = pos.intersection(comp._bounds);
            }
            parent = parent.getParent();
        }
        return pos;
    }

    public XComponent searchComponentAt(int nxPos, int nyPos) {
        XComponent ret = null;
        if (this.isVisible() && this._bounds.contains(nxPos, nyPos)) {
            int n = this.getChildCount();
            int i = 0;
            while (ret == null && i < n) {
                ret = this.getXComponentAt(i).searchComponentAt(nxPos - this._bounds.x, nyPos - this._bounds.y);
                ++i;
            }
            if (ret == null) {
                ret = this;
            }
        }
        return ret;
    }

    public JMenuItem[] getMenuItems() {
        DebuggerProcess debugger = Debugger.getInstance().getActiveDebuggerProcess();
        boolean isPaused = BitField.isSet((int)debugger.getStateMask(), (int)2);
        JMenuItem menuSource = this.createMenuItem(MENU_GOTOSOURCE, true);
        JMenuItem menuWatch = this.createMenuItem(MENU_WATCH, true);
        JMenuItem menuInspect = this.createMenuItem(MENU_INSPECT, true);
        JMenuItem menuListeners = this.createMenuItem(MENU_EVENTS, isPaused ^ true);
        JMenuItem menuHighlight = this.createMenuItem(MENU_HIGHLIGHT, isPaused ^ true);
        JMenuItem menuValidate = this.createMenuItem(MENU_VALIDATE, isPaused ^ true);
        JMenuItem menuToggleVisibility = this.createMenuItem(this.isVisible() ? MENU_HIDE : MENU_SHOW, isPaused ^ true);
        JMenuItem menuShowListeners = this.createMenuItem(MENU_SHOW_LISTENERS, isPaused ^ true);
        JMenuItem[] menuItems = new JMenuItem[]{menuSource, null, menuWatch, menuInspect, null, menuListeners, menuShowListeners, null, menuHighlight, menuToggleVisibility};
        return menuItems;
    }

    private JMenuItem createMenuItem(String text, boolean enabled) {
        JMenuItem menuItem = new JMenuItem(text);
        menuItem.addActionListener(this);
        menuItem.setEnabled(enabled);
        return menuItem;
    }

    public void actionPerformed(ActionEvent e) {
        String sCommand = e.getActionCommand();
        DebuggerProcess debugger = Debugger.getInstance().getActiveDebuggerProcess();
        if (sCommand == MENU_WATCH) {
            this.whenWatch();
        } else if (sCommand == MENU_INSPECT) {
            this.whenInspect();
        } else if (sCommand == MENU_GOTOSOURCE) {
            this.whenGoToSource();
        } else if (sCommand == MENU_EVENTS) {
            this.whenEvents();
        } else if (sCommand == MENU_HIGHLIGHT) {
            debugger.pushRequest(new ReqHighlight(this.getID(), 2));
        } else if (sCommand == MENU_VALIDATE) {
            debugger.pushRequest(new ReqValidate(this.getID()));
        } else if (sCommand == MENU_HIDE) {
            debugger.pushRequest(new ReqVisible(this.getID(), false));
            debugger.pushRequest(new ReqFullTree());
        } else if (sCommand == MENU_SHOW) {
            debugger.pushRequest(new ReqVisible(this.getID(), true));
            debugger.pushRequest(new ReqFullTree());
        } else if (sCommand == MENU_SHOW_LISTENERS) {
            this.whenShowListners();
        }
    }

    private void whenWatch() {
        DebuggerProcess debugger = Debugger.getInstance().getActiveDebuggerProcess();
        debugger.addWatch(this);
    }

    private void whenInspect() {
        DebuggerProcess debugger = Debugger.getInstance().getActiveDebuggerProcess();
        debugger.addInspect(this);
    }

    public void whenGoToSource() {
        DebuggerProcess debugger = Debugger.getInstance().getActiveDebuggerProcess();
        debugger.whenShowSourceFile(this);
    }

    private void whenEvents() {
        IdeMainWindow mainWindow = Ide.getMainWindow();
        Listeners newL = ListenersPanel.showDialog((JFrame)mainWindow, this._nID);
        if (newL != null) {
            DebuggerProcess debugger = Debugger.getInstance().getActiveDebuggerProcess();
            int n = newL.getListenerCount();
            int i = 0;
            while (i < n) {
                Listener l = newL.getListener(i);
                ReqAddListener req = new ReqAddListener(this.getID(), l.getType(), newL.isIncludeChilds());
                debugger.pushRequest(req);
                ++i;
            }
            if (n != 0) {
                DebuggerAddin addin = DebuggerAddin.getInstance();
                DebuggerDockable dockable = addin.getListeners();
                dockable.show();
            }
        }
    }

    private void whenShowListners() {
        ShowListenersPanel.showDialog((JFrame)Ide.getMainWindow(), this);
    }
}

