/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.uidebug.debugger.reply;

import java.io.IOException;
import oracle.jdevimpl.runner.uidebug.comm.DebugStream;
import oracle.jdevimpl.runner.uidebug.debugger.reply.ListenerEventData;

public class ListenerComponentEventData
extends ListenerEventData {
    private static String[] EVENT_NAMES = new String[]{"Component Moved", "Component Resized", "Component Shown", "Component Hidden"};
    private int _x;
    private int _y;
    private int _width;
    private int _height;

    public void readReply(DebugStream stream) throws IOException {
        super.readReply(stream);
        this._x = stream.readInt();
        this._y = stream.readInt();
        this._width = stream.readInt();
        this._height = stream.readInt();
    }

    protected String getEventName() {
        return EVENT_NAMES[this.getEventID() - 100];
    }

    public String toString() {
        String s = super.toString();
        switch (this.getEventID()) {
            case 100: {
                s = s + "[x=" + this._x + ";y=" + this._y + "]";
                break;
            }
            case 101: {
                s = s + "[width=" + this._width + ";height=" + this._height + "]";
                break;
            }
        }
        return s;
    }
}

