/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.uidebug.debugger.request;

import java.io.IOException;
import oracle.jdevimpl.runner.uidebug.comm.DebugStream;
import oracle.jdevimpl.runner.uidebug.debugger.Debugger;
import oracle.jdevimpl.runner.uidebug.debugger.DebuggerProcess;
import oracle.jdevimpl.runner.uidebug.debugger.Request;
import oracle.jdevimpl.runner.uidebug.debugger.model.Listener;
import oracle.jdevimpl.runner.uidebug.debugger.model.XComponent;
import oracle.jdevimpl.runner.uidebug.debugger.reply.Reply;

public final class ReqAddListener
extends Request
implements Reply {
    private static final int REQUEST_TYPE = 3;
    private final int _componentID;
    private final String _type;
    private final boolean _children;

    public ReqAddListener(int componentID, String type, boolean children) {
        super(3, true);
        this._componentID = componentID;
        this._type = type;
        this._children = children;
    }

    public void write(DebugStream stream) throws IOException {
        super.write(stream);
        stream.writeInt(this._componentID);
        stream.writeUTF(this._type);
        stream.writeBoolean(this._children);
    }

    public void readReply(DebugStream stream) throws IOException {
        int nListenerID = stream.readInt();
        Debugger debugger = Debugger.getInstance();
        DebuggerProcess activeDebuggerProcess = debugger.getActiveDebuggerProcess();
        XComponent xComponent = activeDebuggerProcess.searchReference(this._componentID);
        if (xComponent != null) {
            Listener newListener = new Listener(this._type, nListenerID);
            xComponent.getListeners().addListener(newListener);
        }
    }
}

