/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.uidebug.debugger.request;

import java.io.IOException;
import java.util.ArrayList;
import oracle.jdevimpl.runner.uidebug.comm.DebugStream;
import oracle.jdevimpl.runner.uidebug.debugger.Request;
import oracle.jdevimpl.runner.uidebug.debugger.reply.Reply;

public final class ReqFindEventTypes
extends Request
implements Reply {
    private static final int REQUEST_TYPE = 8;
    private final int _componentID;
    private final boolean _includeChildren;
    private ArrayList _listeners;

    public ReqFindEventTypes(int componentID, boolean includeChildren) {
        super(8, true);
        this._componentID = componentID;
        this._includeChildren = includeChildren;
    }

    public void write(DebugStream stream) throws IOException {
        super.write(stream);
        stream.writeInt(this._componentID);
        stream.writeBoolean(this._includeChildren);
    }

    public void readReply(DebugStream stream) throws IOException {
        int len = stream.readInt();
        this._listeners = new ArrayList(len);
        int i = 0;
        while (i < len) {
            String listenerTypeName = stream.readUTF();
            this._listeners.add(listenerTypeName);
            ++i;
        }
    }

    public int getListenerCount() {
        return this._listeners == null ? 0 : this._listeners.size();
    }

    public String getListener(int i) {
        return (String)this._listeners.get(i);
    }
}

