/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.uidebug.debugger.ui;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.event.MouseInputListener;
import javax.swing.tree.TreeNode;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.keyboard.KeyUtil;
import oracle.ide.resource.IdeArb;
import oracle.ide.util.BitField;
import oracle.ide.util.ResourceUtils;
import oracle.jdevimpl.runner.uidebug.debugger.Debugger;
import oracle.jdevimpl.runner.uidebug.debugger.DebuggerProcess;
import oracle.jdevimpl.runner.uidebug.debugger.events.DebuggerProcessEvent;
import oracle.jdevimpl.runner.uidebug.debugger.events.DebuggerProcessListener;
import oracle.jdevimpl.runner.uidebug.debugger.model.XComponent;
import oracle.jdevimpl.runner.uidebug.debugger.request.ReqFullTree;
import oracle.jdevimpl.runner.uidebug.resource.UIDebugArb;

public final class ComponentOutline
extends JPanel
implements DebuggerProcessListener,
PropertyChangeListener,
MouseInputListener,
ActionListener {
    private static final int ZOOM_MIN = -4;
    private static final int ZOOM_MAX = 4;
    private final DebuggerProcess _process;
    private TreeNode _root;
    private JComponent _ui;
    private JButton _butRefresh;
    private JButton _butZoomIn;
    private JButton _butZoomOut;
    private JScrollBar _sbHorz;
    private JScrollBar _sbVert;
    private double _scale;
    private int _zoom;
    private Point _lastMousePos;
    private final boolean _isAdjusting;
    private JCheckBox _cbImage;
    private JCheckBox _cbOutline;

    private void $init$() {
        this._scale = 1.0;
        this._zoom = 0;
        this._lastMousePos = new Point();
        this._isAdjusting = false;
    }

    public ComponentOutline(DebuggerProcess process) {
        this.$init$();
        this._process = process;
        this._process.addDebuggerProcessListener(this);
        this.setBackground(Color.white);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this._process.addSelectionListener(this);
        this.setRequestFocusEnabled(true);
        this.setBackground(UIManager.getColor("window"));
    }

    public double getScale() {
        return this._scale;
    }

    private void setScale(double scale) {
        JViewport viewport = (JViewport)this.getParent();
        Point pt = viewport.getViewPosition();
        pt.x = (int)((double)pt.x / this._scale * scale);
        pt.y = (int)((double)pt.y / this._scale * scale);
        Dimension dimViewport = viewport.getSize();
        Rectangle bounds = this.getOuterBounds();
        int maxX = Math.max(0, (int)((double)bounds.width * scale) - dimViewport.width);
        int maxY = Math.max(0, (int)((double)bounds.height * scale) - dimViewport.height);
        if (pt.x < 0) {
            pt.x = 0;
        }
        if (pt.x > maxX) {
            pt.x = maxX;
        }
        if (pt.y < 0) {
            pt.y = 0;
        }
        if (pt.y > maxY) {
            pt.y = maxY;
        }
        this._scale = scale;
        viewport.setViewPosition(pt);
        this.refresh();
    }

    private void refresh() {
        Dimension d = this.getBoundSize();
        this.setPreferredSize(d);
        this.revalidate();
        this.repaint();
    }

    private Dimension getBoundSize() {
        Rectangle bounds = this.getOuterBounds();
        Dimension d = bounds != null ? new Dimension((int)((double)bounds.width * this._scale), (int)((double)bounds.height * this._scale)) : new Dimension(0, 0);
        return d;
    }

    public JComponent getGUI() {
        if (this._ui == null) {
            this._ui = new JPanel(new GridBagLayout());
            Insets ins0 = new Insets(0, 0, 0, 0);
            this._butZoomIn = new JButton(IdeArb.getIcon((int)181));
            this._butZoomIn.setRequestFocusEnabled(false);
            this._butZoomIn.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
            this._butZoomIn.setContentAreaFilled(false);
            this._butZoomIn.addActionListener(this);
            this._butZoomIn.setEnabled(this._root != null);
            this._butZoomOut = new JButton(IdeArb.getIcon((int)104));
            this._butZoomOut.setRequestFocusEnabled(false);
            this._butZoomOut.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
            this._butZoomOut.setContentAreaFilled(false);
            this._butZoomOut.addActionListener(this);
            this._butZoomOut.setEnabled(this._root != null);
            this._butRefresh = new JButton(IdeArb.getIcon((int)79));
            KeyStroke refreshKey = KeyStroke.getKeyStroke(116, 0);
            this.addKey(new MyAction(this._butRefresh), refreshKey);
            String refreshTip = UIDebugArb.getString(25) + " " + KeyUtil.toString((KeyStroke)refreshKey);
            this._butRefresh.setToolTipText(refreshTip);
            this._butRefresh.addActionListener(this);
            this._cbImage = this.createCheckBox(13, true);
            this._cbOutline = this.createCheckBox(22, false);
            JToolBar tb = new JToolBar();
            tb.setFloatable(false);
            tb.setRollover(true);
            tb.add(this._butRefresh);
            tb.add(this._cbImage);
            tb.add(this._cbOutline);
            this._sbHorz = new JScrollBar(0);
            this._sbHorz.setUnitIncrement(10);
            this._sbVert = new JScrollBar(1);
            this._sbVert.setUnitIncrement(10);
            JScrollPane sp = new JScrollPane(this, 22, 32);
            sp.setBorder(BorderFactory.createEmptyBorder());
            sp.addComponentListener(new 1(this, sp));
            sp.getViewport().setScrollMode(0);
            sp.setHorizontalScrollBar(this._sbHorz);
            sp.setVerticalScrollBar(this._sbVert);
            this._ui.add((Component)tb, new GridBagConstraints(0, 0, 5, 1, 0.0, 0.0, 18, 2, ins0, 0, 0));
            this._ui.add((Component)sp, new GridBagConstraints(0, 1, 4, 1, 1.0, 1.0, 18, 1, ins0, 0, 0));
            this._ui.add((Component)this._sbVert, new GridBagConstraints(4, 1, 1, 1, 0.0, 1.0, 18, 3, ins0, 0, 0));
            this._ui.add((Component)this._sbHorz, new GridBagConstraints(0, 2, 3, 1, 1.0, 0.0, 18, 2, ins0, 0, 0));
            this._ui.add((Component)this._butZoomOut, new GridBagConstraints(3, 2, 1, 1, 0.0, 0.0, 18, 0, ins0, 0, 0));
            this._ui.add((Component)this._butZoomIn, new GridBagConstraints(4, 2, 1, 1, 0.0, 0.0, 18, 0, ins0, 0, 0));
            this.whenStateChanges();
        }
        return this._ui;
    }

    private JCheckBox createCheckBox(int textResource, boolean selected) {
        String label = UIDebugArb.getString(textResource);
        JCheckBox cb = new JCheckBox();
        cb.setSelected(selected);
        ResourceUtils.resButton((AbstractButton)cb, (String)label);
        int keyCode = StringUtils.getMnemonicKeyCode((String)label);
        MyAction butAction = new MyAction(cb);
        KeyStroke ks = KeyStroke.getKeyStroke(keyCode, 8);
        this.addKey(butAction, ks);
        cb.addActionListener(this);
        return cb;
    }

    private void addKey(Action action, KeyStroke ks) {
        InputMap inputMap = this._ui.getInputMap(1);
        inputMap.put(ks, action);
        ActionMap actionMap = this._ui.getActionMap();
        actionMap.put(action, action);
    }

    private Rectangle getOuterBounds() {
        int n;
        Rectangle ret = null;
        if (this._root != null && (n = this._root.getChildCount()) != 0) {
            int i = 0;
            while (i < n) {
                XComponent xcomp = (XComponent)this._root.getChildAt(i);
                if (xcomp.isVisible()) {
                    if (ret == null) {
                        ret = new Rectangle(xcomp.getBounds());
                    } else {
                        Rectangle r = xcomp.getBounds();
                        int x1 = Math.min(ret.x, r.x);
                        int x2 = Math.max(ret.x + ret.width, r.x + r.width);
                        int y1 = Math.min(ret.y, r.y);
                        int y2 = Math.max(ret.y + ret.height, r.y + r.height);
                        ret.setBounds(x1, y1, x2 - x1, y2 - y1);
                    }
                }
                if (ret == null || ret.isEmpty()) {
                    ret = null;
                }
                ++i;
            }
        }
        return ret;
    }

    private XComponent searchComponentAt(Point pt) {
        Rectangle rBounds;
        XComponent ret = null;
        if (this.isVisible() && (rBounds = this.getOuterBounds()) != null) {
            int nxPos = (int)((double)pt.x / this._scale + (double)rBounds.x);
            int nyPos = (int)((double)pt.y / this._scale + (double)rBounds.y);
            int n = this._root.getChildCount();
            int i = 0;
            while (i < n) {
                XComponent xcomp = (XComponent)this._root.getChildAt(i);
                XComponent componentAt = xcomp.searchComponentAt(nxPos, nyPos);
                if (componentAt != null) {
                    ret = componentAt;
                }
                ++i;
            }
        }
        return ret;
    }

    private void selectAt(Point pt) {
        XComponent sel = this.searchComponentAt(pt);
        this._process.setSelection(sel);
    }

    private boolean handlePopupEvent(MouseEvent e) {
        boolean ret = e.isPopupTrigger();
        if (ret) {
            this.showContextMenu(e.getPoint());
        }
        return ret;
    }

    private void showContextMenu(Point pt) {
        XComponent xComponent = this._process.getSelection();
        if (xComponent != null) {
            JMenuItem[] items = xComponent.getMenuItems();
            JPopupMenu menu = new JPopupMenu();
            int i = 0;
            while (i < items.length) {
                JMenuItem item = items[i];
                if (item != null) {
                    menu.add(item);
                } else {
                    menu.addSeparator();
                }
                ++i;
            }
            menu.show(this, pt.x, pt.y);
        }
    }

    private void whenRootChanges(TreeNode root) {
        this._root = root;
        if (this._ui != null) {
            boolean uiEnabled = root != null;
            this._butZoomIn.setEnabled(uiEnabled);
            this._butZoomOut.setEnabled(uiEnabled);
            this._butRefresh.setEnabled(uiEnabled);
        }
        this.refresh();
    }

    private void zoomBy(int zoom) {
        int newZoom = this._zoom + zoom;
        if (newZoom >= -4 && newZoom <= 4) {
            this._zoom = newZoom;
            this.setScale(Math.pow(2.0, this._zoom));
            this._butZoomOut.setEnabled(newZoom != -4);
            this._butZoomIn.setEnabled(newZoom != 4);
        }
    }

    private static void whenRefresh() {
        Debugger.getInstance().getActiveDebuggerProcess().pushRequest(new ReqFullTree());
    }

    private void whenImage() {
        if (!this._cbImage.isSelected()) {
            this._cbOutline.setSelected(true);
        }
        this.repaint();
    }

    private void whenOutline() {
        if (!this._cbOutline.isSelected()) {
            this._cbImage.setSelected(true);
        }
        this.repaint();
    }

    private void whenStateChanges() {
        if (this._butRefresh != null) {
            boolean isPaused = BitField.isSet((int)this._process.getStateMask(), (int)2);
            boolean isActive = BitField.isSet((int)this._process.getStateMask(), (int)1);
            this._butRefresh.setEnabled(isActive && !isPaused);
        }
    }

    protected void paintComponent(Graphics gAWT) {
        Dimension dimension = this.getSize();
        gAWT.setColor(this.getBackground());
        gAWT.fillRect(0, 0, dimension.width, dimension.height);
        Rectangle rBounds = this.getOuterBounds();
        if (rBounds != null) {
            Area selArea = new Area();
            Graphics2D g = (Graphics2D)gAWT;
            AffineTransform saveTransform = g.getTransform();
            XComponent sel = this._process.getSelection();
            g.scale(this._scale, this._scale);
            g.translate(-rBounds.x, -rBounds.y);
            int n = this._root.getChildCount();
            Color clr = g.getColor();
            g.setColor(Color.lightGray);
            int i = 0;
            while (i < n) {
                XComponent xcomp = (XComponent)this._root.getChildAt(i);
                if (xcomp.isVisible()) {
                    Rectangle xRoot = xcomp.getBounds();
                    selArea.add(new Area(xRoot));
                    BufferedImage image = xcomp.getBufferedImage();
                    if (this._cbImage.isSelected() && image != null) {
                        g.drawImage(image, null, xRoot.x, xRoot.y);
                    } else {
                        g.fillRect(xRoot.x, xRoot.y, xRoot.width, xRoot.height);
                    }
                }
                ++i;
            }
            if (this._cbOutline.isSelected()) {
                g.setColor(Color.black);
                BasicStroke hairLine = new BasicStroke(0.0f);
                g.setStroke(hairLine);
                int i2 = 0;
                while (i2 < n) {
                    XComponent xcomp = (XComponent)this._root.getChildAt(i2);
                    xcomp.paintComponent(g);
                    ++i2;
                }
            }
            if (sel != null) {
                Rectangle rSel = sel.getLocation(false);
                selArea.subtract(new Area(rSel));
                g.setColor(new Color(255, 0, 0, 64));
                g.fill(selArea);
            }
            g.setColor(clr);
            g.setTransform(saveTransform);
        }
    }

    public void rootChanging(DebuggerProcessEvent event) {
    }

    public void stateChanged(DebuggerProcessEvent event) {
        this.whenStateChanges();
    }

    public void rootChanged(DebuggerProcessEvent event) {
        TreeNode root = event.getSource().getWindowsRoot();
        this.whenRootChanges(root);
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName() == "SELECTION") {
            this.repaint();
        }
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseMoved(MouseEvent e) {
    }

    public void mouseClicked(MouseEvent e) {
        XComponent xComponent;
        if (!this.handlePopupEvent(e) && e.getClickCount() == 2 && (xComponent = this.searchComponentAt(e.getPoint())) != null) {
            e.consume();
            xComponent.whenGoToSource();
        }
    }

    public void mousePressed(MouseEvent e) {
        this.requestFocus();
        JViewport viewport = (JViewport)this.getParent();
        Point ptOffset = viewport.getViewPosition();
        Point ptEvent = e.getPoint();
        this._lastMousePos.setLocation(ptEvent.x - ptOffset.x, ptEvent.y - ptOffset.y);
        this.selectAt(ptEvent);
        this.handlePopupEvent(e);
    }

    public void mouseDragged(MouseEvent e) {
        JViewport viewport = (JViewport)this.getParent();
        Point pt = viewport.getViewPosition();
        Dimension dimViewport = viewport.getSize();
        Dimension dimView = viewport.getViewSize();
        Point ptMouse = e.getPoint();
        ptMouse.x -= pt.x;
        ptMouse.y -= pt.y;
        pt.translate(this._lastMousePos.x - ptMouse.x, this._lastMousePos.y - ptMouse.y);
        int maxX = Math.max(0, dimView.width - dimViewport.width);
        int maxY = Math.max(0, dimView.height - dimViewport.height);
        if (pt.x < 0) {
            pt.x = 0;
        }
        if (pt.x > maxX) {
            pt.x = maxX;
        }
        if (pt.y < 0) {
            pt.y = 0;
        }
        if (pt.y > maxY) {
            pt.y = maxY;
        }
        viewport.setViewPosition(pt);
        this._lastMousePos = ptMouse;
    }

    public void mouseReleased(MouseEvent e) {
        this.handlePopupEvent(e);
    }

    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this._butRefresh) {
            ComponentOutline.whenRefresh();
        } else if (source == this._butZoomIn) {
            this.zoomBy(1);
        } else if (source == this._butZoomOut) {
            this.zoomBy(-1);
        } else if (source == this._cbImage) {
            this.whenImage();
        } else if (source == this._cbOutline) {
            this.whenOutline();
        }
    }

    private void myActionPerformed(MyAction action) {
        if (action._src == this._cbImage) {
            this._cbImage.setSelected(this._cbImage.isSelected() ^ true);
            this.whenImage();
        } else if (action._src == this._cbOutline) {
            this._cbOutline.setSelected(this._cbOutline.isSelected() ^ true);
            this.whenOutline();
        } else if (action._src == this._butRefresh) {
            ComponentOutline.whenRefresh();
        }
    }

    static void mav$myActionPerformed(ComponentOutline componentOutline, MyAction myAction) {
        componentOutline.myActionPerformed(myAction);
    }

    static JScrollBar ra$_sbHorz(ComponentOutline componentOutline) {
        return componentOutline._sbHorz;
    }

    static JScrollBar ra$_sbVert(ComponentOutline componentOutline) {
        return componentOutline._sbVert;
    }

    final class 1
    implements ComponentListener {
        private final /* synthetic */ JScrollPane v$sp;
        final /* synthetic */ ComponentOutline this$0;

        public void componentHidden(ComponentEvent e) {
        }

        public void componentMoved(ComponentEvent e) {
        }

        public void componentResized(ComponentEvent e) {
            Dimension d = this.v$sp.getViewport().getExtentSize();
            ComponentOutline.ra$_sbHorz(this.this$0).setBlockIncrement(d.width);
            ComponentOutline.ra$_sbVert(this.this$0).setBlockIncrement(d.height);
        }

        public void componentShown(ComponentEvent e) {
        }

        public 1(ComponentOutline componentOutline, JScrollPane jScrollPane) {
            this.v$sp = jScrollPane;
            this.this$0 = componentOutline;
        }
    }

    final class MyAction
    extends AbstractAction {
        final JComponent _src;

        MyAction(JComponent src) {
            this._src = src;
        }

        public void actionPerformed(ActionEvent e) {
            ComponentOutline.mav$myActionPerformed(ComponentOutline.this, this);
        }
    }
}

