/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.uidebug.debugger.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.EventObject;
import javax.swing.JComponent;
import javax.swing.JLabel;
import oracle.ide.Context;
import oracle.ide.docking.DockableWindow;
import oracle.ide.view.View;
import oracle.jdevimpl.runner.uidebug.debugger.Debugger;
import oracle.jdevimpl.runner.uidebug.debugger.DebuggerProcess;
import oracle.jdevimpl.runner.uidebug.debugger.events.DebuggerEvent;
import oracle.jdevimpl.runner.uidebug.debugger.events.DebuggerListener;
import oracle.jdevimpl.runner.uidebug.resource.UIDebugArb;

public abstract class DebuggerDockable
extends DockableWindow
implements DebuggerListener {
    private JComponent _ui;

    public DebuggerDockable(String name) {
        super("UIDebugger." + name);
    }

    public final Context getContext(EventObject event) {
        return Context.newIdeContext((View)this, (EventObject)event);
    }

    public final String getTitleName() {
        return this.getTabName();
    }

    public final String getMenuTitle() {
        return DebuggerDockable.isUIDebugging() ? super.getMenuTitle() : null;
    }

    public final Component getGUI() {
        JComponent ui = null;
        if (DebuggerDockable.isUIDebugging()) {
            if (this._ui == null) {
                this._ui = new JLabel(UIDebugArb.getString(6));
                this._ui.setLayout(new BorderLayout());
                DebuggerProcess process = Debugger.getInstance().getActiveDebuggerProcess();
                if (process != null) {
                    this.attachUI(process);
                }
                Debugger.getInstance().addDebuggerListener(this);
            }
            ui = this._ui;
        }
        return ui;
    }

    public final void debuggerProcessActivated(DebuggerEvent event) {
        DebuggerProcess process = event.getDebuggerProcess();
        if (process != null) {
            this.attachUI(process);
        }
    }

    public final void debuggerProcessCreated(DebuggerEvent event) {
    }

    public final void debuggerProcessDied(DebuggerEvent event) {
        DebuggerProcess process = event.getDebuggerProcess();
        if (this.isDebuggerUICreated(process)) {
            this._ui.remove(this.getDebuggerUI(process));
        }
    }

    private void attachUI(DebuggerProcess process) {
        JComponent gui = this.getDebuggerUI(process);
        if (gui.getParent() != this._ui) {
            this._ui.add((Component)gui, "Center");
            this._ui.revalidate();
        }
    }

    protected abstract JComponent getDebuggerUI(DebuggerProcess var1);

    protected abstract boolean isDebuggerUICreated(DebuggerProcess var1);

    private static boolean isUIDebugging() {
        Debugger debugger = Debugger.getInstance();
        int debuggerProcessCount = debugger.getDebuggerProcessCount();
        return debuggerProcessCount != 0;
    }
}

