/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.uidebug.debugger.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.AbstractButton;
import javax.swing.DefaultListModel;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.help.HelpSystem;
import oracle.ide.util.ResourceUtils;
import oracle.jdevimpl.runner.uidebug.debugger.Debugger;
import oracle.jdevimpl.runner.uidebug.debugger.DebuggerProcess;
import oracle.jdevimpl.runner.uidebug.debugger.events.ReplyEvent;
import oracle.jdevimpl.runner.uidebug.debugger.events.ReplyListener;
import oracle.jdevimpl.runner.uidebug.debugger.model.Listener;
import oracle.jdevimpl.runner.uidebug.debugger.model.Listeners;
import oracle.jdevimpl.runner.uidebug.debugger.reply.Reply;
import oracle.jdevimpl.runner.uidebug.debugger.request.ReqFindEventTypes;
import oracle.jdevimpl.runner.uidebug.resource.UIDebugArb;

public final class ListenersPanel
extends JPanel
implements ReplyListener,
ItemListener {
    private final int _componentID;
    private final JCheckBox _children;
    private final JList _list;

    private ListenersPanel(int componentID) {
        this.setLayout(new BorderLayout());
        this._componentID = componentID;
        DefaultListModel model = new DefaultListModel();
        this._list = new JList(model);
        this._children = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this._children, (String)UIDebugArb.getString(24));
        this._children.addItemListener(this);
        this.add((Component)new JScrollPane(this._list), "Center");
        this.add((Component)this._children, "South");
    }

    public static Listeners showDialog(JFrame frame, int componentID) {
        Listeners ret = null;
        ListenersPanel panel = new ListenersPanel(componentID);
        String title = UIDebugArb.getString(51);
        HelpSystem.getHelpSystem().registerTopic((JComponent)panel, "f1_xray_eventclasses_dlog_html");
        JEWTDialog dlg = new JEWTDialog((Frame)frame, title, 7);
        dlg.setInitialFocus((Component)panel._list);
        dlg.setContent((Component)panel);
        dlg.setResizable(true);
        panel.refresh();
        if (WizardLauncher.runDialog((JDialog)dlg)) {
            Object[] values = panel._list.getSelectedValues();
            boolean includeChilds = panel._children.getModel().isSelected();
            ret = new Listeners(values, includeChilds);
        }
        return ret;
    }

    private void refresh() {
        DebuggerProcess debugger = Debugger.getInstance().getActiveDebuggerProcess();
        boolean includeChildren = this._children.getModel().isSelected();
        this.setUIEnabled(false);
        ReqFindEventTypes reqFindListeners = new ReqFindEventTypes(this._componentID, includeChildren);
        debugger.getReceiveQueue().addReplyListener(this);
        debugger.pushRequest(reqFindListeners);
    }

    private void setUIEnabled(boolean enabled) {
        this._list.setEnabled(enabled);
        this._children.setEnabled(enabled);
        Cursor cursor = enabled ? null : Cursor.getPredefinedCursor(3);
        this._children.setCursor(cursor);
    }

    public void itemStateChanged(ItemEvent e) {
        this.refresh();
    }

    public void replyReceived(ReplyEvent event) {
        Reply eventsReply = event.getReply();
        if (eventsReply instanceof ReqFindEventTypes) {
            DebuggerProcess debugger = Debugger.getInstance().getActiveDebuggerProcess();
            debugger.getReceiveQueue().removeReplyListener(this);
            ReqFindEventTypes reply = (ReqFindEventTypes)eventsReply;
            DefaultListModel model = (DefaultListModel)this._list.getModel();
            model.removeAllElements();
            int n = reply.getListenerCount();
            int i = 0;
            while (i < n) {
                String listenerTypeName = reply.getListener(i);
                Listener listener = new Listener(listenerTypeName);
                model.addElement(listener);
                ++i;
            }
            this.setUIEnabled(true);
        }
    }
}

