/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.uidebug.debugger.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.help.HelpSystem;
import oracle.ide.util.IdeUtil;
import oracle.ide.util.Pair;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.icons.OracleIcons;
import oracle.jdevimpl.debugger.support.DebugMethodInfo;
import oracle.jdevimpl.runner.uidebug.debugger.Debugger;
import oracle.jdevimpl.runner.uidebug.debugger.DebuggerProcess;
import oracle.jdevimpl.runner.uidebug.debugger.events.ReplyEvent;
import oracle.jdevimpl.runner.uidebug.debugger.events.ReplyListener;
import oracle.jdevimpl.runner.uidebug.debugger.model.XComponent;
import oracle.jdevimpl.runner.uidebug.debugger.request.ReqFindObjectListeners;
import oracle.jdevimpl.runner.uidebug.resource.UIDebugArb;

public class ShowListenersPanel
extends JPanel
implements ReplyListener,
ActionListener,
Runnable,
TreeSelectionListener,
MouseListener {
    private static final String TYPE_ROOT = "r";
    private static final String TYPE_LISTENER_INTERFACE = "li";
    private static final String TYPE_LISTENER_CLASS = "lc";
    private static final String TYPE_LISTENER_METHOD = "lm";
    private DismissableJEWTDialog _container;
    private int _requestId;
    private DefaultMutableTreeNode _root;
    private JTree _tree;
    private JButton _butGoToSource;

    private ShowListenersPanel(int requestId) {
        super(new BorderLayout());
        this._requestId = requestId;
        DebuggerProcess debugger = this.getDebuggerProcess();
        debugger.getReceiveQueue().addReplyListener(this);
        this._root = new DefaultMutableTreeNode(new Pair((Object)"", (Object)TYPE_ROOT));
        JLabel lblListeners = new JLabel();
        this._tree = new JTree(new DefaultTreeModel(this._root));
        this._tree.setCellRenderer(new 1());
        this._tree.addMouseListener(this);
        this._tree.setShowsRootHandles(true);
        this._tree.setRootVisible(false);
        this._tree.setEnabled(false);
        this._tree.setCursor(Cursor.getPredefinedCursor(3));
        this._tree.getSelectionModel().addTreeSelectionListener(this);
        ResourceUtils.resLabel((JLabel)lblListeners, (Component)this._tree, (String)UIDebugArb.getString(46));
        this.add((Component)lblListeners, "North");
        this.add((Component)new JScrollPane(this._tree), "Center");
    }

    public static void showDialog(JFrame frame, XComponent obj) {
        DismissableJEWTDialog dlg;
        ReqFindObjectListeners req = new ReqFindObjectListeners(obj.getID());
        ShowListenersPanel listenersPanel = new ShowListenersPanel(req.getRequestID());
        String titleFmt = UIDebugArb.getString(2);
        String title = MessageFormat.format(titleFmt, obj);
        HelpSystem.getHelpSystem().registerTopic((JComponent)listenersPanel, "f1_xray_listendial_html");
        listenersPanel._container = dlg = new DismissableJEWTDialog(frame, title, 20);
        listenersPanel._butGoToSource = new JButton();
        listenersPanel._butGoToSource.setEnabled(false);
        ResourceUtils.resButton((AbstractButton)listenersPanel._butGoToSource, (String)UIDebugArb.getString(44));
        listenersPanel._butGoToSource.addActionListener(listenersPanel);
        dlg.addCustomButton(listenersPanel._butGoToSource);
        dlg.setContent(listenersPanel);
        dlg.setResizable(true);
        DebuggerProcess debugger = Debugger.getInstance().getActiveDebuggerProcess();
        debugger.pushRequest(req);
        WizardLauncher.runDialog((JDialog)((Object)dlg));
    }

    private DebuggerProcess getDebuggerProcess() {
        return Debugger.getInstance().getActiveDebuggerProcess();
    }

    public void replyReceived(ReplyEvent event) {
        if (this._requestId == event.getReply().getRequestID()) {
            DebuggerProcess debugger = this.getDebuggerProcess();
            debugger.getReceiveQueue().removeReplyListener(this);
            debugger.invokeWhilePaused(new 2(this, event));
        }
    }

    private void fillTree(ReplyEvent event) {
        DebuggerProcess debugger = this.getDebuggerProcess();
        ReqFindObjectListeners req = (ReqFindObjectListeners)event.getReply();
        int n = req.getListenerCount();
        int i = 0;
        while (i < n) {
            String listenerClass;
            String listenerInterface = req.getListenerInterface(i);
            ArrayList methodList = debugger.filter(listenerInterface, listenerClass = req.getListenerClass(i));
            if (!methodList.isEmpty()) {
                DefaultMutableTreeNode parent = this.findInterface(listenerInterface);
                Pair listenerClassPair = new Pair((Object)listenerClass, (Object)TYPE_LISTENER_CLASS);
                DefaultMutableTreeNode listenerClassNode = new DefaultMutableTreeNode(listenerClassPair);
                int j = 0;
                while (j < methodList.size()) {
                    DebugMethodInfo listenerMethod = (DebugMethodInfo)methodList.get(j);
                    String methodName = listenerMethod.getNameWithoutClassOrSignature();
                    Pair methodNameInfoPair = new Pair((Object)methodName, (Object)listenerMethod);
                    Pair methodPair = new Pair((Object)methodNameInfoPair, (Object)TYPE_LISTENER_METHOD);
                    DefaultMutableTreeNode methodNode = new DefaultMutableTreeNode(methodPair);
                    listenerClassNode.add(methodNode);
                    ++j;
                }
                parent.add(listenerClassNode);
            }
            ++i;
        }
        this.recSortTree(this._root);
        DefaultTreeModel model = (DefaultTreeModel)this._tree.getModel();
        model.reload();
        this._tree.setEnabled(true);
        this._tree.setCursor(null);
        IdeUtil.expandAllTreeRows((JTree)this._tree);
    }

    private void recSortTree(DefaultMutableTreeNode parent) {
        int childCount = parent.getChildCount();
        ArrayList<TreeNode> arrayList = new ArrayList<TreeNode>(childCount);
        int i = 0;
        while (i < childCount) {
            arrayList.add(parent.getChildAt(i));
            ++i;
        }
        Collections.sort(arrayList, new 3());
        parent.removeAllChildren();
        int i2 = 0;
        while (i2 < arrayList.size()) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)arrayList.get(i2);
            this.recSortTree(child);
            parent.add(child);
            ++i2;
        }
    }

    private DefaultMutableTreeNode findInterface(String listenerInterface) {
        DefaultMutableTreeNode ret = this.searchInterface(listenerInterface);
        if (ret == null) {
            Pair pair = new Pair((Object)listenerInterface, (Object)TYPE_LISTENER_INTERFACE);
            ret = new DefaultMutableTreeNode(pair);
            this._root.add(ret);
        }
        return ret;
    }

    private DefaultMutableTreeNode searchInterface(String listenerInterface) {
        int childCount = this._root.getChildCount();
        int i = 0;
        while (i < childCount) {
            DefaultMutableTreeNode childAt = (DefaultMutableTreeNode)this._root.getChildAt(i);
            String listenerAt = childAt.getUserObject().toString();
            if (listenerInterface.equals(listenerAt)) {
                return childAt;
            }
            ++i;
        }
        return null;
    }

    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this._butGoToSource) {
            this.whenGoToSource();
        }
    }

    private void whenGoToSource() {
        DismissableJEWTDialog.mav$dismiss(this._container);
        SwingUtilities.invokeLater(this);
    }

    public void run() {
        TreeSelectionModel selectionModel = this._tree.getSelectionModel();
        TreePath leadSelectionPath = selectionModel.getLeadSelectionPath();
        DefaultMutableTreeNode methodNode = (DefaultMutableTreeNode)leadSelectionPath.getLastPathComponent();
        Pair methodPair = (Pair)methodNode.getUserObject();
        Pair methodNameInfoPair = (Pair)methodPair.first;
        DebugMethodInfo implementingMethod = (DebugMethodInfo)methodNameInfoPair.second;
        DebuggerProcess debuggerProcess = this.getDebuggerProcess();
        debuggerProcess.whenShowSourceFile(implementingMethod);
    }

    public void valueChanged(TreeSelectionEvent e) {
        TreeSelectionModel selectionModel = this._tree.getSelectionModel();
        boolean isEnabled = false;
        TreePath leadSelectionPath = selectionModel.getLeadSelectionPath();
        if (leadSelectionPath != null) {
            DefaultMutableTreeNode sel = (DefaultMutableTreeNode)leadSelectionPath.getLastPathComponent();
            isEnabled = sel.isLeaf();
        }
        this._butGoToSource.setEnabled(isEnabled);
    }

    public void mouseClicked(MouseEvent e) {
        if (e.getSource() == this._tree && e.getClickCount() == 2 && this._butGoToSource.isEnabled()) {
            this.whenGoToSource();
        }
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    static void mav$fillTree(ShowListenersPanel showListenersPanel, ReplyEvent replyEvent) {
        showListenersPanel.fillTree(replyEvent);
    }

    private static final class DismissableJEWTDialog
    extends JEWTDialog {
        public DismissableJEWTDialog(Frame frame, String s, int i) {
            super(frame, s, i);
        }

        private void dismiss() {
            this.dismissDialog(false);
        }

        static void mav$dismiss(DismissableJEWTDialog dismissableJEWTDialog) {
            dismissableJEWTDialog.dismiss();
        }
    }

    final class 1
    extends DefaultTreeCellRenderer {
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            JLabel label = (JLabel)super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
            Pair pair = (Pair)node.getUserObject();
            Object type = pair.second;
            Icon icon = type == ShowListenersPanel.TYPE_LISTENER_INTERFACE ? OracleIcons.getIcon((String)"interface.png") : (type == ShowListenersPanel.TYPE_LISTENER_CLASS ? OracleIcons.getIcon((String)"class.png") : (type == ShowListenersPanel.TYPE_LISTENER_METHOD ? OracleIcons.getIcon((String)"method.png") : null));
            label.setIcon(icon);
            return label;
        }
    }

    final class 2
    implements Runnable {
        private final /* synthetic */ ReplyEvent v$event;
        final /* synthetic */ ShowListenersPanel this$0;

        public void run() {
            ShowListenersPanel.mav$fillTree(this.this$0, this.v$event);
        }

        public 2(ShowListenersPanel showListenersPanel, ReplyEvent replyEvent) {
            this.v$event = replyEvent;
            this.this$0 = showListenersPanel;
        }
    }

    final class 3
    implements Comparator {
        public int compare(Object o1, Object o2) {
            DefaultMutableTreeNode node1 = (DefaultMutableTreeNode)o1;
            DefaultMutableTreeNode node2 = (DefaultMutableTreeNode)o2;
            Comparable userObject1 = (Comparable)node1.getUserObject();
            Object userObject2 = node2.getUserObject();
            return userObject1.compareTo(userObject2);
        }
    }
}

