/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.xslt;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.net.URL;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Ide;
import oracle.ide.controls.URLPathField;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.help.HelpSystem;
import oracle.ide.model.Project;
import oracle.ide.net.DefaultURLFilter;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.ide.net.URLPath;
import oracle.ide.net.URLTextField;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.data.PropertyStorage;
import oracle.jdeveloper.model.J2eeSettings;
import oracle.jdeveloper.resource.ControlsArb;
import oracle.jdevimpl.runner.xslt.XSLTArb;
import oracle.jdevimpl.runner.xslt.XSLTConfiguration;

public final class XSLTPanel
extends JPanel
implements DocumentListener {
    private URLTextField inputFileField;
    private URL inputFileBaseURL;
    private JButton inputFileButton;
    private JCheckBox showInputFileCheckBox;
    private URLTextField outputFileField;
    private URL outputFileBaseURL;
    private JButton outputFileButton;
    private JCheckBox showOutputFileCheckBox;
    private URLPathField sourcePathField;
    private JButton sourcePathButton;
    private JTextField xsltOptionsTextField;
    private JEWTDialog dlg;

    XSLTPanel() {
        this(false);
    }

    private XSLTPanel(boolean standAloneDialog) {
        JLabel inputFileLabel = new JLabel();
        this.inputFileField = new URLTextField(null, false, false);
        this.inputFileBaseURL = null;
        this.inputFileButton = new JButton();
        this.showInputFileCheckBox = new JCheckBox();
        JLabel outputFileLabel = new JLabel();
        this.outputFileField = new URLTextField(null, false, false);
        this.outputFileBaseURL = null;
        this.outputFileButton = new JButton();
        this.showOutputFileCheckBox = new JCheckBox();
        JLabel sourcePathLabel = new JLabel();
        this.sourcePathField = new URLPathField();
        this.sourcePathButton = new JButton();
        JLabel xsltOptionsLabel = new JLabel();
        this.xsltOptionsTextField = new JTextField();
        ResourceUtils.resLabel((JLabel)inputFileLabel, (Component)this.inputFileField, (String)XSLTArb.getString(10));
        this.inputFileField.setDialogTitle(XSLTArb.getString(25));
        ResourceUtils.resButton((AbstractButton)this.inputFileButton, (String)XSLTArb.getString(5));
        this.inputFileButton.addActionListener((ActionListener)this.inputFileField);
        ResourceUtils.resButton((AbstractButton)this.showInputFileCheckBox, (String)XSLTArb.getString(2));
        ResourceUtils.resLabel((JLabel)outputFileLabel, (Component)this.outputFileField, (String)XSLTArb.getString(9));
        this.outputFileField.setDialogTitle(XSLTArb.getString(13));
        ResourceUtils.resButton((AbstractButton)this.outputFileButton, (String)XSLTArb.getString(11));
        this.outputFileButton.addActionListener((ActionListener)this.outputFileField);
        ResourceUtils.resButton((AbstractButton)this.showOutputFileCheckBox, (String)XSLTArb.getString(32));
        ResourceUtils.resLabel((JLabel)sourcePathLabel, (Component)this.sourcePathField, (String)XSLTArb.getString(0));
        this.sourcePathField.setEditTitle(XSLTArb.getString(17));
        ResourceUtils.resButton((AbstractButton)this.sourcePathButton, (String)XSLTArb.getString(8));
        this.sourcePathButton.addActionListener((ActionListener)this.sourcePathField);
        ResourceUtils.resLabel((JLabel)xsltOptionsLabel, (Component)this.xsltOptionsTextField, (String)XSLTArb.getString(31));
        this.setLayout(new GridBagLayout());
        int y = 0;
        this.add((Component)inputFileLabel, new GridBagConstraints(0, y++, 0, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 2, 0), 0, 0));
        this.add((Component)this.inputFileField, new GridBagConstraints(0, y, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.inputFileButton, new GridBagConstraints(1, y++, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 8, 0, 0), 0, 0));
        this.add((Component)this.showInputFileCheckBox, new GridBagConstraints(0, y++, 0, 1, 0.0, 0.0, 17, 0, new Insets(2, 0, 0, 0), 0, 0));
        this.add((Component)outputFileLabel, new GridBagConstraints(0, y++, 0, 1, 0.0, 0.0, 17, 0, new Insets(10, 0, 2, 0), 0, 0));
        this.add((Component)this.outputFileField, new GridBagConstraints(0, y, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.outputFileButton, new GridBagConstraints(1, y++, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 8, 0, 0), 0, 0));
        this.add((Component)this.showOutputFileCheckBox, new GridBagConstraints(0, y++, 0, 1, 0.0, 0.0, 17, 0, new Insets(2, 0, 0, 0), 0, 0));
        this.add((Component)sourcePathLabel, new GridBagConstraints(0, y++, 0, 1, 0.0, 0.0, 17, 0, new Insets(10, 0, 2, 0), 0, 0));
        this.add((Component)this.sourcePathField, new GridBagConstraints(0, y, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.sourcePathButton, new GridBagConstraints(1, y++, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 8, 0, 0), 0, 0));
        this.add((Component)xsltOptionsLabel, new GridBagConstraints(0, y++, 0, 1, 0.0, 0.0, 17, 0, new Insets(10, 0, 2, 0), 0, 0));
        this.add((Component)this.xsltOptionsTextField, new GridBagConstraints(0, y++, 0, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        DefaultURLFilter XMLFilesFilter = new DefaultURLFilter("xml");
        XMLFilesFilter.addExtension(".xml");
        this.inputFileField.clearChooseableURLFilters();
        this.inputFileField.addChooseableURLFilter((URLFilter)XMLFilesFilter);
        if (standAloneDialog) {
            this.add((Component)new JLabel(), new GridBagConstraints(0, y, 0, 1, 0.0, 1.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.inputFileField.getDocument().addDocumentListener(this);
            this.outputFileField.getDocument().addDocumentListener(this);
            this.sourcePathField.getDocument().addDocumentListener(this);
        }
    }

    void loadFrom(Project project, XSLTConfiguration xsltConfiguration) {
        URL htmlRoot = J2eeSettings.getInstance(project).getHtmlRootDirectory();
        URL htmlRootParent = URLFileSystem.getParent((URL)htmlRoot);
        if (!URLFileSystem.exists((URL)htmlRoot) && URLFileSystem.exists((URL)htmlRootParent)) {
            URLFileSystem.mkdir((URL)htmlRoot);
        }
        this.inputFileBaseURL = htmlRootParent;
        this.outputFileBaseURL = htmlRoot;
        URL inputFile = xsltConfiguration.getInputFileURL();
        if (inputFile != null) {
            this.inputFileField.setURL(inputFile);
        } else {
            this.inputFileField.setDefaultChooserURL(htmlRootParent);
            this.inputFileField.setBaseURL(null);
        }
        this.showInputFileCheckBox.setSelected(xsltConfiguration.isShowInputFile());
        URL outputFile = xsltConfiguration.getOutputFileURL();
        if (outputFile != null) {
            this.outputFileField.setURL(outputFile);
        } else {
            this.outputFileField.setDefaultChooserURL(htmlRoot);
            this.outputFileField.setBaseURL(null);
        }
        this.showOutputFileCheckBox.setSelected(xsltConfiguration.isShowOutputFile());
        URLPath sourcePath = xsltConfiguration.getSourcePath();
        this.sourcePathField.setURLPath(sourcePath);
        this.xsltOptionsTextField.setText(xsltConfiguration.getXSLTOptions());
    }

    void commitTo(XSLTConfiguration xsltConfiguration) throws TraversalException {
        URL inputFile = this.getCurrentURL(this.inputFileField, this.inputFileBaseURL);
        if (inputFile == null) {
            xsltConfiguration.setInputFileURL(inputFile);
        } else if (inputFile.getProtocol().equals("file")) {
            xsltConfiguration.setInputFileURL(URLFileSystem.canonicalize((URL)inputFile));
        }
        xsltConfiguration.setShowInputFile(this.showInputFileCheckBox.isSelected());
        URL outputFile = this.getCurrentURL(this.outputFileField, this.outputFileBaseURL);
        if (outputFile == null) {
            xsltConfiguration.setOutputFileURL(outputFile);
        } else if (outputFile.getProtocol().equals("file")) {
            xsltConfiguration.setOutputFileURL(URLFileSystem.canonicalize((URL)outputFile));
        }
        xsltConfiguration.setShowOutputFile(this.showOutputFileCheckBox.isSelected());
        try {
            URLPath sourcePath = this.sourcePathField.getURLPath();
            xsltConfiguration.setSourcePath(sourcePath);
        }
        catch (URLPathField.BadEntryException bee) {
            throw new TraversalException(ControlsArb.format((int)45, (Object)bee.getBadEntry()));
        }
        xsltConfiguration.setXSLTOptions(this.xsltOptionsTextField.getText());
    }

    void setJEWTDialog(JEWTDialog dlg) {
        this.dlg = dlg;
    }

    public void changedUpdate(DocumentEvent e) {
        this.enableOk();
    }

    public void insertUpdate(DocumentEvent e) {
        this.enableOk();
    }

    public void removeUpdate(DocumentEvent e) {
        this.enableOk();
    }

    private void enableOk() {
        if (this.dlg != null) {
            this.dlg.setOKButtonEnabled(this.canOk());
        }
    }

    private boolean canOk() {
        URL inputFileFieldURL = this.createTempURLUsingBaseURL(this.inputFileField, this.inputFileBaseURL);
        URL outputFileFieldURL = this.createTempURLUsingBaseURL(this.outputFileField, this.outputFileBaseURL);
        if (inputFileFieldURL != null && outputFileFieldURL != null) {
            String inputFilePath = URLFileSystem.getPath((URL)inputFileFieldURL);
            String outputFilePath = URLFileSystem.getPath((URL)outputFileFieldURL);
            if (inputFilePath != null && outputFilePath != null) {
                int InputFileExtDelimiter = inputFilePath.lastIndexOf(46);
                int OutputFileExtDelimiter = outputFilePath.lastIndexOf(46);
                if (InputFileExtDelimiter != -1 && OutputFileExtDelimiter != -1) {
                    URL OutputFileParentURL = URLFileSystem.getParent((URL)outputFileFieldURL);
                    if (URLFileSystem.exists((URL)inputFileFieldURL) && URLFileSystem.exists((URL)OutputFileParentURL)) {
                        try {
                            this.sourcePathField.getURLPath();
                            boolean bl = true;
                            return bl;
                        }
                        catch (URLPathField.BadEntryException bee) {
                            // empty catch block
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean veto() {
        URL outputFile;
        String errorMessage = null;
        URL inputFile = this.getCurrentURL(this.inputFileField, this.inputFileBaseURL);
        if (inputFile == null) {
            errorMessage = XSLTArb.getString(33);
        }
        if (!inputFile.getProtocol().equals("file")) {
            errorMessage = XSLTArb.getString(34);
        }
        if ((outputFile = this.getCurrentURL(this.outputFileField, this.outputFileBaseURL)) == null) {
            errorMessage = XSLTArb.getString(3);
        }
        if (!outputFile.getProtocol().equals("file")) {
            errorMessage = XSLTArb.getString(27);
        }
        if (errorMessage != null) {
            String title = XSLTArb.getString(35);
            JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), errorMessage, title, 0);
            return true;
        }
        return false;
    }

    public static boolean showXSLTDialog(Project project) {
        XSLTConfiguration xsltConfiguration = XSLTConfiguration.getInstance((PropertyStorage)project);
        XSLTPanel xsltPanel = new XSLTPanel(true);
        String title = XSLTArb.getString(35);
        JEWTDialog dlg = OnePageWizardDialogFactory.createJEWTDialog((Component)xsltPanel, (Component)xsltPanel.inputFileField, (String)title);
        xsltPanel.setJEWTDialog(dlg);
        xsltPanel.loadFrom(project, xsltConfiguration);
        xsltPanel.enableOk();
        HelpSystem.getHelpSystem().registerTopic((JComponent)xsltPanel, "f1_projsetxsltrun_html");
        dlg.addVetoableChangeListener((VetoableChangeListener)new 1(xsltPanel));
        if (WizardLauncher.runDialog((JDialog)dlg)) {
            try {
                xsltPanel.commitTo(xsltConfiguration);
            }
            catch (Exception e) {
                // empty catch block
            }
            project.markDirty(true);
            return true;
        }
        return false;
    }

    private URL getCurrentURL(URLTextField textField, URL baseURL) {
        URL returnURL = null;
        if (textField != null && baseURL != null && (returnURL = textField.getURL()) == null && !textField.getText().equals("")) {
            textField.setBaseURL(baseURL);
            returnURL = textField.getURL();
        }
        return returnURL;
    }

    private URL createTempURLUsingBaseURL(URLTextField textField, URL baseURL) {
        String CurrentFieldText;
        URL returnURL = textField.getURL();
        if (returnURL == null && !(CurrentFieldText = textField.getText()).equals("") && baseURL != null) {
            returnURL = URLFactory.newURL((URL)baseURL, (String)CurrentFieldText);
        }
        return returnURL;
    }

    static boolean mav$veto(XSLTPanel xSLTPanel) {
        return xSLTPanel.veto();
    }

    static final class 1
    implements VetoableChangeListener {
        private final /* synthetic */ XSLTPanel v$xsltPanel;

        public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
            if (JEWTDialog.isDialogClosingEvent((PropertyChangeEvent)evt) && XSLTPanel.mav$veto(this.v$xsltPanel)) {
                throw new PropertyVetoException("no", evt);
            }
        }

        public 1(XSLTPanel xSLTPanel) {
            this.v$xsltPanel = xSLTPanel;
        }
    }
}

