/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.xslt;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Method;
import java.net.URL;
import oracle.bali.xml.addin.XMLSourceNode;
import oracle.ide.Addin;
import oracle.ide.Ide;
import oracle.ide.IdeEvent;
import oracle.ide.IdeListener;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.ide.panels.Navigable;
import oracle.ide.runner.Debugger;
import oracle.ide.runner.Runner;
import oracle.ide.runner.SmartDataProvider;
import oracle.ide.runner.StarterFactory;
import oracle.ide.xml.StartElementPacket;
import oracle.ide.xml.XMLUtil;
import oracle.javatools.data.PropertyStorage;
import oracle.jdeveloper.runner.Source;
import oracle.jdeveloper.runner.xslt.XSLTStarterFactory;
import oracle.jdevimpl.debugger.shared.DebugShared;
import oracle.jdevimpl.debugger.support.DebugClassInfo;
import oracle.jdevimpl.debugger.support.DebugDataCompositeInfo;
import oracle.jdevimpl.debugger.support.DebugDataInfo;
import oracle.jdevimpl.debugger.support.DebugMethodInfo;
import oracle.jdevimpl.debugger.support.DebugStackFrameInfo;
import oracle.jdevimpl.debugger.support.DebugVariableInfo;
import oracle.jdevimpl.runner.xslt.XSLTArb;
import oracle.jdevimpl.runner.xslt.XSLTConfiguration;
import oracle.jdevimpl.runner.xslt.XSLTRunnerPanel;
import oracle.jdevimpl.runner.xslt.XSLTSmartDataProvider;
import oracle.jdevimpl.runner.xslt.XSLTSourceFinder;

public final class XSLTRunnerAddin
implements Addin,
IdeListener {
    private static File xsltJar;
    private static boolean firstTime;
    private static boolean firstTimeDebugging;
    public static final String CLASSNAME_XMLString = "$oracle.xml.xslt.XMLString";
    public static final String CLASSNAME_XMLNode = "$oracle.xml.xslt.XMLNode";

    public void initialize() {
        Ide.addIdeListener((IdeListener)this);
    }

    public void shutdown() {
    }

    public boolean canShutdown() {
        return true;
    }

    public void addinsLoaded(IdeEvent e) {
    }

    public void mainWindowOpened(IdeEvent e) {
        Ide.removeIdeListener((IdeListener)this);
        if (XSLTRunnerAddin.isXSLTDebuggingSupported()) {
            Runner runner = Runner.getRunner();
            if (runner != null) {
                runner.registerStarterFactory(XMLSourceNode.class, (StarterFactory)new XSLTStarterFactory());
                Navigable xsltRunner = new Navigable(XSLTArb.getString(28), XSLTRunnerPanel.class);
                runner.addRunConfigurationLaunchNavigable(xsltRunner);
            }
            Source.addSourceFinder(new XSLTSourceFinder());
        }
    }

    public void mainWindowClosing(IdeEvent e) {
    }

    private static boolean supportsJDWP(String className) {
        try {
            Object result;
            Method m;
            Class<?> c = Class.forName(className);
            if (c != null && (m = c.getMethod("supportsJDWP", null)) != null && (result = m.invoke(null, null)) instanceof Boolean) {
                boolean bl = (Boolean)result;
                return bl;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return false;
    }

    public static synchronized File getXSLTJarForDebugging() {
        if (firstTime) {
            String dir = Ide.getProperty((String)"XSLTDebuggerJarDirectory");
            if (dir != null) {
                xsltJar = new File(dir, "xmlparserv2.jar");
            } else if (XSLTRunnerAddin.supportsJDWP("oracle.xml.xslt.XSLProcessor") || XSLTRunnerAddin.supportsJDWP("oracle.xml.parser.v2.XSLProcessor")) {
                String directory = Ide.getOracleHomeDirectory();
                if (!directory.endsWith(File.separator)) {
                    directory = directory + File.separator;
                }
                directory = directory + "lib" + File.separator;
                xsltJar = new File(directory, "xmlparserv2.jar");
            }
            firstTime = false;
        }
        return xsltJar;
    }

    public static boolean isXSLTDebuggingSupported() {
        return XSLTRunnerAddin.getXSLTJarForDebugging() != null;
    }

    public static String getFirstXSLTDebugOption(String port) {
        if (firstTimeDebugging) {
            firstTimeDebugging = false;
            Debugger debugger = Debugger.getDebugger();
            if (debugger != null) {
                debugger.addSmartDataProvider((SmartDataProvider)new XSLTSmartDataProvider());
            }
        }
        return "-Doracle.xml.xslt.jdwp=server=y,port=" + port;
    }

    public static String getLastXSLTDebugOption() {
        return "-debug";
    }

    public static String getXSLTPackage() {
        return "$oracle.xml.xslt";
    }

    public static String getXSLTPackage(URL url) {
        return XSLTRunnerAddin.getXSLTPackage();
    }

    public static boolean isXSLTStylesheet(DebugClassInfo clazz) {
        if (clazz != null && clazz.getLanguage() == 4) {
            String xsltPackagePlusDot = XSLTRunnerAddin.getXSLTPackage() + ".";
            String className = clazz.getName();
            if (className.startsWith(xsltPackagePlusDot) && !className.substring(xsltPackagePlusDot.length()).startsWith("XML")) {
                return true;
            }
        }
        return false;
    }

    private static String convertName(String name) {
        StringBuffer sb = new StringBuffer(name);
        int i = 0;
        while (i < sb.length()) {
            if (sb.charAt(i) == '_' && i + 1 < sb.length()) {
                switch (sb.charAt(i + 1)) {
                    default: {
                        i += 2;
                        break;
                    }
                    case '_': {
                        sb.replace(i, i + 2, "_");
                        ++i;
                        break;
                    }
                    case 'A': {
                        sb.replace(i, i + 2, File.separator);
                        ++i;
                        break;
                    }
                    case 'B': {
                        sb.replace(i, i + 2, ".");
                        ++i;
                        break;
                    }
                    case 'C': {
                        sb.replace(i, i + 2, "-");
                        ++i;
                        break;
                    }
                    case 'D': {
                        sb.replace(i, i + 2, " ");
                        ++i;
                        break;
                    }
                    case 'E': {
                        sb.replace(i, i + 2, ":");
                        ++i;
                        break;
                    }
                }
                continue;
            }
            ++i;
        }
        return sb.toString();
    }

    public static String getStylesheetName(DebugClassInfo clazz, boolean showFullName) {
        String classNameWithoutPackage = clazz.getNameWithoutPackage();
        String stylesheetName = XSLTRunnerAddin.convertName(classNameWithoutPackage);
        if (showFullName) {
            if (stylesheetName.length() > 2 && stylesheetName.charAt(0) == File.separatorChar && stylesheetName.charAt(2) == ':') {
                stylesheetName = stylesheetName.substring(1);
            }
        } else {
            int lastSep = stylesheetName.lastIndexOf(File.separator);
            if (lastSep != -1) {
                stylesheetName = stylesheetName.substring(lastSep + 1);
            }
        }
        return stylesheetName;
    }

    public static String getTemplateName(DebugMethodInfo method, DebugStackFrameInfo stackFrame) {
        String methodName = method.getNameWithoutClassOrSignature();
        if (methodName.startsWith("$$")) {
            DebugDataInfo matchPatternData;
            DebugVariableInfo matchPatternVariable;
            if (stackFrame != null && (matchPatternVariable = stackFrame.getVariable("$matchPattern")) != null && (matchPatternData = matchPatternVariable.getDataInfo()) instanceof DebugDataCompositeInfo) {
                String matchPattern = DebugShared.makeCourtesyValue((DebugDataCompositeInfo)matchPatternData, false, false);
                int index = matchPattern.indexOf(34) == -1 ? 22 : 18;
                return XSLTArb.format(index, matchPattern);
            }
            return XSLTArb.format(4, methodName.substring(2));
        }
        return XSLTRunnerAddin.convertName(methodName);
    }

    public static Node getXSLTInputNode(Project project, boolean checkShow) {
        try {
            URL inputFileURL;
            XSLTConfiguration xsltConfiguration = XSLTConfiguration.getInstance((PropertyStorage)project);
            if ((!checkShow || xsltConfiguration.isShowInputFile()) && (inputFileURL = xsltConfiguration.getInputFileURL()) != null) {
                Node node = NodeFactory.findOrCreate((URL)inputFileURL);
                return node;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return null;
    }

    public static Node getXSLTOutputNode(Project project, boolean checkShow) {
        try {
            URL outputFileURL;
            XSLTConfiguration xsltConfiguration = XSLTConfiguration.getInstance((PropertyStorage)project);
            if ((!checkShow || xsltConfiguration.isShowOutputFile()) && (outputFileURL = xsltConfiguration.getOutputFileURL()) != null) {
                Node node = NodeFactory.findOrCreate((URL)outputFileURL);
                return node;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return null;
    }

    public static String getXMLNodeTypeName(short type) {
        switch (type) {
            case 1: {
                return XSLTArb.getString(6);
            }
            case 2: {
                return XSLTArb.getString(26);
            }
            case 3: {
                return XSLTArb.getString(1);
            }
            case 4: {
                return XSLTArb.getString(36);
            }
            case 5: {
                return XSLTArb.getString(12);
            }
            case 6: {
                return XSLTArb.getString(19);
            }
            case 7: {
                return XSLTArb.getString(15);
            }
            case 8: {
                return XSLTArb.getString(14);
            }
            case 9: {
                return XSLTArb.getString(21);
            }
            case 10: {
                return XSLTArb.getString(23);
            }
            case 11: {
                return XSLTArb.getString(7);
            }
            case 12: {
                return XSLTArb.getString(29);
            }
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isXSLT(XMLSourceNode xmlNode) {
        Reader reader = null;
        try {
            boolean bl;
            try {
                reader = xmlNode.getReader();
                StartElementPacket root = XMLUtil.getXMLRootElement((Reader)reader);
                if (root == null) return false;
                if (root.namespaceURI == null) return false;
                if (!root.namespaceURI.equals("http://www.w3.org/1999/XSL/Transform")) return false;
                if (root.attributes == null) return false;
                int i = root.attributes.getLength() - 1;
                while (i >= 0) {
                    String attributeName = root.attributes.getLocalName(i);
                    if (attributeName != null && attributeName.equals("version")) {
                        bl = true;
                        return bl;
                    }
                    --i;
                }
                return false;
            }
            finally {
                if (reader == null) return bl;
                try {
                    reader.close();
                    return bl;
                }
                catch (IOException iOException) {}
            }
        }
        catch (Exception e) {
            return false;
        }
    }

    static {
        firstTime = true;
        firstTimeDebugging = true;
    }
}

