/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.style;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import oracle.ide.Context;
import oracle.ide.config.Preferences;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.editor.EditorProperties;
import oracle.jdeveloper.style.CodingStyleManager;
import oracle.jdeveloper.style.CodingStyleOptions;
import oracle.jdeveloper.style.CodingStyleOptionsListener;
import oracle.jdevimpl.style.preferences.CodingStylePreferences;
import oracle.jdevimpl.style.profile.CodingStyleProfile;
import oracle.jdevimpl.style.profile.ProfileRepository;

public class CodingStyleManagerImpl
extends CodingStyleManager {
    private CodingStyleProfile profile;
    private CodingStyleProfile localProfile;
    private CodingStyleOptionsListener profileListener;

    private void $init$() {
        this.localProfile = new CodingStyleProfile();
        this.profileListener = new ProfileListener(null);
    }

    public CodingStyleManagerImpl() {
        this.$init$();
        CodingStylePreferences preferences = this.getCodingStylePreferences();
        preferences.addPropertyChangeListener(new PreferencesListener(null));
        this.updateProfile();
    }

    public CodingStyleOptions getCodingStyleOptions() {
        return this.localProfile;
    }

    public CodingStyleOptions getCodingStyleOptions(Context context) {
        return this.getCodingStyleOptions();
    }

    private void updateProfile() {
        if (this.profile != null) {
            this.profile.removeCodingStyleOptionsListener(this.profileListener);
        }
        CodingStylePreferences preferences = this.getCodingStylePreferences();
        String name = preferences.getActiveProfile();
        ProfileRepository repository = ProfileRepository.getProfileRepository();
        if (name != null) {
            this.profile = repository.getProfile(name);
        }
        if (this.profile == null) {
            this.profile = repository.getDefaultProfile();
        }
        if (this.profile != null) {
            this.profile.copyTo((Object)this.localProfile);
            this.profile.addCodingStyleOptionsListener(this.profileListener);
        }
        EditorProperties properties = EditorProperties.getProperties();
        properties.putIntegerProperty("indent-size", this.profile.getIndentSize());
        properties.putBooleanProperty("use-tabs", this.profile.getIndentReplaceWithTabs());
        properties.putIntegerProperty("tab-size", this.profile.getTabSize());
        properties.putBooleanProperty("java-open-brace-same-line", this.profile.getClassBracePosition() == 0);
    }

    private CodingStylePreferences getCodingStylePreferences() {
        return CodingStylePreferences.getInstance((PropertyStorage)Preferences.getPreferences());
    }

    static void mav$updateProfile(CodingStyleManagerImpl codingStyleManagerImpl) {
        codingStyleManagerImpl.updateProfile();
    }

    private class PreferencesListener
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent evt) {
            CodingStyleManagerImpl.mav$updateProfile(CodingStyleManagerImpl.this);
        }

        private PreferencesListener() {
        }

        PreferencesListener(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class ProfileListener
    implements CodingStyleOptionsListener {
        public void optionsChanged(CodingStyleOptions options) {
            CodingStyleManagerImpl.mav$updateProfile(CodingStyleManagerImpl.this);
        }

        private ProfileListener() {
        }

        ProfileListener(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

