/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.style.controller;

import java.awt.Component;
import java.util.ArrayList;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.ceditor.CodeMenuConstants;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.Controller;
import oracle.ide.controller.DynamicMenuListener;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.Menubar;
import oracle.ide.controls.ToggleAction;
import oracle.ide.editor.EditorManager;
import oracle.ide.keyboard.KeyStrokeContextRegistry;
import oracle.ide.navigator.NavigatorManager;
import oracle.ide.navigator.NavigatorWindow;
import oracle.ide.util.ArrayResourceBundle;
import oracle.ide.view.View;
import oracle.javatools.icons.OracleIcons;
import oracle.jdeveloper.controller.NodeActionController;
import oracle.jdeveloper.model.JavaSourceNode;
import oracle.jdevimpl.java.JavaArb;
import oracle.jdevimpl.java.imports.OrganizeImportsActionDelegate;
import oracle.jdevimpl.style.controller.JavaFormatActionDelegate;
import oracle.jdevimpl.style.resource.CodingStyleArb;

public class CodingStyleController
implements ContextMenuListener,
CodeMenuConstants,
DynamicMenuListener {
    private NodeActionController formatController;
    private NodeActionController importController;
    private JMenuItem formatItem;
    private IdeAction formatAction;
    private IdeAction organizeImportsAction;
    private JMenuItem organizeImportsItem;
    private IdeAction widenImportsAction;
    private IdeAction narrowImportsAction;

    public CodingStyleController() {
        ContextMenu menu;
        EditorManager editorManager = EditorManager.getEditorManager();
        ContextMenu contextMenu = menu = Ide.getIdeArgs().getCreateUI() ? editorManager.getContextMenu() : null;
        if (menu != null) {
            menu.addContextMenuListener((ContextMenuListener)this);
        }
        NavigatorManager navigatorManager = NavigatorManager.getWorkspaceNavigatorManager();
        ContextMenu contextMenu2 = menu = Ide.getIdeArgs().getCreateUI() ? navigatorManager.getContextMenu() : null;
        if (menu != null) {
            menu.addContextMenuListener((ContextMenuListener)this);
        }
        if (Ide.getIdeArgs().getCreateUI()) {
            Ide.getMainWindow().addDynamicMenuListener((DynamicMenuListener)this);
        }
        this.formatController = new NodeActionController();
        this.formatController.addDelegate(JavaSourceNode.class, JavaFormatActionDelegate.class);
        this.importController = new NodeActionController();
        this.importController.addDelegate(JavaSourceNode.class, OrganizeImportsActionDelegate.class);
        Menubar menuManager = Ide.getIdeArgs().getCreateUI() ? Ide.getMenubar() : null;
        String formatName = CodingStyleArb.getString(61);
        this.formatAction = IdeAction.get((int)Ide.findOrCreateCmdID((String)"CodingStyleController.FORMAT_CMD"), null, (String)StringUtils.stripMnemonic((String)formatName), (String)CodeMenuConstants.CATEGORY_CODE_MENU, (Integer)new Integer(StringUtils.getMnemonicKeyCode((String)formatName)), (Icon)OracleIcons.getIcon((String)"reformat.png"), null, (boolean)true);
        this.formatAction.addController((Controller)this.formatController);
        this.formatItem = menuManager != null ? menuManager.createMenuItem((ToggleAction)this.formatAction) : null;
        String organizeImportsName = JavaArb.getString(76);
        this.organizeImportsAction = IdeAction.get((int)Ide.findOrCreateCmdID((String)"CodingStyleController.ORGANIZE_IMPORTS_CMD"), null, (String)StringUtils.stripMnemonic((String)organizeImportsName), (String)CodeMenuConstants.CATEGORY_CODE_MENU, (Integer)new Integer(StringUtils.getMnemonicKeyCode((String)organizeImportsName)), (ArrayResourceBundle)JavaArb.getInstance(), (int)94, null, (boolean)false);
        this.organizeImportsAction.addController((Controller)this.importController);
        this.organizeImportsItem = menuManager != null ? menuManager.createMenuItem((ToggleAction)this.organizeImportsAction) : null;
        String widenImportsName = JavaArb.getString(240);
        this.widenImportsAction = IdeAction.get((int)Ide.findOrCreateCmdID((String)"CodingStyleController.WIDEN_IMPORTS_CMD"), null, (String)StringUtils.stripMnemonic((String)widenImportsName), (String)CodeMenuConstants.CATEGORY_CODE_MENU, (Integer)new Integer(StringUtils.getMnemonicKeyCode((String)widenImportsName)), (ArrayResourceBundle)JavaArb.getInstance(), (int)117, null, (boolean)false);
        this.widenImportsAction.putValue("organize-imports-threshold", (Object)new Integer(0));
        this.widenImportsAction.addController((Controller)this.importController);
        String narrowImportsName = JavaArb.getString(245);
        this.narrowImportsAction = IdeAction.get((int)Ide.findOrCreateCmdID((String)"CodingStyleController.NARROW_IMPORTS_CMD"), null, (String)StringUtils.stripMnemonic((String)narrowImportsName), (String)CodeMenuConstants.CATEGORY_CODE_MENU, (Integer)new Integer(StringUtils.getMnemonicKeyCode((String)narrowImportsName)), (ArrayResourceBundle)JavaArb.getInstance(), (int)91, null, (boolean)false);
        this.narrowImportsAction.putValue("organize-imports-threshold", (Object)new Integer(Integer.MAX_VALUE));
        this.narrowImportsAction.addController((Controller)this.importController);
        KeyStrokeContextRegistry registry = Ide.getKeyStrokeContextRegistry();
        registry.addAcceleratorDefinitionFile(this.getClass().getClassLoader(), "oracle/jdevimpl/style/controller/accelerators.xml");
    }

    public void menuWillShow(ContextMenu popup) {
        Context context;
        View view;
        if (popup != null && ((view = (context = popup.getContext()).getView()) instanceof NavigatorWindow || view instanceof CodeEditor)) {
            float section;
            float f = section = view instanceof CodeEditor ? CodeMenuConstants.SECTION_SOURCE_CTXT_MENU : CodeMenuConstants.SECTION_SOURCE_CTXT_MENU_NON_EDITOR;
            if (this.formatController.update(this.formatAction, context)) {
                popup.add((Component)this.formatItem, section);
            }
            if (this.importController.update(this.organizeImportsAction, context)) {
                popup.add((Component)this.organizeImportsItem, section);
            }
        }
    }

    public void menuWillHide(ContextMenu popup) {
    }

    public boolean handleDefaultAction(Context context) {
        return false;
    }

    public JComponent[] gatherDynamicActions(Context context) {
        View view = context.getView();
        if (view instanceof CodeEditor) {
            Menubar menubar = Ide.getMenubar();
            ArrayList<JComponent> actions = new ArrayList<JComponent>(4);
            if (this.importController.update(this.organizeImportsAction, context)) {
                JMenuItem item = menubar.createMenuItem((ToggleAction)this.organizeImportsAction, 605.0f);
                item.putClientProperty("menu-section-id", new Float(5.0f));
                actions.add(item);
            }
            if (this.importController.update(this.widenImportsAction, context)) {
                JMenuItem item = menubar.createMenuItem((ToggleAction)this.widenImportsAction, 620.0f);
                item.putClientProperty("menu-section-id", new Float(5.0f));
                actions.add(item);
            }
            if (this.importController.update(this.narrowImportsAction, context)) {
                JMenuItem item = menubar.createMenuItem((ToggleAction)this.narrowImportsAction, 610.0f);
                item.putClientProperty("menu-section-id", new Float(5.0f));
                actions.add(item);
            }
            if (this.formatController.update(this.formatAction, context)) {
                if (!actions.isEmpty()) {
                    JSeparator separator = new JSeparator();
                    separator.putClientProperty("menu-weight", new Float(499.0f));
                    actions.add(separator);
                }
                JMenuItem item = menubar.createMenuItem((ToggleAction)this.formatAction, 640.0f);
                item.putClientProperty("menu-section-id", new Float(5.5f));
                actions.add(item);
            }
            return actions.toArray(new JComponent[actions.size()]);
        }
        return new JComponent[0];
    }
}

