/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.style.controller;

import java.net.URL;
import oracle.ide.Context;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.controller.IdeAction;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.net.URLFileSystem;
import oracle.ide.view.View;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.util.Formatting;
import oracle.jdeveloper.controller.JavaSourceNodeActionDelegate;
import oracle.jdeveloper.java.JavaManager;
import oracle.jdevimpl.java.Context2ParserHelper;

public class JavaFormatActionDelegate
extends JavaSourceNodeActionDelegate {
    public boolean isEnabled(IdeAction action, Context context, Element[] elements, int[] text) {
        return context.getProject() != null && !this.isSQLJ(context.getNode());
    }

    protected int[] doAction(SourceFile file, Context context, Element[] elements, int[] text, IdeAction action) {
        int[] newSelection = null;
        Context2ParserHelper helper = Context2ParserHelper.createHelper(context);
        JavaManager manager = helper.getJavaManager();
        if (manager != null) {
            int endOffset;
            int startOffset = text != null ? text[0] : -1;
            int n = endOffset = text != null ? text[1] : -1;
            if (startOffset < endOffset && startOffset >= 0 && endOffset >= 0) {
                Formatting.Selection selection = Formatting.reformatRegion((SourceFile)file, (int)startOffset, (int)endOffset);
                if (selection != null) {
                    newSelection = new int[]{selection.getStartOffset(), newSelection[0] + selection.getLength()};
                }
            } else {
                View view = context.getView();
                if (view instanceof CodeEditor) {
                    CodeEditor codeEditor = (CodeEditor)view;
                    SourceElement caretSourceElement = null;
                    int caretOffsetfromSourceElement = -1;
                    Element[] selectedElements = codeEditor.getSelection();
                    if (selectedElements != null && selectedElements.length == 1) {
                        caretSourceElement = (SourceElement)selectedElements[0].getData();
                        caretOffsetfromSourceElement = startOffset - caretSourceElement.getStartOffset();
                    }
                    Formatting.reformatSubtree((SourceElement)file);
                    if (caretSourceElement != null && caretOffsetfromSourceElement >= 0) {
                        int newCaretPosition = caretSourceElement.getStartOffset() + caretOffsetfromSourceElement;
                        newSelection = new int[]{newCaretPosition, newCaretPosition};
                    } else {
                        newSelection = new int[]{startOffset, startOffset};
                    }
                } else {
                    Formatting.reformatSubtree((SourceElement)file);
                }
            }
        }
        return newSelection;
    }

    private boolean isSQLJ(Node node) {
        return URLFileSystem.hasSuffix((URL)node.getURL(), (String)".sqlj");
    }
}

