/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.style.migration;

import java.io.File;
import oracle.ide.Ide;
import oracle.ide.IdeAdapter;
import oracle.ide.IdeEvent;
import oracle.ide.IdeListener;
import oracle.ide.ceditor.options.EditorOptions;
import oracle.ide.config.ClientSetting;
import oracle.ide.config.IdeSettingsMigrator;
import oracle.ide.config.Preferences;
import oracle.ide.migration.MigrationManager;
import oracle.ide.migration.Migrator;
import oracle.javatools.data.PropertyStorage;
import oracle.jdevimpl.java.editing.JavaOptions;
import oracle.jdevimpl.java.imports.JavaImportOptions;
import oracle.jdevimpl.java.insight.JavaInsightOptions;
import oracle.jdevimpl.style.preferences.CodingStylePreferences;
import oracle.jdevimpl.style.profile.CodingStyleProfile;
import oracle.jdevimpl.style.profile.ProfileRepository;
import oracle.jdevimpl.style.resource.CodingStyleArb;

public class CodingStyleMigrator
implements Migrator {
    private static final int CODING_STYLE_CATEGORY = 0;
    private boolean selected;

    public int[] getMigrationCategories() {
        return new int[]{0};
    }

    public String getDescription(int category) {
        return null;
    }

    public boolean canMigrate(int category, File sourceDir) {
        return category == 0;
    }

    public void setSelected(int category, boolean selected) {
        if (category == 0) {
            this.selected = selected;
        }
    }

    public boolean isSelected(int category) {
        return category == 0 ? this.selected : false;
    }

    public String[] migrate(File sourceDir, File destDir) {
        MigrationManager manager;
        Migrator migrator;
        if (this.isSelected(0) && (migrator = (manager = MigrationManager.getMigrationManager()).getMigrator(IdeSettingsMigrator.class)) != null && migrator.isSelected(0)) {
            Ide.addIdeListener((IdeListener)new SecondPhaseMigrator(null));
        }
        return null;
    }

    private class SecondPhaseMigrator
    extends IdeAdapter {
        public void addinsLoaded(IdeEvent e) {
            if (this.isMigrationNeeded()) {
                this.performMigration();
            }
            Ide.removeIdeListener((IdeListener)this);
        }

        private boolean isMigrationNeeded() {
            CodingStylePreferences preferences = CodingStylePreferences.getInstance((PropertyStorage)Preferences.getPreferences());
            return preferences.getActiveProfile() == null;
        }

        private void performMigration() {
            CodingStyleProfile profile = new CodingStyleProfile();
            ProfileRepository repository = ProfileRepository.getProfileRepository();
            CodingStyleProfile defaultProfile = repository.getDefaultProfile();
            defaultProfile.copyTo((Object)profile);
            String profileName = CodingStyleArb.getString(119);
            profile.setName(profileName);
            EditorOptions editorOptions = EditorOptions.getInstance((PropertyStorage)Preferences.getPreferences());
            int tabSize = editorOptions.getTabSize();
            profile.setTabSize(tabSize);
            profile.setIndentSize(tabSize);
            profile.setIndentReplaceWithTabs(editorOptions.getUseSpaces() ^ true);
            ClientSetting javaSettings = ClientSetting.findOrCreate((String)"oracle.jdeveloper");
            if (javaSettings != null) {
                JavaImportOptions importOptions;
                JavaInsightOptions insightOptions;
                JavaOptions javaOptions = (JavaOptions)javaSettings.getData("JavaEditingOptions");
                if (javaOptions != null) {
                    int position = javaOptions.getOpenBraceSameLine() ? 0 : 1;
                    profile.setArrayBracePosition(position);
                    profile.setBlockBracePosition(position);
                    profile.setClassBracePosition(position);
                    profile.setMethodBracePosition(position);
                }
                if ((insightOptions = (JavaInsightOptions)javaSettings.getData("JavaInsightOptions")) != null) {
                    profile.setUseWideImports(insightOptions.getExplicitImport() ^ true);
                }
                if ((importOptions = (JavaImportOptions)javaSettings.getData("JavaImportOptions")) != null) {
                    profile.setGroupImports(importOptions.getGroupImports());
                    if (importOptions.getCollapseGroups()) {
                        profile.setGroupPackageDepth(importOptions.getPackageDepth());
                    } else {
                        profile.setGroupPackageDepth(0);
                    }
                }
            }
            repository.addProfile(profile);
            CodingStylePreferences preferences = CodingStylePreferences.getInstance((PropertyStorage)Preferences.getPreferences());
            preferences.setActiveProfile(profileName);
        }

        private SecondPhaseMigrator() {
        }

        SecondPhaseMigrator(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

