/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.style.preferences;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.HashMap;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.basic.BasicComboBoxRenderer;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import oracle.bali.ewt.button.ButtonBar;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.ewt.help.HelpUtils;
import oracle.ide.Ide;
import oracle.ide.dialogs.DialogRunnerCallback;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.dialogs.SizeKeeperCallback;
import oracle.ide.net.DefaultURLFilter;
import oracle.ide.net.URLChooser;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.ide.panels.ApplyEvent;
import oracle.ide.panels.ApplyListener;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TDialogLauncher;
import oracle.ide.panels.Traversable;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.Assert;
import oracle.ide.util.ModelUtil;
import oracle.ide.util.Namespace;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.util.UnexpectedExceptionError;
import oracle.jdevimpl.style.preferences.CodingStylePreferences;
import oracle.jdevimpl.style.profile.CodingStylePreviewPanel;
import oracle.jdevimpl.style.profile.CodingStyleProfile;
import oracle.jdevimpl.style.profile.CodingStyleProfilePanel;
import oracle.jdevimpl.style.profile.CodingStyleProfiles;
import oracle.jdevimpl.style.profile.ProfileModel;
import oracle.jdevimpl.style.resource.CodingStyleArb;

public class CodingStylePreferencesPanel
extends DefaultTraversablePanel
implements ItemListener,
ActionListener,
ApplyListener {
    private JComboBox profileList;
    private ProfileModel model;
    private JButton editButton;
    private JButton deleteButton;
    private JButton saveAsButton;
    private JButton importButton;
    private JButton exportButton;
    private JButton restoreButton;
    private CodingStylePreviewPanel preview;
    private URL lastImportExportURL;
    private CodingStylePreferences preferences;
    private static final String PREFERENCES_HELP_TOPIC = "f1_ideidesetcodingstyle_html";
    private static final String EDIT_PROFILE_HELP_TOPIC = "f1_ideidesetsavecodingstyle_html";
    private static final String EXPORT_HELP_TOPIC = "f1_ideidesetexportcodingstyle_html";
    private static final String IMPORT_HELP_TOPIC = "f1_ideidesetimportcodingstyle_html";
    private static final String SAMPLE;

    static {
        StringBuffer buffer = new StringBuffer();
        buffer.append("package mypackage;");
        buffer.append("${import}");
        buffer.append("public class Class1");
        buffer.append("{");
        buffer.append("private int ${field field} = 1 + 2 + 3;");
        buffer.append("public Class1()");
        buffer.append("{");
        buffer.append("}");
        buffer.append("public static void main(");
        buffer.append("String[] ${parameter args})");
        buffer.append("{");
        buffer.append("Class1 ${local class1} = new Class1();");
        buffer.append("if ( ${local class1}.toString() != null )");
        buffer.append("{");
        buffer.append("System.out.println( 1 );");
        buffer.append("}");
        buffer.append("else");
        buffer.append("{");
        buffer.append("}");
        buffer.append("switch (${parameter args}.length)");
        buffer.append("{");
        buffer.append("case 0:");
        buffer.append("break;");
        buffer.append("default:");
        buffer.append("break;");
        buffer.append("}");
        buffer.append("}");
        buffer.append("}");
        SAMPLE = buffer.toString();
    }

    public CodingStylePreferencesPanel() {
        this.setHelpID(PREFERENCES_HELP_TOPIC);
        this.model = new ProfileModel();
        this.profileList = new JComboBox(this.model);
        this.profileList.setRenderer(new ProfileRenderer(null));
        this.profileList.setEditable(false);
        this.profileList.addItemListener(this);
        JLabel profileLabel = new JLabel();
        ResourceUtils.resLabel((JLabel)profileLabel, (Component)this.profileList, (String)CodingStyleArb.getString(111));
        this.editButton = new JButton();
        ResourceUtils.resButton((AbstractButton)this.editButton, (String)CodingStyleArb.getString(11));
        this.editButton.addActionListener(this);
        this.saveAsButton = new JButton();
        ResourceUtils.resButton((AbstractButton)this.saveAsButton, (String)CodingStyleArb.getString(25));
        this.saveAsButton.addActionListener(this);
        this.deleteButton = new JButton();
        ResourceUtils.resButton((AbstractButton)this.deleteButton, (String)CodingStyleArb.getString(73));
        this.deleteButton.addActionListener(this);
        this.importButton = new JButton();
        ResourceUtils.resButton((AbstractButton)this.importButton, (String)CodingStyleArb.getString(96));
        this.importButton.addActionListener(this);
        this.exportButton = new JButton();
        ResourceUtils.resButton((AbstractButton)this.exportButton, (String)CodingStyleArb.getString(5));
        this.exportButton.addActionListener(this);
        this.restoreButton = new JButton();
        ResourceUtils.resButton((AbstractButton)this.restoreButton, (String)CodingStyleArb.getString(118));
        this.restoreButton.addActionListener(this);
        this.preview = new CodingStylePreviewPanel();
        this.preview.setSampleCode(SAMPLE);
        JLabel previewLabel = new JLabel();
        ResourceUtils.resLabel((JLabel)previewLabel, (Component)this.preview.getEditor(), (String)CodingStyleArb.getString(110));
        JPanel profilePanel = new JPanel();
        profilePanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.gridwidth = 0;
        gbc.insets = new Insets(0, 0, 3, 0);
        profilePanel.add((Component)profileLabel, gbc);
        gbc.gridwidth = -1;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.insets = new Insets(0, 0, 10, 10);
        profilePanel.add((Component)this.profileList, gbc);
        ButtonBar profileButtons = new ButtonBar();
        profileButtons.add((Component)this.editButton);
        profileButtons.add((Component)this.saveAsButton);
        profileButtons.add((Component)this.deleteButton);
        gbc.gridwidth = 0;
        gbc.fill = 0;
        gbc.weightx = 0.0;
        gbc.insets = new Insets(0, 0, 10, 0);
        profilePanel.add((Component)profileButtons, gbc);
        ButtonBar importButtons = new ButtonBar();
        importButtons.setAlignment(4);
        importButtons.add((Component)this.importButton);
        importButtons.add((Component)this.exportButton);
        importButtons.add((Component)this.restoreButton);
        JPanel previewPanel = new JPanel();
        previewPanel.setLayout(new BorderLayout(0, 3));
        previewPanel.add((Component)previewLabel, "North");
        previewPanel.add((Component)this.preview, "Center");
        this.setLayout(new BorderLayout(0, 5));
        this.add(profilePanel, "North");
        this.add(previewPanel, "Center");
        this.add((Component)importButtons, "South");
    }

    public void onEntry(TraversableContext tc) {
        this.preferences = this.getCodingStylePreferences(tc);
        CodingStyleProfile profile = null;
        String name = this.preferences.getActiveProfile();
        boolean missingProfile = name != null && !this.model.contains(name);
        Assert.println((boolean)missingProfile, (String)("Coding Style profile '" + name + "' not found."));
        profile = name == null || missingProfile ? this.model.getDefaultProfile() : this.model.getProfile(name);
        this.model.setSelectedItem((Object)profile);
        this.updatePreview();
        this.updateButtons();
    }

    public void onExit(TraversableContext tc) throws TraversalException {
        CodingStylePreferences preferences = this.getCodingStylePreferences(tc);
        CodingStyleProfile profile = this.getSelectedProfile();
        if (profile != null) {
            preferences.setActiveProfile(this.getSelectedProfile().getName());
        } else {
            preferences.setActiveProfile(null);
        }
    }

    public void itemStateChanged(ItemEvent e) {
        if (e.getStateChange() == 1) {
            this.updatePreview();
            this.updateButtons();
        }
    }

    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.editButton) {
            this.editProfile();
        } else if (source == this.saveAsButton) {
            this.saveProfile();
        } else if (source == this.deleteButton) {
            this.deleteProfile();
        } else if (source == this.exportButton) {
            this.exportProfile();
        } else if (source == this.importButton) {
            this.importProfile();
        } else if (source == this.restoreButton) {
            this.restoreProfile();
        }
    }

    public void apply(ApplyEvent e) {
        HashMap<String, CodingStyleProfile> map = new HashMap<String, CodingStyleProfile>();
        int n = this.model.getSize();
        int i = 0;
        while (i < n) {
            CodingStyleProfile profile = (CodingStyleProfile)((Object)this.model.getElementAt(i));
            String profileName = profile.getName();
            map.put(profileName, profile);
            ++i;
        }
        TraversableContext tc = e.getTraversableContext();
        PropertyStorage prefs = tc.getPropertyStorage();
        CodingStyleProfiles tcProfiles = CodingStyleProfiles.getInstance(prefs);
        tcProfiles.setProfileMap(map);
    }

    public void cancel(ApplyEvent e) {
        this.model.revert();
    }

    private void updatePreview() {
        CodingStyleProfile profile = this.getSelectedProfile();
        this.preview.setProfile(profile);
        this.preview.update();
    }

    private void updateButtons() {
        CodingStyleProfile profile = this.getSelectedProfile();
        boolean enabled = profile != null;
        this.deleteButton.setEnabled(enabled && !this.model.isDefaultProfile(profile));
        this.restoreButton.setEnabled(enabled && this.model.canRestore(profile));
        this.editButton.setEnabled(enabled);
        this.exportButton.setEnabled(enabled);
        this.saveAsButton.setEnabled(enabled);
    }

    private void editProfile() {
        CodingStyleProfilePanel panel = new CodingStyleProfilePanel();
        CodingStyleProfile profile = this.getSelectedProfile();
        CodingStyleProfile profileCopy = new CodingStyleProfile();
        profile.copyTo((Object)profileCopy);
        Namespace data = new Namespace();
        data.put("Profile", (Object)profileCopy);
        MessageFormat format = new MessageFormat(CodingStyleArb.getString(94));
        TDialogLauncher launcher = new TDialogLauncher((Component)((Object)this), format.format(new Object[]{profileCopy.getName()}), (Traversable)panel, data, (DialogRunnerCallback)new SizeKeeperCallback("coding.style.profile"));
        launcher.setInitialSize(800, 600);
        try {
            if (launcher.showDialog() && ModelUtil.areDifferent((Object)((Object)profile), (Object)((Object)profileCopy))) {
                profileCopy.copyTo((Object)profile);
                this.model.setModified(profile);
                this.updatePreview();
                this.updateButtons();
            }
        }
        finally {
            launcher.dispose();
        }
    }

    private void saveProfile() {
        CodingStyleProfile profile = this.getSelectedProfile();
        String oldName = profile.getName();
        String name = this.getProfileName(oldName);
        if (name != null && (name.equalsIgnoreCase(oldName) || !this.model.contains(name) || this.confirmSaveAsOverwrite(name))) {
            CodingStyleProfile copy = this.model.copy(profile, name);
            this.model.setSelectedItem((Object)copy);
            this.model.revert(profile);
        }
    }

    private boolean confirmSaveAsOverwrite(String name) {
        String title;
        String message = CodingStyleArb.format(22, name);
        int result = JOptionPane.showConfirmDialog((Component)((Object)this), message, title = CodingStyleArb.getString(31), 2);
        return result == 0;
    }

    private String getProfileName(String oldName) {
        JTextField nameField = new JTextField(oldName, 32);
        nameField.selectAll();
        JLabel label = new JLabel();
        ResourceUtils.resLabel((JLabel)label, (Component)nameField, (String)CodingStyleArb.getString(58));
        JPanel content = new JPanel(new GridBagLayout());
        HelpUtils.setHelpID((JComponent)content, (String)EDIT_PROFILE_HELP_TOPIC);
        content.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets.right = 10;
        gbc.gridheight = 0;
        gbc.anchor = 17;
        content.add((Component)label, gbc);
        gbc.gridwidth = 0;
        gbc.insets.right = 0;
        content.add((Component)nameField, gbc);
        JEWTDialog dialog = JEWTDialog.createDialog((Component)((Object)this), (String)CodingStyleArb.getString(68), (int)7);
        nameField.getDocument().addDocumentListener(new SaveAsListener(dialog));
        dialog.setContent((Component)content);
        dialog.setOKButtonText(CodingStyleArb.getString(65));
        return dialog.runDialog() ? nameField.getText().trim() : null;
    }

    private void deleteProfile() {
        CodingStyleProfile profile = this.getSelectedProfile();
        if (this.confirmDelete(profile)) {
            this.model.remove(profile);
        }
    }

    private boolean confirmDelete(CodingStyleProfile profile) {
        String title;
        String message = CodingStyleArb.format(85, profile.getName());
        int result = JOptionPane.showConfirmDialog((Component)((Object)this), message, title = CodingStyleArb.getString(90), 2);
        return result == 0;
    }

    private void exportProfile() {
        ExportURLChooser chooser = new ExportURLChooser();
        DialogUtil.initURLChooser((URLChooser)chooser, null);
        if (this.lastImportExportURL != null) {
            chooser.setSelectedURL(this.lastImportExportURL);
        } else {
            URL url = this.getUserHomeDirectory();
            if (url != null) {
                chooser.setSelectedURL(url);
            }
        }
        chooser.clearChooseableURLFilters();
        DefaultURLFilter filter = new DefaultURLFilter(CodingStyleArb.getString(107), ".xml");
        chooser.addChooseableURLFilter((URLFilter)filter);
        chooser.addChooseableURLFilter(URLChooser.ALL_FILES_FILTER);
        chooser.setURLFilter((URLFilter)filter);
        int result = chooser.showSaveDialog((Component)((Object)this), CodingStyleArb.getString(104));
        if (result == 0) {
            URL url = chooser.getSelectedURL();
            if ("".equals(URLFileSystem.getSuffix((URL)url))) {
                url = URLFileSystem.convertSuffix((URL)url, (String)"", (String)".xml");
            }
            try {
                this.getSelectedProfile().exportTo(url);
                this.lastImportExportURL = URLFileSystem.getParent((URL)url);
            }
            catch (Exception e) {
                String message = CodingStyleArb.format(87, URLFileSystem.getPlatformPathName((URL)url), e.toString());
                String title = CodingStyleArb.getString(88);
                JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), message, title, 0);
            }
        }
    }

    private void importProfile() {
        URLChooser chooser = DialogUtil.newURLChooser();
        chooser.clearChooseableURLFilters();
        DefaultURLFilter filter = new DefaultURLFilter(CodingStyleArb.getString(107), ".xml");
        chooser.addChooseableURLFilter((URLFilter)filter);
        chooser.addChooseableURLFilter(URLChooser.ALL_FILES_FILTER);
        chooser.setURLFilter((URLFilter)filter);
        chooser.setHelpID(IMPORT_HELP_TOPIC);
        if (this.lastImportExportURL != null) {
            chooser.setSelectedURL(this.lastImportExportURL);
        } else {
            URL url = this.getUserHomeDirectory();
            if (url != null) {
                chooser.setSelectedURL(url);
            }
        }
        int result = chooser.showOpenDialog((Component)((Object)this), CodingStyleArb.getString(75));
        if (result == 0) {
            try {
                URL url = chooser.getSelectedURL();
                CodingStyleProfile profile = CodingStyleProfile.importFrom(url);
                String name = profile.getName();
                if (!this.model.contains(name) || this.confirmImportOverwrite(name)) {
                    this.model.add(profile);
                    this.model.setSelectedItem((Object)profile);
                    this.lastImportExportURL = URLFileSystem.getParent((URL)url);
                }
            }
            catch (IOException ioe) {
                ExceptionDialog.showExceptionDialog((Component)((Object)this), (Throwable)ioe);
            }
        }
    }

    private boolean confirmImportOverwrite(String name) {
        String title;
        String message = CodingStyleArb.format(48, name);
        int result = JOptionPane.showConfirmDialog((Component)((Object)this), message, title = CodingStyleArb.getString(12), 2);
        return result == 0;
    }

    private void restoreProfile() {
        this.model.restore(this.getSelectedProfile());
        this.updatePreview();
        this.updateButtons();
    }

    private URL getUserHomeDirectory() {
        URL url = URLFactory.newDirURL((String)Ide.getTrueUserHomeDirectory());
        return URLFileSystem.exists((URL)url) ? url : null;
    }

    private CodingStyleProfile getSelectedProfile() {
        return (CodingStyleProfile)((Object)this.model.getSelectedItem());
    }

    private CodingStylePreferences getCodingStylePreferences(TraversableContext tc) {
        return CodingStylePreferences.getInstance(tc.getPropertyStorage());
    }

    private class ExportURLChooser
    extends URLChooser {
        public ExportURLChooser() {
            this.setHelpID(CodingStylePreferencesPanel.EXPORT_HELP_TOPIC);
        }

        public boolean approveSelection() {
            return super.approveSelection() && this.checkExistingFile() && this.checkReadOnlyFile();
        }

        private boolean checkExistingFile() {
            URL url = this.getSelectedURL();
            if (URLFileSystem.exists((URL)url)) {
                String message = CodingStyleArb.format(60, URLFileSystem.getPlatformPathName((URL)url));
                String title = CodingStyleArb.getString(7);
                int result = JOptionPane.showConfirmDialog((Component)Ide.getMainWindow(), message, title, 2);
                return result == 0;
            }
            return true;
        }

        private boolean checkReadOnlyFile() {
            URL url = this.getSelectedURL();
            if (URLFileSystem.isReadOnly((URL)url)) {
                String message = CodingStyleArb.format(83, URLFileSystem.getPlatformPathName((URL)url));
                String title = CodingStyleArb.getString(88);
                JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), message, title, 0);
                return false;
            }
            return true;
        }
    }

    private class ProfileRenderer
    extends BasicComboBoxRenderer {
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value instanceof CodingStyleProfile) {
                CodingStyleProfile profile = (CodingStyleProfile)((Object)value);
                value = profile.isModified() ? CodingStyleArb.format(54, profile.getName()) : profile.getName();
            }
            return super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
        }

        private ProfileRenderer() {
        }

        ProfileRenderer(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class SaveAsListener
    implements DocumentListener {
        private JEWTDialog dialog;

        public SaveAsListener(JEWTDialog dialog) {
            this.dialog = dialog;
        }

        public void changedUpdate(DocumentEvent e) {
            this.update(e.getDocument());
        }

        public void insertUpdate(DocumentEvent e) {
            this.update(e.getDocument());
        }

        public void removeUpdate(DocumentEvent e) {
            this.update(e.getDocument());
        }

        private void update(Document document) {
            String text;
            try {
                text = document.getText(0, document.getLength()).trim();
            }
            catch (BadLocationException e1) {
                throw new UnexpectedExceptionError((Throwable)e1);
            }
            this.dialog.setOKButtonEnabled(text.length() > 0);
        }
    }
}

