/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.style.profile;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.TableCellEditor;
import javax.swing.tree.TreePath;
import oracle.ide.controls.TreeTableModel;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.util.Assert;
import oracle.ideimpl.controls.dockLayout.DockLayoutConstraint;
import oracle.ideimpl.controls.dockLayout.DockLayoutPanel;
import oracle.jdevimpl.style.profile.CodingStylePreviewPanel;
import oracle.jdevimpl.style.profile.CodingStyleProfile;
import oracle.jdevimpl.style.resource.CodingStyleArb;
import oracle.jdevimpl.style.treetable.CodingStyleTreeBoolean;
import oracle.jdevimpl.style.treetable.CodingStyleTreeCategory;
import oracle.jdevimpl.style.treetable.CodingStyleTreeCategoryBoolean;
import oracle.jdevimpl.style.treetable.CodingStyleTreeItem;
import oracle.jdevimpl.style.treetable.CodingStyleTreeList;
import oracle.jdevimpl.style.treetable.CodingStyleTreeNumber;
import oracle.jdevimpl.style.treetable.CodingStyleTreeTable;
import oracle.jdevimpl.style.treetable.CodingStyleTreeTableModel;

public class CodingStyleFormatPanel
extends DefaultTraversablePanel
implements ChangeListener,
TreeSelectionListener {
    private static final String INDENT_HELP_ID = "f1_ideideseteditcodingstyleindent_html";
    private static final String BRACE_POSITION_HELP_ID = "f1_ideideseteditcodingstylebrace_html";
    private static final String NEWLINES_HELP_ID = "f1_ideideseteditcodingstylenewline_html";
    private static final String LINEWRAPPING_HELP_ID = "f1_ideideseteditcodingstylewrapping_html";
    private static final String BLANKLINES_HELP_ID = "f1_ideideseteditcodingstyleblank_html";
    private static final String SPACE_HELP_ID = "f1_ideideseteditcodingstylespace_html";
    private static final int MAP_READ = 0;
    private static final int MAP_WRITE = 1;
    private CodingStyleTreeTableModel model;
    private CodingStylePreviewPanel preview;
    private CodingStyleTreeTable treeTable;
    private CodingStyleProfile profile;
    private String sample;

    private void $init$() {
        this.preview = new CodingStylePreviewPanel();
    }

    public CodingStyleFormatPanel() {
        this.$init$();
        this.setHelpID(INDENT_HELP_ID);
        this.model = this.createModel();
        this.model.addChangeListener(this);
        this.treeTable = new CodingStyleTreeTable((TreeTableModel)this.model);
        JTree tree = this.treeTable.getTree();
        this.model.setTree(tree);
        tree.addTreeSelectionListener(this);
        tree.expandRow(0);
        tree.setSelectionPath(tree.getPathForRow(0));
        JScrollPane scrollPaneLeft = new JScrollPane((Component)((Object)this.treeTable));
        Color background = this.treeTable.getBackground();
        scrollPaneLeft.setBackground(background);
        scrollPaneLeft.getViewport().setBackground(background);
        DockLayoutPanel dockPanel = new DockLayoutPanel();
        dockPanel.setName("format.splitter");
        dockPanel.add((Component)scrollPaneLeft, (Object)new DockLayoutConstraint(0, null));
        dockPanel.add((Component)this.preview, (Object)new DockLayoutConstraint(1, null));
        this.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        this.setLayout(new BorderLayout());
        this.add((Component)dockPanel, "Center");
    }

    public void onEntry(TraversableContext dataContext) {
        this.profile = (CodingStyleProfile)((Object)dataContext.find("Profile"));
        this.loadFromProfile(this.profile);
        this.updatePreview();
    }

    public void onExit(TraversableContext dataContext) {
        TableCellEditor editor = this.treeTable.getCellEditor();
        if (editor != null) {
            editor.stopCellEditing();
        }
        this.saveToProfile(this.profile);
    }

    public void stateChanged(ChangeEvent ie) {
        if (this.profile != null) {
            this.saveToProfile(this.profile);
        }
        this.updatePreview();
    }

    public void valueChanged(TreeSelectionEvent e) {
        TreePath treePath = e.getPath();
        if (treePath != null) {
            int i = treePath.getPathCount() - 1;
            while (i >= 0) {
                String sample;
                Object o = treePath.getPathComponent(i);
                if (o instanceof CodingStyleTreeItem && (sample = ((CodingStyleTreeItem)o).getSample()) != null) {
                    this.sample = sample;
                    this.updatePreview();
                    break;
                }
                --i;
            }
            int i2 = treePath.getPathCount() - 1;
            while (i2 >= 0) {
                Object o = treePath.getPathComponent(i2);
                if (o instanceof CodingStyleTreeCategory) {
                    this.setHelpID(((CodingStyleTreeCategory)o).getHelpID());
                    break;
                }
                --i2;
            }
        }
    }

    private CodingStyleTreeTableModel createModel() {
        CodingStyleTreeTableModel model = new CodingStyleTreeTableModel(null);
        this.sample = this.getRootSample();
        CodingStyleTreeCategory root = new CodingStyleTreeCategory(model, "root", INDENT_HELP_ID, this.sample);
        model.setRoot(root);
        root.addChild(this.createIndentationCategory(model));
        root.addChild(this.createBracePositionCategory(model));
        root.addChild(this.createNewLinesCategory(model));
        root.addChild(this.createLineWrappingCategory(model));
        root.addChild(this.createBlankLinesCategory(model));
        root.addChild(this.createSpacesCategory(model));
        return model;
    }

    private String getRootSample() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("package mypackage;");
        buffer.append("${import}");
        buffer.append("public class Class1");
        buffer.append("{");
        buffer.append("private int ${field field} = 1 + 2 + 3;");
        buffer.append("public Class1()");
        buffer.append("{");
        buffer.append("}");
        buffer.append("public static void main(String[]");
        buffer.append("${parameter args})");
        buffer.append("{");
        buffer.append("Class1 ${local class1} = new Class1();");
        buffer.append("if (${local class1}.toString() != null)");
        buffer.append("{");
        buffer.append("System.out.println( 1 );");
        buffer.append("}");
        buffer.append("else");
        buffer.append("{");
        buffer.append("}");
        buffer.append("switch (${parameter args}.length)");
        buffer.append("{");
        buffer.append("case 0:");
        buffer.append("break;");
        buffer.append("default:");
        buffer.append("break;");
        buffer.append("}");
        buffer.append("}");
        buffer.append("}");
        return buffer.toString();
    }

    private CodingStyleTreeCategory createBracePositionCategory(CodingStyleTreeTableModel model) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("package mypackage.brace.position;");
        buffer.append("public class Class1 {");
        buffer.append("private String[] ${field values} = {");
        buffer.append("\"a\", \"b\", \"c\"");
        buffer.append("};");
        buffer.append("public Class1(){");
        buffer.append("}");
        buffer.append("public static void main(String[]");
        buffer.append("${parameter args}) {");
        buffer.append("if (${parameter args}.length < 2) {");
        buffer.append("printUsage();");
        buffer.append("}");
        buffer.append("try {");
        buffer.append("for (int ${local i} = 1; ${local i} < ");
        buffer.append("${parameter args}.length; ${local i}++)");
        buffer.append("{");
        buffer.append("processArg(${parameter args}[${local i});");
        buffer.append("}");
        buffer.append("}");
        buffer.append("catch (Exception ${local e}) {");
        buffer.append("${local e}.printStackTrace();");
        buffer.append("}");
        buffer.append("switch (${parameter args}.length)");
        buffer.append("{");
        buffer.append("case 0:");
        buffer.append("{");
        buffer.append("break;");
        buffer.append("}");
        buffer.append("default:");
        buffer.append("{");
        buffer.append("break;");
        buffer.append("}");
        buffer.append("}");
        buffer.append("}");
        buffer.append("}");
        String sample = buffer.toString();
        String[] choices = new String[]{CodingStyleArb.getString(3), CodingStyleArb.getString(134)};
        CodingStyleTreeCategory category = new CodingStyleTreeCategory(model, CodingStyleArb.getString(121), BRACE_POSITION_HELP_ID, sample);
        category.addChild(new CodingStyleTreeList("classBracePosition", CodingStyleArb.getString(89), null, choices));
        category.addChild(new CodingStyleTreeList("methodBracePosition", CodingStyleArb.getString(59), null, choices));
        category.addChild(new CodingStyleTreeList("blockBracePosition", CodingStyleArb.getString(8), null, choices));
        category.addChild(new CodingStyleTreeList("arrayBracePosition", CodingStyleArb.getString(79), null, choices));
        category.addChild(new CodingStyleTreeList("switchCaseBracePosition", CodingStyleArb.getString(100), null, choices));
        return category;
    }

    private CodingStyleTreeCategory createNewLinesCategory(CodingStyleTreeTableModel model) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("package mypackage.newlines;");
        buffer.append("public class MyClass extends BaseClass");
        buffer.append(" implements MyInterface {");
        buffer.append("public void myMethod() throws IOException {");
        buffer.append("try {");
        buffer.append("if (isTrue())");
        buffer.append("{");
        buffer.append("int ${local i} = 0;");
        buffer.append("do");
        buffer.append("{");
        buffer.append("${local i} = getValue();");
        buffer.append("System.out.println(\"Value: \" + value);");
        buffer.append("} while ( ${local i} > 0 );");
        buffer.append("} else {");
        buffer.append("System.out.println(\"false\");");
        buffer.append("}");
        buffer.append("} catch (Exception ${local e}) {");
        buffer.append("e.printStackTrace();");
        buffer.append("} finally {");
        buffer.append("done();");
        buffer.append("} ");
        buffer.append("}");
        buffer.append("}");
        String sample = buffer.toString();
        CodingStyleTreeCategoryBoolean category = new CodingStyleTreeCategoryBoolean(model, CodingStyleArb.getString(32), NEWLINES_HELP_ID, sample);
        category.addChild(new CodingStyleTreeBoolean("newlineExtends", CodingStyleArb.getString(103), null));
        category.addChild(new CodingStyleTreeBoolean("newlineImplements", CodingStyleArb.getString(80), null));
        category.addChild(new CodingStyleTreeBoolean("newlineThrows", CodingStyleArb.getString(86), null));
        category.addChild(new CodingStyleTreeBoolean("newlineElse", CodingStyleArb.getString(28), null));
        category.addChild(new CodingStyleTreeBoolean("newlineWhile", CodingStyleArb.getString(50), null));
        category.addChild(new CodingStyleTreeBoolean("newlineCatch", CodingStyleArb.getString(6), null));
        category.addChild(new CodingStyleTreeBoolean("newlineFinally", CodingStyleArb.getString(132), null));
        return category;
    }

    private CodingStyleTreeCategory createLineWrappingCategory(CodingStyleTreeTableModel model) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("package mypackage.line.wrapping;");
        buffer.append("@Annotation1 @Annotation2(date=\"1/1/2007\",");
        buffer.append("author=\"jsmith\") public class MyClass ");
        buffer.append("implements Interface1,Interface2,Interface3 {");
        buffer.append("private String[] ${field values} = {\"red\",");
        buffer.append("\"orange\",\"yellow\", \"green\", \"blue\", ");
        buffer.append("\"indigo\",\"violet\"};");
        buffer.append("public final void myMethod() throws ");
        buffer.append("Exception1, Exception2, Exception3, Exception4");
        buffer.append("{");
        buffer.append("boolean ${local isOracle}=${field values}[1].");
        buffer.append("substring(0, 3).toUpperCase().concat(\"CLE\").");
        buffer.append("equalsIgnoreCase(\"ORACLE\");");
        buffer.append("print(${field values}[0], ${field values}[1], ");
        buffer.append("${field values}[2], ${field values}[3], ");
        buffer.append("${field values}[4], ${field values}[5], ");
        buffer.append("${field values}[6]);");
        buffer.append("for (int ${local index} = ");
        buffer.append("getMinimumIntegerValue();");
        buffer.append(" index <getMaximumIntegerValue(); index++)");
        buffer.append("{}");
        buffer.append("if (${field values}[0].length() > 2 &&");
        buffer.append(" ${field values}[1].length() == 3 ||");
        buffer.append(" ${field values}[2].length() < 10");
        buffer.append("&& ${field values}[3].length() == 0)");
        buffer.append("{}");
        buffer.append("String ${local str} = isOracle ? ");
        buffer.append("\"the string matches ORACLE\":");
        buffer.append("\"the string does not match ORACLE\";");
        buffer.append("}");
        buffer.append("public void print(String ${parameter arg1}, ");
        buffer.append("String ${parameter arg2},");
        buffer.append("String ${parameter arg3},");
        buffer.append("String ${parameter arg4},");
        buffer.append("String ${parameter arg5},");
        buffer.append("String ${parameter arg6},");
        buffer.append("String ${parameter arg7})");
        buffer.append("{}");
        buffer.append("}");
        String sample = buffer.toString();
        String[] choices = new String[]{CodingStyleArb.getString(4), CodingStyleArb.getString(120), CodingStyleArb.getString(92)};
        CodingStyleTreeCategory category = new CodingStyleTreeCategory(model, CodingStyleArb.getString(126), LINEWRAPPING_HELP_ID, sample);
        category.addChild(new CodingStyleTreeNumber("wrapLineWidth", CodingStyleArb.getString(10), null, 1, 1000));
        category.addChild(new CodingStyleTreeBoolean("wrapAlign", CodingStyleArb.getString(82), null));
        category.addChild(new CodingStyleTreeList("wrapModifiers", CodingStyleArb.getString(44), null, choices));
        category.addChild(new CodingStyleTreeList("wrapExtends", CodingStyleArb.getString(38), null, choices));
        category.addChild(new CodingStyleTreeList("wrapThrows", CodingStyleArb.getString(49), null, choices));
        category.addChild(new CodingStyleTreeList("wrapArrayConstant", CodingStyleArb.getString(84), null, choices));
        category.addChild(new CodingStyleTreeList("wrapParameterList", CodingStyleArb.getString(29), null, choices));
        category.addChild(new CodingStyleTreeList("wrapInvokeArguments", CodingStyleArb.getString(122), null, choices));
        category.addChild(new CodingStyleTreeList("wrapDotChain", CodingStyleArb.getString(114), null, choices));
        category.addChild(new CodingStyleTreeList("wrapForStatement", CodingStyleArb.getString(39), null, choices));
        category.addChild(new CodingStyleTreeList("wrapBinaryOperator", CodingStyleArb.getString(78), null, choices));
        category.addChild(new CodingStyleTreeList("wrapTernaryExpression", CodingStyleArb.getString(35), null, choices));
        return category;
    }

    private CodingStyleTreeCategory createBlankLinesCategory(CodingStyleTreeTableModel model) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("package mypackage.blank.lines;");
        buffer.append("${import}");
        buffer.append("public class Class1");
        buffer.append("{");
        buffer.append("private int ${field field} = 1");
        buffer.append("private Object ${field anonymous} =");
        buffer.append("new Object(){};");
        buffer.append("public Class1()");
        buffer.append("{");
        buffer.append("}");
        buffer.append("public static void main(String[]");
        buffer.append("${parameter args})");
        buffer.append("{");
        buffer.append("// 10 existing blank lines\n");
        buffer.append("\n\n\n\n\n\n\n\n\n\n");
        buffer.append("// End existing blank lines\n");
        buffer.append("if (${parameter args}.length > 0)");
        buffer.append("{");
        buffer.append("System.out.println(${parameter args}.length)");
        buffer.append("}");
        buffer.append("else");
        buffer.append("{");
        buffer.append("}");
        buffer.append("}");
        buffer.append("private class MemberClass {}");
        buffer.append("}");
        buffer.append("class EmptyClass");
        buffer.append("{");
        buffer.append("}");
        String sample = buffer.toString();
        CodingStyleTreeCategory category = new CodingStyleTreeCategory(model, CodingStyleArb.getString(26), BLANKLINES_HELP_ID, sample);
        category.addChild(new CodingStyleTreeNumber("blanklinesAfterPackage", CodingStyleArb.getString(125), null, 0, 20));
        category.addChild(new CodingStyleTreeNumber("blanklinesAfterImports", CodingStyleArb.getString(138), null, 0, 20));
        category.addChild(new CodingStyleTreeNumber("blanklinesBeforeFirstClass", CodingStyleArb.getString(76), null, 0, 20));
        category.addChild(new CodingStyleTreeNumber("blanklinesBeforeFirstMember", CodingStyleArb.getString(47), null, 0, 20));
        category.addChild(new CodingStyleTreeNumber("blanklinesAfterLastMember", CodingStyleArb.getString(70), null, 0, 20));
        category.addChild(new CodingStyleTreeNumber("blanklinesBeforeField", CodingStyleArb.getString(115), null, 0, 20));
        category.addChild(new CodingStyleTreeNumber("blanklinesBeforeMethod", CodingStyleArb.getString(30), null, 0, 20));
        category.addChild(new CodingStyleTreeNumber("blanklinesBeforeMemberClass", CodingStyleArb.getString(9), null, 0, 20));
        category.addChild(new CodingStyleTreeNumber("blanklinesEmptyClass", CodingStyleArb.getString(23), null, 0, 20));
        category.addChild(new CodingStyleTreeNumber("blanklinesEmptyAnonymous", CodingStyleArb.getString(1), null, 0, 20));
        category.addChild(new CodingStyleTreeNumber("blanklinesEmptyBlock", CodingStyleArb.getString(97), null, 0, 20));
        category.addChild(new CodingStyleTreeNumber("blanklinesEmptyMethod", CodingStyleArb.getString(77), null, 0, 20));
        category.addChild(new CodingStyleTreeNumber("blanklinesPreserved", CodingStyleArb.getString(129), null, 0, 20));
        return category;
    }

    private CodingStyleTreeCategory createIndentationCategory(CodingStyleTreeTableModel model) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("package mypackage.indentation;");
        buffer.append("public class Class1");
        buffer.append("{");
        buffer.append("private int ${field field} = 1 + 2 + 3;");
        buffer.append("public Class1()");
        buffer.append("{");
        buffer.append("}");
        buffer.append("public static void main(String[] ");
        buffer.append("${parameter args})");
        buffer.append("{");
        buffer.append("Class1 ${local class1} = new Class1();");
        buffer.append("if ( ${local class1}.toString() != null )");
        buffer.append("{");
        buffer.append("System.out.println( 1 );");
        buffer.append("}");
        buffer.append("else");
        buffer.append("{");
        buffer.append("}");
        buffer.append("switch (${parameter args}.length)");
        buffer.append("{");
        buffer.append("case 0:");
        buffer.append("break;");
        buffer.append("default:");
        buffer.append("break;");
        buffer.append("}");
        buffer.append("}");
        buffer.append("}");
        String sample = buffer.toString();
        CodingStyleTreeCategory category = new CodingStyleTreeCategory(model, CodingStyleArb.getString(95), INDENT_HELP_ID, sample);
        category.addChild(new CodingStyleTreeNumber("indentSize", CodingStyleArb.getString(130), null, 1, 20));
        category.addChild(new CodingStyleTreeBoolean("indentReplaceWithTabs", CodingStyleArb.getString(53), null));
        category.addChild(new CodingStyleTreeNumber("tabSize", CodingStyleArb.getString(33), null, 1, 20));
        category.addChild(new CodingStyleTreeBoolean("indentClassMembers", CodingStyleArb.getString(20), null));
        category.addChild(new CodingStyleTreeBoolean("indentControlBlocks", CodingStyleArb.getString(106), null));
        category.addChild(new CodingStyleTreeBoolean("indentBlockChildren", CodingStyleArb.getString(74), null));
        category.addChild(new CodingStyleTreeBoolean("indentSwitchCases", CodingStyleArb.getString(18), null));
        return category;
    }

    private CodingStyleTreeCategory createSpacesCategory(CodingStyleTreeTableModel model) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("package mypackage.spaces;");
        buffer.append("public class MyClass");
        buffer.append(" implements Interface1, Inteface2 {");
        buffer.append("private String[] ${field values} =");
        buffer.append("{\"a\", \"b\", \"c\"};");
        buffer.append("public void myMethod(int[] ${parameter a}) {");
        buffer.append("int ${local total} = 0;");
        buffer.append("for (int ${local total} : ${parameter a}) {");
        buffer.append("${local total} += e;");
        buffer.append("}");
        buffer.append("int[] ${local copy} = new int[5];");
        buffer.append("int ${local max} = (${parameter a}.length < 5)");
        buffer.append("?  ${parameter a}.length : 5;");
        buffer.append("for (int ${local i} = 0; ${local i}  <");
        buffer.append("${local max}; ${local i}++) {");
        buffer.append("${local copy}[i] = ${parameter a}[${local i}];");
        buffer.append("}");
        buffer.append("Integer ${local x} = (Integer)getValue(");
        buffer.append("${parameter a}, ${local total});");
        buffer.append("}");
        buffer.append("}");
        String sample = buffer.toString();
        CodingStyleTreeCategoryBoolean category = new CodingStyleTreeCategoryBoolean(model, CodingStyleArb.getString(101), SPACE_HELP_ID, sample);
        category.addChild(new CodingStyleTreeBoolean("spaceBeforeOpenBrace", CodingStyleArb.getString(62), null));
        category.addChild(new CodingStyleTreeBoolean("spaceBeforeComma", CodingStyleArb.getString(98), null));
        category.addChild(new CodingStyleTreeBoolean("spaceAfterComma", CodingStyleArb.getString(123), null));
        category.addChild(new CodingStyleTreeBoolean("spaceBeforeSemicolon", CodingStyleArb.getString(113), null));
        category.addChild(new CodingStyleTreeBoolean("spaceAfterSemicolon", CodingStyleArb.getString(136), null));
        category.addChild(new CodingStyleTreeBoolean("spaceBeforeQuestion", CodingStyleArb.getString(116), null));
        category.addChild(new CodingStyleTreeBoolean("spaceAfterQuestion", CodingStyleArb.getString(27), null));
        category.addChild(new CodingStyleTreeBoolean("spaceBeforeColon", CodingStyleArb.getString(56), null));
        category.addChild(new CodingStyleTreeBoolean("spaceAfterColon", CodingStyleArb.getString(72), null));
        category.addChild(new CodingStyleTreeBoolean("spaceAfterTypecast", CodingStyleArb.getString(17), null));
        category.addChild(new CodingStyleTreeBoolean("spaceBeforeArguments", CodingStyleArb.getString(55), null));
        category.addChild(new CodingStyleTreeBoolean("spaceBeforeParameters", CodingStyleArb.getString(43), null));
        category.addChild(new CodingStyleTreeBoolean("spaceAfterKeyword", CodingStyleArb.getString(131), null));
        category.addChild(new CodingStyleTreeBoolean("spaceAroundAssignment", CodingStyleArb.getString(42), null));
        category.addChild(new CodingStyleTreeBoolean("spaceAroundBinaryOperator", CodingStyleArb.getString(127), null));
        category.addChild(new CodingStyleTreeBoolean("spaceWithinParenthesis", CodingStyleArb.getString(0), null));
        category.addChild(new CodingStyleTreeBoolean("spaceWithinBrackets", CodingStyleArb.getString(19), null));
        return category;
    }

    private void loadFromProfile(CodingStyleProfile profile) {
        CodingStyleTreeCategory category = (CodingStyleTreeCategory)this.model.getRoot();
        try {
            BeanInfo bean = Introspector.getBeanInfo(CodingStyleProfile.class);
            Map readMap = this.createPropertyMap(bean, 0);
            this.loadSettingsFromCategory(category, profile, readMap);
        }
        catch (IntrospectionException e) {
            e.printStackTrace();
        }
    }

    private void saveToProfile(CodingStyleProfile profile) {
        CodingStyleTreeCategory category = (CodingStyleTreeCategory)this.model.getRoot();
        try {
            BeanInfo bean = Introspector.getBeanInfo(CodingStyleProfile.class);
            Map map = this.createPropertyMap(bean, 1);
            this.saveSettingsToCategory(category, profile, map);
        }
        catch (IntrospectionException e) {
            e.printStackTrace();
        }
    }

    private void loadSettingsFromCategory(CodingStyleTreeCategory category, CodingStyleProfile profile, Map map) {
        int i = 0;
        while (i < category.getChildCount()) {
            CodingStyleTreeItem item = category.getChild(i);
            if (item instanceof CodingStyleTreeCategory) {
                CodingStyleTreeCategory subcat = (CodingStyleTreeCategory)item;
                this.loadSettingsFromCategory(subcat, profile, map);
            } else {
                Object value;
                Method m = (Method)map.get(item.getPropertyName());
                Assert.println((m == null ? 1 : 0) != 0, (String)("No write method for property " + item.getPropertyName()));
                if (m != null && (value = this.invokeReadMethod(m, (Object)profile)) != null) {
                    item.setValue(value);
                }
            }
            ++i;
        }
    }

    private void saveSettingsToCategory(CodingStyleTreeCategory category, CodingStyleProfile profile, Map map) {
        int i = 0;
        while (i < category.getChildCount()) {
            CodingStyleTreeItem item = category.getChild(i);
            if (item instanceof CodingStyleTreeCategory) {
                CodingStyleTreeCategory subcat = (CodingStyleTreeCategory)item;
                this.saveSettingsToCategory(subcat, profile, map);
            } else {
                Method m = (Method)map.get(item.getPropertyName());
                Assert.println((m == null ? 1 : 0) != 0, (String)("No write method for property " + item.getPropertyName()));
                if (m != null) {
                    this.invokeWriteMethod(m, (Object)profile, item.getValue());
                }
            }
            ++i;
        }
    }

    private Object invokeMethod(Method m, Object bean, Object[] args) {
        try {
            Object object = m.invoke(bean, args);
            return object;
        }
        catch (Exception ex) {
            Assert.println((String)"invokeMethod", (Object)ex.toString());
            Assert.println((String)(m + ":"), (Object)bean);
            ex.printStackTrace();
            return null;
        }
    }

    private Object invokeReadMethod(Method m, Object bean) {
        return this.invokeMethod(m, bean, new Object[0]);
    }

    private Object invokeWriteMethod(Method m, Object bean, Object value) {
        return this.invokeMethod(m, bean, new Object[]{value});
    }

    private void updatePreview() {
        this.preview.setSampleCode(this.sample);
        this.preview.setProfile(this.profile);
        this.preview.update();
    }

    private Map createPropertyMap(BeanInfo bean, int type) {
        HashMap<String, Method> map = new HashMap<String, Method>();
        PropertyDescriptor[] descriptors = bean.getPropertyDescriptors();
        int i = 0;
        while (i < descriptors.length) {
            PropertyDescriptor d = descriptors[i];
            String name = d.getName();
            Method method = type == 0 ? d.getReadMethod() : d.getWriteMethod();
            map.put(name, method);
            ++i;
        }
        return map;
    }
}

